/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.command.coord;

import org.apache.oozie.CoordinatorJobBean;
import org.apache.oozie.client.Job;
import org.apache.oozie.command.CommandException;
import org.apache.oozie.command.PreconditionException;
import org.apache.oozie.command.UnpauseTransitionXCommand;
import org.apache.oozie.command.bundle.BundleStatusUpdateXCommand;
import org.apache.oozie.executor.jpa.CoordJobQueryExecutor;
import org.apache.oozie.executor.jpa.JPAExecutorException;
import org.apache.oozie.service.JPAService;
import org.apache.oozie.service.Services;
import org.apache.oozie.util.LogUtils;

public class CoordUnpauseXCommand
extends UnpauseTransitionXCommand {
    private final JPAService jpaService = Services.get().get(JPAService.class);
    private final CoordinatorJobBean coordJob;
    private Job.Status prevStatus = null;

    public CoordUnpauseXCommand(CoordinatorJobBean coordJob) {
        super("coord_unpause", "coord_unpause", 1);
        this.coordJob = coordJob;
    }

    @Override
    public String getEntityKey() {
        return this.coordJob.getId();
    }

    @Override
    protected boolean isLockRequired() {
        return true;
    }

    @Override
    public void loadState() throws CommandException {
        this.prevStatus = this.coordJob.getStatus();
        LogUtils.setLogInfo(this.coordJob);
    }

    @Override
    protected void verifyPrecondition() throws CommandException, PreconditionException {
    }

    @Override
    public void notifyParent() throws CommandException {
        if (this.coordJob.getBundleId() != null) {
            BundleStatusUpdateXCommand bundleStatusUpdate = new BundleStatusUpdateXCommand(this.coordJob, this.prevStatus);
            bundleStatusUpdate.call();
        }
    }

    @Override
    public Job getJob() {
        return this.coordJob;
    }

    @Override
    public void updateJob() throws CommandException {
        try {
            CoordJobQueryExecutor.getInstance().executeUpdate(CoordJobQueryExecutor.CoordJobQuery.UPDATE_COORD_JOB_STATUS, this.coordJob);
        }
        catch (JPAExecutorException e) {
            throw new CommandException(e);
        }
    }

    @Override
    public void unpauseChildren() throws CommandException {
    }

    @Override
    public void performWrites() throws CommandException {
    }
}

