/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.command.sla;

import org.apache.oozie.WorkflowJobBean;
import org.apache.oozie.client.WorkflowJob;
import org.apache.oozie.command.CommandException;
import org.apache.oozie.command.sla.SLAJobEventXCommand;
import org.apache.oozie.executor.jpa.JPAExecutorException;
import org.apache.oozie.executor.jpa.WorkflowJobQueryExecutor;
import org.apache.oozie.sla.SLACalcStatus;
import org.apache.oozie.util.LogUtils;

public class SLAWorkflowJobEventXCommand
extends SLAJobEventXCommand {
    WorkflowJobBean wf;

    public SLAWorkflowJobEventXCommand(SLACalcStatus slaCalc, long lockTimeOut) {
        super(slaCalc, lockTimeOut);
    }

    @Override
    protected void loadState() throws CommandException {
        try {
            this.wf = WorkflowJobQueryExecutor.getInstance().get(WorkflowJobQueryExecutor.WorkflowJobQuery.GET_WORKFLOW_FOR_SLA, this.slaCalc.getId());
        }
        catch (JPAExecutorException e) {
            throw new CommandException(e);
        }
        LogUtils.setLogInfo(this.wf);
    }

    @Override
    protected void updateJobInfo() {
        if (this.wf.inTerminalState()) {
            this.setEnded(true);
            if (this.wf.getStatus() == WorkflowJob.Status.KILLED || this.wf.getStatus() == WorkflowJob.Status.FAILED || this.wf.getEndTime().getTime() > this.slaCalc.getExpectedEnd().getTime()) {
                this.setEndMiss(true);
            }
            this.slaCalc.setActualEnd(this.wf.getEndTime());
        }
        this.slaCalc.setActualStart(this.wf.getStartTime());
        this.slaCalc.setJobStatus(this.wf.getStatusStr());
    }
}

