/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.service;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.mapred.JobConf;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.service.ConfigurationService;
import org.apache.oozie.service.HadoopAccessorException;
import org.apache.oozie.service.HadoopAccessorService;
import org.apache.oozie.service.Service;
import org.apache.oozie.service.Services;
import org.apache.oozie.util.IOUtils;
import org.apache.oozie.util.XConfiguration;
import org.apache.oozie.util.XLog;
import org.apache.oozie.workflow.WorkflowApp;
import org.apache.oozie.workflow.WorkflowException;

public abstract class WorkflowAppService
implements Service {
    public static final String CONF_PREFIX = "oozie.service.WorkflowAppService.";
    public static final String SYSTEM_LIB_PATH = "oozie.service.WorkflowAppService.system.libpath";
    public static final String APP_LIB_PATH_LIST = "oozie.wf.application.lib";
    public static final String HADOOP_USER = "user.name";
    public static final String CONFG_MAX_WF_LENGTH = "oozie.service.WorkflowAppService.WorkflowDefinitionMaxLength";
    public static final String OOZIE_SUBWORKFLOW_CLASSPATH_INHERITANCE = "oozie.subworkflow.classpath.inheritance";
    public static final String OOZIE_WF_SUBWORKFLOW_CLASSPATH_INHERITANCE = "oozie.wf.subworkflow.classpath.inheritance";
    private Path systemLibPath;
    private long maxWFLength;
    private boolean oozieSubWfCPInheritance;

    @Override
    public void init(Services services) {
        Configuration conf = services.getConf();
        String path = ConfigurationService.get(conf, SYSTEM_LIB_PATH);
        if (path.trim().length() > 0) {
            this.systemLibPath = new Path(path.trim());
        }
        this.maxWFLength = conf.getInt(CONFG_MAX_WF_LENGTH, 100000);
        this.oozieSubWfCPInheritance = conf.getBoolean(OOZIE_SUBWORKFLOW_CLASSPATH_INHERITANCE, false);
    }

    @Override
    public void destroy() {
    }

    @Override
    public Class<? extends Service> getInterface() {
        return WorkflowAppService.class;
    }

    protected String readDefinition(String appPath, String user, Configuration conf) throws WorkflowException {
        try {
            FileStatus fsStatus;
            URI uri = new URI(appPath);
            HadoopAccessorService has = Services.get().get(HadoopAccessorService.class);
            JobConf jobConf = has.createJobConf(uri.getAuthority());
            FileSystem fs = has.createFileSystem(user, uri, (Configuration)jobConf);
            Path path = new Path(uri.getPath());
            if (!fs.isFile(path)) {
                path = new Path(path, "workflow.xml");
            }
            if ((fsStatus = fs.getFileStatus(path)).getLen() > this.maxWFLength) {
                throw new WorkflowException(ErrorCode.E0736, fsStatus.getLen(), this.maxWFLength);
            }
            InputStreamReader reader = new InputStreamReader((InputStream)fs.open(path));
            StringWriter writer = new StringWriter();
            IOUtils.copyCharStream(reader, writer);
            return writer.toString();
        }
        catch (WorkflowException wfe) {
            throw wfe;
        }
        catch (IOException ex) {
            throw new WorkflowException(ErrorCode.E0710, ex.getMessage(), ex);
        }
        catch (URISyntaxException ex) {
            throw new WorkflowException(ErrorCode.E0711, appPath, ex.getMessage(), ex);
        }
        catch (HadoopAccessorException ex) {
            throw new WorkflowException(ex);
        }
        catch (Exception ex) {
            throw new WorkflowException(ErrorCode.E0710, ex.getMessage(), ex);
        }
    }

    public XConfiguration createProtoActionConf(Configuration jobConf, boolean isWorkflowJob) throws WorkflowException {
        try {
            String[] parentFilePaths;
            Path path;
            HadoopAccessorService has = Services.get().get(HadoopAccessorService.class);
            URI uri = new URI(jobConf.get("oozie.wf.application.path"));
            JobConf conf = has.createJobConf(uri.getAuthority());
            XConfiguration protoConf = new XConfiguration();
            String user = jobConf.get(HADOOP_USER);
            conf.set(HADOOP_USER, user);
            protoConf.set(HADOOP_USER, user);
            FileSystem fs = has.createFileSystem(user, uri, (Configuration)conf);
            Path appPath = new Path(uri);
            XLog.getLog(this.getClass()).debug("jobConf.libPath = " + jobConf.get("oozie.libpath"));
            XLog.getLog(this.getClass()).debug("jobConf.appPath = " + appPath);
            Collection<Object> filePaths = isWorkflowJob ? (!fs.isFile(path = new Path(uri.getPath())) ? this.getLibFiles(fs, new Path(appPath + "/lib")) : this.getLibFiles(fs, new Path(appPath.getParent(), "lib"))) : new LinkedHashSet();
            String[] libPaths = jobConf.getStrings("oozie.libpath");
            if (libPaths != null && libPaths.length > 0) {
                for (int i = 0; i < libPaths.length; ++i) {
                    if (libPaths[i].trim().length() <= 0) continue;
                    Path libPath = new Path(libPaths[i].trim());
                    Collection<String> libFilePaths = this.getLibFiles(fs, libPath);
                    filePaths.addAll(libFilePaths);
                }
            }
            if (jobConf.getBoolean(OOZIE_WF_SUBWORKFLOW_CLASSPATH_INHERITANCE, this.oozieSubWfCPInheritance) && (parentFilePaths = jobConf.getStrings(APP_LIB_PATH_LIST)) != null && parentFilePaths.length > 0) {
                Object[] filePathsNames = filePaths.toArray(new String[filePaths.size()]);
                for (int i = 0; i < filePathsNames.length; ++i) {
                    Path p = new Path((String)filePathsNames[i]);
                    filePathsNames[i] = p.getName();
                }
                Arrays.sort(filePathsNames);
                ArrayList<String> nonDuplicateParentFilePaths = new ArrayList<String>();
                for (String parentFilePath : parentFilePaths) {
                    Path p = new Path(parentFilePath);
                    if (Arrays.binarySearch(filePathsNames, p.getName()) >= 0) continue;
                    nonDuplicateParentFilePaths.add(parentFilePath);
                }
                filePaths.addAll(nonDuplicateParentFilePaths);
            }
            protoConf.setStrings(APP_LIB_PATH_LIST, filePaths.toArray(new String[filePaths.size()]));
            for (Map.Entry entry : jobConf) {
                if (!((String)entry.getKey()).startsWith("oozie.")) continue;
                String name = (String)entry.getKey();
                String value = (String)entry.getValue();
                if (protoConf.get(name) != null) continue;
                protoConf.set(name, value);
            }
            return protoConf;
        }
        catch (IOException ex) {
            throw new WorkflowException(ErrorCode.E0712, jobConf.get("oozie.wf.application.path"), ex.getMessage(), ex);
        }
        catch (URISyntaxException ex) {
            throw new WorkflowException(ErrorCode.E0711, jobConf.get("oozie.wf.application.path"), ex.getMessage(), ex);
        }
        catch (HadoopAccessorException ex) {
            throw new WorkflowException(ex);
        }
        catch (Exception ex) {
            throw new WorkflowException(ErrorCode.E0712, jobConf.get("oozie.wf.application.path"), ex.getMessage(), ex);
        }
    }

    public abstract WorkflowApp parseDef(Configuration var1) throws WorkflowException;

    public abstract WorkflowApp parseDef(Configuration var1, Configuration var2) throws WorkflowException;

    public abstract WorkflowApp parseDef(String var1, Configuration var2) throws WorkflowException;

    private Collection<String> getLibFiles(FileSystem fs, Path libPath) throws IOException {
        LinkedHashSet<String> libPaths = new LinkedHashSet<String>();
        if (fs.exists(libPath)) {
            FileStatus[] files;
            for (FileStatus file : files = fs.listStatus(libPath, (PathFilter)new NoPathFilter())) {
                libPaths.add(file.getPath().toUri().toString());
            }
        } else {
            XLog.getLog(this.getClass()).warn("libpath [{0}] does not exist", libPath);
        }
        return libPaths;
    }

    public Path getSystemLibPath() {
        return this.systemLibPath;
    }

    private class NoPathFilter
    implements PathFilter {
        private NoPathFilter() {
        }

        public boolean accept(Path path) {
            return true;
        }
    }
}

