/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.osgi.metastore.locator.impl.local;

import com.google.common.annotations.VisibleForTesting;
import org.pentaho.di.metastore.MetaStoreConst;
import org.pentaho.metastore.api.IMetaStore;
import org.pentaho.metastore.api.exceptions.MetaStoreException;
import org.pentaho.osgi.metastore.locator.api.MetastoreProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalFileMetastoreProvider
implements MetastoreProvider {
    private static final Logger logger = LoggerFactory.getLogger(LocalFileMetastoreProvider.class);
    private final MetastoreSupplier supplier;

    public LocalFileMetastoreProvider() {
        this(MetaStoreConst::openLocalPentahoMetaStore);
    }

    public LocalFileMetastoreProvider(MetastoreSupplier supplier) {
        this.supplier = supplier;
    }

    public IMetaStore getMetastore() {
        try {
            return this.supplier.getMetastore();
        }
        catch (MetaStoreException e) {
            logger.error("Unable to open local metastore", (Throwable)e);
            return null;
        }
    }

    @VisibleForTesting
    static interface MetastoreSupplier {
        public IMetaStore getMetastore() throws MetaStoreException;
    }
}

