/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.metaverse.analyzer.kettle.step.excelinput;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.vfs2.FileObject;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleFileException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.steps.excelinput.ExcelInput;
import org.pentaho.di.trans.steps.excelinput.ExcelInputMeta;
import org.pentaho.metaverse.api.IAnalysisContext;
import org.pentaho.metaverse.api.analyzer.kettle.step.BaseStepExternalResourceConsumer;
import org.pentaho.metaverse.api.model.ExternalResourceInfoFactory;
import org.pentaho.metaverse.api.model.IExternalResourceInfo;

public class ExcelInputExternalResourceConsumer
extends BaseStepExternalResourceConsumer<ExcelInput, ExcelInputMeta> {
    public boolean isDataDriven(ExcelInputMeta meta) {
        return meta.isAcceptingFilenames();
    }

    public Collection<IExternalResourceInfo> getResourcesFromMeta(ExcelInputMeta meta, IAnalysisContext context) {
        String[] paths;
        TransMeta parentTransMeta;
        StepMeta parentStepMeta;
        List<IExternalResourceInfo> resources = Collections.emptyList();
        if (!this.isDataDriven(meta) && (parentStepMeta = meta.getParentStepMeta()) != null && (parentTransMeta = parentStepMeta.getParentTransMeta()) != null && (paths = meta.getFilePaths((VariableSpace)parentTransMeta)) != null) {
            resources = new ArrayList<IExternalResourceInfo>(paths.length);
            for (String path : paths) {
                if (Const.isEmpty((String)path)) continue;
                try {
                    IExternalResourceInfo resource = ExternalResourceInfoFactory.createFileResource((FileObject)KettleVFS.getFileObject((String)path), (boolean)true);
                    if (resource == null) {
                        throw new KettleFileException("Error getting file resource!");
                    }
                    resources.add(resource);
                }
                catch (KettleFileException kettleFileException) {
                    // empty catch block
                }
            }
        }
        return resources;
    }

    public Collection<IExternalResourceInfo> getResourcesFromRow(ExcelInput excelInput, RowMetaInterface rowMeta, Object[] row) {
        LinkedList<IExternalResourceInfo> resources = new LinkedList<IExternalResourceInfo>();
        ExcelInputMeta meta = (ExcelInputMeta)excelInput.getStepMetaInterface();
        if (meta == null) {
            meta = (ExcelInputMeta)excelInput.getStepMeta().getStepMetaInterface();
        }
        try {
            String filename = rowMeta.getString(row, meta.getAcceptingField(), null);
            if (!Const.isEmpty((String)filename)) {
                FileObject fileObject = KettleVFS.getFileObject((String)filename);
                resources.add(ExternalResourceInfoFactory.createFileResource((FileObject)fileObject, (boolean)true));
            }
        }
        catch (KettleException kettleException) {
            // empty catch block
        }
        return resources;
    }

    public Class<ExcelInputMeta> getMetaClass() {
        return ExcelInputMeta.class;
    }
}

