/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.metaverse.analyzer.kettle.step.jobexecutor;

import java.io.FileNotFoundException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.pentaho.di.base.AbstractMeta;
import org.pentaho.di.core.ProgressMonitorListener;
import org.pentaho.di.core.ProgressNullMonitorListener;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleMissingPluginsException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.repository.RepositoryDirectoryInterface;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.steps.jobexecutor.JobExecutorMeta;
import org.pentaho.dictionary.DictionaryConst;
import org.pentaho.metaverse.analyzer.kettle.JobAnalyzer;
import org.pentaho.metaverse.api.IComponentDescriptor;
import org.pentaho.metaverse.api.IDocument;
import org.pentaho.metaverse.api.IMetaverseBuilder;
import org.pentaho.metaverse.api.IMetaverseNode;
import org.pentaho.metaverse.api.INamespace;
import org.pentaho.metaverse.api.MetaverseAnalyzerException;
import org.pentaho.metaverse.api.MetaverseComponentDescriptor;
import org.pentaho.metaverse.api.StepField;
import org.pentaho.metaverse.api.analyzer.kettle.KettleAnalyzerUtil;
import org.pentaho.metaverse.api.analyzer.kettle.jobentry.IJobEntryAnalyzerProvider;
import org.pentaho.metaverse.api.analyzer.kettle.step.IClonableStepAnalyzer;
import org.pentaho.metaverse.api.analyzer.kettle.step.StepAnalyzer;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobExecutorStepAnalyzer
extends StepAnalyzer<JobExecutorMeta> {
    public static final String JOB_TO_EXECUTE = "jobToExecute";
    public static final String EXECUTION_RESULTS_TARGET = "executionResultsTarget";
    public static final String OUTPUT_ROWS_TARGET = "outputRowsTarget";
    public static final String RESULT_FILES_TARGET = "resultFilesTarget";
    private Logger log = LoggerFactory.getLogger(JobExecutorStepAnalyzer.class);

    protected Set<StepField> getUsedFields(JobExecutorMeta meta) {
        return this.getInputs().getFieldNames();
    }

    protected boolean isPassthrough(StepField originalFieldName) {
        return false;
    }

    protected void customAnalyze(JobExecutorMeta meta, IMetaverseNode node) throws MetaverseAnalyzerException {
        String jobPath = meta.getFileName();
        JobMeta subJobMeta = null;
        Repository repo = this.parentTransMeta.getRepository();
        switch (meta.getSpecificationMethod()) {
            case FILENAME: {
                jobPath = this.parentTransMeta.environmentSubstitute(meta.getFileName());
                try {
                    String normalized = KettleAnalyzerUtil.normalizeFilePath((String)jobPath);
                    subJobMeta = this.getSubJobMeta((VariableSpace)this.parentTransMeta, normalized);
                    jobPath = normalized;
                    break;
                }
                catch (Exception e) {
                    throw new MetaverseAnalyzerException("Sub transformation can not be found - " + jobPath, (Throwable)e);
                }
            }
            case REPOSITORY_BY_NAME: {
                if (repo != null) {
                    String dir = this.parentTransMeta.environmentSubstitute(meta.getDirectoryPath());
                    String file = this.parentTransMeta.environmentSubstitute(meta.getJobName());
                    try {
                        RepositoryDirectoryInterface rdi = repo.findDirectory(dir);
                        subJobMeta = repo.loadJob(file, rdi, null, null);
                        String filename = subJobMeta.getFilename() == null ? subJobMeta.toString() : subJobMeta.getFilename();
                        jobPath = filename + "." + subJobMeta.getDefaultExtension();
                        break;
                    }
                    catch (KettleException e) {
                        throw new MetaverseAnalyzerException("Sub transformation can not be found in repository - " + file, (Throwable)e);
                    }
                }
                throw new MetaverseAnalyzerException("Not connected to a repository, can't get the transformation");
            }
            case REPOSITORY_BY_REFERENCE: {
                if (repo != null) {
                    try {
                        subJobMeta = repo.loadJob(meta.getJobObjectId(), null);
                        String filename = subJobMeta.getFilename() == null ? subJobMeta.toString() : subJobMeta.getFilename();
                        jobPath = filename + "." + subJobMeta.getDefaultExtension();
                        break;
                    }
                    catch (KettleException e) {
                        throw new MetaverseAnalyzerException("Sub transformation can not be found by reference - " + meta.getJobObjectId(), (Throwable)e);
                    }
                }
                throw new MetaverseAnalyzerException("Not connected to a repository, can't get the transformation");
            }
        }
        subJobMeta.copyVariablesFrom((VariableSpace)this.parentTransMeta);
        MetaverseComponentDescriptor ds = new MetaverseComponentDescriptor(subJobMeta.getName(), "Job", this.descriptor.getNamespace().getParentNamespace());
        IMetaverseNode jobNode = this.createNodeFromDescriptor((IComponentDescriptor)ds);
        jobNode.setProperty("namespace", (Object)ds.getNamespaceId());
        jobNode.setProperty("path", (Object)jobPath);
        jobNode.setLogicalIdGenerator(DictionaryConst.LOGICAL_ID_GENERATOR_DOCUMENT);
        this.metaverseBuilder.addLink(node, "executes", jobNode);
        IDocument subTransDocument = KettleAnalyzerUtil.buildDocument((IMetaverseBuilder)this.getMetaverseBuilder(), (AbstractMeta)subJobMeta, (String)jobPath, (INamespace)this.getDocumentDescriptor().getNamespace());
        MetaverseComponentDescriptor subtransDocumentDescriptor = new MetaverseComponentDescriptor(subTransDocument.getStringID(), "Transformation", this.getDocumentDescriptor().getNamespace(), this.getDescriptor().getContext());
        JobAnalyzer jobAnalyzer = new JobAnalyzer();
        jobAnalyzer.setJobEntryAnalyzerProvider((IJobEntryAnalyzerProvider)PentahoSystem.get(IJobEntryAnalyzerProvider.class));
        jobAnalyzer.setMetaverseBuilder(this.getMetaverseBuilder());
        jobAnalyzer.analyze((IComponentDescriptor)subtransDocumentDescriptor, (AbstractMeta)subJobMeta, jobNode, jobPath);
        this.connectToSubJobOutputFields(meta, subJobMeta, jobNode, this.descriptor);
        node.setProperty(JOB_TO_EXECUTE, (Object)jobPath);
        if (StringUtils.isNotEmpty((String)meta.getExecutionResultTargetStep())) {
            node.setProperty(EXECUTION_RESULTS_TARGET, (Object)meta.getExecutionResultTargetStep());
        }
        if (StringUtils.isNotEmpty((String)meta.getResultFilesTargetStep())) {
            node.setProperty(RESULT_FILES_TARGET, (Object)meta.getResultFilesTargetStep());
        }
    }

    protected JobMeta getSubJobMeta(VariableSpace variableSpace, String filePath) throws FileNotFoundException, KettleXMLException, KettleMissingPluginsException {
        return new JobMeta(variableSpace, filePath, null, null, null);
    }

    protected void connectToSubJobOutputFields(JobExecutorMeta meta, JobMeta subJobMeta, IMetaverseNode subTransNode, IComponentDescriptor descriptor) {
        if (meta.getResultRowsTargetStep() != null) {
            String outputStep = meta.getResultRowsTargetStep();
            for (int i = 0; i < meta.getResultRowsField().length; ++i) {
                String fieldName = meta.getResultRowsField()[i];
                IMetaverseNode iMetaverseNode = this.getOutputs().findNode(outputStep, fieldName);
            }
        }
    }

    protected Map<String, RowMetaInterface> getOutputRowMetaInterfaces(JobExecutorMeta meta) {
        HashMap<String, RowMetaInterface> outputFields = new HashMap<String, RowMetaInterface>();
        String[] nextStepNames = this.parentTransMeta.getNextStepNames(this.parentStepMeta);
        for (int i = 0; i < nextStepNames.length; ++i) {
            String nextStepName = nextStepNames[i];
            StepMeta step = this.parentTransMeta.findStep(nextStepName);
            ProgressNullMonitorListener progressMonitor = new ProgressNullMonitorListener();
            try {
                RowMetaInterface prevStepFields = this.parentTransMeta.getPrevStepFields(step, (ProgressMonitorListener)progressMonitor);
                outputFields.put(nextStepName, prevStepFields);
                progressMonitor.done();
                continue;
            }
            catch (KettleStepException e) {
                this.log.warn("Could not get step fields for " + nextStepName, (Throwable)e);
            }
        }
        return outputFields;
    }

    public Set<Class<? extends BaseStepMeta>> getSupportedSteps() {
        HashSet<Class<? extends BaseStepMeta>> supportedSteps = new HashSet<Class<? extends BaseStepMeta>>();
        supportedSteps.add(JobExecutorMeta.class);
        return supportedSteps;
    }

    protected void setParentTransMeta(TransMeta parentTransMeta) {
        this.parentTransMeta = parentTransMeta;
    }

    protected void setParentStepMeta(StepMeta parentStepMeta) {
        this.parentStepMeta = parentStepMeta;
    }

    protected IMetaverseNode createFieldNode(IComponentDescriptor fieldDescriptor, ValueMetaInterface fieldMeta, String targetStepName, boolean addTheNode) {
        return super.createFieldNode(fieldDescriptor, fieldMeta, targetStepName, addTheNode);
    }

    public IClonableStepAnalyzer newInstance() {
        return new JobExecutorStepAnalyzer();
    }
}

