/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.metaverse.impl.model.kettle.json;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.List;
import org.pentaho.di.base.AbstractMeta;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.parameters.UnknownParamException;
import org.pentaho.metaverse.api.model.BaseResourceInfo;
import org.pentaho.metaverse.api.model.ExternalResourceInfoFactory;
import org.pentaho.metaverse.impl.model.ParamInfo;
import org.pentaho.metaverse.impl.model.kettle.LineageRepository;
import org.pentaho.metaverse.messages.Messages;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMetaJsonSerializer<T extends AbstractMeta>
extends StdSerializer<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractMetaJsonSerializer.class);
    public static final String JSON_PROPERTY_PARAMETERS = "parameters";
    public static final String JSON_PROPERTY_STEPS = "steps";
    public static final String JSON_PROPERTY_CONNECTIONS = "connections";
    public static final String JSON_PROPERTY_HOPS = "hops";
    public static final String JSON_PROPERTY_VARIABLES = "variables";
    public static final String JSON_PROPERTY_CREATED_DATE = "created";
    public static final String JSON_PROPERTY_LAST_MODIFIED_DATE = "lastmodified";
    public static final String JSON_PROPERTY_CREATED_BY = "createdby";
    public static final String JSON_PROPERTY_LAST_MODIFIED_BY = "lastmodifiedby";
    public static final String JSON_PROPERTY_PATH = "path";
    public static final String JSON_PROPERTY_REPOSITORY = "repository";
    private LineageRepository lineageRepository;

    protected AbstractMetaJsonSerializer(Class<T> aClass) {
        super(aClass);
    }

    protected AbstractMetaJsonSerializer(JavaType javaType) {
        super(javaType);
    }

    protected AbstractMetaJsonSerializer(Class<?> aClass, boolean b) {
        super(aClass, b);
    }

    public LineageRepository getLineageRepository() {
        return this.lineageRepository;
    }

    public void setLineageRepository(LineageRepository repo) {
        this.lineageRepository = repo;
    }

    public void serialize(T meta, JsonGenerator json, SerializerProvider serializerProvider) throws IOException, JsonGenerationException {
        json.writeStartObject();
        json.writeStringField("@class", meta.getClass().getName());
        json.writeStringField("name", meta.getName());
        json.writeStringField("description", meta.getDescription());
        json.writeObjectField(JSON_PROPERTY_CREATED_DATE, (Object)meta.getCreatedDate());
        json.writeObjectField(JSON_PROPERTY_LAST_MODIFIED_DATE, (Object)meta.getModifiedDate());
        json.writeStringField(JSON_PROPERTY_CREATED_BY, meta.getCreatedUser());
        json.writeStringField(JSON_PROPERTY_LAST_MODIFIED_BY, meta.getModifiedUser());
        json.writeStringField(JSON_PROPERTY_PATH, meta.getFilename());
        if (meta.getRepository() != null) {
            json.writeStringField(JSON_PROPERTY_REPOSITORY, meta.getRepository().getName());
        }
        this.serializeParameters(meta, json);
        this.serializeVariables(meta, json);
        this.serializeSteps(meta, json);
        this.serializeConnections(meta, json);
        this.serializeHops(meta, json);
        json.writeEndObject();
    }

    protected abstract void serializeHops(T var1, JsonGenerator var2) throws IOException;

    protected void serializeConnections(T meta, JsonGenerator json) throws IOException {
        json.writeArrayFieldStart(JSON_PROPERTY_CONNECTIONS);
        for (DatabaseMeta dbmeta : meta.getDatabases()) {
            BaseResourceInfo resourceInfo = (BaseResourceInfo)ExternalResourceInfoFactory.createDatabaseResource((DatabaseMeta)dbmeta);
            resourceInfo.setInput(true);
            json.writeObject((Object)resourceInfo);
        }
        json.writeEndArray();
    }

    protected abstract void serializeSteps(T var1, JsonGenerator var2) throws IOException;

    protected abstract List<String> getUsedVariables(T var1);

    protected void serializeVariables(T meta, JsonGenerator json) throws IOException {
        json.writeArrayFieldStart(JSON_PROPERTY_VARIABLES);
        List<String> variables = this.getUsedVariables(meta);
        if (variables != null) {
            for (String param : variables) {
                ParamInfo paramInfo = new ParamInfo(param, meta.getVariable(param));
                json.writeObject((Object)paramInfo);
            }
        }
        json.writeEndArray();
    }

    protected void serializeParameters(T meta, JsonGenerator json) throws IOException {
        json.writeArrayFieldStart(JSON_PROPERTY_PARAMETERS);
        String[] parameters = meta.listParameters();
        if (parameters != null) {
            for (String param : parameters) {
                try {
                    ParamInfo paramInfo = new ParamInfo(param, null, meta.getParameterDefault(param), meta.getParameterDescription(param));
                    json.writeObject((Object)paramInfo);
                }
                catch (UnknownParamException e) {
                    LOGGER.warn(Messages.getString("WARNING.Serialization.Trans.Param", param), (Throwable)e);
                }
            }
        }
        json.writeEndArray();
    }
}

