/*
 * Decompiled with CFR 0.152.
 */
package mondrian.gui;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import mondrian.gui.I18n;
import mondrian.gui.Workbench;
import org.apache.log4j.Logger;

public class JdbcMetaData {
    private static final Logger LOGGER = Logger.getLogger(JdbcMetaData.class);
    String jdbcDriverClassName = null;
    String jdbcUsername = null;
    String jdbcConnectionUrl = null;
    String jdbcPassword = null;
    String jdbcSchema = null;
    boolean requireSchema = false;
    Connection conn = null;
    DatabaseMetaData md = null;
    Workbench workbench;
    public static final String LEVEL_SEPARATOR = "->";
    private String errMsg = null;
    private Database db = new Database();

    public JdbcMetaData(Workbench wb, String jdbcDriverClassName, String jdbcConnectionUrl, String jdbcUsername, String jdbcPassword, String jdbcSchema, boolean requireSchema) {
        this.workbench = wb;
        this.jdbcConnectionUrl = jdbcConnectionUrl;
        this.jdbcDriverClassName = jdbcDriverClassName;
        this.jdbcUsername = jdbcUsername;
        this.jdbcPassword = jdbcPassword;
        this.jdbcSchema = jdbcSchema;
        this.requireSchema = requireSchema;
        if (this.initConnection() == null) {
            this.setAllSchemas();
            this.closeConnection();
        }
    }

    public boolean getRequireSchema() {
        return this.requireSchema;
    }

    public I18n getResourceConverter() {
        return this.workbench.getResourceConverter();
    }

    public JdbcMetaData(String jdbcDriverClassName, String jdbcConnectionUrl, String jdbcUsername, String jdbcPassword) {
        this.jdbcConnectionUrl = jdbcConnectionUrl;
        this.jdbcDriverClassName = jdbcDriverClassName;
        this.jdbcUsername = jdbcUsername;
        this.jdbcPassword = jdbcPassword;
        if (this.initConnection() == null) {
            this.closeConnection();
        }
    }

    public String initConnection() {
        LOGGER.debug((Object)"JdbcMetaData: initConnection");
        try {
            if (this.jdbcDriverClassName == null || this.jdbcDriverClassName.trim().length() == 0 || this.jdbcConnectionUrl == null || this.jdbcConnectionUrl.trim().length() == 0) {
                this.errMsg = this.getResourceConverter().getFormattedString("jdbcMetaData.blank.exception", "Driver={0}\nConnection URL={1}\nUse Preferences to set Database Connection parameters first and then open a Schema", this.jdbcDriverClassName, this.jdbcConnectionUrl);
                return this.errMsg;
            }
            Class.forName(this.jdbcDriverClassName);
            this.conn = this.jdbcUsername != null && this.jdbcUsername.length() > 0 ? DriverManager.getConnection(this.jdbcConnectionUrl, this.jdbcUsername, this.jdbcPassword) : DriverManager.getConnection(this.jdbcConnectionUrl);
            LOGGER.debug((Object)"JDBC connection OPEN");
            this.md = this.conn.getMetaData();
            this.db.productName = this.md.getDatabaseProductName();
            this.db.productVersion = this.md.getDatabaseProductVersion();
            this.db.catalogName = this.conn.getCatalog();
            LOGGER.debug((Object)("Catalog name = " + this.db.catalogName));
            LOGGER.debug((Object)("Database Product Name: " + this.db.productName));
            LOGGER.debug((Object)("Database Product Version: " + this.db.productVersion));
            LOGGER.debug((Object)"JdbcMetaData: initConnection - no error");
            return null;
        }
        catch (Exception e) {
            this.errMsg = e.getClass().getSimpleName() + " : " + e.getLocalizedMessage();
            LOGGER.error((Object)("Database connection exception : " + this.errMsg), (Throwable)e);
            return this.errMsg;
        }
    }

    public void closeConnection() {
        if (this.conn == null) {
            return;
        }
        this.md = null;
        try {
            this.conn.close();
            LOGGER.debug((Object)"JDBC connection CLOSE");
        }
        catch (Exception e) {
            LOGGER.error((Object)e);
        }
        this.conn = null;
    }

    private boolean inJdbcSchemas(String schemaName) {
        String[] schemas;
        if (this.jdbcSchema == null || this.jdbcSchema.trim().length() == 0) {
            return true;
        }
        for (String schema : schemas = this.jdbcSchema.split("[,;]")) {
            if (!schema.trim().equalsIgnoreCase(schemaName)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> listAllSchemas() {
        LOGGER.debug((Object)"JdbcMetaData: listAllSchemas");
        if (this.initConnection() != null) {
            return null;
        }
        ArrayList<String> schemaNames = new ArrayList<String>();
        ResultSet rs = null;
        try {
            rs = this.md.getSchemas();
            while (rs.next()) {
                String schemaName = rs.getString("TABLE_SCHEM");
                schemaNames.add(schemaName);
            }
        }
        catch (Exception e) {
            LOGGER.debug((Object)("Exception : Database does not support schemas." + e.getMessage()));
            List<String> list = null;
            return list;
        }
        finally {
            try {
                rs.close();
                this.closeConnection();
            }
            catch (Exception exception) {}
        }
        return schemaNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setAllSchemas() {
        LOGGER.debug((Object)"JdbcMetaData: setAllSchemas");
        ResultSet rs = null;
        boolean gotSchema = false;
        try {
            rs = this.md.getSchemas();
            while (rs.next()) {
                String schemaName = rs.getString("TABLE_SCHEM");
                if (!this.inJdbcSchemas(schemaName)) continue;
                DbSchema dbs = new DbSchema();
                dbs.name = schemaName;
                LOGGER.debug((Object)("JdbcMetaData: setAllTables - " + dbs.name));
                this.setAllTables(dbs);
                this.db.addDbSchema(dbs);
                gotSchema = true;
            }
        }
        catch (Exception e) {
            LOGGER.debug((Object)("Exception : Database does not support schemas." + e.getMessage()));
        }
        finally {
            try {
                rs.close();
            }
            catch (Exception e) {}
        }
        if (!gotSchema) {
            LOGGER.debug((Object)"JdbcMetaData: setAllSchemas - tables with no schema name");
            DbSchema dbs = new DbSchema();
            dbs.name = null;
            this.setAllTables(dbs);
            this.db.addDbSchema(dbs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setAllTables(DbSchema dbs) {
        LOGGER.debug((Object)("JdbcMetaData: Loading schema: '" + dbs.name + "'"));
        ResultSet rs = null;
        try {
            try {
                rs = this.md.getTables(null, dbs.name, null, new String[]{"TABLE", "VIEW"});
            }
            catch (Exception e) {
                rs = this.md.getTables(null, dbs.name, null, new String[]{"TABLE"});
            }
            while (rs.next()) {
                DbTable dbt;
                String tbname;
                block26: {
                    tbname = rs.getString("TABLE_NAME");
                    if (!tbname.matches("(?!BIN\\$).+")) continue;
                    dbt = null;
                    try {
                        ResultSet rs_fks = this.md.getImportedKeys(null, dbs.name, tbname);
                        try {
                            if (rs_fks.next()) {
                                dbt = new FactTable();
                                do {
                                    ((FactTable)dbt).addFks(rs_fks.getString("FKCOLUMN_NAME"), rs_fks.getString("pktable_name"));
                                } while (rs_fks.next());
                            } else {
                                dbt = new DbTable();
                            }
                        }
                        finally {
                            try {
                                rs_fks.close();
                            }
                            catch (Exception exception) {}
                        }
                    }
                    catch (Exception e) {
                        LOGGER.warn((Object)"unable to process foreign keys", (Throwable)e);
                        if (dbt != null) break block26;
                        dbt = new FactTable();
                    }
                }
                dbt.schemaName = dbs.name;
                dbt.name = tbname;
                this.setPKey(dbt);
                dbs.addDbTable(dbt);
                this.db.addDbTable(dbt);
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)"setAllTables", (Throwable)e);
        }
        finally {
            try {
                rs.close();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setPKey(DbTable dbt) {
        ResultSet rs = null;
        try {
            rs = this.md.getPrimaryKeys(null, dbt.schemaName, dbt.name);
            if (rs.next()) {
                dbt.pk = rs.getString("column_name");
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)"setPKey", (Throwable)e);
        }
        finally {
            try {
                rs.close();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setColumns(String schemaName, String tableName) {
        LOGGER.debug((Object)("setColumns: <" + tableName + "> in schema <" + schemaName + ">"));
        DbTable dbt = this.db.getTable(schemaName, tableName);
        if (dbt == null) {
            LOGGER.debug((Object)("No table with name: <" + tableName + "> in schema <" + schemaName + ">"));
            return;
        }
        if (this.initConnection() != null) {
            return;
        }
        try {
            this.setColumns(dbt);
            LOGGER.debug((Object)("got " + dbt.colsDataType.size() + " columns"));
        }
        finally {
            this.closeConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setColumns(DbTable dbt) {
        ResultSet rs = null;
        try {
            rs = this.md.getColumns(null, dbt.schemaName, dbt.name, null);
            while (rs.next()) {
                DbColumn col = new DbColumn();
                col.dataType = rs.getInt("DATA_TYPE");
                col.name = rs.getString("COLUMN_NAME");
                col.typeName = rs.getString("TYPE_NAME");
                col.columnSize = JdbcMetaData.getSafeInt(rs, "COLUMN_SIZE");
                col.decimalDigits = JdbcMetaData.getSafeInt(rs, "DECIMAL_DIGITS");
                dbt.addColsDataType(col);
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)"setColumns", (Throwable)e);
        }
        finally {
            try {
                rs.close();
            }
            catch (Exception exception) {}
        }
    }

    private static int getSafeInt(ResultSet rs, String columnName) throws SQLException {
        try {
            return rs.getInt(columnName);
        }
        catch (Exception e) {
            if (rs.wasNull()) {
                return 0;
            }
            throw new SQLException(e);
        }
    }

    public List<String> getAllSchemas() {
        return this.db.getAllSchemas();
    }

    public List<String> getAllTables(String schemaName) {
        return this.db.getAllTables(schemaName);
    }

    public List<String> getAllTables(String schemaName, String minusTable) {
        if (minusTable == null) {
            return this.getAllTables(schemaName);
        }
        ArrayList<String> allTablesMinusOne = new ArrayList<String>();
        for (String s : this.getAllTables(schemaName)) {
            if (s.endsWith(minusTable) && (schemaName == null || s.startsWith(schemaName))) continue;
            allTablesMinusOne.add(s);
        }
        return allTablesMinusOne;
    }

    public List<String> getFactTables(String schemaName) {
        return this.db.getFactTables(schemaName);
    }

    public List<String> getDimensionTables(String schemaName, String factTable) {
        ArrayList<String> dimeTables = new ArrayList<String>();
        if (factTable == null) {
            return dimeTables;
        }
        return this.db.getDimensionTables(schemaName, factTable);
    }

    public boolean isTableExists(String schemaName, String tableName) {
        if (tableName == null) {
            return true;
        }
        return this.db.tableExists(schemaName, tableName);
    }

    public boolean isColExists(String schemaName, String tableName, String colName) {
        if (tableName == null || colName == null) {
            return true;
        }
        if (!this.db.hasColumns(schemaName, tableName)) {
            this.setColumns(schemaName, tableName);
        }
        return this.db.colExists(schemaName, tableName, colName);
    }

    public List<String> getFactTableFKs(String schemaName, String factTable) {
        ArrayList<String> fks = new ArrayList<String>();
        if (factTable == null) {
            return fks;
        }
        return this.db.getFactTableFKs(schemaName, factTable);
    }

    public String getTablePK(String schemaName, String tableName) {
        if (tableName == null) {
            return null;
        }
        return this.db.getTablePK(schemaName, tableName);
    }

    public List<String> getAllColumns(String schemaName, String tableName) {
        ArrayList<String> allcols = new ArrayList<String>();
        if (tableName == null) {
            List<String> allTables = this.getAllTables(schemaName);
            for (int i = 0; i < allTables.size(); ++i) {
                List<String> cols;
                String tab = allTables.get(i);
                if (tab.indexOf(LEVEL_SEPARATOR) == -1) {
                    cols = this.getAllColumns(schemaName, tab);
                } else {
                    String[] names = tab.split(LEVEL_SEPARATOR);
                    cols = this.getAllColumns(names[0], names[1]);
                }
                for (int j = 0; j < cols.size(); ++j) {
                    String col = cols.get(j);
                    allcols.add(tab + LEVEL_SEPARATOR + col);
                }
            }
            return allcols;
        }
        if (!this.db.hasColumns(schemaName, tableName)) {
            this.setColumns(schemaName, tableName);
        }
        return this.db.getAllColumns(schemaName, tableName);
    }

    public List<DbColumn> getAllDbColumns(String schemaName, String tableName) {
        ArrayList<DbColumn> allcols = new ArrayList<DbColumn>();
        if (tableName == null) {
            List<String> allTables = this.getAllTables(schemaName);
            for (int i = 0; i < allTables.size(); ++i) {
                List<DbColumn> cols;
                String tab = allTables.get(i);
                if (tab.indexOf(LEVEL_SEPARATOR) == -1) {
                    cols = this.getAllDbColumns(schemaName, tab);
                } else {
                    String[] names = tab.split(LEVEL_SEPARATOR);
                    cols = this.getAllDbColumns(names[0], names[1]);
                }
                allcols.addAll(cols);
            }
            return allcols;
        }
        if (!this.db.hasColumns(schemaName, tableName)) {
            this.setColumns(schemaName, tableName);
        }
        return this.db.getAllDbColumns(schemaName, tableName);
    }

    public int getColumnDataType(String schemaName, String tableName, String colName) {
        if (tableName == null || colName == null) {
            return -1;
        }
        if (!this.db.hasColumns(schemaName, tableName)) {
            this.setColumns(schemaName, tableName);
        }
        return this.db.getColumnDataType(schemaName, tableName, colName);
    }

    public DbColumn getColumnDefinition(String schemaName, String tableName, String colName) {
        if (tableName == null || colName == null) {
            return null;
        }
        if (!this.db.hasColumns(schemaName, tableName)) {
            this.setColumns(schemaName, tableName);
        }
        return this.db.getColumnDefinition(schemaName, tableName, colName);
    }

    public String getDbCatalogName() {
        return this.db.catalogName;
    }

    public String getDatabaseProductName() {
        return this.db.productName;
    }

    public String getJdbcConnectionUrl() {
        return this.jdbcConnectionUrl;
    }

    public String getErrMsg() {
        return this.errMsg;
    }

    public static void main(String[] args) {
        if (args.length < 2) {
            throw new RuntimeException("need at least 2 args: driver class and jdbcUrl");
        }
        String driverClass = args[0];
        String jdbcUrl = args[1];
        String username = null;
        String password = null;
        if (args.length > 2) {
            if (args.length != 4) {
                throw new RuntimeException("need 4 args: including user name and password");
            }
            username = args[2];
            password = args[3];
        }
        JdbcMetaData sb = new JdbcMetaData(null, driverClass, jdbcUrl, username, password, "", false);
        List<String> foundSchemas = sb.getAllSchemas();
        System.out.println("allSchemas = " + foundSchemas);
        for (String schemaName : foundSchemas) {
            List<String> foundTables = sb.getAllTables(schemaName);
            if (foundTables == null || foundTables.size() <= 0) continue;
            System.out.println("schema = " + schemaName);
            for (String tableName : foundTables) {
                System.out.println("\t" + tableName);
                List<String> foundColumns = sb.getAllColumns(schemaName, tableName);
                for (String columnName : foundColumns) {
                    System.out.println("\t\t" + columnName);
                }
            }
        }
    }

    class FactTable
    extends DbTable {
        final Map<String, String> fks;

        FactTable() {
            this.fks = new TreeMap<String, String>();
        }

        private void addFks(String fk, String pkt) {
            this.fks.put(fk, pkt);
        }
    }

    class DbTable {
        String schemaName;
        String name;
        String pk;
        final Map<String, DbColumn> colsDataType = new TreeMap<String, DbColumn>();

        DbTable() {
        }

        private void addColsDataType(DbColumn columnDefinition) {
            this.colsDataType.put(columnDefinition.name, columnDefinition);
        }

        private DbColumn getColumn(String cname) {
            return this.colsDataType.get(cname);
        }

        private boolean hasColumns() {
            return this.colsDataType.size() > 0;
        }
    }

    public class DbColumn {
        public String name;
        public int dataType;
        public String typeName;
        public int columnSize;
        public int decimalDigits;

        public String displayType() {
            StringBuffer sb = new StringBuffer();
            switch (this.dataType) {
                case 2003: {
                    sb.append("ARRAY(" + this.columnSize + ")");
                    break;
                }
                case -5: {
                    sb.append("BIGINT");
                    break;
                }
                case -2: {
                    sb.append("BINARY(" + this.columnSize + ")");
                    break;
                }
                case 2004: {
                    sb.append("BLOB(" + this.columnSize + ")");
                    break;
                }
                case -7: {
                    sb.append("BIT");
                    break;
                }
                case 16: {
                    sb.append("BOOLEAN");
                    break;
                }
                case 1: {
                    sb.append("CHAR");
                    break;
                }
                case 2005: {
                    sb.append("CLOB(" + this.columnSize + ")");
                    break;
                }
                case 91: {
                    sb.append("DATE");
                    break;
                }
                case 3: {
                    sb.append("DECIMAL(" + this.columnSize + ", " + this.decimalDigits + ")");
                    break;
                }
                case 2001: {
                    sb.append("DISTINCT");
                    break;
                }
                case 8: {
                    sb.append("DOUBLE(" + this.columnSize + ", " + this.decimalDigits + ")");
                    break;
                }
                case 6: {
                    sb.append("FLOAT(" + this.columnSize + ", " + this.decimalDigits + ")");
                    break;
                }
                case 4: {
                    sb.append("INTEGER(" + this.columnSize + ")");
                    break;
                }
                case 2000: {
                    sb.append("JAVA_OBJECT(" + this.columnSize + ")");
                    break;
                }
                case 0: {
                    sb.append("NULL");
                    break;
                }
                case 2: {
                    sb.append("NUMERIC(" + this.columnSize + ", " + this.decimalDigits + ")");
                    break;
                }
                case 1111: {
                    sb.append("OTHER");
                    break;
                }
                case 7: {
                    sb.append("REAL(" + this.columnSize + ", " + this.decimalDigits + ")");
                    break;
                }
                case 2006: {
                    sb.append("REF");
                    break;
                }
                case 5: {
                    sb.append("SMALLINT(" + this.columnSize + ")");
                    break;
                }
                case 2002: {
                    sb.append("STRUCT");
                    break;
                }
                case 92: {
                    sb.append("TIME");
                    break;
                }
                case 93: {
                    sb.append("TIMESTAMP");
                    break;
                }
                case -6: {
                    sb.append("TINYINT(" + this.columnSize + ")");
                    break;
                }
                case -3: {
                    sb.append("VARBINARY(" + this.columnSize + ")");
                    break;
                }
                case 12: {
                    sb.append("VARCHAR(" + this.columnSize + ")");
                }
            }
            return sb.toString();
        }
    }

    class DbSchema {
        String name;
        final Map<String, DbTable> tables = new TreeMap<String, DbTable>();

        DbSchema() {
        }

        private DbTable getTable(String tableName) {
            return this.tables.get(tableName);
        }

        private void addDbTable(DbTable dbt) {
            this.tables.put(dbt.name, dbt);
        }
    }

    class Database {
        String catalogName = "";
        String productName = "Unknown";
        String productVersion = "";
        Map<String, DbSchema> schemas = new TreeMap<String, DbSchema>();
        Map<String, TableTracker> tables = new TreeMap<String, TableTracker>();
        List<String> allSchemas;

        Database() {
        }

        private void addDbSchema(DbSchema dbs) {
            this.schemas.put(dbs.name != null ? dbs.name : "", dbs);
        }

        private void addDbTable(DbTable dbs) {
            TableTracker tracker = this.tables.get(dbs.name);
            if (tracker == null) {
                tracker = new TableTracker();
                this.tables.put(dbs.name, tracker);
            }
            tracker.add(dbs);
        }

        private boolean schemaNameEquals(String a, String b) {
            return a != null && a.equals(b);
        }

        private DbSchema getSchema(String schemaName) {
            return this.schemas.get(schemaName != null ? schemaName : "");
        }

        private List<String> getAllSchemas() {
            if (this.allSchemas == null) {
                this.allSchemas = new ArrayList<String>();
                this.allSchemas.addAll(this.schemas.keySet());
            }
            return this.allSchemas;
        }

        private boolean tableExists(String sname, String tableName) {
            return this.getTable(sname, tableName) != null;
        }

        private DbTable getTable(String sname, String tableName) {
            if (sname == null || sname.equals("")) {
                TableTracker t = this.tables.get(tableName);
                if (t != null) {
                    return t.namedTable.get(0);
                }
                return null;
            }
            DbSchema s = this.schemas.get(sname);
            if (s == null) {
                return null;
            }
            return s.getTable(tableName);
        }

        private boolean hasColumns(String schemaName, String tableName) {
            DbTable table = this.getTable(schemaName, tableName);
            if (table != null) {
                return table.hasColumns();
            }
            return false;
        }

        private boolean colExists(String sname, String tableName, String colName) {
            DbTable t = this.getTable(sname, tableName);
            if (t == null) {
                return false;
            }
            return t.getColumn(colName) != null;
        }

        private List<String> getAllTables(String sname) {
            return this.getAllTables(sname, false);
        }

        private List<String> getFactTables(String sname) {
            return this.getAllTables(sname, true);
        }

        private List<String> getAllTables(String sname, boolean factOnly) {
            ArrayList<String> v;
            block5: {
                block4: {
                    v = new ArrayList<String>();
                    if (sname != null && !sname.equals("")) break block4;
                    for (TableTracker tt : this.tables.values()) {
                        for (DbTable t : tt.namedTable) {
                            if (factOnly && (!factOnly || !(t instanceof FactTable))) continue;
                            if (t.schemaName == null) {
                                v.add(t.name);
                                continue;
                            }
                            v.add(t.schemaName + JdbcMetaData.LEVEL_SEPARATOR + t.name);
                        }
                    }
                    break block5;
                }
                DbSchema s = this.getSchema(sname);
                if (s == null) break block5;
                for (DbTable t : s.tables.values()) {
                    if (factOnly && (!factOnly || !(t instanceof FactTable))) continue;
                    v.add(t.name);
                }
            }
            return v;
        }

        private List<String> getFactTableFKs(String sname, String factTable) {
            ArrayList<String> f = new ArrayList<String>();
            if (sname == null || sname.equals("")) {
                TableTracker tracker = this.tables.get(factTable);
                if (tracker == null) {
                    return f;
                }
                boolean duplicate = tracker.count() > 1;
                for (DbTable t : tracker.namedTable) {
                    if (!(t instanceof FactTable)) continue;
                    if (duplicate) {
                        for (String fk : ((FactTable)t).fks.keySet()) {
                            if (t.schemaName == null) {
                                f.add(t.name + JdbcMetaData.LEVEL_SEPARATOR + fk);
                                continue;
                            }
                            f.add(t.schemaName + JdbcMetaData.LEVEL_SEPARATOR + t.name + JdbcMetaData.LEVEL_SEPARATOR + fk);
                        }
                        continue;
                    }
                    f.addAll(((FactTable)t).fks.keySet());
                }
            } else {
                DbSchema s = this.getSchema(sname);
                if (s == null) {
                    return f;
                }
                DbTable t = s.getTable(factTable);
                if (t == null) {
                    return f;
                }
                if (t instanceof FactTable && t.name.equals(factTable)) {
                    f.addAll(((FactTable)t).fks.keySet());
                }
            }
            return f;
        }

        private List<String> getDimensionTables(String sname, String factTable) {
            ArrayList<String> f = new ArrayList<String>();
            if (sname == null || sname.equals("")) {
                TableTracker tracker = this.tables.get(factTable);
                if (tracker == null) {
                    return f;
                }
                boolean duplicate = tracker.count() > 1;
                for (DbTable t : tracker.namedTable) {
                    if (!(t instanceof FactTable)) continue;
                    if (duplicate) {
                        for (String fkt : ((FactTable)t).fks.values()) {
                            if (t.schemaName == null) {
                                f.add(t.name + JdbcMetaData.LEVEL_SEPARATOR + fkt);
                                continue;
                            }
                            f.add(t.schemaName + JdbcMetaData.LEVEL_SEPARATOR + t.name + JdbcMetaData.LEVEL_SEPARATOR + fkt);
                        }
                        continue;
                    }
                    f.addAll(((FactTable)t).fks.keySet());
                }
            } else {
                DbSchema s = this.getSchema(sname);
                if (s == null) {
                    return f;
                }
                DbTable t = s.getTable(factTable);
                if (t == null) {
                    return f;
                }
                if (t instanceof FactTable && t.name.equals(factTable)) {
                    f.addAll(((FactTable)t).fks.values());
                }
            }
            return f;
        }

        private String getTablePK(String sname, String tableName) {
            if (sname == null || sname.equals("")) {
                TableTracker tracker = this.tables.get(tableName);
                if (tracker == null) {
                    return null;
                }
                return tracker.namedTable.get((int)0).pk;
            }
            DbTable t = this.getTable(sname, tableName);
            if (t == null) {
                return null;
            }
            return t.pk;
        }

        private List<String> getAllColumns(String sname, String tableName) {
            ArrayList<String> f = new ArrayList<String>();
            if (sname == null || sname.equals("")) {
                TableTracker tracker = this.tables.get(tableName);
                if (tracker == null) {
                    return f;
                }
                boolean duplicate = tracker.count() > 1;
                for (DbTable t : tracker.namedTable) {
                    for (Map.Entry<String, DbColumn> c : t.colsDataType.entrySet()) {
                        StringBuffer sb = new StringBuffer();
                        if (t.schemaName != null && !duplicate) {
                            sb.append(t.schemaName).append(JdbcMetaData.LEVEL_SEPARATOR);
                        }
                        sb.append(t.name).append(JdbcMetaData.LEVEL_SEPARATOR).append(c.getKey()).append(" - ").append(c.getValue().displayType());
                        f.add(sb.toString());
                    }
                }
            } else {
                DbTable t = this.getTable(sname, tableName);
                if (t == null) {
                    return f;
                }
                f.addAll(t.colsDataType.keySet());
            }
            return f;
        }

        private List<DbColumn> getAllDbColumns(String sname, String tableName) {
            ArrayList<DbColumn> f = new ArrayList<DbColumn>();
            if (sname == null || sname.equals("")) {
                TableTracker tracker = this.tables.get(tableName);
                if (tracker == null) {
                    return f;
                }
                for (DbTable t : tracker.namedTable) {
                    for (Map.Entry<String, DbColumn> c : t.colsDataType.entrySet()) {
                        f.add(c.getValue());
                    }
                }
            } else {
                DbTable t = this.getTable(sname, tableName);
                if (t == null) {
                    return f;
                }
                for (Map.Entry<String, DbColumn> c : t.colsDataType.entrySet()) {
                    f.add(c.getValue());
                }
            }
            return f;
        }

        private int getColumnDataType(String sname, String tableName, String colName) {
            DbColumn result = this.getColumnDefinition(sname, tableName, colName);
            if (result == null) {
                return -1;
            }
            return result.dataType;
        }

        private DbColumn getColumnDefinition(String sname, String tableName, String colName) {
            DbTable t = this.getTable(sname, tableName);
            if (t == null) {
                return null;
            }
            return t.colsDataType.get(colName);
        }

        class TableTracker {
            List<DbTable> namedTable = new ArrayList<DbTable>();

            TableTracker() {
            }

            public void add(DbTable table) {
                this.namedTable.add(table);
            }

            public int count() {
                return this.namedTable.size();
            }
        }
    }
}

