/*
 * Decompiled with CFR 0.152.
 */
package mondrian.gui;

import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.DefaultCellEditor;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.border.EtchedBorder;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.plaf.basic.BasicArrowButton;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.text.DefaultEditorKit;
import javax.swing.tree.TreePath;
import mondrian.gui.I18n;
import mondrian.gui.JTreeUpdater;
import mondrian.gui.JdbcMetaData;
import mondrian.gui.MondrianGuiDef;
import mondrian.gui.PropertyTableModel;
import mondrian.gui.SchemaPropertyCellEditor;
import mondrian.gui.SchemaPropertyCellRenderer;
import mondrian.gui.SchemaTreeCellEditor;
import mondrian.gui.SchemaTreeCellRenderer;
import mondrian.gui.SchemaTreeModel;
import mondrian.gui.Workbench;
import org.apache.log4j.Logger;
import org.eigenbase.xom.ElementDef;
import org.eigenbase.xom.Parser;
import org.eigenbase.xom.XMLOutput;
import org.eigenbase.xom.XOMException;
import org.eigenbase.xom.XOMUtil;

public class SchemaExplorer
extends JPanel
implements TreeSelectionListener,
CellEditorListener {
    private static final Logger LOGGER = Logger.getLogger(SchemaExplorer.class);
    private final Workbench workbench;
    private MondrianGuiDef.Schema schema;
    private SchemaTreeModel model;
    private SchemaTreeCellRenderer renderer;
    private File schemaFile;
    private JTreeUpdater updater;
    private final ClassLoader myClassLoader;
    private boolean newFile;
    private boolean dirty = false;
    private boolean dirtyFlag = false;
    private JInternalFrame parentIFrame;
    private JdbcMetaData jdbcMetaData;
    private boolean editModeXML = false;
    private String errMsg = null;
    public Object lastSelected;
    static final String[] DEF_DEFAULT = new String[0];
    static final String[] DEF_VIRTUAL_CUBE = new String[]{"name", "description", "caption", "enabled", "visible"};
    static final String[] DEF_VIRTUAL_CUBE_MEASURE = new String[]{"name", "cubeName", "visible"};
    static final String[] DEF_VIRTUAL_CUBE_DIMENSION = new String[]{"name", "cubeName", "caption", "foreignKey"};
    static final String[] DEF_VIEW = new String[]{"alias"};
    static final String[] DEF_TABLE = new String[]{"schema", "name", "alias"};
    static final String[] DEF_AGG_FACT_COUNT = new String[]{"column"};
    static final String[] DEF_AGG_MEASURE_FACT_COUNT = new String[]{"column", "factColumn"};
    static final String[] DEF_AGG_NAME = new String[]{"name", "ignorecase", "approxRowCount"};
    static final String[] DEF_AGG_PATTERN = new String[]{"pattern", "ignorecase"};
    static final String[] DEF_AGG_EXCLUDE = new String[]{"pattern", "name", "ignorecase"};
    static final String[] DEF_AGG_IGNORE_COLUMN = new String[]{"column"};
    static final String[] DEF_AGG_FOREIGN_KEY = new String[]{"factColumn", "aggColumn"};
    static final String[] DEF_AGG_MEASURE = new String[]{"column", "name", "rollupType"};
    static final String[] DEF_AGG_LEVEL = new String[]{"column", "name", "collapsed", "captionColumn", "ordinalColumn", "nameColumn"};
    static final String[] DEF_AGG_LEVEL_PROP = new String[]{"name", "column"};
    static final String[] DEF_CLOSURE = new String[]{"parentColumn", "childColumn"};
    static final String[] DEF_RELATION = new String[]{"name"};
    static final String[] DEF_SQL = new String[]{"cdata", "dialect"};
    static final String[] DEF_ANNOTATION = new String[]{"name", "cdata"};
    static final String[] DEF_SCHEMA = new String[]{"name", "description", "measuresCaption", "defaultRole"};
    static final String[] DEF_PROPERTY = new String[]{"name", "description", "column", "type", "formatter", "caption"};
    static final String[] DEF_PARAMETER_SCHEMA = new String[]{"name", "description", "type", "modifiable", "defaultValue"};
    static final String[] DEF_PARAMETER = new String[]{"name", "value"};
    static final String[] DEF_MEASURE = new String[]{"name", "description", "aggregator", "column", "formatString", "datatype", "formatter", "caption", "visible"};
    static final String[] DEF_CALCULATED_MEMBER = new String[]{"name", "description", "caption", "dimension", "hierarchy", "parent", "visible", "formula | formulaElement.cdata", "formatString"};
    static final String[] DEF_FORMULA = new String[]{"cdata"};
    static final String[] DEF_CALCULATED_MEMBER_PROPERTY = new String[]{"name", "description", "caption", "expression", "value"};
    static final String[] DEF_NAMED_SET = new String[]{"name", "description", "formula", "caption"};
    static final String[] DEF_USER_DEFINED_FUNCTION = new String[]{"name", "className"};
    static final String[] DEF_SCRIPT = new String[]{"language", "cdata"};
    static final String[] DEF_LEVEL = new String[]{"name", "description", "table", "column", "nameColumn", "parentColumn", "nullParentValue", "ordinalColumn", "type", "internalType", "uniqueMembers", "levelType", "hideMemberIf", "approxRowCount", "caption", "captionColumn", "formatter", "visible"};
    static final String[] DEF_JOIN = new String[]{"leftAlias", "leftKey", "rightAlias", "rightKey"};
    static final String[] DEF_HIERARCHY = new String[]{"name", "description", "hasAll", "allMemberName", "allMemberCaption", "allLevelName", "defaultMember", "memberReaderClass", "primaryKeyTable", "primaryKey", "caption", "visible"};
    static final String[] DEF_FORMATTER = new String[]{"className"};
    static final String[] DEF_EXPRESSION_VIEW = new String[0];
    static final String[] DEF_DIMENSION_USAGE = new String[]{"name", "foreignKey", "source", "level", "usagePrefix", "caption", "visible"};
    static final String[] DEF_DIMENSION = new String[]{"name", "description", "foreignKey", "type", "usagePrefix", "caption", "visible"};
    static final String[] DEF_CUBE = new String[]{"name", "description", "caption", "cache", "enabled", "visible"};
    static final String[] DEF_ROLE = new String[]{"name"};
    static final String[] DEF_SCHEMA_GRANT = new String[]{"access"};
    static final String[] DEF_CUBE_GRANT = new String[]{"access", "cube"};
    static final String[] DEF_DIMENSION_GRANT = new String[]{"access", "dimension"};
    static final String[] DEF_HIERARCHY_GRANT = new String[]{"access", "hierarchy", "topLevel", "bottomLevel", "rollupPolicy"};
    static final String[] DEF_MEMBER_GRANT = new String[]{"access", "member"};
    static final String[] DEF_COLUMN = new String[]{"name", "table"};
    private static final String LBL_COLUMN = "Column";
    private static final String LBL_CUBE = "Cube";
    private static final String LBL_ROLE = "Role";
    private static final String LBL_SCHEMA_GRANT = "Schema Grant";
    private static final String LBL_CUBE_GRANT = "Cube Grant";
    private static final String LBL_DIMENSION_GRANT = "Dimension Grant";
    private static final String LBL_HIERARCHY_GRANT = "Hierarchy Grant";
    private static final String LBL_MEMBER_GRANT = "Member Grant";
    private static final String LBL_DIMENSION = "Dimension";
    private static final String LBL_DIMENSION_USAGE = "Dimension Usage";
    private static final String LBL_EXPRESSION_VIEW = "Expression View";
    private static final String LBL_KEY_EXPRESSION = "Key Expression";
    private static final String LBL_NAME_EXPRESSION = "Name Expression";
    private static final String LBL_ANNOTATIONS = "Annotations";
    private static final String LBL_ANNOTATION = "Annotation";
    private static final String LBL_ORDINAL_EXPRESSION = "Ordinal Expression";
    private static final String LBL_PARENT_EXPRESSION = "Parent Expression";
    private static final String LBL_MEASURE_EXPRESSION = "Measure Expression";
    private static final String LBL_HIERARCHY = "Hierarchy";
    private static final String LBL_JOIN = "Join";
    private static final String LBL_LEVEL = "Level";
    private static final String LBL_MEASURE = "Measure";
    private static final String LBL_CALCULATED_MEMBER = "Calculated Member";
    private static final String LBL_CALCULATED_MEMBER_PROPERTY = "Calculated Member Property";
    private static final String LBL_NAMED_SET = "Named Set";
    private static final String LBL_USER_DEFINED_FUNCTION = "User Defined Function";
    private static final String LBL_PARAMETER = "Parameter";
    private static final String LBL_PARAMETER_SCHEMA = "Schema Parameter";
    private static final String LBL_PROPERTY = "Property";
    private static final String LBL_SCHEMA = "Schema";
    private static final String LBL_SQL = "SQL";
    private static final String LBL_TABLE = "Table";
    private static final String LBL_CLOSURE = "Closure";
    private static final String LBL_AGG_NAME = "Aggregate Name";
    private static final String LBL_AGG_IGNORE_COLUMN = "Aggregate Ignore Column";
    private static final String LBL_AGG_FOREIGN_KEY = "Aggregate Foreign Key";
    private static final String LBL_AGG_MEASURE = "Aggregate Measure";
    private static final String LBL_AGG_LEVEL = "Aggregate Level";
    private static final String LBL_AGG_LEVEL_PROP = "Aggregate Level Property";
    private static final String LBL_AGG_PATTERN = "Aggregate Pattern";
    private static final String LBL_AGG_EXCLUDE = "Aggregate Exclude";
    private static final String LBL_AGG_FACT_COUNT = "Aggregate Fact Count";
    private static final String LBL_AGG_MEASURE_FACT_COUNT = "Aggregate Measure Fact Count";
    private static final String LBL_VIEW = "View";
    private static final String LBL_VIRTUAL_CUBE = "Virtual Cube";
    private static final String LBL_VIRTUAL_CUBE_DIMENSION = "Virtual Cube Dimension";
    private static final String LBL_VIRTUAL_CUBE_MEASURE = "Virtual Cube Measure";
    private static final String LBL_UNKNOWN_TYPE = "Unknown Type";
    private static String alert = "Alert";
    private AbstractAction arrowButtonUpAction;
    private AbstractAction arrowButtonDownAction;
    private AbstractAction addCube;
    private AbstractAction addRole;
    private AbstractAction addParameter;
    private AbstractAction addSchemaGrant;
    private AbstractAction addCubeGrant;
    private AbstractAction addDimensionGrant;
    private AbstractAction addHierarchyGrant;
    private AbstractAction addMemberGrant;
    private AbstractAction addAnnotations;
    private AbstractAction addAnnotation;
    private AbstractAction addDimension;
    private AbstractAction addDimensionUsage;
    private AbstractAction addHierarchy;
    private AbstractAction addNamedSet;
    private AbstractAction addUserDefinedFunction;
    private AbstractAction addScript;
    private AbstractAction addCalculatedMember;
    private AbstractAction addMeasure;
    private AbstractAction addMeasureExp;
    private AbstractAction addFormula;
    private AbstractAction addLevel;
    private AbstractAction addSQL;
    private AbstractAction addKeyExp;
    private AbstractAction addNameExp;
    private AbstractAction addOrdinalExp;
    private AbstractAction addCaptionExp;
    private AbstractAction addParentExp;
    private AbstractAction addTable;
    private AbstractAction addJoin;
    private AbstractAction addView;
    private AbstractAction addInlineTable;
    private AbstractAction moveLevelUp;
    private AbstractAction moveLevelDown;
    private AbstractAction addProperty;
    private AbstractAction addCalculatedMemberProperty;
    private AbstractAction addClosure;
    private AbstractAction addAggName;
    private AbstractAction addAggIgnoreColumn;
    private AbstractAction addAggForeignKey;
    private AbstractAction addAggMeasure;
    private AbstractAction addAggLevel;
    private AbstractAction addAggLevelProperty;
    private AbstractAction addAggPattern;
    private AbstractAction addAggExclude;
    private AbstractAction addAggFactCount;
    private AbstractAction addAggMeasureFactCount;
    private AbstractAction addVirtualCube;
    private AbstractAction addVirtualCubeDimension;
    private AbstractAction addVirtualCubeMeasure;
    private AbstractAction addCellFormatter;
    private AbstractAction addMemberFormatter;
    private AbstractAction addPropertyFormatter;
    private AbstractAction delete;
    private AbstractAction editMode;
    private JTable propertyTable;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JButton addLevelButton;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane1;
    private JButton addPropertyButton;
    private JButton addCalculatedMemberPropertyButton;
    private JButton pasteButton;
    private JLabel targetLabel;
    private JLabel validStatusLabel;
    private JLabel targetLabel2;
    private JLabel validStatusLabel2;
    JTree tree;
    private JSplitPane jSplitPane1;
    private JButton addDimensionButton;
    private JButton addDimensionUsageButton;
    private JButton addHierarchyButton;
    private JButton addNamedSetButton;
    private JButton addUserDefinedFunctionButton;
    private JButton addCalculatedMemberButton;
    private JButton cutButton;
    private JButton addMeasureButton;
    private JButton addCubeButton;
    private JButton addRoleButton;
    private JButton addVirtualCubeButton;
    private JButton addVirtualCubeDimensionButton;
    private JButton addVirtualCubeMeasureButton;
    private JButton deleteButton;
    private JToggleButton editModeButton;
    private JButton copyButton;
    private JToolBar jToolBar1;
    private CustomJPopupMenu jPopupMenu;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JPanel footer;
    private JLabel databaseLabel;
    private JPanel jPanelXML;
    private JScrollPane jScrollPaneXML;
    private JEditorPane jEditorPaneXML;

    public SchemaExplorer(Workbench workbench) {
        this.workbench = workbench;
        this.myClassLoader = this.getClass().getClassLoader();
        this.initComponents();
    }

    public SchemaExplorer(Workbench workbench, File f, JdbcMetaData jdbcMetaData, boolean newFile, JInternalFrame parentIFrame) {
        this(workbench);
        alert = this.getResourceConverter().getString("schemaExplorer.alert.title", "Alert");
        try {
            this.jEditorPaneXML = new JEditorPane();
        }
        catch (Exception ex) {
            LOGGER.error((Object)"SchemaExplorer-JEditorPane", (Throwable)ex);
        }
        this.jEditorPaneXML.setLayout(new BorderLayout());
        this.jEditorPaneXML.setEditable(false);
        this.jScrollPaneXML = new JScrollPane(this.jEditorPaneXML);
        this.jPanelXML.setLayout(new BorderLayout());
        this.jPanelXML.add((Component)this.jScrollPaneXML, "Center");
        this.jPanelXML.add((Component)this.targetLabel2, "North");
        this.jPanelXML.add((Component)this.validStatusLabel2, "South");
        this.jPanelXML.setMaximumSize(this.jPanel1.getMaximumSize());
        this.jPanelXML.setPreferredSize(this.jPanel1.getPreferredSize());
        this.databaseLabel.setText(this.getResourceConverter().getFormattedString("schemaExplorer.database.text", "Database - {0} ({1})", SchemaExplorer.nvl(jdbcMetaData.getDbCatalogName()), jdbcMetaData.getDatabaseProductName()));
        try {
            Parser xmlParser = XOMUtil.createDefaultParser();
            this.schemaFile = f;
            this.setNewFile(newFile);
            this.parentIFrame = parentIFrame;
            this.jdbcMetaData = jdbcMetaData;
            if (newFile) {
                this.schema = new MondrianGuiDef.Schema();
                this.schema.parameters = new MondrianGuiDef.Parameter[0];
                this.schema.cubes = new MondrianGuiDef.Cube[0];
                this.schema.dimensions = new MondrianGuiDef.Dimension[0];
                this.schema.namedSets = new MondrianGuiDef.NamedSet[0];
                this.schema.roles = new MondrianGuiDef.Role[0];
                this.schema.userDefinedFunctions = new MondrianGuiDef.UserDefinedFunction[0];
                this.schema.virtualCubes = new MondrianGuiDef.VirtualCube[0];
                String sname = this.schemaFile.getName();
                int ext = sname.indexOf(".");
                if (ext != -1) {
                    this.schema.name = "New " + sname.substring(0, ext);
                }
            } else {
                try {
                    this.schema = new MondrianGuiDef.Schema(xmlParser.parse(this.schemaFile.toURL()));
                }
                catch (XOMException ex) {
                    ex.printStackTrace();
                    this.schema = new MondrianGuiDef.Schema();
                    this.schema.parameters = new MondrianGuiDef.Parameter[0];
                    this.schema.cubes = new MondrianGuiDef.Cube[0];
                    this.schema.dimensions = new MondrianGuiDef.Dimension[0];
                    this.schema.namedSets = new MondrianGuiDef.NamedSet[0];
                    this.schema.roles = new MondrianGuiDef.Role[0];
                    this.schema.userDefinedFunctions = new MondrianGuiDef.UserDefinedFunction[0];
                    this.schema.virtualCubes = new MondrianGuiDef.VirtualCube[0];
                    LOGGER.error((Object)("Exception  : Schema file parsing failed." + ex.getMessage()), (Throwable)ex);
                    this.errMsg = this.getResourceConverter().getFormattedString("schemaExplorer.parsing.error", "Parsing Error: Could not open file {0}\n{1}", this.schemaFile.toString(), ex.getLocalizedMessage());
                }
            }
            this.setTitle();
            this.renderer = new SchemaTreeCellRenderer(workbench, jdbcMetaData);
            this.model = new SchemaTreeModel(this.schema);
            this.tree.setModel(this.model);
            this.tree.setCellRenderer(this.renderer);
            this.tree.addTreeSelectionListener(this);
            JComboBox<String> listEditor = new JComboBox<String>(new String[]{this.getResourceConverter().getString("schemaExplorer.hierarchy.select.join", LBL_JOIN), this.getResourceConverter().getString("schemaExplorer.hierarchy.select.table", LBL_TABLE)});
            listEditor.setToolTipText(this.getResourceConverter().getString("schemaExplorer.hierarchy.select.title", "Select Join or Table Hierarchy"));
            listEditor.setPreferredSize(new Dimension(listEditor.getPreferredSize().width, 24));
            listEditor.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    TreePath parentpath;
                    SchemaExplorer.this.tree.stopEditing();
                    TreePath tpath = SchemaExplorer.this.tree.getSelectionPath();
                    if (tpath != null && (parentpath = tpath.getParentPath()) != null) {
                        SchemaExplorer.this.refreshTree(parentpath);
                    }
                }
            });
            DefaultCellEditor comboEditor = new DefaultCellEditor(listEditor);
            SchemaTreeCellEditor editor = new SchemaTreeCellEditor(workbench, this.tree, this.renderer, comboEditor);
            this.tree.setCellEditor(editor);
            this.tree.setEditable(true);
            SchemaPropertyCellEditor spce = new SchemaPropertyCellEditor(workbench, jdbcMetaData);
            spce.addCellEditorListener(this);
            this.propertyTable.setDefaultEditor(Object.class, spce);
            SchemaPropertyCellRenderer.attributeBackground = this.jScrollPane2.getBackground();
            SchemaPropertyCellRenderer spcr = new SchemaPropertyCellRenderer(workbench);
            this.propertyTable.setDefaultRenderer(Object.class, spcr);
        }
        catch (Exception ex) {
            LOGGER.error((Object)"SchemaExplorer init error", (Throwable)ex);
        }
    }

    private static String nvl(String s) {
        return s == null ? "" : s;
    }

    private void initComponents() {
        this.jPanelXML = new JPanel();
        this.jScrollPaneXML = new JScrollPane();
        this.footer = new JPanel();
        this.databaseLabel = new JLabel();
        this.jSeparator1 = new JSeparator();
        this.jSeparator2 = new JSeparator();
        this.jSplitPane1 = new JSplitPane();
        this.jPanel1 = new JPanel();
        this.jScrollPane2 = new JScrollPane();
        this.propertyTable = new JTable(){

            @Override
            public void changeSelection(int rowIndex, int columnIndex, boolean toggle, boolean extend) {
                KeyEvent ke;
                int kcode;
                AWTEvent currentEvent;
                if (columnIndex == 0 && (currentEvent = EventQueue.getCurrentEvent()) instanceof KeyEvent && (kcode = (ke = (KeyEvent)currentEvent).getKeyCode()) == 9) {
                    if ((ke.getModifiersEx() & 0x40) == 64 && --rowIndex < 0) {
                        rowIndex = SchemaExplorer.this.propertyTable.getRowCount() - 1;
                    }
                    SchemaExplorer.this.setTableCellFocus(rowIndex);
                    return;
                }
                super.changeSelection(rowIndex, columnIndex, toggle, extend);
            }

            @Override
            public void processKeyEvent(KeyEvent e) {
                int kcode = e.getKeyCode();
                if (kcode == 38 || kcode == 40) {
                    int row = SchemaExplorer.this.propertyTable.getSelectedRow();
                    SchemaExplorer.this.setTableCellFocus(row);
                    return;
                }
                super.processKeyEvent(e);
            }
        };
        this.targetLabel = new JLabel();
        this.validStatusLabel = new JLabel();
        this.targetLabel2 = new JLabel();
        this.validStatusLabel2 = new JLabel();
        this.jPanel2 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.tree = new JTree();
        this.tree.getSelectionModel().setSelectionMode(1);
        ToolTipManager.sharedInstance().registerComponent(this.tree);
        this.jToolBar1 = new JToolBar();
        this.addCubeButton = new JButton();
        this.addDimensionButton = new JButton();
        this.addDimensionUsageButton = new JButton();
        this.addHierarchyButton = new JButton();
        this.addNamedSetButton = new JButton();
        this.addUserDefinedFunctionButton = new JButton();
        this.addRoleButton = new JButton();
        this.addMeasureButton = new JButton();
        this.addCalculatedMemberButton = new JButton();
        this.addLevelButton = new JButton();
        this.addPropertyButton = new JButton();
        this.addCalculatedMemberPropertyButton = new JButton();
        this.addVirtualCubeButton = new JButton();
        this.addVirtualCubeDimensionButton = new JButton();
        this.addVirtualCubeMeasureButton = new JButton();
        this.cutButton = new JButton(new DefaultEditorKit.CutAction());
        this.copyButton = new JButton(new DefaultEditorKit.CopyAction());
        this.pasteButton = new JButton(new DefaultEditorKit.PasteAction());
        this.deleteButton = new JButton();
        this.editModeButton = new JToggleButton();
        this.setLayout(new BorderLayout());
        this.jSplitPane1.setDividerLocation(200);
        this.jPanel1.setLayout(new BorderLayout());
        this.propertyTable.setModel(new DefaultTableModel(new Object[0][], new String[]{this.getResourceConverter().getString("schemaExplorer.propertyTable.attribute", "Attribute"), this.getResourceConverter().getString("schemaExplorer.propertyTable.value", "Value")}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{String.class, Object.class};
                this.canEdit = new boolean[]{false, true};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.propertyTable.getTableHeader().setFont(new Font("Dialog", 1, 12));
        this.jScrollPane2.setViewportView(this.propertyTable);
        this.jPanel1.add((Component)this.jScrollPane2, "Center");
        this.targetLabel.setFont(new Font("Dialog", 1, 14));
        this.targetLabel.setForeground((Color)UIManager.getDefaults().get("CheckBoxMenuItem.acceleratorForeground"));
        this.targetLabel.setHorizontalAlignment(0);
        this.targetLabel.setText(this.getResourceConverter().getString("schemaExplorer.targetLabel.title", LBL_SCHEMA));
        this.targetLabel.setBorder(new EtchedBorder());
        this.jPanel3 = new JPanel();
        this.jPanel3.setLayout(new BorderLayout());
        BasicArrowButton arrowButtonUp = new BasicArrowButton(1);
        BasicArrowButton arrowButtonDown = new BasicArrowButton(5);
        arrowButtonUp.setToolTipText(this.getResourceConverter().getString("schemaExplorer.arrowButtonUp.toolTip", "move to parent element"));
        arrowButtonDown.setToolTipText(this.getResourceConverter().getString("schemaExplorer.arrowButtonDown.toolTip", "move to child element"));
        this.arrowButtonUpAction = new AbstractAction(this.getResourceConverter().getString("schemaExplorer.arrowButtonUp.title", "Arrow button up")){

            @Override
            public void actionPerformed(ActionEvent e) {
                SchemaExplorer.this.arrowButtonUpAction(e);
            }
        };
        this.arrowButtonDownAction = new AbstractAction(this.getResourceConverter().getString("schemaExplorer.arrowButtonDown.title", "Arrow button down")){

            @Override
            public void actionPerformed(ActionEvent e) {
                SchemaExplorer.this.arrowButtonDownAction(e);
            }
        };
        arrowButtonUp.addActionListener(this.arrowButtonUpAction);
        arrowButtonDown.addActionListener(this.arrowButtonDownAction);
        this.jPanel3.add((Component)arrowButtonDown, "East");
        this.jPanel3.add((Component)arrowButtonUp, "West");
        this.jPanel3.add((Component)this.targetLabel, "Center");
        this.jPanel1.add((Component)this.jPanel3, "North");
        this.validStatusLabel.setFont(new Font("Dialog", 0, 12));
        this.validStatusLabel.setForeground(Color.RED);
        this.validStatusLabel.setHorizontalAlignment(0);
        this.jPanel1.add((Component)this.validStatusLabel, "South");
        this.targetLabel2.setFont(new Font("Dialog", 1, 14));
        this.targetLabel2.setForeground((Color)UIManager.getDefaults().get("CheckBoxMenuItem.acceleratorForeground"));
        this.targetLabel2.setHorizontalAlignment(0);
        this.targetLabel2.setText(this.getResourceConverter().getString("schemaExplorer.targetLabel.title", LBL_SCHEMA));
        this.targetLabel2.setBorder(new EtchedBorder());
        this.validStatusLabel2.setFont(new Font("Dialog", 0, 12));
        this.validStatusLabel2.setForeground(Color.RED);
        this.validStatusLabel2.setHorizontalAlignment(0);
        this.jSplitPane1.setRightComponent(this.jPanel1);
        this.jPanel2.setLayout(new BorderLayout());
        this.jScrollPane1.setViewportView(this.tree);
        this.jPanel2.add((Component)this.jScrollPane1, "Center");
        this.jSplitPane1.setLeftComponent(this.jPanel2);
        this.addCube = new AbstractAction(this.getResourceConverter().getString("schemaExplorer.addCube.title", "Add Cube")){

            @Override
            public void actionPerformed(ActionEvent e) {
                SchemaExplorer.this.addCube(e);
            }
        };
        this.addParameter = new AbstractAction(this.getResourceConverter().getString("schemaExplorer.addParameter.title", "Add Parameter")){

            @Override
            public void actionPerformed(ActionEvent e) {
                SchemaExplorer.this.addParameter(e);
            }
        };
        this.addDimension = new AbstractAction(this.getResourceConverter().getString("schemaExplorer.addDimension.title", "Add Dimension")){

            @Override
            public void actionPerformed(ActionEvent e) {
                SchemaExplorer.this.addDimension(e);
            }
        };
        this.addDimensionUsage = new AbstractAction(this.getResourceConverter().getString("schemaExplorer.addDimensionUsage.title", "Add Dimension Usage")){

            @Override
            public void actionPerformed(ActionEvent e) {
                SchemaExplorer.this.addDimensionUsage(e);
            }
        };
        this.addHierarchy = new AbstractAction(this.getResourceConverter().getString("schemaExplorer.addHierarchy.title", "Add Hierarchy")){

            @Override
            public void actionPerformed(ActionEvent e) {
                SchemaExplorer.this.addHierarchy(e);
            }
        };
        this.addNamedSet = new AbstractAction(this.getResourceConverter().getString("schemaExplorer.addNamedSet.title", "Add Named Set")){

            @Override
            public void actionPerformed(ActionEvent e) {
                SchemaExplorer.this.addNamedSet(e);
            }
        };
        this.addMeasure = new AbstractAction(this.getResourceConverter().getString("schemaExplorer.addMeasure.title", "Add Measure")){

            @Override
            public void actionPerformed(ActionEvent e) {
                SchemaExplorer.this.addMeasure(e);
            }
        };
        this.addCalculatedMember = new AbstractAction(this.getResourceConverter().getString("schemaExplorer.addCalculatedMember.title", "Add Calculated Member")){

            @Override
            public void actionPerformed(ActionEvent e) {
                SchemaExplorer.this.addCalculatedMember(e);
            }
        };
        this.addUserDefinedFunction = new AbstractAction(this.getResourceConverter().getString("schemaExplorer.addUserDefinedFunction.title", "Add User Defined Function")){

            @Override
            public void actionPerformed(ActionEvent e) {
                SchemaExplorer.this.addUserDefinedFunction(e);
            }
        };
        this.addScript = new AbstractAction(this.getResourceConverter().getString("schemaExplorer.addScript.title", "Add Script")){

            @Override
            public void actionPerformed(ActionEvent e) {
                SchemaExplorer.this.addScript(e);
            }
        };
        this.addCellFormatter = new AbstractAction(this.getResourceConverter().getString("schemaExplorer.addCellFormatter.title", "Add Cell Formatter")){

            @Override
            public void actionPerformed(ActionEvent e) {
                SchemaExplorer.this.addCellFormatter(e);
            }
        };
        this.addPropertyFormatter = new AbstractAction(this.getResourceConverter().getString("schemaExplorer.addPropertyFormatter.title", "Add Property Formatter")){

            @Override
            public void actionPerformed(ActionEvent e) {
                SchemaExplorer.this.addPropertyFormatter(e);
            }
        };
        this.addMemberFormatter = new AbstractAction(this.getResourceConverter().getString("schemaExplorer.addMemberFormatter.title", "Add Member Formatter")){

            @Override
            public void actionPerformed(ActionEvent e) {
                SchemaExplorer.this.addMemberFormatter(e);
            }
        };
        this.addRole = new AbstractAction(this.getResourceConverter().getString("schemaExplorer.addRole.title", "Add Role")){

            @Override
            public void actionPerformed(ActionEvent e) {
                SchemaExplorer.this.addRole(e);
            }
        };
        this.addSchemaGrant = new AbstractAction(this.getResourceConverter().getString("schemaExplorer.addSchemaGrant.title", "Add Schema Grant")){

            @Override
            public void actionPerformed(ActionEvent e) {
                SchemaExplorer.this.addSchemaGrant(e);
            }
        };
        this.addCubeGrant = new AbstractAction(this.getResourceConverter().getString("schemaExplorer.addCubeGrant.title", "Add Cube Grant")){

            @Override
            public void actionPerformed(ActionEvent e) {
                SchemaExplorer.this.addCubeGrant(e);
            }
        };
        this.addDimensionGrant = new AbstractAction(this.getResourceConverter().getString("schemaExplorer.addDimensionGrant.title", "Add Dimension Grant")){

            @Override
            public void actionPerformed(ActionEvent e) {
                SchemaExplorer.this.addDimensionGrant(e);
            }
        };
        this.addHierarchyGrant = new AbstractAction(this.getResourceConverter().getString("schemaExplorer.addHierarchyGrant.title", "Add Hierarchy Grant")){

            @Override
            public void actionPerformed(ActionEvent e) {
                SchemaExplorer.this.addHierarchyGrant(e);
            }
        };
        this.addMemberGrant = new AbstractAction(this.getResourceConverter().getString("schemaExplorer.addMemberGrant.title", "Add Member Grant")){

            @Override
            public void actionPerformed(ActionEvent e) {
                SchemaExplorer.this.addMemberGrant(e);
            }
        };
        this.addAnnotations = new AbstractAction(this.getResourceConverter().getString("schemaExplorer.addAnnotations.title", "Add Annotations")){

            @Override
            public void actionPerformed(ActionEvent e) {
                SchemaExplorer.this.addAnnotations(e);
            }
        };
        this.addAnnotation = new AbstractAction(this.getResourceConverter().getString("schemaExplorer.addAnnotation.title", "Add Annotation")){

            @Override
            public void actionPerformed(ActionEvent e) {
                SchemaExplorer.this.addAnnotation(e);
            }
        };
        this.addLevel = new AbstractAction(this.getResourceConverter().getString("schemaExplorer.addLevel.title", "Add Level")){

            @Override
            public void actionPerformed(ActionEvent e) {
                SchemaExplorer.this.addLevel(e);
            }
        };
        this.addClosure = new AbstractAction(this.getResourceConverter().getString("schemaExplorer.addClosure.title", "Add Closure")){

            @Override
            public void actionPerformed(ActionEvent e) {
                SchemaExplorer.this.addClosure(e);
            }
        };
        this.addKeyExp = new AbstractAction(this.getResourceConverter().getString("schemaExplorer.addKeyExpression.title", "Add Key Expression")){

            @Override
            public void actionPerformed(ActionEvent e) {
                SchemaExplorer.this.addKeyExp(e);
            }
        };
        this.addNameExp = new AbstractAction(this.getResourceConverter().getString("schemaExplorer.addNameExpression.title", "Add Name Expression")){

            @Override
            public void actionPerformed(ActionEvent e) {
                SchemaExplorer.this.addNameExp(e);
            }
        };
        this.addOrdinalExp = new AbstractAction(this.getResourceConverter().getString("schemaExplorer.addOrdinalExpression.title", "Add Ordinal Expression")){

            @Override
            public void actionPerformed(ActionEvent e) {
                SchemaExplorer.this.addOrdinalExp(e);
            }
        };
        this.addCaptionExp = new AbstractAction(this.getResourceConverter().getString("schemaExplorer.addCaptionExpression.title", "Add Caption Expression")){

            @Override
            public void actionPerformed(ActionEvent e) {
                SchemaExplorer.this.addCaptionExp(e);
            }
        };
        this.addParentExp = new AbstractAction(this.getResourceConverter().getString("schemaExplorer.addParentExpression.title", "Add Parent Expression")){

            @Override
            public void actionPerformed(ActionEvent e) {
                SchemaExplorer.this.addParentExp(e);
            }
        };
        this.addMeasureExp = new AbstractAction(this.getResourceConverter().getString("schemaExplorer.addMeasureExpression.title", "Add Measure Expression")){

            @Override
            public void actionPerformed(ActionEvent e) {
                SchemaExplorer.this.addMeasureExp(e);
            }
        };
        this.addFormula = new AbstractAction(this.getResourceConverter().getString("schemaExplorer.addFormula.title", "Add Formula")){

            @Override
            public void actionPerformed(ActionEvent e) {
                SchemaExplorer.this.addFormula(e);
            }
        };
        this.addSQL = new AbstractAction(this.getResourceConverter().getString("schemaExplorer.addSQL.title", "Add SQL")){

            @Override
            public void actionPerformed(ActionEvent e) {
                SchemaExplorer.this.addSQL(e);
            }
        };
        this.addTable = new AbstractAction(this.getResourceConverter().getString("schemaExplorer.addTable.title", "Add Table")){

            @Override
            public void actionPerformed(ActionEvent e) {
                SchemaExplorer.this.addTable(e);
            }
        };
        this.addJoin = new AbstractAction(this.getResourceConverter().getString("schemaExplorer.addJoin.title", "Add Join")){

            @Override
            public void actionPerformed(ActionEvent e) {
                SchemaExplorer.this.addJoin(e);
            }
        };
        this.addView = new AbstractAction(this.getResourceConverter().getString("schemaExplorer.addView.title", "Add View")){

            @Override
            public void actionPerformed(ActionEvent e) {
                SchemaExplorer.this.addView(e);
            }
        };
        this.addInlineTable = new AbstractAction(this.getResourceConverter().getString("schemaExplorer.addInlineTable.title", "Add Inline Table")){

            @Override
            public void actionPerformed(ActionEvent e) {
                SchemaExplorer.this.addInlineTable(e);
            }
        };
        this.moveLevelUp = new AbstractAction(this.getResourceConverter().getString("schemaExplorer.moveLevelUp.title", "Move Up")){

            @Override
            public void actionPerformed(ActionEvent e) {
                SchemaExplorer.this.moveLevelUp(e);
            }
        };
        this.moveLevelDown = new AbstractAction(this.getResourceConverter().getString("schemaExplorer.moveLevelDown.title", "Move Down")){

            @Override
            public void actionPerformed(ActionEvent e) {
                SchemaExplorer.this.moveLevelDown(e);
            }
        };
        this.addProperty = new AbstractAction(this.getResourceConverter().getString("schemaExplorer.addProperty.title", "Add Property")){

            @Override
            public void actionPerformed(ActionEvent e) {
                SchemaExplorer.this.addProperty(e);
            }
        };
        this.addCalculatedMemberProperty = new AbstractAction(this.getResourceConverter().getString("schemaExplorer.addCalculatedMemberProperty.title", "Add Calculated Member Property")){

            @Override
            public void actionPerformed(ActionEvent e) {
                SchemaExplorer.this.addCalculatedMemberProperty(e);
            }
        };
        this.addVirtualCube = new AbstractAction(this.getResourceConverter().getString("schemaExplorer.addVirtualCube.title", "Add Virtual Cube")){

            @Override
            public void actionPerformed(ActionEvent e) {
                SchemaExplorer.this.addVirtualCube(e);
            }
        };
        this.addVirtualCubeDimension = new AbstractAction(this.getResourceConverter().getString("schemaExplorer.addVirtualCubeDimension.title", "Add Virtual Cube Dimension")){

            @Override
            public void actionPerformed(ActionEvent e) {
                SchemaExplorer.this.addVirtualCubeDimension(e);
            }
        };
        this.addVirtualCubeMeasure = new AbstractAction(this.getResourceConverter().getString("schemaExplorer.addVirtualCubeMeasure.title", "Add Virtual Cube Measure")){

            @Override
            public void actionPerformed(ActionEvent e) {
                SchemaExplorer.this.addVirtualCubeMeasure(e);
            }
        };
        this.addAggPattern = new AbstractAction(this.getResourceConverter().getString("schemaExplorer.addAggregatePattern.title", "Add Aggregate Pattern")){

            @Override
            public void actionPerformed(ActionEvent e) {
                SchemaExplorer.this.addAggPattern(e);
            }
        };
        this.addAggExclude = new AbstractAction(this.getResourceConverter().getString("schemaExplorer.addAggregateExcludeTable.title", "Add Aggregate Exclude Table")){

            @Override
            public void actionPerformed(ActionEvent e) {
                SchemaExplorer.this.addAggExclude(e);
            }
        };
        this.addAggName = new AbstractAction(this.getResourceConverter().getString("schemaExplorer.addAggregateName.title", "Add Aggregate Name")){

            @Override
            public void actionPerformed(ActionEvent e) {
                SchemaExplorer.this.addAggName(e);
            }
        };
        this.addAggIgnoreColumn = new AbstractAction(this.getResourceConverter().getString("schemaExplorer.addAggregateIgnoreColumn.title", "Add Aggregate Ignore Column")){

            @Override
            public void actionPerformed(ActionEvent e) {
                SchemaExplorer.this.addAggIgnoreColumn(e);
            }
        };
        this.addAggForeignKey = new AbstractAction(this.getResourceConverter().getString("schemaExplorer.addAggregateForeignKey.title", "Add Aggregate Foreign Key")){

            @Override
            public void actionPerformed(ActionEvent e) {
                SchemaExplorer.this.addAggForeignKey(e);
            }
        };
        this.addAggMeasure = new AbstractAction(this.getResourceConverter().getString("schemaExplorer.addAggregateMeasure.title", "Add Aggregate Measure")){

            @Override
            public void actionPerformed(ActionEvent e) {
                SchemaExplorer.this.addAggMeasure(e);
            }
        };
        this.addAggLevel = new AbstractAction(this.getResourceConverter().getString("schemaExplorer.addAggregateLevel.title", "Add Aggregate Level")){

            @Override
            public void actionPerformed(ActionEvent e) {
                SchemaExplorer.this.addAggLevel(e);
            }
        };
        this.addAggLevelProperty = new AbstractAction(this.getResourceConverter().getString("schemaExplorer.addAggregateLevelProperty.title", "Add Aggregate Level Property")){

            @Override
            public void actionPerformed(ActionEvent e) {
                SchemaExplorer.this.addAggLevelProperty(e);
            }
        };
        this.addAggFactCount = new AbstractAction(this.getResourceConverter().getString("schemaExplorer.addAggregateFactCount.title", "Add Aggregate Fact Count")){

            @Override
            public void actionPerformed(ActionEvent e) {
                SchemaExplorer.this.addAggFactCount(e);
            }
        };
        this.addAggMeasureFactCount = new AbstractAction(this.getResourceConverter().getString("schemaExplorer.addAggregateMeasureFactCount.title", "Add Aggregate Measure Fact Count")){

            @Override
            public void actionPerformed(ActionEvent e) {
                SchemaExplorer.this.addAggMeasureFactCount(e);
            }
        };
        this.delete = new AbstractAction(this.getResourceConverter().getString("schemaExplorer.actionDelete.title", "Delete")){

            @Override
            public void actionPerformed(ActionEvent e) {
                SchemaExplorer.this.delete(e);
            }
        };
        this.editMode = new AbstractAction(this.getResourceConverter().getString("schemaExplorer.actionEdit.title", "EditMode")){

            @Override
            public void actionPerformed(ActionEvent e) {
                SchemaExplorer.this.editMode(e);
            }
        };
        this.addCubeButton.setIcon(new ImageIcon(this.myClassLoader.getResource(this.getResourceConverter().getGUIReference("addCube"))));
        this.addCubeButton.setToolTipText(this.getResourceConverter().getString("schemaExplorer.addCube.title", "Add cube"));
        this.addCubeButton.addActionListener(this.addCube);
        this.addDimensionButton.setIcon(new ImageIcon(this.myClassLoader.getResource(this.getResourceConverter().getGUIReference("addDimension"))));
        this.addDimensionButton.setToolTipText(this.getResourceConverter().getString("schemaExplorer.addDimension.title", "Add Dimension"));
        this.addDimensionButton.addActionListener(this.addDimension);
        this.addDimensionUsageButton.setIcon(new ImageIcon(this.myClassLoader.getResource(this.getResourceConverter().getGUIReference("addDimensionUsage"))));
        this.addDimensionUsageButton.setToolTipText(this.getResourceConverter().getString("schemaExplorer.addDimensionUsage.title", "Add Dimension Usage"));
        this.addDimensionUsageButton.addActionListener(this.addDimensionUsage);
        this.addHierarchyButton.setIcon(new ImageIcon(this.myClassLoader.getResource(this.getResourceConverter().getGUIReference("addHierarchy"))));
        this.addHierarchyButton.setToolTipText(this.getResourceConverter().getString("schemaExplorer.addHierarchy.title", "Add Hierarchy"));
        this.addHierarchyButton.addActionListener(this.addHierarchy);
        this.addNamedSetButton.setIcon(new ImageIcon(this.myClassLoader.getResource(this.getResourceConverter().getGUIReference("addNamedSet"))));
        this.addNamedSetButton.setToolTipText(this.getResourceConverter().getString("schemaExplorer.addNamedSet.title", "Add Named Set"));
        this.addNamedSetButton.addActionListener(this.addNamedSet);
        this.addUserDefinedFunctionButton.setIcon(new ImageIcon(this.myClassLoader.getResource(this.getResourceConverter().getGUIReference("addUserDefinedFunction"))));
        this.addUserDefinedFunctionButton.setToolTipText(this.getResourceConverter().getString("schemaExplorer.addUserDefinedFunction.title", "Add User defined Function"));
        this.addUserDefinedFunctionButton.addActionListener(this.addUserDefinedFunction);
        this.addCalculatedMemberButton.setIcon(new ImageIcon(this.myClassLoader.getResource(this.getResourceConverter().getGUIReference("addCalculatedMember"))));
        this.addCalculatedMemberButton.setToolTipText(this.getResourceConverter().getString("schemaExplorer.addCalculatedMember.title", "Add Calculated Member"));
        this.addCalculatedMemberButton.addActionListener(this.addCalculatedMember);
        this.addMeasureButton.setIcon(new ImageIcon(this.myClassLoader.getResource(this.getResourceConverter().getGUIReference("addMeasure"))));
        this.addMeasureButton.setToolTipText(this.getResourceConverter().getString("schemaExplorer.addMeasure.title", "Add Measure"));
        this.addMeasureButton.addActionListener(this.addMeasure);
        this.addLevelButton.setIcon(new ImageIcon(this.myClassLoader.getResource(this.getResourceConverter().getGUIReference("addLevel"))));
        this.addLevelButton.setToolTipText(this.getResourceConverter().getString("schemaExplorer.addLevel.title", "Add Level"));
        this.addLevelButton.addActionListener(this.addLevel);
        this.addPropertyButton.setIcon(new ImageIcon(this.myClassLoader.getResource(this.getResourceConverter().getGUIReference("addProperty"))));
        this.addPropertyButton.setToolTipText(this.getResourceConverter().getString("schemaExplorer.addProperty.title", "Add Property"));
        this.addPropertyButton.addActionListener(this.addProperty);
        this.addCalculatedMemberPropertyButton.setIcon(new ImageIcon(this.myClassLoader.getResource(this.getResourceConverter().getGUIReference("addCalculatedMemberProperty"))));
        this.addCalculatedMemberPropertyButton.setToolTipText(this.getResourceConverter().getString("schemaExplorer.addCalculatedMemberProperty.title", "Add Calculated Member Property"));
        this.addCalculatedMemberPropertyButton.addActionListener(this.addCalculatedMemberProperty);
        this.addVirtualCubeButton.setIcon(new ImageIcon(this.myClassLoader.getResource(this.getResourceConverter().getGUIReference("addVirtualCube"))));
        this.addVirtualCubeButton.setToolTipText(this.getResourceConverter().getString("schemaExplorer.addVirtualCube.title", "Add Virtual Cube"));
        this.addVirtualCubeButton.addActionListener(this.addVirtualCube);
        this.addVirtualCubeDimensionButton.setIcon(new ImageIcon(this.myClassLoader.getResource(this.getResourceConverter().getGUIReference("addVirtualCubeDimension"))));
        this.addVirtualCubeDimensionButton.setToolTipText(this.getResourceConverter().getString("schemaExplorer.addVirtualCubeDimension.title", "Add Virtual Dimension"));
        this.addVirtualCubeDimensionButton.addActionListener(this.addVirtualCubeDimension);
        this.addVirtualCubeMeasureButton.setIcon(new ImageIcon(this.myClassLoader.getResource(this.getResourceConverter().getGUIReference("addVirtualCubeMeasure"))));
        this.addVirtualCubeMeasureButton.setToolTipText(this.getResourceConverter().getString("schemaExplorer.addVirtualCubeMeasure.title", "Add Virtual Measure"));
        this.addVirtualCubeMeasureButton.addActionListener(this.addVirtualCubeMeasure);
        this.addRoleButton.setIcon(new ImageIcon(this.myClassLoader.getResource(this.getResourceConverter().getGUIReference("addRole"))));
        this.addRoleButton.setToolTipText(this.getResourceConverter().getString("schemaExplorer.addRole.title", "Add Role"));
        this.addRoleButton.addActionListener(this.addRole);
        this.cutButton.setIcon(new ImageIcon(this.getClass().getResource(this.getResourceConverter().getGUIReference("cut"))));
        this.cutButton.setText("");
        this.cutButton.setToolTipText(this.getResourceConverter().getString("schemaExplorer.actionCut.title", "Cut"));
        this.copyButton.setIcon(new ImageIcon(this.getClass().getResource(this.getResourceConverter().getGUIReference("copy"))));
        this.copyButton.setText("");
        this.copyButton.setToolTipText(this.getResourceConverter().getString("schemaExplorer.actionCopy.title", "Copy"));
        this.pasteButton.setIcon(new ImageIcon(this.getClass().getResource(this.getResourceConverter().getGUIReference("paste"))));
        this.pasteButton.setText("");
        this.pasteButton.setToolTipText(this.getResourceConverter().getString("schemaExplorer.actionPaste.title", "Paste"));
        this.deleteButton.setIcon(new ImageIcon(this.getClass().getResource(this.getResourceConverter().getGUIReference("delete"))));
        this.deleteButton.setToolTipText(this.getResourceConverter().getString("schemaExplorer.actionDelete.title", "Delete"));
        this.deleteButton.addActionListener(this.delete);
        this.editModeButton.setIcon(new ImageIcon(this.getClass().getResource(this.getResourceConverter().getGUIReference("edit"))));
        this.editModeButton.setToolTipText(this.getResourceConverter().getString("schemaExplorer.actionEdit.title", "Edit Mode"));
        this.editModeButton.addActionListener(this.editMode);
        this.databaseLabel.setIcon(new ImageIcon(this.getClass().getResource(this.getResourceConverter().getGUIReference("database"))));
        this.jToolBar1.add(this.addCubeButton);
        this.jToolBar1.add(this.addDimensionButton);
        this.jToolBar1.add(this.addDimensionUsageButton);
        this.jToolBar1.add(this.addHierarchyButton);
        this.jToolBar1.add(this.addNamedSetButton);
        this.jToolBar1.add(this.addUserDefinedFunctionButton);
        this.jToolBar1.add(this.addCalculatedMemberButton);
        this.jToolBar1.add(this.addMeasureButton);
        this.jToolBar1.add(this.addLevelButton);
        this.jToolBar1.add(this.addPropertyButton);
        this.jToolBar1.add(this.addCalculatedMemberPropertyButton);
        this.jToolBar1.addSeparator();
        this.jToolBar1.add(this.addVirtualCubeButton);
        this.jToolBar1.add(this.addVirtualCubeDimensionButton);
        this.jToolBar1.add(this.addVirtualCubeMeasureButton);
        this.jToolBar1.addSeparator();
        this.jToolBar1.add(this.addRoleButton);
        this.jToolBar1.addSeparator();
        this.jToolBar1.add(this.cutButton);
        this.jToolBar1.add(this.copyButton);
        this.jToolBar1.add(this.pasteButton);
        this.jToolBar1.addSeparator();
        this.jToolBar1.add(this.deleteButton);
        this.jToolBar1.addSeparator();
        this.jToolBar1.add(this.editModeButton);
        this.jPopupMenu = new CustomJPopupMenu();
        this.tree.addMouseListener(new PopupTrigger());
        this.tree.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                int kcode = e.getKeyCode();
                if (kcode == 127 || kcode == 110) {
                    SchemaExplorer.this.delete(e);
                }
            }
        });
        this.footer.setLayout(new BorderLayout());
        this.footer.add((Component)this.databaseLabel, "Center");
        this.add((Component)this.jSplitPane1, "Center");
        this.add((Component)this.jToolBar1, "North");
        this.add((Component)this.footer, "South");
        this.updater = new JTreeUpdater(this.tree);
    }

    protected void arrowButtonUpAction(ActionEvent evt) {
        TreePath parentpath;
        TreePath tpath = this.tree.getSelectionPath();
        if (tpath != null && (parentpath = tpath.getParentPath()) != null) {
            this.tree.setSelectionPath(parentpath);
            this.refreshTree(parentpath);
        }
    }

    protected void arrowButtonDownAction(ActionEvent evt) {
        TreePath tpath = this.tree.getSelectionPath();
        if (tpath != null) {
            Object current = tpath.getLastPathComponent();
            Object child = this.tree.getModel().getChild(current, 0);
            if (child != null) {
                Object[] treeObjs = new Object[30];
                treeObjs[0] = child;
                treeObjs[1] = current;
                int objCnt = 2;
                for (TreePath parentpath = tpath.getParentPath(); parentpath != null; parentpath = parentpath.getParentPath()) {
                    Object po;
                    treeObjs[objCnt] = po = parentpath.getLastPathComponent();
                    ++objCnt;
                }
                Object[] nodes = new Object[objCnt];
                int loopCnt = objCnt - 1;
                for (int j = 0; j < objCnt; ++j) {
                    nodes[j] = treeObjs[loopCnt];
                    --loopCnt;
                }
                TreePath childPath = new TreePath(nodes);
                this.tree.setSelectionPath(childPath);
                this.refreshTree(childPath);
            }
        }
    }

    protected void setTableCellFocus(int row) {
        this.propertyTable.editCellAt(row, 1);
        TableCellEditor editor = this.propertyTable.getCellEditor(row, 1);
        Component comp = editor.getTableCellEditorComponent(this.propertyTable, this.propertyTable.getValueAt(row, 1), true, row, 1);
    }

    protected void addCube(ActionEvent evt) {
        MondrianGuiDef.Schema schema = (MondrianGuiDef.Schema)((Object)this.tree.getModel().getRoot());
        MondrianGuiDef.Cube cube = new MondrianGuiDef.Cube();
        cube.name = "";
        cube.dimensions = new MondrianGuiDef.Dimension[0];
        cube.measures = new MondrianGuiDef.Measure[0];
        cube.calculatedMembers = new MondrianGuiDef.CalculatedMember[0];
        cube.namedSets = new MondrianGuiDef.NamedSet[0];
        cube.name = this.getNewName(this.getResourceConverter().getString("schemaExplorer.newCube.title", "New Cube"), (Object[])schema.cubes);
        cube.cache = Boolean.TRUE;
        cube.enabled = Boolean.TRUE;
        cube.visible = Boolean.TRUE;
        MondrianGuiDef.Cube[] temp = schema.cubes;
        schema.cubes = new MondrianGuiDef.Cube[temp.length + 1];
        for (int _i = 0; _i < temp.length; ++_i) {
            schema.cubes[_i] = temp[_i];
        }
        schema.cubes[schema.cubes.length - 1] = cube;
        this.tree.setSelectionPath(new TreePath(this.model.getRoot()).pathByAddingChild((Object)cube));
        this.refreshTree(this.tree.getSelectionPath());
        this.setTableCellFocus(0);
    }

    protected void addParameter(ActionEvent evt) {
        MondrianGuiDef.Schema schema = (MondrianGuiDef.Schema)((Object)this.tree.getModel().getRoot());
        MondrianGuiDef.Parameter parameter = new MondrianGuiDef.Parameter();
        parameter.name = "";
        parameter.name = this.getNewName(this.getResourceConverter().getString("schemaExplorer.newParameter.title", "New Parameter"), (Object[])schema.parameters);
        parameter.type = "String";
        parameter.modifiable = Boolean.TRUE;
        MondrianGuiDef.Parameter[] temp = schema.parameters;
        schema.parameters = new MondrianGuiDef.Parameter[temp.length + 1];
        for (int _i = 0; _i < temp.length; ++_i) {
            schema.parameters[_i] = temp[_i];
        }
        schema.parameters[schema.parameters.length - 1] = parameter;
        this.tree.setSelectionPath(new TreePath(this.model.getRoot()).pathByAddingChild((Object)parameter));
        this.refreshTree(this.tree.getSelectionPath());
        this.setTableCellFocus(0);
    }

    protected void addRole(ActionEvent evt) {
        MondrianGuiDef.Schema schema = (MondrianGuiDef.Schema)((Object)this.tree.getModel().getRoot());
        MondrianGuiDef.Role role = new MondrianGuiDef.Role();
        role.name = "";
        role.schemaGrants = new MondrianGuiDef.SchemaGrant[0];
        role.name = this.getNewName(this.getResourceConverter().getString("schemaExplorer.newRole.title", "New Role"), (Object[])schema.roles);
        MondrianGuiDef.Role[] temp = schema.roles;
        schema.roles = new MondrianGuiDef.Role[temp.length + 1];
        for (int _i = 0; _i < temp.length; ++_i) {
            schema.roles[_i] = temp[_i];
        }
        schema.roles[schema.roles.length - 1] = role;
        this.tree.setSelectionPath(new TreePath(this.model.getRoot()).pathByAddingChild((Object)role));
        this.refreshTree(this.tree.getSelectionPath());
        this.setTableCellFocus(0);
    }

    protected void addVirtualCube(ActionEvent evt) {
        MondrianGuiDef.Schema schema = (MondrianGuiDef.Schema)((Object)this.tree.getModel().getRoot());
        MondrianGuiDef.VirtualCube cube = new MondrianGuiDef.VirtualCube();
        cube.name = "";
        cube.dimensions = new MondrianGuiDef.VirtualCubeDimension[0];
        cube.measures = new MondrianGuiDef.VirtualCubeMeasure[0];
        cube.calculatedMembers = new MondrianGuiDef.CalculatedMember[0];
        cube.enabled = Boolean.TRUE;
        cube.name = this.getNewName(this.getResourceConverter().getString("schemaExplorer.newVirtualCube.title", "New Virtual Cube"), (Object[])schema.virtualCubes);
        MondrianGuiDef.VirtualCube[] temp = schema.virtualCubes;
        schema.virtualCubes = new MondrianGuiDef.VirtualCube[temp.length + 1];
        for (int i = 0; i < temp.length; ++i) {
            schema.virtualCubes[i] = temp[i];
        }
        schema.virtualCubes[schema.virtualCubes.length - 1] = cube;
        this.tree.setSelectionPath(new TreePath(this.model.getRoot()).pathByAddingChild((Object)cube));
        this.refreshTree(this.tree.getSelectionPath());
        this.setTableCellFocus(0);
    }

    protected void addUserDefinedFunction(ActionEvent evt) {
        MondrianGuiDef.Schema schema = (MondrianGuiDef.Schema)((Object)this.tree.getModel().getRoot());
        MondrianGuiDef.UserDefinedFunction udf = new MondrianGuiDef.UserDefinedFunction();
        udf.name = "";
        udf.name = this.getNewName(this.getResourceConverter().getString("schemaExplorer.newUserDefinedFunction.title", "New User defined Function"), (Object[])schema.userDefinedFunctions);
        MondrianGuiDef.UserDefinedFunction[] temp = schema.userDefinedFunctions;
        schema.userDefinedFunctions = new MondrianGuiDef.UserDefinedFunction[temp.length + 1];
        for (int _i = 0; _i < temp.length; ++_i) {
            schema.userDefinedFunctions[_i] = temp[_i];
        }
        schema.userDefinedFunctions[schema.userDefinedFunctions.length - 1] = udf;
        this.tree.setSelectionPath(new TreePath(this.model.getRoot()).pathByAddingChild((Object)udf));
        this.refreshTree(this.tree.getSelectionPath());
        this.setTableCellFocus(0);
    }

    private void refreshTree(TreePath path) {
        this.setDirty(true);
        if (!this.dirtyFlag) {
            this.setDirtyFlag(true);
            this.setTitle();
        }
        this.updater.update();
        this.tree.scrollPathToVisible(path);
    }

    protected void addMeasure(ActionEvent evt) {
        TreePath tpath = null;
        Object path = null;
        tpath = this.getTreePath(evt);
        int parentIndex = -1;
        if (tpath != null) {
            for (parentIndex = tpath.getPathCount() - 1; parentIndex >= 0; --parentIndex) {
                Object p = tpath.getPathComponent(parentIndex);
                if (!(p instanceof MondrianGuiDef.Cube)) continue;
                path = p;
                break;
            }
        }
        if (!(path instanceof MondrianGuiDef.Cube)) {
            JOptionPane.showMessageDialog(this, this.getResourceConverter().getString("schemaExplorer.cubeNotSelected.alert", "Cube not selected."), alert, 2);
            return;
        }
        MondrianGuiDef.Cube cube = (MondrianGuiDef.Cube)((Object)path);
        MondrianGuiDef.Measure measure = new MondrianGuiDef.Measure();
        measure.name = "";
        measure.name = this.getNewName(this.getResourceConverter().getString("schemaExplorer.newMeasure.title", "New Measure"), (Object[])cube.measures);
        measure.visible = Boolean.TRUE;
        measure.aggregator = "distinct-count";
        MondrianGuiDef.Measure[] temp = cube.measures;
        cube.measures = new MondrianGuiDef.Measure[temp.length + 1];
        for (int i = 0; i < temp.length; ++i) {
            cube.measures[i] = temp[i];
        }
        cube.measures[cube.measures.length - 1] = measure;
        Object[] parentPathObjs = new Object[parentIndex + 1];
        for (int i = 0; i <= parentIndex; ++i) {
            parentPathObjs[i] = tpath.getPathComponent(i);
        }
        TreePath parentPath = new TreePath(parentPathObjs);
        this.tree.setSelectionPath(parentPath.pathByAddingChild((Object)measure));
        this.refreshTree(this.tree.getSelectionPath());
        this.setTableCellFocus(0);
    }

    protected void addAggPattern(ActionEvent evt) {
        TreePath tpath = null;
        Object path = null;
        tpath = this.getTreePath(evt);
        int parentIndex = -1;
        if (tpath != null) {
            for (parentIndex = tpath.getPathCount() - 1; parentIndex >= 0; --parentIndex) {
                Object p = tpath.getPathComponent(parentIndex);
                if (!(p instanceof MondrianGuiDef.Table) || parentIndex - 1 < 0 || !(tpath.getPathComponent(parentIndex - 1) instanceof MondrianGuiDef.Cube)) continue;
                path = p;
                break;
            }
        }
        if (!(path instanceof MondrianGuiDef.Table)) {
            JOptionPane.showMessageDialog(this, this.getResourceConverter().getString("schemaExplorer.cubeFactTableNotSelected.alert", "Cube Fact Table not selected."), alert, 2);
            return;
        }
        MondrianGuiDef.Table factTable = (MondrianGuiDef.Table)((Object)path);
        MondrianGuiDef.AggPattern aggname = new MondrianGuiDef.AggPattern();
        aggname.pattern = "";
        aggname.ignorecase = Boolean.TRUE;
        aggname.factcount = null;
        aggname.ignoreColumns = new MondrianGuiDef.AggIgnoreColumn[0];
        aggname.foreignKeys = new MondrianGuiDef.AggForeignKey[0];
        aggname.measures = new MondrianGuiDef.AggMeasure[0];
        aggname.levels = new MondrianGuiDef.AggLevel[0];
        aggname.excludes = new MondrianGuiDef.AggExclude[0];
        MondrianGuiDef.AggTable[] temp = factTable.aggTables;
        factTable.aggTables = new MondrianGuiDef.AggTable[temp.length + 1];
        for (int i = 0; i < temp.length; ++i) {
            factTable.aggTables[i] = temp[i];
        }
        factTable.aggTables[factTable.aggTables.length - 1] = aggname;
        Object[] parentPathObjs = new Object[parentIndex + 1];
        for (int i = 0; i <= parentIndex; ++i) {
            parentPathObjs[i] = tpath.getPathComponent(i);
        }
        TreePath parentPath = new TreePath(parentPathObjs);
        this.tree.setSelectionPath(parentPath.pathByAddingChild((Object)aggname));
        this.refreshTree(this.tree.getSelectionPath());
        this.setTableCellFocus(0);
    }

    protected void addAggName(ActionEvent evt) {
        TreePath tpath = null;
        Object path = null;
        tpath = this.getTreePath(evt);
        int parentIndex = -1;
        if (tpath != null) {
            for (parentIndex = tpath.getPathCount() - 1; parentIndex >= 0; --parentIndex) {
                Object p = tpath.getPathComponent(parentIndex);
                if (!(p instanceof MondrianGuiDef.Table) || parentIndex - 1 < 0 || !(tpath.getPathComponent(parentIndex - 1) instanceof MondrianGuiDef.Cube)) continue;
                path = p;
                break;
            }
        }
        if (!(path instanceof MondrianGuiDef.Table)) {
            JOptionPane.showMessageDialog(this, this.getResourceConverter().getString("schemaExplorer.tableNotSelected.alert", "Table not selected."), alert, 2);
            return;
        }
        MondrianGuiDef.Table factTable = (MondrianGuiDef.Table)((Object)path);
        MondrianGuiDef.AggName aggname = new MondrianGuiDef.AggName();
        aggname.name = "";
        aggname.ignorecase = Boolean.TRUE;
        aggname.factcount = null;
        aggname.ignoreColumns = new MondrianGuiDef.AggIgnoreColumn[0];
        aggname.foreignKeys = new MondrianGuiDef.AggForeignKey[0];
        aggname.measures = new MondrianGuiDef.AggMeasure[0];
        aggname.levels = new MondrianGuiDef.AggLevel[0];
        MondrianGuiDef.AggTable[] temp = factTable.aggTables;
        if (temp == null) {
            factTable.aggTables = new MondrianGuiDef.AggTable[1];
        } else {
            factTable.aggTables = new MondrianGuiDef.AggTable[temp.length + 1];
            for (int i = 0; i < temp.length; ++i) {
                factTable.aggTables[i] = temp[i];
            }
        }
        factTable.aggTables[factTable.aggTables.length - 1] = aggname;
        Object[] parentPathObjs = new Object[parentIndex + 1];
        for (int i = 0; i <= parentIndex; ++i) {
            parentPathObjs[i] = tpath.getPathComponent(i);
        }
        TreePath parentPath = new TreePath(parentPathObjs);
        this.tree.setSelectionPath(parentPath.pathByAddingChild((Object)aggname));
        this.refreshTree(this.tree.getSelectionPath());
        this.setTableCellFocus(0);
    }

    protected void addAggExclude(ActionEvent evt) {
        int i;
        MondrianGuiDef.AggExclude[] temp;
        ElementDef parent;
        TreePath tpath = null;
        Object path = null;
        tpath = this.getTreePath(evt);
        int parentIndex = -1;
        if (tpath != null) {
            for (parentIndex = tpath.getPathCount() - 1; parentIndex >= 0; --parentIndex) {
                Object p = tpath.getPathComponent(parentIndex);
                if (p instanceof MondrianGuiDef.Table) {
                    if (parentIndex - 1 < 0 || !(tpath.getPathComponent(parentIndex - 1) instanceof MondrianGuiDef.Cube)) continue;
                    path = p;
                    break;
                }
                if (!(p instanceof MondrianGuiDef.AggPattern)) continue;
                path = p;
                break;
            }
        }
        if (!(path instanceof MondrianGuiDef.Table) && !(path instanceof MondrianGuiDef.AggPattern)) {
            JOptionPane.showMessageDialog(this, this.getResourceConverter().getString("schemaExplorer.cubeFactTableOrAggPatternNotSelected.alert", "Cube Fact Table or Aggregate Pattern not selected."), alert, 2);
            return;
        }
        MondrianGuiDef.AggExclude aggexclude = new MondrianGuiDef.AggExclude();
        aggexclude.pattern = "";
        aggexclude.ignorecase = Boolean.TRUE;
        if (path instanceof MondrianGuiDef.Table) {
            parent = (MondrianGuiDef.Table)((Object)path);
            temp = parent.aggExcludes;
            parent.aggExcludes = new MondrianGuiDef.AggExclude[temp.length + 1];
            for (i = 0; i < temp.length; ++i) {
                parent.aggExcludes[i] = temp[i];
            }
            parent.aggExcludes[parent.aggExcludes.length - 1] = aggexclude;
        } else {
            parent = (MondrianGuiDef.AggPattern)((Object)path);
            temp = parent.excludes;
            parent.excludes = new MondrianGuiDef.AggExclude[temp.length + 1];
            for (i = 0; i < temp.length; ++i) {
                parent.excludes[i] = temp[i];
            }
            parent.excludes[parent.excludes.length - 1] = aggexclude;
        }
        Object[] parentPathObjs = new Object[parentIndex + 1];
        for (int i2 = 0; i2 <= parentIndex; ++i2) {
            parentPathObjs[i2] = tpath.getPathComponent(i2);
        }
        TreePath parentPath = new TreePath(parentPathObjs);
        this.tree.setSelectionPath(parentPath.pathByAddingChild((Object)aggexclude));
        this.refreshTree(this.tree.getSelectionPath());
        this.setTableCellFocus(0);
    }

    protected void addAggIgnoreColumn(ActionEvent evt) {
        TreePath tpath = null;
        Object path = null;
        tpath = this.getTreePath(evt);
        int parentIndex = -1;
        if (tpath != null) {
            for (parentIndex = tpath.getPathCount() - 1; parentIndex >= 0; --parentIndex) {
                Object p = tpath.getPathComponent(parentIndex);
                if (!(p instanceof MondrianGuiDef.AggTable)) continue;
                path = p;
                break;
            }
        }
        if (!(path instanceof MondrianGuiDef.AggTable)) {
            JOptionPane.showMessageDialog(this, this.getResourceConverter().getString("schemaExplorer.aggregateTableNotSelected.alert", "Aggregate Table not selected."), alert, 2);
            return;
        }
        MondrianGuiDef.AggTable aggTable = (MondrianGuiDef.AggTable)((Object)path);
        MondrianGuiDef.AggIgnoreColumn aggicol = new MondrianGuiDef.AggIgnoreColumn();
        aggicol.column = "";
        MondrianGuiDef.AggIgnoreColumn[] temp = aggTable.ignoreColumns;
        aggTable.ignoreColumns = new MondrianGuiDef.AggIgnoreColumn[temp.length + 1];
        for (int i = 0; i < temp.length; ++i) {
            aggTable.ignoreColumns[i] = temp[i];
        }
        aggTable.ignoreColumns[aggTable.ignoreColumns.length - 1] = aggicol;
        Object[] parentPathObjs = new Object[parentIndex + 1];
        for (int i = 0; i <= parentIndex; ++i) {
            parentPathObjs[i] = tpath.getPathComponent(i);
        }
        TreePath parentPath = new TreePath(parentPathObjs);
        this.tree.setSelectionPath(parentPath.pathByAddingChild((Object)aggicol));
        this.refreshTree(this.tree.getSelectionPath());
        this.setTableCellFocus(0);
    }

    protected void addAggForeignKey(ActionEvent evt) {
        TreePath tpath = null;
        Object path = null;
        tpath = this.getTreePath(evt);
        int parentIndex = -1;
        if (tpath != null) {
            for (parentIndex = tpath.getPathCount() - 1; parentIndex >= 0; --parentIndex) {
                Object p = tpath.getPathComponent(parentIndex);
                if (!(p instanceof MondrianGuiDef.AggTable)) continue;
                path = p;
                break;
            }
        }
        if (!(path instanceof MondrianGuiDef.AggTable)) {
            JOptionPane.showMessageDialog(this, this.getResourceConverter().getString("schemaExplorer.aggregateTableNotSelected.alert", "Aggregate Table not selected."), alert, 2);
            return;
        }
        MondrianGuiDef.AggTable aggTable = (MondrianGuiDef.AggTable)((Object)path);
        MondrianGuiDef.AggForeignKey aggfkey = new MondrianGuiDef.AggForeignKey();
        MondrianGuiDef.AggForeignKey[] temp = aggTable.foreignKeys;
        aggTable.foreignKeys = new MondrianGuiDef.AggForeignKey[temp.length + 1];
        for (int i = 0; i < temp.length; ++i) {
            aggTable.foreignKeys[i] = temp[i];
        }
        aggTable.foreignKeys[aggTable.foreignKeys.length - 1] = aggfkey;
        Object[] parentPathObjs = new Object[parentIndex + 1];
        for (int i = 0; i <= parentIndex; ++i) {
            parentPathObjs[i] = tpath.getPathComponent(i);
        }
        TreePath parentPath = new TreePath(parentPathObjs);
        this.tree.setSelectionPath(parentPath.pathByAddingChild((Object)aggfkey));
        this.refreshTree(this.tree.getSelectionPath());
        this.setTableCellFocus(0);
    }

    protected void addAggMeasure(ActionEvent evt) {
        TreePath tpath = null;
        Object path = null;
        tpath = this.getTreePath(evt);
        int parentIndex = -1;
        if (tpath != null) {
            for (parentIndex = tpath.getPathCount() - 1; parentIndex >= 0; --parentIndex) {
                Object p = tpath.getPathComponent(parentIndex);
                if (!(p instanceof MondrianGuiDef.AggTable)) continue;
                path = p;
                break;
            }
        }
        if (!(path instanceof MondrianGuiDef.AggTable)) {
            JOptionPane.showMessageDialog(this, this.getResourceConverter().getString("schemaExplorer.aggregateTableNotSelected.alert", "Aggregate Table not selected."), alert, 2);
            return;
        }
        MondrianGuiDef.AggTable aggTable = (MondrianGuiDef.AggTable)((Object)path);
        MondrianGuiDef.AggMeasure aggmeasure = new MondrianGuiDef.AggMeasure();
        MondrianGuiDef.AggMeasure[] temp = aggTable.measures;
        aggTable.measures = new MondrianGuiDef.AggMeasure[temp.length + 1];
        for (int i = 0; i < temp.length; ++i) {
            aggTable.measures[i] = temp[i];
        }
        aggTable.measures[aggTable.measures.length - 1] = aggmeasure;
        Object[] parentPathObjs = new Object[parentIndex + 1];
        for (int i = 0; i <= parentIndex; ++i) {
            parentPathObjs[i] = tpath.getPathComponent(i);
        }
        TreePath parentPath = new TreePath(parentPathObjs);
        this.tree.setSelectionPath(parentPath.pathByAddingChild((Object)aggmeasure));
        this.refreshTree(this.tree.getSelectionPath());
        this.setTableCellFocus(0);
    }

    protected void addAggLevel(ActionEvent evt) {
        TreePath tpath = null;
        Object path = null;
        tpath = this.getTreePath(evt);
        int parentIndex = -1;
        if (tpath != null) {
            for (parentIndex = tpath.getPathCount() - 1; parentIndex >= 0; --parentIndex) {
                Object p = tpath.getPathComponent(parentIndex);
                if (!(p instanceof MondrianGuiDef.AggTable)) continue;
                path = p;
                break;
            }
        }
        if (!(path instanceof MondrianGuiDef.AggTable)) {
            JOptionPane.showMessageDialog(this, this.getResourceConverter().getString("schemaExplorer.aggregateTableNotSelected.alert", "Aggregate Table not selected."), alert, 2);
            return;
        }
        MondrianGuiDef.AggTable aggTable = (MondrianGuiDef.AggTable)((Object)path);
        MondrianGuiDef.AggLevel agglevel = new MondrianGuiDef.AggLevel();
        MondrianGuiDef.AggLevel[] temp = aggTable.levels;
        aggTable.levels = new MondrianGuiDef.AggLevel[temp.length + 1];
        for (int i = 0; i < temp.length; ++i) {
            aggTable.levels[i] = temp[i];
        }
        aggTable.levels[aggTable.levels.length - 1] = agglevel;
        agglevel.collapsed = Boolean.TRUE;
        Object[] parentPathObjs = new Object[parentIndex + 1];
        for (int i = 0; i <= parentIndex; ++i) {
            parentPathObjs[i] = tpath.getPathComponent(i);
        }
        TreePath parentPath = new TreePath(parentPathObjs);
        this.tree.setSelectionPath(parentPath.pathByAddingChild((Object)agglevel));
        this.refreshTree(this.tree.getSelectionPath());
        this.setTableCellFocus(0);
    }

    protected void addAggLevelProperty(ActionEvent evt) {
        TreePath tpath = this.getTreePath(evt);
        Object path = null;
        int parentIndex = -1;
        if (tpath != null) {
            for (parentIndex = tpath.getPathCount() - 1; parentIndex >= 0; --parentIndex) {
                Object p = tpath.getPathComponent(parentIndex);
                if (!(p instanceof MondrianGuiDef.AggLevel)) continue;
                path = p;
                break;
            }
        }
        if (!(path instanceof MondrianGuiDef.AggLevel)) {
            JOptionPane.showMessageDialog(this, this.getResourceConverter().getString("schemaExplorer.aggregateLevelNotSelected.alert", "Aggregate Level not selected."), alert, 2);
            return;
        }
        MondrianGuiDef.AggLevel aggLevel = (MondrianGuiDef.AggLevel)((Object)path);
        MondrianGuiDef.AggLevelProperty aggLevelProperty = new MondrianGuiDef.AggLevelProperty();
        this.appendAggLevelProperty(aggLevel, aggLevelProperty);
        Object[] parentPathObjs = new Object[parentIndex + 1];
        for (int i = 0; i <= parentIndex; ++i) {
            parentPathObjs[i] = tpath.getPathComponent(i);
        }
        TreePath parentPath = new TreePath(parentPathObjs);
        this.tree.setSelectionPath(parentPath.pathByAddingChild((Object)aggLevelProperty));
        this.refreshTree(this.tree.getSelectionPath());
        this.setTableCellFocus(0);
    }

    private void appendAggLevelProperty(MondrianGuiDef.AggLevel aggLevel, MondrianGuiDef.AggLevelProperty aggLevelProperty) {
        if (aggLevel.properties == null) {
            aggLevel.properties = new MondrianGuiDef.AggLevelProperty[]{aggLevelProperty};
        } else {
            aggLevel.properties = Arrays.copyOf(aggLevel.properties, aggLevel.properties.length + 1);
            aggLevel.properties[aggLevel.properties.length - 1] = aggLevelProperty;
        }
    }

    private TreePath getTreePath(ActionEvent evt) {
        TreePath tpath = evt.getSource() instanceof Component && ((Component)evt.getSource()).getParent() instanceof CustomJPopupMenu ? ((CustomJPopupMenu)((Component)evt.getSource()).getParent()).getPath() : this.tree.getSelectionPath();
        return tpath;
    }

    protected void addAggFactCount(ActionEvent evt) {
        TreePath tpath = null;
        Object path = null;
        tpath = this.getTreePath(evt);
        int parentIndex = -1;
        if (tpath != null) {
            for (parentIndex = tpath.getPathCount() - 1; parentIndex >= 0; --parentIndex) {
                Object p = tpath.getPathComponent(parentIndex);
                if (!(p instanceof MondrianGuiDef.AggTable)) continue;
                path = p;
                break;
            }
        }
        if (!(path instanceof MondrianGuiDef.AggName) && !(path instanceof MondrianGuiDef.AggPattern)) {
            JOptionPane.showMessageDialog(this, this.getResourceConverter().getString("schemaExplorer.aggregateTableOrAggPatternNotSelected.alert", "Aggregate Table or Aggregate Pattern not selected."), alert, 2);
            return;
        }
        MondrianGuiDef.AggFactCount aggFactCount = new MondrianGuiDef.AggFactCount();
        MondrianGuiDef.AggName aggName = null;
        MondrianGuiDef.AggPattern aggPattern = null;
        if (path instanceof MondrianGuiDef.AggName) {
            aggName = (MondrianGuiDef.AggName)((Object)path);
            aggName.factcount = new MondrianGuiDef.AggFactCount();
        } else {
            aggPattern = (MondrianGuiDef.AggPattern)((Object)path);
            aggPattern.factcount = new MondrianGuiDef.AggFactCount();
        }
        Object[] parentPathObjs = new Object[parentIndex + 1];
        for (int i = 0; i <= parentIndex; ++i) {
            parentPathObjs[i] = tpath.getPathComponent(i);
        }
        TreePath parentPath = new TreePath(parentPathObjs);
        this.tree.setSelectionPath(parentPath.pathByAddingChild((Object)aggFactCount));
        this.refreshTree(this.tree.getSelectionPath());
        this.setTableCellFocus(0);
    }

    protected void addAggMeasureFactCount(ActionEvent evt) {
        TreePath tpath = null;
        Object path = null;
        tpath = this.getTreePath(evt);
        int parentIndex = -1;
        if (tpath != null) {
            for (parentIndex = tpath.getPathCount() - 1; parentIndex >= 0; --parentIndex) {
                Object p = tpath.getPathComponent(parentIndex);
                if (!(p instanceof MondrianGuiDef.AggTable)) continue;
                path = p;
                break;
            }
        }
        if (!(path instanceof MondrianGuiDef.AggName) && !(path instanceof MondrianGuiDef.AggPattern)) {
            JOptionPane.showMessageDialog(this, this.getResourceConverter().getString("schemaExplorer.aggregateTableOrAggPatternNotSelected.alert", "Aggregate Table or Aggregate Pattern not selected."), alert, 2);
            return;
        }
        MondrianGuiDef.AggTable aggTable = (MondrianGuiDef.AggTable)((Object)path);
        MondrianGuiDef.AggMeasureFactCount aggMeasureFactCount = new MondrianGuiDef.AggMeasureFactCount();
        MondrianGuiDef.AggMeasureFactCount[] temp = aggTable.measuresfactcount;
        aggTable.measuresfactcount = new MondrianGuiDef.AggMeasureFactCount[temp.length + 1];
        for (int i = 0; i < temp.length; ++i) {
            aggTable.measuresfactcount[i] = temp[i];
        }
        aggTable.measuresfactcount[aggTable.measuresfactcount.length - 1] = aggMeasureFactCount;
        Object[] parentPathObjs = new Object[parentIndex + 1];
        for (int i = 0; i <= parentIndex; ++i) {
            parentPathObjs[i] = tpath.getPathComponent(i);
        }
        TreePath parentPath = new TreePath(parentPathObjs);
        this.tree.setSelectionPath(parentPath.pathByAddingChild((Object)aggMeasureFactCount));
        this.refreshTree(this.tree.getSelectionPath());
        this.setTableCellFocus(0);
    }

    protected void addVirtualCubeMeasure(ActionEvent evt) {
        TreePath tpath = null;
        Object path = null;
        tpath = this.getTreePath(evt);
        int parentIndex = -1;
        if (tpath != null) {
            for (parentIndex = tpath.getPathCount() - 1; parentIndex >= 0; --parentIndex) {
                Object p = tpath.getPathComponent(parentIndex);
                if (!(p instanceof MondrianGuiDef.VirtualCube)) continue;
                path = p;
                break;
            }
        }
        if (!(path instanceof MondrianGuiDef.VirtualCube)) {
            JOptionPane.showMessageDialog(this, this.getResourceConverter().getString("schemaExplorer.virtualCubeNotSelected.alert", "Virtual Cube not selected."), alert, 2);
            return;
        }
        MondrianGuiDef.VirtualCube cube = (MondrianGuiDef.VirtualCube)((Object)path);
        MondrianGuiDef.VirtualCubeMeasure measure = new MondrianGuiDef.VirtualCubeMeasure();
        measure.name = "";
        measure.name = this.getNewName(this.getResourceConverter().getString("schemaExplorer.newVirtualMeasure.title", "New Virtual Measure"), (Object[])cube.measures);
        measure.visible = Boolean.TRUE;
        MondrianGuiDef.VirtualCubeMeasure[] temp = cube.measures;
        cube.measures = new MondrianGuiDef.VirtualCubeMeasure[temp.length + 1];
        for (int i = 0; i < temp.length; ++i) {
            cube.measures[i] = temp[i];
        }
        cube.measures[cube.measures.length - 1] = measure;
        Object[] parentPathObjs = new Object[parentIndex + 1];
        for (int i = 0; i <= parentIndex; ++i) {
            parentPathObjs[i] = tpath.getPathComponent(i);
        }
        TreePath parentPath = new TreePath(parentPathObjs);
        this.tree.setSelectionPath(parentPath.pathByAddingChild((Object)measure));
        this.refreshTree(this.tree.getSelectionPath());
        this.setTableCellFocus(0);
    }

    protected void addCalculatedMember(ActionEvent evt) {
        int i;
        MondrianGuiDef.CalculatedMember[] temp;
        TreePath tpath = null;
        Object path = null;
        tpath = this.getTreePath(evt);
        int parentIndex = -1;
        if (tpath != null) {
            for (parentIndex = tpath.getPathCount() - 1; parentIndex >= 0; --parentIndex) {
                Object p = tpath.getPathComponent(parentIndex);
                if (!(p instanceof MondrianGuiDef.Cube) && !(p instanceof MondrianGuiDef.VirtualCube)) continue;
                path = p;
                break;
            }
        }
        if (!(path instanceof MondrianGuiDef.Cube) && !(path instanceof MondrianGuiDef.VirtualCube)) {
            JOptionPane.showMessageDialog(this, this.getResourceConverter().getString("schemaExplorer.cubeOrVirtualCubeNotSelected.alert", "Cube or Virtual Cube not selected."), alert, 2);
            return;
        }
        MondrianGuiDef.Cube cube = null;
        MondrianGuiDef.VirtualCube vcube = null;
        if (path instanceof MondrianGuiDef.Cube) {
            cube = (MondrianGuiDef.Cube)((Object)path);
        } else {
            vcube = (MondrianGuiDef.VirtualCube)((Object)path);
        }
        MondrianGuiDef.CalculatedMember calcmember = new MondrianGuiDef.CalculatedMember();
        calcmember.name = "";
        calcmember.dimension = "Measures";
        calcmember.visible = Boolean.TRUE;
        calcmember.formatString = "";
        calcmember.formula = "";
        calcmember.formulaElement = new MondrianGuiDef.Formula();
        calcmember.memberProperties = new MondrianGuiDef.CalculatedMemberProperty[0];
        if (cube != null) {
            calcmember.name = this.getNewName(this.getResourceConverter().getString("schemaExplorer.newCalculatedMember.title", "New Calculated Member"), (Object[])cube.calculatedMembers);
            temp = cube.calculatedMembers;
            cube.calculatedMembers = new MondrianGuiDef.CalculatedMember[temp.length + 1];
            for (i = 0; i < temp.length; ++i) {
                cube.calculatedMembers[i] = temp[i];
            }
            cube.calculatedMembers[cube.calculatedMembers.length - 1] = calcmember;
        } else {
            calcmember.name = this.getNewName(this.getResourceConverter().getString("schemaExplorer.newCalculatedMember.title", "New Calculated Member"), (Object[])vcube.calculatedMembers);
            temp = vcube.calculatedMembers;
            vcube.calculatedMembers = new MondrianGuiDef.CalculatedMember[temp.length + 1];
            for (i = 0; i < temp.length; ++i) {
                vcube.calculatedMembers[i] = temp[i];
            }
            vcube.calculatedMembers[vcube.calculatedMembers.length - 1] = calcmember;
        }
        Object[] parentPathObjs = new Object[parentIndex + 1];
        for (i = 0; i <= parentIndex; ++i) {
            parentPathObjs[i] = tpath.getPathComponent(i);
        }
        TreePath parentPath = new TreePath(parentPathObjs);
        this.tree.setSelectionPath(parentPath.pathByAddingChild((Object)calcmember));
        this.refreshTree(this.tree.getSelectionPath());
        this.setTableCellFocus(0);
    }

    protected boolean editMode(EventObject evt) {
        this.editModeXML = !this.isEditModeXML();
        this.editModeButton.setSelected(this.isEditModeXML());
        if (this.isEditModeXML()) {
            this.jSplitPane1.setRightComponent(this.jPanelXML);
        } else {
            this.jSplitPane1.setRightComponent(this.jPanel1);
        }
        for (Container o = this.parentIFrame.getDesktopPane().getParent(); o != null; o = o.getParent()) {
            if (o.getClass() != Workbench.class) continue;
            ((Workbench)o).getViewXmlMenuItem().setSelected(this.editModeXML);
            break;
        }
        return this.isEditModeXML();
    }

    protected void delete(EventObject evt) {
        TreePath tpath = null;
        Object path = null;
        tpath = evt.getSource() instanceof Component && ((Component)evt.getSource()).getParent() instanceof CustomJPopupMenu ? ((CustomJPopupMenu)((Component)evt.getSource()).getParent()).getPath() : this.tree.getSelectionPath();
        if (tpath == null) {
            JOptionPane.showMessageDialog(this, this.getResourceConverter().getString("schemaExplorer.objectToDeleteNotSelected.alert", "Object to delete in Schema not selected."), alert, 2);
            return;
        }
        this.delete(tpath);
    }

    void delete(TreePath tpath) {
        Object child = tpath.getLastPathComponent();
        Object nextSibling = null;
        Object prevSibling = null;
        Object parent = null;
        Object grandparent = null;
        boolean grandparentAsSibling = false;
        int i = tpath.getPathCount() - 1 - 1;
        if (i >= 0) {
            parent = tpath.getPathComponent(i);
            if (tpath.getPathCount() - 3 > 0) {
                grandparent = tpath.getPathComponent(i - 1);
            }
        }
        if (parent == null) {
            JOptionPane.showMessageDialog(this, this.getResourceConverter().getString("schemaExplorer.cantDeleteObject.alert", "Schema object cannot be deleted."), alert, 2);
            return;
        }
        boolean tofind = true;
        Field[] fs = parent.getClass().getFields();
        for (int i2 = 0; i2 < fs.length; ++i2) {
            if (fs[i2].getType().isArray() && fs[i2].getType().getComponentType().isInstance(child)) {
                try {
                    Object parentArr = fs[i2].get(parent);
                    int parentArrLen = Array.getLength(parentArr);
                    Object newArr = Array.newInstance(fs[i2].getType().getComponentType(), parentArrLen - 1);
                    tofind = true;
                    int m = 0;
                    for (int k = 0; k < parentArrLen; ++k) {
                        Object match = Array.get(parentArr, k);
                        if (tofind && match.equals(child)) {
                            if (child instanceof MondrianGuiDef.CubeDimension) {
                                MondrianGuiDef.CubeDimension matchDim = (MondrianGuiDef.CubeDimension)((Object)match);
                                MondrianGuiDef.CubeDimension childDim = (MondrianGuiDef.CubeDimension)((Object)child);
                                if (this.eq(matchDim.name, childDim.name) && this.eq(matchDim.caption, childDim.caption) && this.eq(matchDim.foreignKey, childDim.foreignKey)) {
                                    tofind = false;
                                    if (k + 1 < parentArrLen) {
                                        nextSibling = Array.get(parentArr, k + 1);
                                    }
                                    if (k - 1 < 0) continue;
                                    prevSibling = Array.get(parentArr, k - 1);
                                    continue;
                                }
                            } else {
                                tofind = false;
                                if (k + 1 < parentArrLen) {
                                    nextSibling = Array.get(parentArr, k + 1);
                                }
                                if (k - 1 < 0) continue;
                                prevSibling = Array.get(parentArr, k - 1);
                                continue;
                            }
                        }
                        Array.set(newArr, m++, match);
                    }
                    if (child instanceof MondrianGuiDef.SQL && parent instanceof MondrianGuiDef.ExpressionView && Array.getLength(newArr) < 1) {
                        if (parent instanceof MondrianGuiDef.KeyExpression) {
                            ((MondrianGuiDef.Level)((Object)grandparent)).keyExp = null;
                        } else if (parent instanceof MondrianGuiDef.NameExpression) {
                            ((MondrianGuiDef.Level)((Object)grandparent)).nameExp = null;
                        } else if (parent instanceof MondrianGuiDef.OrdinalExpression) {
                            ((MondrianGuiDef.Level)((Object)grandparent)).ordinalExp = null;
                        } else if (parent instanceof MondrianGuiDef.CaptionExpression) {
                            ((MondrianGuiDef.Level)((Object)grandparent)).captionExp = null;
                        } else if (parent instanceof MondrianGuiDef.ParentExpression) {
                            ((MondrianGuiDef.Level)((Object)grandparent)).parentExp = null;
                        } else if (parent instanceof MondrianGuiDef.MeasureExpression) {
                            ((MondrianGuiDef.Measure)((Object)grandparent)).measureExp = null;
                        }
                        grandparentAsSibling = true;
                        break;
                    }
                    fs[i2].set(parent, newArr);
                }
                catch (Exception parentArr) {}
                break;
            }
            if (!fs[i2].getType().isInstance(child)) continue;
            try {
                if (fs[i2].get(parent) != child) continue;
                fs[i2].set(parent, null);
                break;
            }
            catch (Exception ex) {
                LOGGER.error((Object)"delete", (Throwable)ex);
            }
        }
        TreeExpansionEvent e = null;
        e = new TreeExpansionEvent(this.tree, tpath);
        this.updater.treeCollapsed(e);
        if (nextSibling != null) {
            this.tree.setSelectionPath(tpath.getParentPath().pathByAddingChild(nextSibling));
        } else if (prevSibling != null) {
            this.tree.setSelectionPath(tpath.getParentPath().pathByAddingChild(prevSibling));
        } else if (grandparentAsSibling) {
            this.tree.setSelectionPath(tpath.getParentPath().getParentPath());
        } else {
            this.tree.setSelectionPath(tpath.getParentPath());
        }
        this.refreshTree(this.tree.getSelectionPath());
    }

    private boolean eq(String o1, String o2) {
        return o1 == null ? o2 == null : o1.equals(o2);
    }

    protected void addDimension(ActionEvent evt) {
        int i;
        MondrianGuiDef.CubeDimension[] temp;
        TreePath tpath = null;
        Object path = null;
        tpath = this.getTreePath(evt);
        int parentIndex = -1;
        if (tpath != null) {
            for (parentIndex = tpath.getPathCount() - 1; parentIndex >= 0; --parentIndex) {
                Object p = tpath.getPathComponent(parentIndex);
                if (!(p instanceof MondrianGuiDef.Cube) && !(p instanceof MondrianGuiDef.Schema)) continue;
                path = p;
                break;
            }
        }
        if (!(path instanceof MondrianGuiDef.Cube) && !(path instanceof MondrianGuiDef.Schema)) {
            JOptionPane.showMessageDialog(this, this.getResourceConverter().getString("schemaExplorer.cubeOrSchemaNotSelected.alert", "Cube or Schema not selected."), alert, 2);
            return;
        }
        MondrianGuiDef.Cube cube = null;
        MondrianGuiDef.Schema schema = null;
        if (path instanceof MondrianGuiDef.Cube) {
            cube = (MondrianGuiDef.Cube)((Object)path);
        } else {
            schema = (MondrianGuiDef.Schema)((Object)path);
        }
        MondrianGuiDef.Dimension dimension = new MondrianGuiDef.Dimension();
        dimension.name = "";
        dimension.visible = Boolean.TRUE;
        dimension.type = "StandardDimension";
        dimension.hierarchies = new MondrianGuiDef.Hierarchy[1];
        dimension.hierarchies[0] = new MondrianGuiDef.Hierarchy();
        dimension.hierarchies[0].name = this.getResourceConverter().getString("schemaExplorer.newHierarchyInTree.title", "New Hierarchy 0");
        dimension.hierarchies[0].visible = Boolean.TRUE;
        dimension.hierarchies[0].hasAll = true;
        dimension.hierarchies[0].levels = new MondrianGuiDef.Level[0];
        dimension.hierarchies[0].memberReaderParameters = new MondrianGuiDef.MemberReaderParameter[0];
        if (cube != null) {
            dimension.name = this.getNewName(this.getResourceConverter().getString("schemaExplorer.newDimension.title", "New Dimension"), (Object[])cube.dimensions);
            temp = cube.dimensions;
            cube.dimensions = new MondrianGuiDef.CubeDimension[temp.length + 1];
            for (i = 0; i < temp.length; ++i) {
                cube.dimensions[i] = temp[i];
            }
            cube.dimensions[cube.dimensions.length - 1] = dimension;
        } else {
            dimension.name = this.getNewName(this.getResourceConverter().getString("schemaExplorer.newDimension.title", "New Dimension"), (Object[])schema.dimensions);
            temp = schema.dimensions;
            schema.dimensions = new MondrianGuiDef.Dimension[temp.length + 1];
            for (i = 0; i < temp.length; ++i) {
                schema.dimensions[i] = (MondrianGuiDef.Dimension)temp[i];
            }
            schema.dimensions[schema.dimensions.length - 1] = dimension;
        }
        Object[] parentPathObjs = new Object[parentIndex + 1];
        for (i = 0; i <= parentIndex; ++i) {
            parentPathObjs[i] = tpath.getPathComponent(i);
        }
        TreePath parentPath = new TreePath(parentPathObjs);
        this.tree.setSelectionPath(parentPath.pathByAddingChild((Object)dimension));
        this.refreshTree(this.tree.getSelectionPath());
        this.setTableCellFocus(0);
    }

    protected void addVirtualCubeDimension(ActionEvent evt) {
        TreePath tpath = null;
        Object path = null;
        tpath = this.getTreePath(evt);
        int parentIndex = -1;
        if (tpath != null) {
            for (parentIndex = tpath.getPathCount() - 1; parentIndex >= 0; --parentIndex) {
                Object p = tpath.getPathComponent(parentIndex);
                if (!(p instanceof MondrianGuiDef.VirtualCube)) continue;
                path = p;
                break;
            }
        }
        if (!(path instanceof MondrianGuiDef.VirtualCube)) {
            JOptionPane.showMessageDialog(this, this.getResourceConverter().getString("schemaExplorer.virtualCubeNotSelected.alert", "Virtual Cube not selected."), alert, 2);
            return;
        }
        MondrianGuiDef.VirtualCube cube = (MondrianGuiDef.VirtualCube)((Object)path);
        MondrianGuiDef.VirtualCubeDimension dimension = new MondrianGuiDef.VirtualCubeDimension();
        dimension.name = "";
        dimension.name = this.getNewName(this.getResourceConverter().getString("schemaExplorer.newVirtualDimension.title", "New Virtual Dimension"), (Object[])cube.dimensions);
        MondrianGuiDef.VirtualCubeDimension[] temp = cube.dimensions;
        cube.dimensions = new MondrianGuiDef.VirtualCubeDimension[temp.length + 1];
        for (int i = 0; i < temp.length; ++i) {
            cube.dimensions[i] = temp[i];
        }
        cube.dimensions[cube.dimensions.length - 1] = dimension;
        Object[] parentPathObjs = new Object[parentIndex + 1];
        for (int i = 0; i <= parentIndex; ++i) {
            parentPathObjs[i] = tpath.getPathComponent(i);
        }
        TreePath parentPath = new TreePath(parentPathObjs);
        this.tree.setSelectionPath(parentPath.pathByAddingChild((Object)dimension));
        this.refreshTree(this.tree.getSelectionPath());
        this.setTableCellFocus(0);
    }

    private String getNewName(String preName, Object[] objs) {
        String newName = "";
        String workName = preName.trim() + " ";
        if (objs != null) {
            int objNo = objs.length;
            try {
                boolean exists;
                Field f = objs.getClass().getComponentType().getField("name");
                while (exists = SchemaExplorer.existsWithFieldValue(objs, newName = workName + objNo++, f)) {
                }
            }
            catch (Exception ex) {
                LOGGER.error((Object)"getNewName", (Throwable)ex);
            }
        } else {
            newName = workName + 0;
        }
        return newName;
    }

    private static boolean existsWithFieldValue(Object[] objs, String seek, Field f) throws IllegalAccessException {
        for (int i = 0; i < objs.length; ++i) {
            String value = (String)f.get(objs[i]);
            if (!seek.equals(value)) continue;
            return true;
        }
        return false;
    }

    protected void addNamedSet(ActionEvent evt) {
        int i;
        MondrianGuiDef.NamedSet[] temp;
        TreePath tpath = null;
        Object path = null;
        tpath = this.getTreePath(evt);
        int parentIndex = -1;
        if (tpath != null) {
            for (parentIndex = tpath.getPathCount() - 1; parentIndex >= 0; --parentIndex) {
                Object p = tpath.getPathComponent(parentIndex);
                if (!(p instanceof MondrianGuiDef.Cube) && !(p instanceof MondrianGuiDef.Schema)) continue;
                path = p;
                break;
            }
        }
        if (!(path instanceof MondrianGuiDef.Cube) && !(path instanceof MondrianGuiDef.Schema)) {
            JOptionPane.showMessageDialog(this, this.getResourceConverter().getString("schemaExplorer.cubeOrSchemaNotSelected.alert", "Cube or Schema not selected."), alert, 2);
            return;
        }
        MondrianGuiDef.Cube cube = null;
        MondrianGuiDef.Schema schema = null;
        if (path instanceof MondrianGuiDef.Cube) {
            cube = (MondrianGuiDef.Cube)((Object)path);
        } else {
            schema = (MondrianGuiDef.Schema)((Object)path);
        }
        MondrianGuiDef.NamedSet namedset = new MondrianGuiDef.NamedSet();
        namedset.name = "";
        namedset.formula = "";
        namedset.formulaElement = new MondrianGuiDef.Formula();
        if (cube != null) {
            namedset.name = this.getNewName(this.getResourceConverter().getString("schemaExplorer.newNamedSet.title", "New Named Set"), (Object[])cube.namedSets);
            temp = cube.namedSets;
            cube.namedSets = new MondrianGuiDef.NamedSet[temp.length + 1];
            for (i = 0; i < temp.length; ++i) {
                cube.namedSets[i] = temp[i];
            }
            cube.namedSets[cube.namedSets.length - 1] = namedset;
        } else {
            namedset.name = this.getNewName(this.getResourceConverter().getString("schemaExplorer.newNamedSet.title", "New Named Set"), (Object[])schema.namedSets);
            temp = schema.namedSets;
            schema.namedSets = new MondrianGuiDef.NamedSet[temp.length + 1];
            for (i = 0; i < temp.length; ++i) {
                schema.namedSets[i] = temp[i];
            }
            schema.namedSets[schema.namedSets.length - 1] = namedset;
        }
        Object[] parentPathObjs = new Object[parentIndex + 1];
        for (i = 0; i <= parentIndex; ++i) {
            parentPathObjs[i] = tpath.getPathComponent(i);
        }
        TreePath parentPath = new TreePath(parentPathObjs);
        this.tree.setSelectionPath(parentPath.pathByAddingChild((Object)namedset));
        this.refreshTree(this.tree.getSelectionPath());
        this.setTableCellFocus(0);
    }

    protected void addDimensionUsage(ActionEvent evt) {
        TreePath tpath = null;
        Object path = null;
        tpath = this.getTreePath(evt);
        int parentIndex = -1;
        if (tpath != null) {
            for (parentIndex = tpath.getPathCount() - 1; parentIndex >= 0; --parentIndex) {
                Object p = tpath.getPathComponent(parentIndex);
                if (!(p instanceof MondrianGuiDef.Cube)) continue;
                path = p;
                break;
            }
        }
        if (!(path instanceof MondrianGuiDef.Cube)) {
            JOptionPane.showMessageDialog(this, this.getResourceConverter().getString("schemaExplorer.cubeNotSelected.alert", "Cube not selected."), alert, 2);
            return;
        }
        MondrianGuiDef.Cube cube = (MondrianGuiDef.Cube)((Object)path);
        MondrianGuiDef.DimensionUsage dimension = new MondrianGuiDef.DimensionUsage();
        dimension.name = "";
        dimension.visible = Boolean.TRUE;
        dimension.name = this.getNewName(this.getResourceConverter().getString("schemaExplorer.newDimensionUsage.title", "New Dimension Usage"), (Object[])cube.dimensions);
        MondrianGuiDef.CubeDimension[] temp = cube.dimensions;
        cube.dimensions = new MondrianGuiDef.CubeDimension[temp.length + 1];
        for (int i = 0; i < temp.length; ++i) {
            cube.dimensions[i] = temp[i];
        }
        cube.dimensions[cube.dimensions.length - 1] = dimension;
        Object[] parentPathObjs = new Object[parentIndex + 1];
        for (int i = 0; i <= parentIndex; ++i) {
            parentPathObjs[i] = tpath.getPathComponent(i);
        }
        TreePath parentPath = new TreePath(parentPathObjs);
        this.tree.setSelectionPath(parentPath.pathByAddingChild((Object)dimension));
        this.refreshTree(this.tree.getSelectionPath());
        this.setTableCellFocus(0);
    }

    protected void addSchemaGrant(ActionEvent evt) {
        TreePath tpath = null;
        Object path = null;
        tpath = this.getTreePath(evt);
        int parentIndex = -1;
        if (tpath != null) {
            for (parentIndex = tpath.getPathCount() - 1; parentIndex >= 0; --parentIndex) {
                Object p = tpath.getPathComponent(parentIndex);
                if (!(p instanceof MondrianGuiDef.Role)) continue;
                path = p;
                break;
            }
        }
        if (!(path instanceof MondrianGuiDef.Role)) {
            JOptionPane.showMessageDialog(this, this.getResourceConverter().getString("schemaExplorer.roleNotSelected.alert", "Role not selected."), alert, 2);
            return;
        }
        MondrianGuiDef.Role role = (MondrianGuiDef.Role)((Object)path);
        MondrianGuiDef.SchemaGrant schemaGrant = new MondrianGuiDef.SchemaGrant();
        schemaGrant.access = "";
        schemaGrant.cubeGrants = new MondrianGuiDef.CubeGrant[0];
        MondrianGuiDef.SchemaGrant[] temp = role.schemaGrants;
        role.schemaGrants = new MondrianGuiDef.SchemaGrant[temp.length + 1];
        for (int i = 0; i < temp.length; ++i) {
            role.schemaGrants[i] = temp[i];
        }
        role.schemaGrants[role.schemaGrants.length - 1] = schemaGrant;
        Object[] parentPathObjs = new Object[parentIndex + 1];
        for (int i = 0; i <= parentIndex; ++i) {
            parentPathObjs[i] = tpath.getPathComponent(i);
        }
        TreePath parentPath = new TreePath(parentPathObjs);
        this.tree.setSelectionPath(parentPath.pathByAddingChild(schemaGrant));
        this.refreshTree(this.tree.getSelectionPath());
        this.setTableCellFocus(0);
    }

    protected void addCubeGrant(ActionEvent evt) {
        TreePath tpath = null;
        Object path = null;
        tpath = this.getTreePath(evt);
        int parentIndex = -1;
        if (tpath != null) {
            for (parentIndex = tpath.getPathCount() - 1; parentIndex >= 0; --parentIndex) {
                Object p = tpath.getPathComponent(parentIndex);
                if (!(p instanceof MondrianGuiDef.SchemaGrant)) continue;
                path = p;
                break;
            }
        }
        if (!(path instanceof MondrianGuiDef.SchemaGrant)) {
            JOptionPane.showMessageDialog(this, this.getResourceConverter().getString("schemaExplorer.schemaGrantNotSelected.alert", "Schema Grant not selected."), alert, 2);
            return;
        }
        MondrianGuiDef.SchemaGrant schemaGrant = (MondrianGuiDef.SchemaGrant)path;
        MondrianGuiDef.CubeGrant cubeGrant = new MondrianGuiDef.CubeGrant();
        cubeGrant.access = "";
        cubeGrant.dimensionGrants = new MondrianGuiDef.DimensionGrant[0];
        cubeGrant.hierarchyGrants = new MondrianGuiDef.HierarchyGrant[0];
        MondrianGuiDef.CubeGrant[] temp = schemaGrant.cubeGrants;
        schemaGrant.cubeGrants = new MondrianGuiDef.CubeGrant[temp.length + 1];
        for (int i = 0; i < temp.length; ++i) {
            schemaGrant.cubeGrants[i] = temp[i];
        }
        schemaGrant.cubeGrants[schemaGrant.cubeGrants.length - 1] = cubeGrant;
        Object[] parentPathObjs = new Object[parentIndex + 1];
        for (int i = 0; i <= parentIndex; ++i) {
            parentPathObjs[i] = tpath.getPathComponent(i);
        }
        TreePath parentPath = new TreePath(parentPathObjs);
        this.tree.setSelectionPath(parentPath.pathByAddingChild(cubeGrant));
        this.refreshTree(this.tree.getSelectionPath());
        this.setTableCellFocus(0);
    }

    protected void addDimensionGrant(ActionEvent evt) {
        TreePath tpath = null;
        Object path = null;
        tpath = this.getTreePath(evt);
        int parentIndex = -1;
        if (tpath != null) {
            for (parentIndex = tpath.getPathCount() - 1; parentIndex >= 0; --parentIndex) {
                Object p = tpath.getPathComponent(parentIndex);
                if (!(p instanceof MondrianGuiDef.CubeGrant)) continue;
                path = p;
                break;
            }
        }
        if (!(path instanceof MondrianGuiDef.CubeGrant)) {
            JOptionPane.showMessageDialog(this, this.getResourceConverter().getString("schemaExplorer.cubeGrantNotSelected.alert", "Cube Grant not selected."), alert, 2);
            return;
        }
        MondrianGuiDef.CubeGrant cubeGrant = (MondrianGuiDef.CubeGrant)path;
        MondrianGuiDef.DimensionGrant dimeGrant = new MondrianGuiDef.DimensionGrant();
        dimeGrant.access = "";
        MondrianGuiDef.DimensionGrant[] temp = cubeGrant.dimensionGrants;
        cubeGrant.dimensionGrants = new MondrianGuiDef.DimensionGrant[temp.length + 1];
        for (int i = 0; i < temp.length; ++i) {
            cubeGrant.dimensionGrants[i] = temp[i];
        }
        cubeGrant.dimensionGrants[cubeGrant.dimensionGrants.length - 1] = dimeGrant;
        Object[] parentPathObjs = new Object[parentIndex + 1];
        for (int i = 0; i <= parentIndex; ++i) {
            parentPathObjs[i] = tpath.getPathComponent(i);
        }
        TreePath parentPath = new TreePath(parentPathObjs);
        this.tree.setSelectionPath(parentPath.pathByAddingChild(dimeGrant));
        this.refreshTree(this.tree.getSelectionPath());
        this.setTableCellFocus(0);
    }

    protected void addHierarchyGrant(ActionEvent evt) {
        TreePath tpath = null;
        Object path = null;
        tpath = this.getTreePath(evt);
        int parentIndex = -1;
        if (tpath != null) {
            for (parentIndex = tpath.getPathCount() - 1; parentIndex >= 0; --parentIndex) {
                Object p = tpath.getPathComponent(parentIndex);
                if (!(p instanceof MondrianGuiDef.CubeGrant)) continue;
                path = p;
                break;
            }
        }
        if (!(path instanceof MondrianGuiDef.CubeGrant)) {
            JOptionPane.showMessageDialog(this, this.getResourceConverter().getString("schemaExplorer.cubeGrantNotSelected.alert", "Cube Grant not selected."), alert, 2);
            return;
        }
        MondrianGuiDef.CubeGrant cubeGrant = (MondrianGuiDef.CubeGrant)path;
        MondrianGuiDef.HierarchyGrant hieGrant = new MondrianGuiDef.HierarchyGrant();
        hieGrant.access = "";
        hieGrant.memberGrants = new MondrianGuiDef.MemberGrant[0];
        MondrianGuiDef.HierarchyGrant[] temp = cubeGrant.hierarchyGrants;
        cubeGrant.hierarchyGrants = new MondrianGuiDef.HierarchyGrant[temp.length + 1];
        for (int i = 0; i < temp.length; ++i) {
            cubeGrant.hierarchyGrants[i] = temp[i];
        }
        cubeGrant.hierarchyGrants[cubeGrant.hierarchyGrants.length - 1] = hieGrant;
        Object[] parentPathObjs = new Object[parentIndex + 1];
        for (int i = 0; i <= parentIndex; ++i) {
            parentPathObjs[i] = tpath.getPathComponent(i);
        }
        TreePath parentPath = new TreePath(parentPathObjs);
        this.tree.setSelectionPath(parentPath.pathByAddingChild(hieGrant));
        this.refreshTree(this.tree.getSelectionPath());
        this.setTableCellFocus(0);
    }

    protected void addMemberGrant(ActionEvent evt) {
        TreePath tpath = null;
        Object path = null;
        tpath = this.getTreePath(evt);
        int parentIndex = -1;
        if (tpath != null) {
            for (parentIndex = tpath.getPathCount() - 1; parentIndex >= 0; --parentIndex) {
                Object p = tpath.getPathComponent(parentIndex);
                if (!(p instanceof MondrianGuiDef.HierarchyGrant)) continue;
                path = p;
                break;
            }
        }
        if (!(path instanceof MondrianGuiDef.HierarchyGrant)) {
            JOptionPane.showMessageDialog(this, this.getResourceConverter().getString("schemaExplorer.hierarchyGrantNotSelected.alert", "Hierarchy Grant not selected."), alert, 2);
            return;
        }
        MondrianGuiDef.HierarchyGrant hieGrant = (MondrianGuiDef.HierarchyGrant)path;
        MondrianGuiDef.MemberGrant memberGrant = new MondrianGuiDef.MemberGrant();
        memberGrant.access = "";
        MondrianGuiDef.MemberGrant[] temp = hieGrant.memberGrants;
        hieGrant.memberGrants = new MondrianGuiDef.MemberGrant[temp.length + 1];
        for (int i = 0; i < temp.length; ++i) {
            hieGrant.memberGrants[i] = temp[i];
        }
        hieGrant.memberGrants[hieGrant.memberGrants.length - 1] = memberGrant;
        Object[] parentPathObjs = new Object[parentIndex + 1];
        for (int i = 0; i <= parentIndex; ++i) {
            parentPathObjs[i] = tpath.getPathComponent(i);
        }
        TreePath parentPath = new TreePath(parentPathObjs);
        this.tree.setSelectionPath(parentPath.pathByAddingChild((Object)memberGrant));
        this.refreshTree(this.tree.getSelectionPath());
        this.setTableCellFocus(0);
    }

    protected void addAnnotations(ActionEvent evt) {
        TreePath tpath = null;
        tpath = this.getTreePath(evt);
        Object path = this.tree.getSelectionPath().getLastPathComponent();
        if (!(path != null && (path instanceof MondrianGuiDef.Schema || path instanceof MondrianGuiDef.CubeDimension || path instanceof MondrianGuiDef.Cube || path instanceof MondrianGuiDef.VirtualCube || path instanceof MondrianGuiDef.VirtualCubeMeasure || path instanceof MondrianGuiDef.Hierarchy || path instanceof MondrianGuiDef.Level || path instanceof MondrianGuiDef.Measure || path instanceof MondrianGuiDef.CalculatedMember || path instanceof MondrianGuiDef.NamedSet || path instanceof MondrianGuiDef.Role))) {
            JOptionPane.showMessageDialog(this, this.getResourceConverter().getString("schemaExplorer.objectNotSelectedForAnnotations.alert", "Please select an object that supports annotations."), alert, 2);
            return;
        }
        MondrianGuiDef.Annotations annotations = new MondrianGuiDef.Annotations();
        annotations.array = new MondrianGuiDef.Annotation[0];
        Class<?> cls = path.getClass();
        try {
            Field field = cls.getField("annotations");
            field.set(path, (Object)annotations);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.tree.setSelectionPath(tpath.pathByAddingChild((Object)annotations));
        this.refreshTree(this.tree.getSelectionPath());
    }

    protected void addAnnotation(ActionEvent evt) {
        TreePath tpath = null;
        tpath = this.getTreePath(evt);
        Object path = this.tree.getSelectionPath().getLastPathComponent();
        if (!(path instanceof MondrianGuiDef.Annotations)) {
            JOptionPane.showMessageDialog(this, this.getResourceConverter().getString("schemaExplorer.annotationsNotSelected.alert", "Annotations not selected."), alert, 2);
            return;
        }
        MondrianGuiDef.Annotations annotations = (MondrianGuiDef.Annotations)((Object)path);
        MondrianGuiDef.Annotation annotation = new MondrianGuiDef.Annotation();
        annotation.name = this.getNewName(this.getResourceConverter().getString("schemaExplorer.newAnnotation.title", "New Annotation"), (Object[])annotations.array);
        MondrianGuiDef.Annotation[] temp = annotations.array;
        annotations.array = new MondrianGuiDef.Annotation[temp.length + 1];
        for (int i = 0; i < temp.length; ++i) {
            annotations.array[i] = temp[i];
        }
        annotations.array[annotations.array.length - 1] = annotation;
        this.tree.setSelectionPath(tpath.pathByAddingChild((Object)annotation));
        this.refreshTree(this.tree.getSelectionPath());
        this.setTableCellFocus(0);
    }

    protected void addLevel(ActionEvent evt) {
        TreePath tpath = null;
        Object path = null;
        tpath = this.getTreePath(evt);
        int parentIndex = -1;
        if (tpath != null) {
            for (parentIndex = tpath.getPathCount() - 1; parentIndex >= 0; --parentIndex) {
                Object p = tpath.getPathComponent(parentIndex);
                if (!(p instanceof MondrianGuiDef.Hierarchy)) continue;
                path = p;
                break;
            }
        }
        if (!(path instanceof MondrianGuiDef.Hierarchy)) {
            JOptionPane.showMessageDialog(this, this.getResourceConverter().getString("schemaExplorer.hierarchyNotSelected.alert", "Hierarchy not selected."), alert, 2);
            return;
        }
        MondrianGuiDef.Hierarchy hierarchy = (MondrianGuiDef.Hierarchy)((Object)path);
        MondrianGuiDef.Level level = new MondrianGuiDef.Level();
        level.uniqueMembers = false;
        level.visible = Boolean.TRUE;
        level.name = "";
        level.properties = new MondrianGuiDef.Property[0];
        level.name = this.getNewName(this.getResourceConverter().getString("schemaExplorer.newLevel.title", "New Level"), (Object[])hierarchy.levels);
        MondrianGuiDef.Level[] temp = hierarchy.levels;
        hierarchy.levels = new MondrianGuiDef.Level[temp.length + 1];
        for (int i = 0; i < temp.length; ++i) {
            hierarchy.levels[i] = temp[i];
        }
        hierarchy.levels[hierarchy.levels.length - 1] = level;
        Object[] parentPathObjs = new Object[parentIndex + 1];
        for (int i = 0; i <= parentIndex; ++i) {
            parentPathObjs[i] = tpath.getPathComponent(i);
        }
        TreePath parentPath = new TreePath(parentPathObjs);
        this.tree.setSelectionPath(parentPath.pathByAddingChild((Object)level));
        this.refreshTree(this.tree.getSelectionPath());
        this.setTableCellFocus(0);
    }

    protected void addSQL(ActionEvent evt) {
        int i;
        MondrianGuiDef.SQL[] temp;
        TreePath tpath = null;
        Object path = null;
        tpath = this.getTreePath(evt);
        int parentIndex = -1;
        if (tpath != null) {
            for (parentIndex = tpath.getPathCount() - 1; parentIndex >= 0; --parentIndex) {
                Object p = tpath.getPathComponent(parentIndex);
                if (!(p instanceof MondrianGuiDef.ExpressionView) && !(p instanceof MondrianGuiDef.View)) continue;
                path = p;
                break;
            }
        }
        if (path == null) {
            JOptionPane.showMessageDialog(this, this.getResourceConverter().getString("schemaExplorer.sqlExpressionNotSelected.alert", "Expression or View for SQL not selected."), alert, 2);
            return;
        }
        MondrianGuiDef.SQL sql = new MondrianGuiDef.SQL();
        sql.dialect = "generic";
        if (path instanceof MondrianGuiDef.ExpressionView) {
            MondrianGuiDef.ExpressionView expview = (MondrianGuiDef.ExpressionView)path;
            temp = expview.expressions;
            expview.expressions = new MondrianGuiDef.SQL[temp.length + 1];
            for (i = 0; i < temp.length; ++i) {
                expview.expressions[i] = temp[i];
            }
            expview.expressions[expview.expressions.length - 1] = sql;
        } else {
            MondrianGuiDef.View view = (MondrianGuiDef.View)((Object)path);
            temp = view.selects;
            view.selects = new MondrianGuiDef.SQL[temp.length + 1];
            for (i = 0; i < temp.length; ++i) {
                view.selects[i] = temp[i];
            }
            view.selects[view.selects.length - 1] = sql;
        }
        Object[] parentPathObjs = new Object[parentIndex + 1];
        for (int i2 = 0; i2 <= parentIndex; ++i2) {
            parentPathObjs[i2] = tpath.getPathComponent(i2);
        }
        TreePath parentPath = new TreePath(parentPathObjs);
        this.tree.setSelectionPath(parentPath.pathByAddingChild((Object)sql));
        this.refreshTree(this.tree.getSelectionPath());
        this.setTableCellFocus(0);
    }

    protected void addScript(ActionEvent evt) {
        ElementDef parent;
        TreePath tpath = null;
        Object path = null;
        tpath = this.getTreePath(evt);
        int parentIndex = -1;
        if (tpath != null) {
            for (parentIndex = tpath.getPathCount() - 1; parentIndex >= 0; --parentIndex) {
                Object p = tpath.getPathComponent(parentIndex);
                if (!(p instanceof MondrianGuiDef.UserDefinedFunction) && !(p instanceof MondrianGuiDef.MemberFormatter) && !(p instanceof MondrianGuiDef.CellFormatter) && !(p instanceof MondrianGuiDef.PropertyFormatter)) continue;
                path = p;
                break;
            }
        }
        if (path == null) {
            JOptionPane.showMessageDialog(this, this.getResourceConverter().getString("schemaExplorer.userDefinedFunctionOrFormatterNotSelected.alert", "User Defined Function or Formatter not selected."), alert, 2);
            return;
        }
        MondrianGuiDef.Script script = new MondrianGuiDef.Script();
        if (path instanceof MondrianGuiDef.UserDefinedFunction) {
            parent = (MondrianGuiDef.UserDefinedFunction)((Object)path);
            parent.script = script;
        } else if (path instanceof MondrianGuiDef.CellFormatter) {
            parent = (MondrianGuiDef.CellFormatter)((Object)path);
            parent.script = script;
        } else if (path instanceof MondrianGuiDef.MemberFormatter) {
            parent = (MondrianGuiDef.MemberFormatter)((Object)path);
            parent.script = script;
        } else if (path instanceof MondrianGuiDef.PropertyFormatter) {
            parent = (MondrianGuiDef.PropertyFormatter)((Object)path);
            parent.script = script;
        }
        Object[] parentPathObjs = new Object[parentIndex + 1];
        for (int i = 0; i <= parentIndex; ++i) {
            parentPathObjs[i] = tpath.getPathComponent(i);
        }
        TreePath parentPath = new TreePath(parentPathObjs);
        this.tree.setSelectionPath(parentPath.pathByAddingChild((Object)script));
        this.refreshTree(this.tree.getSelectionPath());
        this.setTableCellFocus(0);
    }

    protected void addCellFormatter(ActionEvent evt) {
        ElementDef parent;
        TreePath tpath = null;
        Object path = null;
        tpath = this.getTreePath(evt);
        int parentIndex = -1;
        if (tpath != null) {
            for (parentIndex = tpath.getPathCount() - 1; parentIndex >= 0; --parentIndex) {
                Object p = tpath.getPathComponent(parentIndex);
                if (!(p instanceof MondrianGuiDef.Measure) && !(p instanceof MondrianGuiDef.CalculatedMember)) continue;
                path = p;
                break;
            }
        }
        if (path == null) {
            JOptionPane.showMessageDialog(this, this.getResourceConverter().getString("schemaExplorer.measureOrCalculatedMemberNotSelected.alert", "Measure or Calculated Member not selected."), alert, 2);
            return;
        }
        MondrianGuiDef.CellFormatter formatter = new MondrianGuiDef.CellFormatter();
        if (path instanceof MondrianGuiDef.Measure) {
            parent = (MondrianGuiDef.Measure)((Object)path);
            parent.cellFormatter = formatter;
        } else if (path instanceof MondrianGuiDef.CalculatedMember) {
            parent = (MondrianGuiDef.CalculatedMember)((Object)path);
            parent.cellFormatter = formatter;
        }
        Object[] parentPathObjs = new Object[parentIndex + 1];
        for (int i = 0; i <= parentIndex; ++i) {
            parentPathObjs[i] = tpath.getPathComponent(i);
        }
        TreePath parentPath = new TreePath(parentPathObjs);
        this.tree.setSelectionPath(parentPath.pathByAddingChild((Object)formatter));
        this.refreshTree(this.tree.getSelectionPath());
        this.setTableCellFocus(0);
    }

    protected LevelInfo getSelectedLevel(ActionEvent evt) {
        LevelInfo info = new LevelInfo();
        TreePath tpath = null;
        Object path = null;
        tpath = this.getTreePath(evt);
        int parentIndex = -1;
        if (tpath != null) {
            for (parentIndex = tpath.getPathCount() - 1; parentIndex >= 0; --parentIndex) {
                Object p = tpath.getPathComponent(parentIndex);
                if (!(p instanceof MondrianGuiDef.Level)) continue;
                path = p;
                break;
            }
        }
        if (path == null || !(path instanceof MondrianGuiDef.Level)) {
            JOptionPane.showMessageDialog(this, this.getResourceConverter().getString("schemaExplorer.levelNotSelected.alert", "Level not selected."), alert, 2);
            return null;
        }
        info.level = (MondrianGuiDef.Level)((Object)path);
        info.parentPathObjs = new Object[parentIndex + 1];
        for (int i = 0; i <= parentIndex; ++i) {
            info.parentPathObjs[i] = tpath.getPathComponent(i);
        }
        return info;
    }

    protected void addMemberFormatter(ActionEvent evt) {
        MondrianGuiDef.MemberFormatter formatter;
        LevelInfo info = this.getSelectedLevel(evt);
        if (info == null) {
            return;
        }
        info.level.memberFormatter = formatter = new MondrianGuiDef.MemberFormatter();
        TreePath parentPath = new TreePath(info.parentPathObjs);
        this.tree.setSelectionPath(parentPath.pathByAddingChild((Object)formatter));
        this.refreshTree(this.tree.getSelectionPath());
        this.setTableCellFocus(0);
    }

    protected void addPropertyFormatter(ActionEvent evt) {
        TreePath tpath = null;
        Object path = null;
        tpath = this.getTreePath(evt);
        int parentIndex = -1;
        if (tpath != null) {
            for (parentIndex = tpath.getPathCount() - 1; parentIndex >= 0; --parentIndex) {
                Object p = tpath.getPathComponent(parentIndex);
                if (!(p instanceof MondrianGuiDef.Property)) continue;
                path = p;
                break;
            }
        }
        if (path == null) {
            JOptionPane.showMessageDialog(this, this.getResourceConverter().getString("schemaExplorer.propertyNotSelected.alert", "Property not selected."), alert, 2);
            return;
        }
        MondrianGuiDef.PropertyFormatter formatter = new MondrianGuiDef.PropertyFormatter();
        MondrianGuiDef.Property parent = (MondrianGuiDef.Property)((Object)path);
        parent.propertyFormatter = formatter;
        Object[] parentPathObjs = new Object[parentIndex + 1];
        for (int i = 0; i <= parentIndex; ++i) {
            parentPathObjs[i] = tpath.getPathComponent(i);
        }
        TreePath parentPath = new TreePath(parentPathObjs);
        this.tree.setSelectionPath(parentPath.pathByAddingChild((Object)formatter));
        this.refreshTree(this.tree.getSelectionPath());
        this.setTableCellFocus(0);
    }

    protected void addKeyExp(ActionEvent evt) {
        LevelInfo info = this.getSelectedLevel(evt);
        if (info == null) {
            return;
        }
        MondrianGuiDef.KeyExpression keyExp = new MondrianGuiDef.KeyExpression();
        keyExp.expressions = new MondrianGuiDef.SQL[1];
        keyExp.expressions[0] = new MondrianGuiDef.SQL();
        keyExp.expressions[0].dialect = "generic";
        keyExp.expressions[0].cdata = "";
        info.level.keyExp = keyExp;
        TreePath parentPath = new TreePath(info.parentPathObjs);
        this.tree.setSelectionPath(parentPath.pathByAddingChild(keyExp));
        this.refreshTree(this.tree.getSelectionPath());
    }

    protected void addNameExp(ActionEvent evt) {
        LevelInfo info = this.getSelectedLevel(evt);
        if (info == null) {
            return;
        }
        MondrianGuiDef.NameExpression nameExp = new MondrianGuiDef.NameExpression();
        nameExp.expressions = new MondrianGuiDef.SQL[1];
        nameExp.expressions[0] = new MondrianGuiDef.SQL();
        nameExp.expressions[0].dialect = "generic";
        nameExp.expressions[0].cdata = "";
        info.level.nameExp = nameExp;
        TreePath parentPath = new TreePath(info.parentPathObjs);
        this.tree.setSelectionPath(parentPath.pathByAddingChild(nameExp));
        this.refreshTree(this.tree.getSelectionPath());
    }

    protected void addOrdinalExp(ActionEvent evt) {
        LevelInfo info = this.getSelectedLevel(evt);
        if (info == null) {
            return;
        }
        MondrianGuiDef.OrdinalExpression ordinalExp = new MondrianGuiDef.OrdinalExpression();
        ordinalExp.expressions = new MondrianGuiDef.SQL[1];
        ordinalExp.expressions[0] = new MondrianGuiDef.SQL();
        ordinalExp.expressions[0].dialect = "generic";
        ordinalExp.expressions[0].cdata = "";
        info.level.ordinalExp = ordinalExp;
        TreePath parentPath = new TreePath(info.parentPathObjs);
        this.tree.setSelectionPath(parentPath.pathByAddingChild(ordinalExp));
        this.refreshTree(this.tree.getSelectionPath());
    }

    protected void addCaptionExp(ActionEvent evt) {
        LevelInfo info = this.getSelectedLevel(evt);
        if (info == null) {
            return;
        }
        MondrianGuiDef.CaptionExpression captionExp = new MondrianGuiDef.CaptionExpression();
        captionExp.expressions = new MondrianGuiDef.SQL[1];
        captionExp.expressions[0] = new MondrianGuiDef.SQL();
        captionExp.expressions[0].dialect = "generic";
        captionExp.expressions[0].cdata = "";
        info.level.captionExp = captionExp;
        TreePath parentPath = new TreePath(info.parentPathObjs);
        this.tree.setSelectionPath(parentPath.pathByAddingChild(captionExp));
        this.refreshTree(this.tree.getSelectionPath());
    }

    protected void addParentExp(ActionEvent evt) {
        LevelInfo info = this.getSelectedLevel(evt);
        if (info == null) {
            return;
        }
        MondrianGuiDef.ParentExpression parentExp = new MondrianGuiDef.ParentExpression();
        parentExp.expressions = new MondrianGuiDef.SQL[1];
        parentExp.expressions[0] = new MondrianGuiDef.SQL();
        parentExp.expressions[0].dialect = "generic";
        parentExp.expressions[0].cdata = "";
        info.level.parentExp = parentExp;
        TreePath parentPath = new TreePath(info.parentPathObjs);
        this.tree.setSelectionPath(parentPath.pathByAddingChild(parentExp));
        this.refreshTree(this.tree.getSelectionPath());
    }

    protected void addMeasureExp(ActionEvent evt) {
        TreePath tpath = null;
        Object path = null;
        tpath = this.getTreePath(evt);
        int parentIndex = -1;
        if (tpath != null) {
            for (parentIndex = tpath.getPathCount() - 1; parentIndex >= 0; --parentIndex) {
                Object p = tpath.getPathComponent(parentIndex);
                if (!(p instanceof MondrianGuiDef.Measure)) continue;
                path = p;
                break;
            }
        }
        if (!(path instanceof MondrianGuiDef.Measure)) {
            JOptionPane.showMessageDialog(this, this.getResourceConverter().getString("schemaExplorer.measureNotSelected.alert", "Measure not selected."), alert, 2);
            return;
        }
        MondrianGuiDef.Measure measure = (MondrianGuiDef.Measure)((Object)path);
        MondrianGuiDef.MeasureExpression measureExp = new MondrianGuiDef.MeasureExpression();
        measureExp.expressions = new MondrianGuiDef.SQL[1];
        measureExp.expressions[0] = new MondrianGuiDef.SQL();
        measureExp.expressions[0].dialect = "generic";
        measureExp.expressions[0].cdata = "";
        measure.measureExp = measureExp;
        Object[] parentPathObjs = new Object[parentIndex + 1];
        for (int i = 0; i <= parentIndex; ++i) {
            parentPathObjs[i] = tpath.getPathComponent(i);
        }
        TreePath parentPath = new TreePath(parentPathObjs);
        this.tree.setSelectionPath(parentPath.pathByAddingChild(measureExp));
        this.refreshTree(this.tree.getSelectionPath());
    }

    protected void addFormula(ActionEvent evt) {
        ElementDef ns;
        TreePath tpath = null;
        Object path = null;
        tpath = this.getTreePath(evt);
        int parentIndex = -1;
        if (tpath != null) {
            for (parentIndex = tpath.getPathCount() - 1; parentIndex >= 0; --parentIndex) {
                Object p = tpath.getPathComponent(parentIndex);
                if (!(p instanceof MondrianGuiDef.NamedSet) && !(p instanceof MondrianGuiDef.CalculatedMember)) continue;
                path = p;
                break;
            }
        }
        if (!(path instanceof MondrianGuiDef.NamedSet) && !(path instanceof MondrianGuiDef.CalculatedMember)) {
            JOptionPane.showMessageDialog(this, this.getResourceConverter().getString("schemaExplorer.namedsetOrCalcMemberNotSelected.alert", "Named Set or Calculated Member not selected."), alert, 2);
            return;
        }
        MondrianGuiDef.Formula formulaElement = new MondrianGuiDef.Formula();
        formulaElement.cdata = "";
        if (path instanceof MondrianGuiDef.NamedSet) {
            ns = (MondrianGuiDef.NamedSet)((Object)path);
            ns.formulaElement = formulaElement;
        } else if (path instanceof MondrianGuiDef.CalculatedMember) {
            ns = (MondrianGuiDef.CalculatedMember)((Object)path);
            ns.formulaElement = formulaElement;
        }
        Object[] parentPathObjs = new Object[parentIndex + 1];
        for (int i = 0; i <= parentIndex; ++i) {
            parentPathObjs[i] = tpath.getPathComponent(i);
        }
        TreePath parentPath = new TreePath(parentPathObjs);
        this.tree.setSelectionPath(parentPath.pathByAddingChild((Object)formulaElement));
        this.refreshTree(this.tree.getSelectionPath());
    }

    protected void addTable(ActionEvent evt) {
        MondrianGuiDef.Table relation = new MondrianGuiDef.Table("", LBL_TABLE, "", null);
        this.addRelation(evt, relation);
    }

    protected void addJoin(ActionEvent evt) {
        MondrianGuiDef.Join relation = new MondrianGuiDef.Join("", "", new MondrianGuiDef.Table("", "Table 1", "", null), "", "", new MondrianGuiDef.Table("", "Table 2", "", null));
        this.addRelation(evt, relation);
    }

    protected void addView(ActionEvent evt) {
        MondrianGuiDef.View view = new MondrianGuiDef.View();
        view.alias = "";
        view.selects = new MondrianGuiDef.SQL[1];
        view.selects[0] = new MondrianGuiDef.SQL();
        view.selects[0].dialect = "generic";
        view.selects[0].cdata = "";
        this.addRelation(evt, view);
    }

    protected void addInlineTable(ActionEvent evt) {
        MondrianGuiDef.InlineTable inlineTable = new MondrianGuiDef.InlineTable();
        inlineTable.alias = "";
        inlineTable.columnDefs = new MondrianGuiDef.ColumnDefs();
        inlineTable.rows = new MondrianGuiDef.Rows();
        this.addRelation(evt, inlineTable);
    }

    protected void addRelation(ActionEvent evt, MondrianGuiDef.RelationOrJoin relation) {
        TreePath tpath = null;
        Object path = null;
        tpath = this.getTreePath(evt);
        int parentIndex = -1;
        if (tpath != null) {
            for (parentIndex = tpath.getPathCount() - 1; parentIndex >= 0; --parentIndex) {
                Object p = tpath.getPathComponent(parentIndex);
                if (!(p instanceof MondrianGuiDef.Hierarchy) && !(p instanceof MondrianGuiDef.Cube)) continue;
                path = p;
                break;
            }
        }
        if (path instanceof MondrianGuiDef.Hierarchy) {
            MondrianGuiDef.Hierarchy h = (MondrianGuiDef.Hierarchy)((Object)path);
            h.relation = relation;
        } else if (path instanceof MondrianGuiDef.Cube) {
            if (!(relation instanceof MondrianGuiDef.Relation)) {
                JOptionPane.showMessageDialog(this, this.getResourceConverter().getString("schemaExplorer.relationOrJoinNotRelation.alert", "Can't add a Join."), alert, 2);
                return;
            }
            MondrianGuiDef.Cube cube = (MondrianGuiDef.Cube)((Object)path);
            cube.fact = (MondrianGuiDef.Relation)relation;
        } else {
            JOptionPane.showMessageDialog(this, this.getResourceConverter().getString("schemaExplorer.hierarchyOrCubeNotSelected.alert", "Hierarchy or Cube not selected."), alert, 2);
            return;
        }
        Object[] parentPathObjs = new Object[parentIndex + 1];
        for (int i = 0; i <= parentIndex; ++i) {
            parentPathObjs[i] = tpath.getPathComponent(i);
        }
        TreePath parentPath = new TreePath(parentPathObjs);
        this.tree.setSelectionPath(parentPath.pathByAddingChild((Object)relation));
        this.refreshTree(this.tree.getSelectionPath());
        this.setTableCellFocus(0);
    }

    protected void addHierarchy(ActionEvent evt) {
        TreePath tpath = null;
        Object path = null;
        tpath = this.getTreePath(evt);
        int parentIndex = -1;
        if (tpath != null) {
            for (parentIndex = tpath.getPathCount() - 1; parentIndex >= 0; --parentIndex) {
                Object p = tpath.getPathComponent(parentIndex);
                if (!(p instanceof MondrianGuiDef.Dimension)) continue;
                path = p;
                break;
            }
        }
        if (!(path instanceof MondrianGuiDef.Dimension)) {
            JOptionPane.showMessageDialog(this, this.getResourceConverter().getString("schemaExplorer.dimensionNotSelected.alert", "Dimension not selected."), alert, 2);
            return;
        }
        MondrianGuiDef.Dimension dimension = (MondrianGuiDef.Dimension)((Object)path);
        MondrianGuiDef.Hierarchy hierarchy = new MondrianGuiDef.Hierarchy();
        hierarchy.name = "";
        hierarchy.hasAll = Boolean.TRUE;
        hierarchy.visible = Boolean.TRUE;
        hierarchy.levels = new MondrianGuiDef.Level[0];
        hierarchy.memberReaderParameters = new MondrianGuiDef.MemberReaderParameter[0];
        hierarchy.name = this.getNewName(this.getResourceConverter().getString("schemaExplorer.newHierarchy.title", "New Hierarchy"), (Object[])dimension.hierarchies);
        MondrianGuiDef.Hierarchy[] temp = dimension.hierarchies;
        dimension.hierarchies = new MondrianGuiDef.Hierarchy[temp.length + 1];
        for (int i = 0; i < temp.length; ++i) {
            dimension.hierarchies[i] = temp[i];
        }
        dimension.hierarchies[dimension.hierarchies.length - 1] = hierarchy;
        Object[] parentPathObjs = new Object[parentIndex + 1];
        for (int i = 0; i <= parentIndex; ++i) {
            parentPathObjs[i] = tpath.getPathComponent(i);
        }
        TreePath parentPath = new TreePath(parentPathObjs);
        this.tree.setSelectionPath(parentPath.pathByAddingChild((Object)hierarchy));
        this.refreshTree(this.tree.getSelectionPath());
        this.setTableCellFocus(0);
    }

    protected void moveLevelUp(ActionEvent evt) {
        LevelInfo info = this.getSelectedLevel(evt);
        if (info == null) {
            return;
        }
        MondrianGuiDef.Hierarchy hierarchy = (MondrianGuiDef.Hierarchy)((Object)info.parentPathObjs[info.parentPathObjs.length - 2]);
        int loc = -1;
        for (int i = 0; i < hierarchy.levels.length; ++i) {
            if (hierarchy.levels[i] != info.level) continue;
            loc = i;
            break;
        }
        if (loc > 0) {
            MondrianGuiDef.Level tmp = hierarchy.levels[loc - 1];
            hierarchy.levels[loc - 1] = info.level;
            hierarchy.levels[loc] = tmp;
        }
        TreePath parentPath = new TreePath(info.parentPathObjs);
        this.tree.setSelectionPath(parentPath);
        this.refreshTree(this.tree.getSelectionPath());
        this.setTableCellFocus(0);
    }

    protected void moveLevelDown(ActionEvent evt) {
        LevelInfo info = this.getSelectedLevel(evt);
        if (info == null) {
            return;
        }
        MondrianGuiDef.Hierarchy hierarchy = (MondrianGuiDef.Hierarchy)((Object)info.parentPathObjs[info.parentPathObjs.length - 2]);
        int loc = -1;
        for (int i = 0; i < hierarchy.levels.length; ++i) {
            if (hierarchy.levels[i] != info.level) continue;
            loc = i;
            break;
        }
        if (loc < hierarchy.levels.length - 1) {
            MondrianGuiDef.Level tmp = hierarchy.levels[loc + 1];
            hierarchy.levels[loc + 1] = info.level;
            hierarchy.levels[loc] = tmp;
        }
        TreePath parentPath = new TreePath(info.parentPathObjs);
        this.tree.setSelectionPath(parentPath);
        this.refreshTree(this.tree.getSelectionPath());
        this.setTableCellFocus(0);
    }

    protected void addProperty(ActionEvent evt) {
        LevelInfo info = this.getSelectedLevel(evt);
        if (info == null) {
            return;
        }
        MondrianGuiDef.Property property = new MondrianGuiDef.Property();
        property.name = "";
        if (info.level.properties == null) {
            info.level.properties = new MondrianGuiDef.Property[0];
        }
        property.name = this.getNewName(this.getResourceConverter().getString("schemaExplorer.newProperty.title", "New Property"), (Object[])info.level.properties);
        MondrianGuiDef.Property[] temp = info.level.properties;
        info.level.properties = new MondrianGuiDef.Property[temp.length + 1];
        for (int i = 0; i < temp.length; ++i) {
            info.level.properties[i] = temp[i];
        }
        info.level.properties[info.level.properties.length - 1] = property;
        TreePath parentPath = new TreePath(info.parentPathObjs);
        this.tree.setSelectionPath(parentPath.pathByAddingChild((Object)property));
        this.refreshTree(this.tree.getSelectionPath());
        this.setTableCellFocus(0);
    }

    protected void addCalculatedMemberProperty(ActionEvent evt) {
        TreePath tpath = null;
        Object path = null;
        tpath = this.getTreePath(evt);
        int parentIndex = -1;
        if (tpath != null) {
            for (parentIndex = tpath.getPathCount() - 1; parentIndex >= 0; --parentIndex) {
                Object p = tpath.getPathComponent(parentIndex);
                if (!(p instanceof MondrianGuiDef.CalculatedMember) && !(p instanceof MondrianGuiDef.Measure)) continue;
                path = p;
                break;
            }
        }
        if (path instanceof MondrianGuiDef.CalculatedMember) {
            this.addCalcMemberPropToCalcMember((MondrianGuiDef.CalculatedMember)((Object)path), parentIndex, tpath);
        } else if (path instanceof MondrianGuiDef.Measure) {
            this.addCalcMemberPropToMeasure((MondrianGuiDef.Measure)((Object)path), parentIndex, tpath);
        } else {
            JOptionPane.showMessageDialog(this, this.getResourceConverter().getString("schemaExplorer.calculatedMemberNotSelected.alert", "Calculated Member or Measure not selected."), alert, 2);
        }
    }

    protected void addCalcMemberPropToCalcMember(MondrianGuiDef.CalculatedMember calcMember, int parentIndex, TreePath tpath) {
        MondrianGuiDef.CalculatedMemberProperty property = new MondrianGuiDef.CalculatedMemberProperty();
        property.name = "";
        if (calcMember.memberProperties == null) {
            calcMember.memberProperties = new MondrianGuiDef.CalculatedMemberProperty[0];
        }
        property.name = this.getNewName(this.getResourceConverter().getString("schemaExplorer.newProperty.title", "New Property"), (Object[])calcMember.memberProperties);
        MondrianGuiDef.CalculatedMemberProperty[] temp = calcMember.memberProperties;
        calcMember.memberProperties = new MondrianGuiDef.CalculatedMemberProperty[temp.length + 1];
        for (int i = 0; i < temp.length; ++i) {
            calcMember.memberProperties[i] = temp[i];
        }
        calcMember.memberProperties[calcMember.memberProperties.length - 1] = property;
        Object[] parentPathObjs = new Object[parentIndex + 1];
        for (int i = 0; i <= parentIndex; ++i) {
            parentPathObjs[i] = tpath.getPathComponent(i);
        }
        TreePath parentPath = new TreePath(parentPathObjs);
        this.tree.setSelectionPath(parentPath.pathByAddingChild((Object)property));
        this.refreshTree(this.tree.getSelectionPath());
        this.setTableCellFocus(0);
    }

    protected void addCalcMemberPropToMeasure(MondrianGuiDef.Measure measure, int parentIndex, TreePath tpath) {
        MondrianGuiDef.CalculatedMemberProperty property = new MondrianGuiDef.CalculatedMemberProperty();
        property.name = "";
        if (measure.memberProperties == null) {
            measure.memberProperties = new MondrianGuiDef.CalculatedMemberProperty[0];
        }
        property.name = this.getNewName(this.getResourceConverter().getString("schemaExplorer.newProperty.title", "New Property"), (Object[])measure.memberProperties);
        MondrianGuiDef.CalculatedMemberProperty[] temp = measure.memberProperties;
        measure.memberProperties = new MondrianGuiDef.CalculatedMemberProperty[temp.length + 1];
        for (int i = 0; i < temp.length; ++i) {
            measure.memberProperties[i] = temp[i];
        }
        measure.memberProperties[measure.memberProperties.length - 1] = property;
        Object[] parentPathObjs = new Object[parentIndex + 1];
        for (int i = 0; i <= parentIndex; ++i) {
            parentPathObjs[i] = tpath.getPathComponent(i);
        }
        TreePath parentPath = new TreePath(parentPathObjs);
        this.tree.setSelectionPath(parentPath.pathByAddingChild((Object)property));
        this.refreshTree(this.tree.getSelectionPath());
        this.setTableCellFocus(0);
    }

    protected void addClosure(ActionEvent evt) {
        TreePath tpath = null;
        Object path = null;
        tpath = this.getTreePath(evt);
        int parentIndex = -1;
        if (tpath != null) {
            for (parentIndex = tpath.getPathCount() - 1; parentIndex >= 0; --parentIndex) {
                Object p = tpath.getPathComponent(parentIndex);
                if (!(p instanceof MondrianGuiDef.Level)) continue;
                path = p;
                break;
            }
        }
        if (!(path instanceof MondrianGuiDef.Level)) {
            JOptionPane.showMessageDialog(this, this.getResourceConverter().getString("schemaExplorer.levelNotSelected.alert", "Level not selected."), alert, 2);
            return;
        }
        MondrianGuiDef.Level level = (MondrianGuiDef.Level)((Object)path);
        MondrianGuiDef.Closure closure = new MondrianGuiDef.Closure();
        closure.parentColumn = "";
        closure.childColumn = "";
        closure.table = new MondrianGuiDef.Table("", LBL_TABLE, "", null);
        if (level.closure == null) {
            level.closure = closure;
        }
        Object[] parentPathObjs = new Object[parentIndex + 1];
        for (int i = 0; i <= parentIndex; ++i) {
            parentPathObjs[i] = tpath.getPathComponent(i);
        }
        TreePath parentPath = new TreePath(parentPathObjs);
        this.tree.setSelectionPath(parentPath.pathByAddingChild((Object)closure));
        this.refreshTree(this.tree.getSelectionPath());
        this.setTableCellFocus(0);
    }

    public MondrianGuiDef.Schema getSchema() {
        return this.schema;
    }

    public File getSchemaFile() {
        return this.schemaFile;
    }

    public void setSchemaFile(File f) {
        this.schemaFile = f;
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        SchemaPropertyCellEditor sce;
        if (this.propertyTable.isEditing() && this.lastSelected != e.getPath().getLastPathComponent() && (sce = (SchemaPropertyCellEditor)this.propertyTable.getCellEditor()) != null) {
            TreeSelectionEvent e2 = e;
            sce.stopCellEditing();
            e = e2;
        }
        this.lastSelected = e.getPath().getLastPathComponent();
        String selectedFactTable = null;
        String selectedFactTableSchema = null;
        for (int i = e.getPath().getPathCount() - 1; i >= 0; --i) {
            Object comp = e.getPath().getPathComponent(i);
            if (!(comp instanceof MondrianGuiDef.Cube)) continue;
            MondrianGuiDef.Cube cube = (MondrianGuiDef.Cube)((Object)comp);
            if (!(cube.fact instanceof MondrianGuiDef.Table)) continue;
            MondrianGuiDef.Table table = (MondrianGuiDef.Table)cube.fact;
            selectedFactTable = table.name;
            selectedFactTableSchema = table.schema;
        }
        TreePath tpath = e.getPath();
        Object o = tpath.getLastPathComponent();
        Object po = null;
        TreePath parentTpath = tpath.getParentPath();
        String parentName = "";
        String elementName = "";
        if (parentTpath != null) {
            po = parentTpath.getLastPathComponent();
            Class<?> parentClassName = po.getClass();
            try {
                Field nameField = po.getClass().getField("name");
                elementName = (String)nameField.get(po);
                elementName = elementName == null ? "" : "'" + elementName + "'";
            }
            catch (Exception ex) {
                elementName = "";
            }
            int pos = parentClassName.toString().lastIndexOf("$");
            if (pos > 0) {
                parentName = parentClassName.toString().substring(pos + 1);
            }
        }
        StringWriter sxml = new StringWriter();
        XMLOutput pxml = new XMLOutput((Writer)sxml);
        pxml.setIndentString("    ");
        pxml.setAlwaysQuoteCData(true);
        String[] pNames = DEF_DEFAULT;
        this.validStatusLabel.setText(this.renderer.invalid(this.tree, e.getPath(), o));
        this.validStatusLabel2.setText(this.validStatusLabel.getText());
        if (o instanceof MondrianGuiDef.Column) {
            pNames = DEF_COLUMN;
            this.targetLabel.setText(this.getResourceConverter().getString("common.column.title", LBL_COLUMN));
        } else if (o instanceof MondrianGuiDef.Cube) {
            pNames = DEF_CUBE;
            this.targetLabel.setText(this.getResourceConverter().getString("common.cube.title", LBL_CUBE));
            ((MondrianGuiDef.Cube)((Object)o)).displayXML(pxml, 0);
        } else if (o instanceof MondrianGuiDef.Dimension) {
            pNames = DEF_DIMENSION;
            if (po instanceof MondrianGuiDef.Schema) {
                this.targetLabel.setText(this.getResourceConverter().getString("common.sharedDimension.title", "Shared Dimension"));
            } else {
                this.targetLabel.setText(this.getResourceConverter().getFormattedString("schemaExplorer.dimensionElementParent.title", "Dimension for {0} {1}", elementName, parentName));
            }
            ((MondrianGuiDef.Dimension)((Object)o)).displayXML(pxml, 0);
        } else if (o instanceof MondrianGuiDef.DimensionUsage) {
            pNames = DEF_DIMENSION_USAGE;
            this.targetLabel.setText(this.getResourceConverter().getFormattedString("schemaExplorer.dimensionUsageForElement.title", "Dimension Usage for {0} {1}", elementName, parentName));
            ((MondrianGuiDef.DimensionUsage)((Object)o)).displayXML(pxml, 0);
        } else if (o instanceof MondrianGuiDef.KeyExpression) {
            pNames = DEF_DEFAULT;
            this.targetLabel.setText(this.getResourceConverter().getString("common.keyExpression.title", LBL_KEY_EXPRESSION));
            ((MondrianGuiDef.ExpressionView)o).displayXML(pxml, 0);
        } else if (o instanceof MondrianGuiDef.NameExpression) {
            pNames = DEF_DEFAULT;
            this.targetLabel.setText(this.getResourceConverter().getString("common.nameExpression.title", LBL_NAME_EXPRESSION));
            ((MondrianGuiDef.ExpressionView)o).displayXML(pxml, 0);
        } else if (o instanceof MondrianGuiDef.OrdinalExpression) {
            pNames = DEF_DEFAULT;
            this.targetLabel.setText(this.getResourceConverter().getString("common.ordinalExpression.title", LBL_ORDINAL_EXPRESSION));
            ((MondrianGuiDef.ExpressionView)o).displayXML(pxml, 0);
        } else if (o instanceof MondrianGuiDef.ParentExpression) {
            pNames = DEF_DEFAULT;
            this.targetLabel.setText(this.getResourceConverter().getString("common.parentExpression.title", LBL_PARENT_EXPRESSION));
            ((MondrianGuiDef.ExpressionView)o).displayXML(pxml, 0);
        } else if (o instanceof MondrianGuiDef.ExpressionView) {
            pNames = DEF_EXPRESSION_VIEW;
            this.targetLabel.setText(this.getResourceConverter().getString("common.expressionView.title", LBL_EXPRESSION_VIEW));
            ((MondrianGuiDef.ExpressionView)o).displayXML(pxml, 0);
        } else if (o instanceof MondrianGuiDef.MeasureExpression) {
            pNames = DEF_DEFAULT;
            this.targetLabel.setText(this.getResourceConverter().getString("common.measureExpression.title", LBL_MEASURE_EXPRESSION));
            ((MondrianGuiDef.ExpressionView)o).displayXML(pxml, 0);
        } else if (o instanceof MondrianGuiDef.Hierarchy) {
            pNames = DEF_HIERARCHY;
            this.targetLabel.setText(this.getResourceConverter().getFormattedString("schemaExplorer.hierarchyElementParent.title", "Hierarchy for {0} {1}", elementName, parentName));
            ((MondrianGuiDef.Hierarchy)((Object)o)).displayXML(pxml, 0);
        } else if (o instanceof MondrianGuiDef.Join) {
            pNames = DEF_JOIN;
            if (parentName.equalsIgnoreCase(LBL_JOIN)) {
                Object parentJoin = parentTpath.getLastPathComponent();
                int indexOfChild = this.tree.getModel().getIndexOfChild(parentJoin, o);
                switch (indexOfChild) {
                    case 0: {
                        this.targetLabel.setText(this.getResourceConverter().getString("common.leftJoin.title", "Left : Join"));
                        break;
                    }
                    case 1: {
                        this.targetLabel.setText(this.getResourceConverter().getString("common.rightJoin.title", "Right : Join"));
                    }
                }
            } else {
                this.targetLabel.setText(this.getResourceConverter().getFormattedString("schemaExplorer.generalJoinForElement.title", "Join for {0} {1}", elementName, parentName));
            }
            ((MondrianGuiDef.Join)((Object)o)).displayXML(pxml, 0);
        } else if (o instanceof MondrianGuiDef.Level) {
            pNames = DEF_LEVEL;
            this.targetLabel.setText(this.getResourceConverter().getFormattedString("schemaExplorer.levelForElement.title", "Level for {0} {1}", elementName, parentName));
            ((MondrianGuiDef.Level)((Object)o)).displayXML(pxml, 0);
        } else if (o instanceof MondrianGuiDef.Measure) {
            pNames = DEF_MEASURE;
            this.targetLabel.setText(this.getResourceConverter().getFormattedString("schemaExplorer.measureForElement.title", "Measure for {0} {1}", elementName, parentName));
            ((MondrianGuiDef.Measure)((Object)o)).displayXML(pxml, 0);
        } else if (o instanceof MondrianGuiDef.CalculatedMember) {
            pNames = DEF_CALCULATED_MEMBER;
            this.targetLabel.setText(this.getResourceConverter().getFormattedString("schemaExplorer.calculatedMemberForElement.title", "Calculated Member for {0} {1}", elementName, parentName));
            ((MondrianGuiDef.CalculatedMember)((Object)o)).displayXML(pxml, 0);
        } else if (o instanceof MondrianGuiDef.CalculatedMemberProperty) {
            pNames = DEF_CALCULATED_MEMBER_PROPERTY;
            this.targetLabel.setText(this.getResourceConverter().getString("common.calculatedMemberProperty.title", LBL_CALCULATED_MEMBER_PROPERTY));
        } else if (o instanceof MondrianGuiDef.NamedSet) {
            pNames = DEF_NAMED_SET;
            this.targetLabel.setText(this.getResourceConverter().getFormattedString("schemaExplorer.namedSetForElement.title", "Named Set for {0} {1}", elementName, parentName));
            ((MondrianGuiDef.NamedSet)((Object)o)).displayXML(pxml, 0);
        } else if (o instanceof MondrianGuiDef.Formula) {
            pNames = DEF_FORMULA;
            this.targetLabel.setText(this.getResourceConverter().getFormattedString("schemaExplorer.formulaForElement.title", "Formula for {0} {1}", elementName, parentName));
            ((MondrianGuiDef.Formula)((Object)o)).displayXML(pxml, 0);
        } else if (o instanceof MondrianGuiDef.UserDefinedFunction) {
            pNames = DEF_USER_DEFINED_FUNCTION;
            this.targetLabel.setText(this.getResourceConverter().getFormattedString("schemaExplorer.userDefinedFunctionForElement.title", "User Defined Function for {0} {1}", elementName, parentName));
            ((MondrianGuiDef.UserDefinedFunction)((Object)o)).displayXML(pxml, 0);
        } else if (o instanceof MondrianGuiDef.Script) {
            pNames = DEF_SCRIPT;
            this.targetLabel.setText(this.getResourceConverter().getFormattedString("schemaExplorer.scriptForElement.title", "Script for {0} {1}", elementName, parentName));
            ((MondrianGuiDef.Script)((Object)o)).displayXML(pxml, 0);
        } else if (o instanceof MondrianGuiDef.CellFormatter) {
            pNames = DEF_FORMATTER;
            this.targetLabel.setText(this.getResourceConverter().getFormattedString("schemaExplorer.cellFormatterForElement.title", "Cell Formatter for {0} {1}", elementName, parentName));
            ((MondrianGuiDef.CellFormatter)((Object)o)).displayXML(pxml, 0);
        } else if (o instanceof MondrianGuiDef.PropertyFormatter) {
            pNames = DEF_FORMATTER;
            this.targetLabel.setText(this.getResourceConverter().getFormattedString("schemaExplorer.propertyFormatterForElement.title", "Property Formatter for {0} {1}", elementName, parentName));
            ((MondrianGuiDef.PropertyFormatter)((Object)o)).displayXML(pxml, 0);
        } else if (o instanceof MondrianGuiDef.MemberFormatter) {
            pNames = DEF_FORMATTER;
            this.targetLabel.setText(this.getResourceConverter().getFormattedString("schemaExplorer.memberFormatterForElement.title", "Member Formatter for {0} {1}", elementName, parentName));
            ((MondrianGuiDef.MemberFormatter)((Object)o)).displayXML(pxml, 0);
        } else if (o instanceof MondrianGuiDef.MemberReaderParameter) {
            pNames = DEF_PARAMETER;
            this.targetLabel.setText(this.getResourceConverter().getString("common.parameter.title", LBL_PARAMETER));
        } else if (o instanceof MondrianGuiDef.Property) {
            pNames = DEF_PROPERTY;
            this.targetLabel.setText(this.getResourceConverter().getString("common.property.title", LBL_PROPERTY));
            ((MondrianGuiDef.Property)((Object)o)).displayXML(pxml, 0);
        } else if (o instanceof MondrianGuiDef.Closure) {
            pNames = DEF_CLOSURE;
            this.targetLabel.setText(this.getResourceConverter().getString("common.closure.title", LBL_CLOSURE));
            ((MondrianGuiDef.Closure)((Object)o)).displayXML(pxml, 0);
        } else if (o instanceof MondrianGuiDef.Schema) {
            pNames = DEF_SCHEMA;
            this.targetLabel.setText(this.getResourceConverter().getString("common.schema.title", LBL_SCHEMA));
            ((MondrianGuiDef.Schema)((Object)o)).displayXML(pxml, 0);
        } else if (o instanceof MondrianGuiDef.SQL) {
            pNames = DEF_SQL;
            this.targetLabel.setText(this.getResourceConverter().getString("common.sql.title", LBL_SQL));
            ((MondrianGuiDef.SQL)((Object)o)).displayXML(pxml, 0);
        } else if (o instanceof MondrianGuiDef.Table) {
            pNames = DEF_TABLE;
            this.targetLabel.setText(this.getResourceConverter().getFormattedString("schemaExplorer.tableForElement.title", "Table for {0} {1}", elementName, parentName));
            ((MondrianGuiDef.Table)((Object)o)).displayXML(pxml, 0);
        } else if (o instanceof MondrianGuiDef.AggName) {
            pNames = DEF_AGG_NAME;
            this.targetLabel.setText(this.getResourceConverter().getString("common.aggName.title", LBL_AGG_NAME));
            ((MondrianGuiDef.AggName)((Object)o)).displayXML(pxml, 0);
        } else if (o instanceof MondrianGuiDef.AggIgnoreColumn) {
            pNames = DEF_AGG_IGNORE_COLUMN;
            this.targetLabel.setText(this.getResourceConverter().getString("common.aggIgnoreColumn.title", LBL_AGG_IGNORE_COLUMN));
            ((MondrianGuiDef.AggIgnoreColumn)((Object)o)).displayXML(pxml, 0);
        } else if (o instanceof MondrianGuiDef.AggForeignKey) {
            pNames = DEF_AGG_FOREIGN_KEY;
            this.targetLabel.setText(this.getResourceConverter().getString("common.aggForeignKey.title", LBL_AGG_FOREIGN_KEY));
            ((MondrianGuiDef.AggForeignKey)((Object)o)).displayXML(pxml, 0);
        } else if (o instanceof MondrianGuiDef.AggMeasure) {
            pNames = DEF_AGG_MEASURE;
            this.targetLabel.setText(this.getResourceConverter().getString("common.aggMeasure.title", LBL_AGG_MEASURE));
            ((MondrianGuiDef.AggMeasure)((Object)o)).displayXML(pxml, 0);
        } else if (o instanceof MondrianGuiDef.AggLevel) {
            pNames = DEF_AGG_LEVEL;
            this.targetLabel.setText(this.getResourceConverter().getString("common.aggLevel.title", LBL_AGG_LEVEL));
            ((MondrianGuiDef.AggLevel)((Object)o)).displayXML(pxml, 0);
        } else if (o instanceof MondrianGuiDef.AggLevelProperty) {
            pNames = DEF_AGG_LEVEL_PROP;
            this.targetLabel.setText(this.getResourceConverter().getString("common.aggLevelProperty.title", LBL_AGG_LEVEL_PROP));
            ((MondrianGuiDef.AggLevelProperty)((Object)o)).displayXML(pxml, 0);
        } else if (o instanceof MondrianGuiDef.AggExclude) {
            pNames = DEF_AGG_EXCLUDE;
            this.targetLabel.setText(this.getResourceConverter().getString("common.aggExclude.title", LBL_AGG_EXCLUDE));
            ((MondrianGuiDef.AggExclude)((Object)o)).displayXML(pxml, 0);
        } else if (o instanceof MondrianGuiDef.AggPattern) {
            pNames = DEF_AGG_PATTERN;
            this.targetLabel.setText(this.getResourceConverter().getString("common.aggPattern.title", LBL_AGG_PATTERN));
            ((MondrianGuiDef.AggPattern)((Object)o)).displayXML(pxml, 0);
        } else if (o instanceof MondrianGuiDef.AggFactCount) {
            pNames = DEF_AGG_FACT_COUNT;
            this.targetLabel.setText(this.getResourceConverter().getString("common.aggFactCount.title", LBL_AGG_FACT_COUNT));
            ((MondrianGuiDef.AggFactCount)((Object)o)).displayXML(pxml, 0);
        } else if (o instanceof MondrianGuiDef.AggMeasureFactCount) {
            pNames = DEF_AGG_MEASURE_FACT_COUNT;
            this.targetLabel.setText(this.getResourceConverter().getString("common.aggMeasureFactCount.title", LBL_AGG_MEASURE_FACT_COUNT));
            ((MondrianGuiDef.AggMeasureFactCount)((Object)o)).displayXML(pxml, 0);
        } else if (o instanceof MondrianGuiDef.View) {
            pNames = DEF_VIEW;
            this.targetLabel.setText(this.getResourceConverter().getString("common.view.title", LBL_VIEW));
        } else if (o instanceof MondrianGuiDef.Role) {
            pNames = DEF_ROLE;
            this.targetLabel.setText(this.getResourceConverter().getFormattedString("schemaExplorer.roleElementParent.title", "Role for {0} {1}", elementName, parentName));
            ((MondrianGuiDef.Role)((Object)o)).displayXML(pxml, 0);
        } else if (o instanceof MondrianGuiDef.Parameter) {
            pNames = DEF_PARAMETER_SCHEMA;
            this.targetLabel.setText(this.getResourceConverter().getString("common.schemaParameter.title", LBL_PARAMETER_SCHEMA));
            ((MondrianGuiDef.Parameter)((Object)o)).displayXML(pxml, 0);
        } else if (o instanceof MondrianGuiDef.SchemaGrant) {
            pNames = DEF_SCHEMA_GRANT;
            this.targetLabel.setText(this.getResourceConverter().getString("common.schemaGrant.title", LBL_SCHEMA_GRANT));
            ((MondrianGuiDef.SchemaGrant)o).displayXML(pxml, 0);
        } else if (o instanceof MondrianGuiDef.CubeGrant) {
            pNames = DEF_CUBE_GRANT;
            this.targetLabel.setText(this.getResourceConverter().getString("common.cubeGrant.title", LBL_CUBE_GRANT));
            ((MondrianGuiDef.CubeGrant)o).displayXML(pxml, 0);
        } else if (o instanceof MondrianGuiDef.DimensionGrant) {
            pNames = DEF_DIMENSION_GRANT;
            this.targetLabel.setText(this.getResourceConverter().getString("common.dimensionGrant.title", LBL_DIMENSION_GRANT));
            ((MondrianGuiDef.DimensionGrant)o).displayXML(pxml, 0);
        } else if (o instanceof MondrianGuiDef.HierarchyGrant) {
            pNames = DEF_HIERARCHY_GRANT;
            this.targetLabel.setText(this.getResourceConverter().getString("common.hierarchyGrant.title", LBL_HIERARCHY_GRANT));
            ((MondrianGuiDef.HierarchyGrant)o).displayXML(pxml, 0);
        } else if (o instanceof MondrianGuiDef.MemberGrant) {
            pNames = DEF_MEMBER_GRANT;
            this.targetLabel.setText(this.getResourceConverter().getString("common.memberGrant.title", LBL_MEMBER_GRANT));
            ((MondrianGuiDef.MemberGrant)((Object)o)).displayXML(pxml, 0);
        } else if (o instanceof MondrianGuiDef.VirtualCube) {
            pNames = DEF_VIRTUAL_CUBE;
            this.targetLabel.setText(this.getResourceConverter().getFormattedString("schemaExplorer.virtualCubeElementParent.title", "Virtual Cube for {0} {1}", elementName, parentName));
            ((MondrianGuiDef.VirtualCube)((Object)o)).displayXML(pxml, 0);
        } else if (o instanceof MondrianGuiDef.VirtualCubeDimension) {
            pNames = DEF_VIRTUAL_CUBE_DIMENSION;
            this.targetLabel.setText(this.getResourceConverter().getFormattedString("schemaExplorer.virtualCubeDimensionElementParent.title", "Virtual Cube Dimension for {0} {1}", elementName, parentName));
            ((MondrianGuiDef.VirtualCubeDimension)((Object)o)).displayXML(pxml, 0);
        } else if (o instanceof MondrianGuiDef.VirtualCubeMeasure) {
            pNames = DEF_VIRTUAL_CUBE_MEASURE;
            this.targetLabel.setText(this.getResourceConverter().getString("common.virtualCubeMeasure.title", LBL_VIRTUAL_CUBE_MEASURE));
            ((MondrianGuiDef.VirtualCubeMeasure)((Object)o)).displayXML(pxml, 0);
        } else if (o instanceof MondrianGuiDef.Annotations) {
            pNames = DEF_DEFAULT;
            this.targetLabel.setText(this.getResourceConverter().getString("common.annotations.title", LBL_ANNOTATIONS));
            ((MondrianGuiDef.Annotations)((Object)o)).displayXML(pxml, 0);
        } else if (o instanceof MondrianGuiDef.Annotation) {
            pNames = DEF_ANNOTATION;
            this.targetLabel.setText(this.getResourceConverter().getString("common.annotation.title", LBL_ANNOTATION));
            ((MondrianGuiDef.Annotation)((Object)o)).displayXML(pxml, 0);
        } else {
            this.targetLabel.setText(this.getResourceConverter().getString("common.unknownType.title", LBL_UNKNOWN_TYPE));
        }
        try {
            this.jEditorPaneXML.read(new StringReader(sxml.toString()), null);
            this.jEditorPaneXML.getDocument().putProperty("tabSize", new Integer(2));
        }
        catch (Exception parentJoin) {
            // empty catch block
        }
        this.targetLabel2.setText(this.targetLabel.getText());
        PropertyTableModel ptm = new PropertyTableModel(this.workbench, o, pNames);
        ptm.setFactTable(selectedFactTable);
        ptm.setFactTableSchema(selectedFactTableSchema);
        Object parent = null;
        int i = e.getPath().getPathCount() - 1 - 1;
        if (i >= 0) {
            parent = e.getPath().getPathComponent(i);
        }
        if (parent != null) {
            Field[] fs = parent.getClass().getFields();
            ArrayList<String> names = new ArrayList<String>();
            for (int i2 = 0; i2 < fs.length; ++i2) {
                if (!fs[i2].getType().isArray() || !fs[i2].getType().getComponentType().isInstance(o)) continue;
                try {
                    Field fname = fs[i2].getType().getComponentType().getField("name");
                    Object objs = fs[i2].get(parent);
                    for (int j = 0; j < Array.getLength(objs); ++j) {
                        Object child = Array.get(objs, j);
                        String vname = (String)fname.get(child);
                        names.add(vname);
                    }
                    ptm.setNames(names);
                }
                catch (Exception fname) {}
                break;
            }
        }
        this.propertyTable.setModel(ptm);
        this.propertyTable.getColumnModel().getColumn(0).setMaxWidth(150);
        this.propertyTable.getColumnModel().getColumn(0).setMinWidth(150);
        for (i = 0; i < this.propertyTable.getRowCount(); ++i) {
            TableCellRenderer renderer = this.propertyTable.getCellRenderer(i, 1);
            Component comp = renderer.getTableCellRendererComponent(this.propertyTable, this.propertyTable.getValueAt(i, 1), false, false, i, 1);
            try {
                int height = comp.getMaximumSize().height;
                this.propertyTable.setRowHeight(i, height);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void editingCanceled(ChangeEvent e) {
        this.updater.update();
    }

    @Override
    public void editingStopped(ChangeEvent e) {
        String emsg;
        this.setDirty(true);
        if (!this.dirtyFlag || ((PropertyTableModel)this.propertyTable.getModel()).target instanceof MondrianGuiDef.Schema) {
            this.setDirtyFlag(true);
            this.setTitle();
        }
        if ((emsg = ((PropertyTableModel)this.propertyTable.getModel()).getErrorMsg()) != null) {
            JOptionPane.showMessageDialog(this, emsg, "Error", 0);
            ((PropertyTableModel)this.propertyTable.getModel()).setErrorMsg(null);
        }
        this.updater.update();
    }

    public boolean isNewFile() {
        return this.newFile;
    }

    public void setNewFile(boolean newFile) {
        this.newFile = newFile;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    public void setTitle() {
        this.parentIFrame.setTitle(this.getResourceConverter().getFormattedString("schemaExplorer.frame.title", "Schema - {0} ({1}){2}", this.schema.name, this.schemaFile.getName(), this.isDirty() ? "*" : ""));
        this.parentIFrame.setToolTipText(this.schemaFile.toString());
    }

    public void setDirtyFlag(boolean dirtyFlag) {
        this.dirtyFlag = dirtyFlag;
    }

    public Object getParentObject() {
        TreePath tPath = this.tree.getSelectionPath();
        if (tPath != null && tPath.getParentPath() != null) {
            return tPath.getParentPath().getLastPathComponent();
        }
        return null;
    }

    public String getJdbcConnectionUrl() {
        return this.jdbcMetaData.jdbcConnectionUrl;
    }

    public String getJdbcUsername() {
        return this.jdbcMetaData.jdbcUsername;
    }

    public String getJdbcPassword() {
        return this.jdbcMetaData.jdbcPassword;
    }

    public String getErrMsg() {
        return this.errMsg;
    }

    public boolean isEditModeXML() {
        return this.editModeXML;
    }

    public I18n getResourceConverter() {
        return this.workbench.getResourceConverter();
    }

    public static void getTableNamesForJoin(MondrianGuiDef.RelationOrJoin aRelOrJoin, Set<String> aTableNames) {
        if (aRelOrJoin instanceof MondrianGuiDef.Join) {
            MondrianGuiDef.RelationOrJoin theRelOrJoin_L = ((MondrianGuiDef.Join)aRelOrJoin).left;
            MondrianGuiDef.RelationOrJoin theRelOrJoin_R = ((MondrianGuiDef.Join)aRelOrJoin).right;
            for (int i = 0; i < 2; ++i) {
                MondrianGuiDef.RelationOrJoin theCurrentRelOrJoin;
                MondrianGuiDef.RelationOrJoin relationOrJoin = theCurrentRelOrJoin = i == 0 ? theRelOrJoin_L : theRelOrJoin_R;
                if (theCurrentRelOrJoin instanceof MondrianGuiDef.Table) {
                    MondrianGuiDef.Table theTable = (MondrianGuiDef.Table)theCurrentRelOrJoin;
                    String theTableName = theTable.alias != null && theTable.alias.trim().length() > 0 ? theTable.alias : theTable.name;
                    aTableNames.add(theTableName);
                    continue;
                }
                SchemaExplorer.getTableNamesForJoin(theCurrentRelOrJoin, aTableNames);
            }
        }
    }

    public static String[] getTableNameForAlias(MondrianGuiDef.RelationOrJoin aRelOrJoin, String anAlias) {
        String theTableName = anAlias;
        String schemaName = null;
        if (aRelOrJoin instanceof MondrianGuiDef.Join) {
            MondrianGuiDef.RelationOrJoin theRelOrJoin_L = ((MondrianGuiDef.Join)aRelOrJoin).left;
            MondrianGuiDef.RelationOrJoin theRelOrJoin_R = ((MondrianGuiDef.Join)aRelOrJoin).right;
            for (int i = 0; i < 2; ++i) {
                MondrianGuiDef.RelationOrJoin theCurrentRelOrJoin;
                MondrianGuiDef.RelationOrJoin relationOrJoin = theCurrentRelOrJoin = i == 0 ? theRelOrJoin_L : theRelOrJoin_R;
                if (theCurrentRelOrJoin instanceof MondrianGuiDef.Table) {
                    MondrianGuiDef.Table theTable = (MondrianGuiDef.Table)theCurrentRelOrJoin;
                    if (theTable.alias == null || !theTable.alias.equals(anAlias)) continue;
                    theTableName = theTable.name;
                    schemaName = theTable.schema;
                    continue;
                }
                String[] result = SchemaExplorer.getTableNameForAlias(theCurrentRelOrJoin, anAlias);
                schemaName = result[0];
                theTableName = result[1];
            }
        }
        return new String[]{schemaName, theTableName};
    }

    public void resetMetaData(JdbcMetaData aMetaData) {
        this.jdbcMetaData = aMetaData;
        String theLabel = this.getResourceConverter().getFormattedString("schemaExplorer.database.text", "Database - {0} ({1})", this.jdbcMetaData.getDbCatalogName(), this.jdbcMetaData.getDatabaseProductName());
        this.databaseLabel.setText(theLabel);
        this.renderer.setMetaData(aMetaData);
        TableCellEditor theTableCellEditor = this.propertyTable.getDefaultEditor(Object.class);
        if (theTableCellEditor instanceof SchemaPropertyCellEditor) {
            ((SchemaPropertyCellEditor)theTableCellEditor).setMetaData(aMetaData);
        }
    }

    public JTreeUpdater getTreeUpdater() {
        return this.updater;
    }

    private class CustomJPopupMenu
    extends JPopupMenu {
        private TreePath path;

        private CustomJPopupMenu() {
        }

        void setPath(TreePath path) {
            this.path = path;
        }

        public TreePath getPath() {
            return this.path;
        }
    }

    class PopupTrigger
    extends MouseAdapter {
        PopupTrigger() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.showMenu(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.showMenu(e);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void showMenu(MouseEvent e) {
            int y;
            int x;
            TreePath path;
            if (!e.isPopupTrigger() || (path = SchemaExplorer.this.tree.getPathForLocation(x = e.getX(), y = e.getY())) == null) return;
            SchemaExplorer.this.jPopupMenu.setPath(path);
            SchemaExplorer.this.jPopupMenu.removeAll();
            Object pathSelected = path.getLastPathComponent();
            if (pathSelected instanceof MondrianGuiDef.Schema) {
                MondrianGuiDef.Schema s = (MondrianGuiDef.Schema)((Object)pathSelected);
                SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.addCube);
                SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.addDimension);
                SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.addNamedSet);
                SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.addUserDefinedFunction);
                SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.jSeparator1);
                SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.addVirtualCube);
                SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.addRole);
                SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.addParameter);
                SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.addAnnotations);
                if (s.annotations == null) {
                    SchemaExplorer.this.addAnnotations.setEnabled(true);
                } else {
                    SchemaExplorer.this.addAnnotations.setEnabled(false);
                }
            } else if (pathSelected instanceof MondrianGuiDef.Cube) {
                SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.addDimension);
                SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.addDimensionUsage);
                SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.addMeasure);
                SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.addCalculatedMember);
                SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.addNamedSet);
                SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.jSeparator1);
                SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.addTable);
                SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.addView);
                SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.addInlineTable);
                SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.addAnnotations);
                if (((MondrianGuiDef.Cube)((Object)pathSelected)).annotations == null) {
                    SchemaExplorer.this.addAnnotations.setEnabled(true);
                } else {
                    SchemaExplorer.this.addAnnotations.setEnabled(false);
                }
                SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.jSeparator2);
                SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.delete);
                if (((MondrianGuiDef.Cube)((Object)pathSelected)).fact == null) {
                    SchemaExplorer.this.addMeasure.setEnabled(false);
                    SchemaExplorer.this.addCalculatedMember.setEnabled(false);
                    SchemaExplorer.this.addTable.setEnabled(true);
                    SchemaExplorer.this.addView.setEnabled(true);
                    SchemaExplorer.this.addInlineTable.setEnabled(true);
                } else {
                    SchemaExplorer.this.addMeasure.setEnabled(true);
                    SchemaExplorer.this.addCalculatedMember.setEnabled(true);
                    SchemaExplorer.this.addTable.setEnabled(false);
                    SchemaExplorer.this.addView.setEnabled(false);
                    SchemaExplorer.this.addInlineTable.setEnabled(false);
                }
            } else if (pathSelected instanceof MondrianGuiDef.Dimension) {
                SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.addHierarchy);
                SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.addAnnotations);
                if (((MondrianGuiDef.Dimension)((Object)pathSelected)).annotations == null) {
                    SchemaExplorer.this.addAnnotations.setEnabled(true);
                } else {
                    SchemaExplorer.this.addAnnotations.setEnabled(false);
                }
                SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.jSeparator1);
                SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.delete);
            } else if (pathSelected instanceof MondrianGuiDef.Hierarchy) {
                SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.addLevel);
                SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.jSeparator1);
                SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.addTable);
                SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.addJoin);
                SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.addView);
                SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.addInlineTable);
                SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.addAnnotations);
                if (((MondrianGuiDef.Hierarchy)((Object)pathSelected)).annotations == null) {
                    SchemaExplorer.this.addAnnotations.setEnabled(true);
                } else {
                    SchemaExplorer.this.addAnnotations.setEnabled(false);
                }
                SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.jSeparator2);
                SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.delete);
                if (((MondrianGuiDef.Hierarchy)((Object)pathSelected)).relation == null) {
                    SchemaExplorer.this.addLevel.setEnabled(false);
                    SchemaExplorer.this.addTable.setEnabled(true);
                    SchemaExplorer.this.addJoin.setEnabled(true);
                    SchemaExplorer.this.addView.setEnabled(true);
                    SchemaExplorer.this.addInlineTable.setEnabled(true);
                } else {
                    SchemaExplorer.this.addLevel.setEnabled(true);
                    SchemaExplorer.this.addTable.setEnabled(false);
                    SchemaExplorer.this.addJoin.setEnabled(false);
                    SchemaExplorer.this.addView.setEnabled(false);
                    SchemaExplorer.this.addInlineTable.setEnabled(false);
                }
            } else if (pathSelected instanceof MondrianGuiDef.Level) {
                SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.moveLevelUp);
                SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.moveLevelDown);
                SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.addProperty);
                SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.addKeyExp);
                MondrianGuiDef.Level level = (MondrianGuiDef.Level)((Object)pathSelected);
                if (level.keyExp == null) {
                    SchemaExplorer.this.addKeyExp.setEnabled(true);
                } else {
                    SchemaExplorer.this.addKeyExp.setEnabled(false);
                }
                SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.addNameExp);
                if (level.nameExp == null) {
                    SchemaExplorer.this.addNameExp.setEnabled(true);
                } else {
                    SchemaExplorer.this.addNameExp.setEnabled(false);
                }
                SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.addOrdinalExp);
                if (level.ordinalExp == null) {
                    SchemaExplorer.this.addOrdinalExp.setEnabled(true);
                } else {
                    SchemaExplorer.this.addOrdinalExp.setEnabled(false);
                }
                SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.addCaptionExp);
                if (level.captionExp == null) {
                    SchemaExplorer.this.addCaptionExp.setEnabled(true);
                } else {
                    SchemaExplorer.this.addCaptionExp.setEnabled(false);
                }
                SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.addParentExp);
                if (level.parentExp == null) {
                    SchemaExplorer.this.addParentExp.setEnabled(true);
                } else {
                    SchemaExplorer.this.addParentExp.setEnabled(false);
                }
                SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.addClosure);
                if (level.closure == null) {
                    SchemaExplorer.this.addClosure.setEnabled(true);
                } else {
                    SchemaExplorer.this.addClosure.setEnabled(false);
                }
                SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.addAnnotations);
                if (level.annotations == null) {
                    SchemaExplorer.this.addAnnotations.setEnabled(true);
                } else {
                    SchemaExplorer.this.addAnnotations.setEnabled(false);
                }
                SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.addMemberFormatter);
                if (((MondrianGuiDef.Level)((Object)pathSelected)).memberFormatter == null) {
                    SchemaExplorer.this.addMemberFormatter.setEnabled(true);
                } else {
                    SchemaExplorer.this.addMemberFormatter.setEnabled(false);
                }
                SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.jSeparator1);
                SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.delete);
            } else if (pathSelected instanceof MondrianGuiDef.KeyExpression || pathSelected instanceof MondrianGuiDef.NameExpression || pathSelected instanceof MondrianGuiDef.OrdinalExpression || pathSelected instanceof MondrianGuiDef.CaptionExpression || pathSelected instanceof MondrianGuiDef.ParentExpression || pathSelected instanceof MondrianGuiDef.ExpressionView || pathSelected instanceof MondrianGuiDef.View) {
                SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.addSQL);
                SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.jSeparator1);
                SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.delete);
            } else if (pathSelected instanceof MondrianGuiDef.RelationOrJoin) {
                Object po = path.getParentPath().getLastPathComponent();
                if (po instanceof MondrianGuiDef.RelationOrJoin || po instanceof MondrianGuiDef.Closure) return;
                if (po instanceof MondrianGuiDef.Cube) {
                    SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.addAggName);
                    SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.addAggPattern);
                    SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.addAggExclude);
                    SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.jSeparator1);
                }
                SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.delete);
            } else if (pathSelected instanceof MondrianGuiDef.Measure) {
                SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.addMeasureExp);
                SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.addCalculatedMemberProperty);
                if (((MondrianGuiDef.Measure)((Object)pathSelected)).measureExp == null) {
                    SchemaExplorer.this.addMeasureExp.setEnabled(true);
                } else {
                    SchemaExplorer.this.addMeasureExp.setEnabled(false);
                }
                SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.addAnnotations);
                if (((MondrianGuiDef.Measure)((Object)pathSelected)).annotations == null) {
                    SchemaExplorer.this.addAnnotations.setEnabled(true);
                } else {
                    SchemaExplorer.this.addAnnotations.setEnabled(false);
                }
                SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.addCellFormatter);
                if (((MondrianGuiDef.Measure)((Object)pathSelected)).cellFormatter == null) {
                    SchemaExplorer.this.addCellFormatter.setEnabled(true);
                } else {
                    SchemaExplorer.this.addCellFormatter.setEnabled(false);
                }
                SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.jSeparator1);
                SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.delete);
            } else if (pathSelected instanceof MondrianGuiDef.NamedSet) {
                SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.addFormula);
                if (((MondrianGuiDef.NamedSet)((Object)pathSelected)).formulaElement == null) {
                    SchemaExplorer.this.addFormula.setEnabled(false);
                } else {
                    SchemaExplorer.this.addFormula.setEnabled(false);
                }
                SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.addAnnotations);
                if (((MondrianGuiDef.NamedSet)((Object)pathSelected)).annotations == null) {
                    SchemaExplorer.this.addAnnotations.setEnabled(true);
                } else {
                    SchemaExplorer.this.addAnnotations.setEnabled(false);
                }
                SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.jSeparator1);
                SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.delete);
            } else if (pathSelected instanceof MondrianGuiDef.CalculatedMember) {
                SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.addFormula);
                SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.addCalculatedMemberProperty);
                if (((MondrianGuiDef.CalculatedMember)((Object)pathSelected)).formulaElement == null) {
                    SchemaExplorer.this.addFormula.setEnabled(false);
                } else {
                    SchemaExplorer.this.addFormula.setEnabled(false);
                }
                SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.addAnnotations);
                if (((MondrianGuiDef.CalculatedMember)((Object)pathSelected)).annotations == null) {
                    SchemaExplorer.this.addAnnotations.setEnabled(true);
                } else {
                    SchemaExplorer.this.addAnnotations.setEnabled(false);
                }
                SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.addCellFormatter);
                if (((MondrianGuiDef.CalculatedMember)((Object)pathSelected)).cellFormatter == null) {
                    SchemaExplorer.this.addCellFormatter.setEnabled(true);
                } else {
                    SchemaExplorer.this.addCellFormatter.setEnabled(false);
                }
                SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.jSeparator1);
                SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.delete);
            } else if (pathSelected instanceof MondrianGuiDef.MeasureExpression) {
                SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.addSQL);
                SchemaExplorer.this.addSQL.setEnabled(false);
                SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.jSeparator1);
                SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.delete);
            } else if (pathSelected instanceof MondrianGuiDef.Closure) {
                SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.delete);
            } else if (pathSelected instanceof MondrianGuiDef.AggName || pathSelected instanceof MondrianGuiDef.AggPattern) {
                SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.addAggFactCount);
                SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.addAggMeasureFactCount);
                SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.addAggIgnoreColumn);
                SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.addAggForeignKey);
                SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.addAggMeasure);
                SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.addAggLevel);
                if (pathSelected instanceof MondrianGuiDef.AggPattern) {
                    SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.addAggExclude);
                    if (((MondrianGuiDef.AggPattern)((Object)pathSelected)).factcount == null) {
                        SchemaExplorer.this.addAggFactCount.setEnabled(true);
                    } else {
                        SchemaExplorer.this.addAggFactCount.setEnabled(false);
                    }
                } else if (((MondrianGuiDef.AggName)((Object)pathSelected)).factcount == null) {
                    SchemaExplorer.this.addAggFactCount.setEnabled(true);
                } else {
                    SchemaExplorer.this.addAggFactCount.setEnabled(false);
                }
                SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.jSeparator1);
                SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.delete);
            } else if (pathSelected instanceof MondrianGuiDef.AggLevel) {
                SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.addAggLevelProperty);
            } else if (pathSelected instanceof MondrianGuiDef.VirtualCube) {
                SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.addVirtualCubeDimension);
                SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.addVirtualCubeMeasure);
                SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.addCalculatedMember);
                SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.addAnnotations);
                if (((MondrianGuiDef.VirtualCube)((Object)pathSelected)).annotations == null) {
                    SchemaExplorer.this.addAnnotations.setEnabled(true);
                } else {
                    SchemaExplorer.this.addAnnotations.setEnabled(false);
                }
                SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.jSeparator1);
                SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.delete);
            } else if (pathSelected instanceof MondrianGuiDef.Role) {
                SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.addSchemaGrant);
                SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.addAnnotations);
                if (((MondrianGuiDef.Role)((Object)pathSelected)).annotations == null) {
                    SchemaExplorer.this.addAnnotations.setEnabled(true);
                } else {
                    SchemaExplorer.this.addAnnotations.setEnabled(false);
                }
                SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.jSeparator1);
                SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.delete);
            } else if (pathSelected instanceof MondrianGuiDef.SchemaGrant) {
                SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.addCubeGrant);
                SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.jSeparator1);
                SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.delete);
            } else if (pathSelected instanceof MondrianGuiDef.CubeGrant) {
                SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.addDimensionGrant);
                SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.addHierarchyGrant);
                SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.jSeparator1);
                SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.delete);
            } else if (pathSelected instanceof MondrianGuiDef.VirtualCubeMeasure) {
                SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.addAnnotations);
                SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.jSeparator1);
                SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.delete);
            } else if (pathSelected instanceof MondrianGuiDef.HierarchyGrant) {
                SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.addMemberGrant);
                SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.jSeparator1);
                SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.delete);
            } else if (pathSelected instanceof MondrianGuiDef.Annotations) {
                SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.addAnnotation);
                SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.jSeparator1);
                SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.delete);
            } else if (pathSelected instanceof MondrianGuiDef.UserDefinedFunction) {
                SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.addScript);
                SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.delete);
            } else if (pathSelected instanceof MondrianGuiDef.Property) {
                SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.addPropertyFormatter);
                SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.delete);
            } else if (pathSelected instanceof MondrianGuiDef.CellFormatter) {
                SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.addScript);
                SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.delete);
            } else if (pathSelected instanceof MondrianGuiDef.MemberFormatter) {
                SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.addScript);
                SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.delete);
            } else if (pathSelected instanceof MondrianGuiDef.PropertyFormatter) {
                SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.addScript);
                SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.delete);
            } else {
                SchemaExplorer.this.jPopupMenu.add(SchemaExplorer.this.delete);
            }
            SchemaExplorer.this.jPopupMenu.show(SchemaExplorer.this.tree, x, y);
        }
    }

    private static class LevelInfo {
        MondrianGuiDef.Level level = null;
        Object[] parentPathObjs = null;

        private LevelInfo() {
        }
    }
}

