/*
 * Decompiled with CFR 0.152.
 */
package mondrian.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.table.TableCellEditor;
import javax.swing.text.JTextComponent;
import mondrian.gui.I18n;
import mondrian.gui.JdbcMetaData;
import mondrian.gui.MondrianGuiDef;
import mondrian.gui.PropertyTableModel;
import mondrian.gui.SchemaExplorer;
import mondrian.gui.SchemaPropertyCellRenderer;
import mondrian.gui.Workbench;
import mondrian.olap.Id;
import mondrian.olap.MondrianProperties;
import mondrian.olap.Util;
import org.eigenbase.xom.NodeDef;

public class SchemaPropertyCellEditor
implements TableCellEditor {
    Workbench workbench;
    final List<CellEditorListener> listeners = new ArrayList<CellEditorListener>();
    JTextField stringEditor;
    JTextArea cdataTextArea;
    JScrollPane jScrollPaneCDATA;
    JCheckBox booleanEditor;
    JTextField integerEditor;
    JTable tableEditor;
    Component activeEditor;
    JComboBox listEditor;
    JTable relationTable;
    JPanel relationRenderer;
    JdbcMetaData jdbcMetaData;
    ComboBoxModel allOptions;
    ComboBoxModel selOptions;
    String listEditorValue;
    MouseListener ml;
    ItemListener il;
    ActionListener al;
    String noSelect = "-- No Selection --";
    FocusAdapter editorFocus;
    Object originalValue;
    private String cacheCube = "";
    private String cacheHierarchy = "";
    private List<String> hlevels = new ArrayList<String>();

    public SchemaPropertyCellEditor(Workbench workbench) {
        this(workbench, null);
    }

    public SchemaPropertyCellEditor(Workbench workbench, JdbcMetaData jdbcMetaData) {
        this.workbench = workbench;
        this.jdbcMetaData = jdbcMetaData;
        this.noSelect = this.getResourceConverter().getString("schemaPropertyCellEditor.noSelection", this.noSelect);
        this.stringEditor = new JTextField();
        this.stringEditor.setFont(Font.decode("Dialog"));
        this.stringEditor.setBorder(null);
        this.cdataTextArea = new JTextArea();
        this.cdataTextArea.setLineWrap(true);
        this.cdataTextArea.setWrapStyleWord(true);
        this.cdataTextArea.setLayout(new BorderLayout());
        this.cdataTextArea.setEditable(true);
        this.cdataTextArea.setPreferredSize(new Dimension(100, 300));
        this.cdataTextArea.setMinimumSize(new Dimension(100, 100));
        this.jScrollPaneCDATA = new JScrollPane(this.cdataTextArea);
        this.jScrollPaneCDATA.setMaximumSize(this.cdataTextArea.getPreferredSize());
        this.booleanEditor = new JCheckBox();
        this.booleanEditor.setBackground(Color.white);
        this.integerEditor = new JTextField();
        this.integerEditor.setBorder(null);
        this.integerEditor.setHorizontalAlignment(4);
        this.integerEditor.setFont(Font.decode("Courier"));
        this.tableEditor = new JTable();
        this.listEditor = new JComboBox();
        this.listEditor.setEditable(true);
        this.listEditor.setMaximumSize(this.stringEditor.getMaximumSize());
        this.listEditor.setFont(Font.decode("Dialog"));
        this.listEditor.setBackground(Color.white);
        this.listEditor.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.al = new ActionListener(){
            boolean all = true;

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getActionCommand().equals("comboBoxChanged") && SchemaPropertyCellEditor.this.listEditor.getSelectedIndex() == 0) {
                    if (this.all) {
                        SchemaPropertyCellEditor.this.listEditor.setModel(SchemaPropertyCellEditor.this.allOptions);
                    } else {
                        SchemaPropertyCellEditor.this.listEditor.setModel(SchemaPropertyCellEditor.this.selOptions);
                    }
                    SchemaPropertyCellEditor.this.listEditor.setSelectedIndex(-1);
                    this.all = !this.all;
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (SchemaPropertyCellEditor.this.listEditor.isDisplayable()) {
                            SchemaPropertyCellEditor.this.listEditor.setPopupVisible(true);
                        }
                    }
                });
            }
        };
        JTextComponent editor = (JTextComponent)this.listEditor.getEditor().getEditorComponent();
        editor.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (SchemaPropertyCellEditor.this.listEditor.isDisplayable()) {
                    SchemaPropertyCellEditor.this.listEditor.setPopupVisible(true);
                }
            }
        });
        editor.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (SchemaPropertyCellEditor.this.listEditor.isDisplayable()) {
                    SchemaPropertyCellEditor.this.listEditor.setPopupVisible(true);
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 27) {
                    SchemaPropertyCellEditor.this.listEditor.setSelectedItem(SchemaPropertyCellEditor.this.listEditorValue);
                    SchemaPropertyCellEditor.this.listEditor.getEditor().setItem(SchemaPropertyCellEditor.this.listEditorValue);
                }
            }
        });
    }

    public MondrianGuiDef.RelationOrJoin getRelation(JTable table, int row, int column) {
        PropertyTableModel tableModel = (PropertyTableModel)table.getModel();
        Object value = tableModel.getValue();
        Class<?> targetClassz = tableModel.target.getClass();
        Object parent = this.getParentObject();
        MondrianGuiDef.RelationOrJoin relation = null;
        if (targetClassz == MondrianGuiDef.Table.class) {
            relation = (MondrianGuiDef.Table)((Object)value);
        } else if (targetClassz == MondrianGuiDef.View.class) {
            relation = (MondrianGuiDef.View)((Object)value);
        } else if (targetClassz == MondrianGuiDef.Join.class) {
            relation = (MondrianGuiDef.Join)((Object)value);
        } else if (targetClassz == MondrianGuiDef.Hierarchy.class) {
            MondrianGuiDef.Hierarchy hProps = (MondrianGuiDef.Hierarchy)((Object)value);
            relation = hProps.relation;
        } else if (targetClassz == MondrianGuiDef.Level.class) {
            MondrianGuiDef.Hierarchy hProps = (MondrianGuiDef.Hierarchy)((Object)parent);
            relation = hProps.relation;
        } else if (targetClassz == MondrianGuiDef.Cube.class) {
            MondrianGuiDef.Cube hProps = (MondrianGuiDef.Cube)((Object)value);
            relation = hProps.fact;
        }
        return relation;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        boolean nonTableRelation;
        PropertyTableModel tableModel = (PropertyTableModel)table.getModel();
        Class<?> parentClassz = null;
        if (tableModel.getParentTarget() != null) {
            parentClassz = tableModel.getParentTarget().getClass();
        }
        Class<?> targetClassz = tableModel.target.getClass();
        String propertyName = tableModel.getRowName(row);
        String selectedFactTable = tableModel.getFactTable();
        String selectedFactTableSchema = tableModel.getFactTableSchema();
        this.listEditorValue = null;
        Object parent = this.getParentObject();
        MondrianGuiDef.RelationOrJoin currentRelation = this.getRelation(table, row, column);
        boolean bl = nonTableRelation = currentRelation != null && !(currentRelation instanceof MondrianGuiDef.Table) && !(currentRelation instanceof MondrianGuiDef.Join);
        if (targetClassz == MondrianGuiDef.UserDefinedFunction.class && propertyName.equals("className")) {
            List<String> udfs = this.getUdfs();
            DefaultComboBoxModel<String> cAlludfs = new DefaultComboBoxModel<String>(new Vector<String>(udfs));
            this.listEditor.setEditable(true);
            this.listEditor.setToolTipText(null);
            this.listEditor.removeActionListener(this.al);
            this.listEditor.setModel(cAlludfs);
            this.listEditor.setSelectedItem((String)value);
            this.listEditorValue = (String)value;
            this.activeEditor = this.listEditor;
        } else if (targetClassz == MondrianGuiDef.Measure.class && propertyName.equals("formatString")) {
            List<String> formatStrs = this.getFormatStrings();
            DefaultComboBoxModel<String> cAllformatStrs = new DefaultComboBoxModel<String>(new Vector<String>(formatStrs));
            this.listEditor.setEditable(true);
            this.listEditor.setToolTipText(null);
            this.listEditor.removeActionListener(this.al);
            this.listEditor.setModel(cAllformatStrs);
            this.listEditor.setSelectedItem((String)value);
            this.listEditorValue = (String)value;
            this.activeEditor = this.listEditor;
        } else if (targetClassz == MondrianGuiDef.Measure.class && propertyName.equals("aggregator")) {
            this.listEditor.setEditable(false);
            this.listEditor.setToolTipText(null);
            this.listEditor.removeActionListener(this.al);
            this.listEditor.setModel(new DefaultComboBoxModel<String>(MondrianGuiDef.Measure._aggregator_values));
            this.listEditor.setSelectedItem((String)value);
            this.activeEditor = this.listEditor;
        } else if (targetClassz == MondrianGuiDef.Measure.class && propertyName.equals("datatype")) {
            this.listEditor.setEditable(false);
            this.listEditor.setToolTipText(null);
            this.listEditor.removeActionListener(this.al);
            this.listEditor.setModel(new DefaultComboBoxModel<String>(MondrianGuiDef.Measure._datatype_values));
            this.listEditor.setSelectedItem((String)value);
            this.activeEditor = this.listEditor;
        } else if (targetClassz == MondrianGuiDef.Parameter.class && propertyName.equals("parameter")) {
            this.listEditor.setEditable(false);
            this.listEditor.setToolTipText(null);
            this.listEditor.removeActionListener(this.al);
            this.listEditor.setModel(new DefaultComboBoxModel<String>(MondrianGuiDef.Parameter._type_values));
            this.listEditor.setSelectedItem((String)value);
            this.activeEditor = this.listEditor;
        } else if (targetClassz == MondrianGuiDef.SQL.class && propertyName.equals("dialect")) {
            this.listEditor.setEditable(false);
            this.listEditor.setToolTipText(null);
            this.listEditor.removeActionListener(this.al);
            this.listEditor.setModel(new DefaultComboBoxModel<String>(MondrianGuiDef.SQL._dialect_values));
            this.listEditor.setSelectedItem((String)value);
            this.activeEditor = this.listEditor;
        } else if (targetClassz == MondrianGuiDef.Level.class && propertyName.equals("hideMemberIf")) {
            this.listEditor.setEditable(false);
            this.listEditor.setToolTipText(null);
            this.listEditor.removeActionListener(this.al);
            this.listEditor.setModel(new DefaultComboBoxModel<String>(MondrianGuiDef.Level._hideMemberIf_values));
            this.listEditor.setSelectedItem((String)value);
            this.activeEditor = this.listEditor;
        } else if (targetClassz == MondrianGuiDef.Level.class && propertyName.equals("levelType")) {
            this.listEditor.setEditable(false);
            this.listEditor.setToolTipText(null);
            this.listEditor.removeActionListener(this.al);
            this.listEditor.setModel(new DefaultComboBoxModel<String>(MondrianGuiDef.Level._levelType_values));
            this.listEditor.setSelectedItem((String)value);
            this.activeEditor = this.listEditor;
        } else if (targetClassz == MondrianGuiDef.Level.class && propertyName.equals("type")) {
            this.listEditor.setEditable(false);
            this.listEditor.setToolTipText(null);
            this.listEditor.removeActionListener(this.al);
            this.listEditor.setModel(new DefaultComboBoxModel<String>(MondrianGuiDef.Level._type_values));
            this.listEditor.setSelectedItem((String)value);
            this.activeEditor = this.listEditor;
        } else if (targetClassz == MondrianGuiDef.Level.class && propertyName.equals("internalType")) {
            this.listEditor.setEditable(false);
            this.listEditor.setToolTipText(null);
            this.listEditor.removeActionListener(this.al);
            this.listEditor.setModel(new DefaultComboBoxModel<String>(MondrianGuiDef.Level._internalType_values));
            this.listEditor.setSelectedItem((String)value);
            this.activeEditor = this.listEditor;
        } else if (targetClassz == MondrianGuiDef.Dimension.class && propertyName.equals("type")) {
            this.listEditor.setEditable(false);
            this.listEditor.setToolTipText(null);
            this.listEditor.removeActionListener(this.al);
            this.listEditor.setModel(new DefaultComboBoxModel<String>(MondrianGuiDef.Dimension._type_values));
            this.listEditor.setSelectedItem((String)value);
            this.activeEditor = this.listEditor;
        } else if (targetClassz == MondrianGuiDef.DimensionUsage.class && propertyName.equals("source")) {
            List<String> source = this.getSource();
            DefaultComboBoxModel<String> cAllsource = new DefaultComboBoxModel<String>(new Vector<String>(source));
            this.listEditor.setEditable(true);
            this.listEditor.setToolTipText(null);
            this.listEditor.removeActionListener(this.al);
            this.listEditor.setModel(cAllsource);
            this.listEditor.setSelectedItem((String)value);
            this.listEditorValue = (String)value;
            this.activeEditor = this.listEditor;
        } else if ((tableModel.target instanceof MondrianGuiDef.Grant || tableModel.target instanceof MondrianGuiDef.MemberGrant) && propertyName.equals("access")) {
            this.listEditor.setEditable(false);
            this.listEditor.setToolTipText(null);
            this.listEditor.removeActionListener(this.al);
            DefaultComboBoxModel<String> cAccess = new DefaultComboBoxModel<String>(new String[]{"all", "none"});
            if (targetClassz == MondrianGuiDef.SchemaGrant.class) {
                cAccess = new DefaultComboBoxModel<String>(new String[]{"all", "custom", "none", "all_dimensions"});
            } else if (targetClassz == MondrianGuiDef.CubeGrant.class || targetClassz == MondrianGuiDef.DimensionGrant.class || targetClassz == MondrianGuiDef.MemberGrant.class) {
                cAccess = new DefaultComboBoxModel<String>(new String[]{"all", "custom", "none"});
            } else if (targetClassz == MondrianGuiDef.HierarchyGrant.class || targetClassz == MondrianGuiDef.DimensionGrant.class) {
                cAccess = new DefaultComboBoxModel<String>(new String[]{"all", "custom", "none"});
            }
            this.listEditor.setModel(cAccess);
            this.listEditor.setSelectedItem((String)value);
            this.activeEditor = this.listEditor;
        } else if (targetClassz == MondrianGuiDef.HierarchyGrant.class && propertyName.equals("rollupPolicy")) {
            DefaultComboBoxModel<String> cRollupPolicy = new DefaultComboBoxModel<String>(new String[]{"full", "partial", "hidden"});
            this.listEditor.setModel(cRollupPolicy);
            this.listEditor.setSelectedItem(value);
            this.activeEditor = this.listEditor;
        } else if (targetClassz == MondrianGuiDef.DimensionGrant.class && propertyName.equals("dimension")) {
            List<String> source = this.getDimensions();
            DefaultComboBoxModel<String> cAllsource = new DefaultComboBoxModel<String>(new Vector<String>(source));
            this.listEditor.setEditable(false);
            this.listEditor.setToolTipText(null);
            this.listEditor.removeActionListener(this.al);
            this.listEditor.setModel(cAllsource);
            this.listEditor.setSelectedItem((String)value);
            this.listEditorValue = (String)value;
            this.activeEditor = this.listEditor;
        } else if (targetClassz == MondrianGuiDef.HierarchyGrant.class && propertyName.equals("hierarchy")) {
            List<String> source = this.getHierarchies();
            DefaultComboBoxModel<String> cAllsource = new DefaultComboBoxModel<String>(new Vector<String>(source));
            this.listEditor.setEditable(false);
            this.listEditor.setToolTipText(null);
            this.listEditor.removeActionListener(this.al);
            this.listEditor.setModel(cAllsource);
            this.listEditor.setSelectedItem((String)value);
            this.listEditorValue = (String)value;
            this.activeEditor = this.listEditor;
        } else if (targetClassz == MondrianGuiDef.HierarchyGrant.class && (propertyName.equals("topLevel") || propertyName.equals("bottomLevel"))) {
            List<String> source = this.getLevels(((MondrianGuiDef.HierarchyGrant)tableModel.target).hierarchy);
            DefaultComboBoxModel<String> cAllsource = new DefaultComboBoxModel<String>(new Vector<String>(source));
            this.listEditor.setEditable(false);
            this.listEditor.setToolTipText(null);
            this.listEditor.removeActionListener(this.al);
            this.listEditor.setModel(cAllsource);
            this.listEditor.setSelectedItem((String)value);
            this.listEditorValue = (String)value;
            this.activeEditor = this.listEditor;
        } else if ((targetClassz == MondrianGuiDef.VirtualCubeDimension.class || targetClassz == MondrianGuiDef.VirtualCubeMeasure.class) && propertyName.equals("cubeName") || targetClassz == MondrianGuiDef.CubeGrant.class && propertyName.equals("cube")) {
            List<String> source = this.getCubes();
            DefaultComboBoxModel<String> cAllsource = new DefaultComboBoxModel<String>(new Vector<String>(source));
            this.listEditor.setEditable(false);
            this.listEditor.setToolTipText(null);
            this.listEditor.removeActionListener(this.al);
            this.listEditor.setModel(cAllsource);
            this.listEditor.setSelectedItem((String)value);
            this.listEditorValue = (String)value;
            this.activeEditor = this.listEditor;
        } else if (targetClassz == MondrianGuiDef.Dimension.class && propertyName.equals("foreignKey") || targetClassz == MondrianGuiDef.DimensionUsage.class && propertyName.equals("foreignKey") || targetClassz == MondrianGuiDef.Measure.class && propertyName.equals("column")) {
            Vector<String> fks = new Vector<String>(this.jdbcMetaData.getFactTableFKs(selectedFactTableSchema, selectedFactTable));
            fks.add(0, this.getResourceConverter().getString("schemaPropertyCellEditor.allColumns", "<< All Columns >>"));
            Vector<String> allcols = new Vector<String>(this.jdbcMetaData.getAllColumns(selectedFactTableSchema, selectedFactTable));
            DefaultComboBoxModel<String> cFks = new DefaultComboBoxModel<String>(fks);
            this.listEditor.setEditable(true);
            this.listEditor.setToolTipText(null);
            this.listEditor.removeActionListener(this.al);
            if (fks.size() > 1 && propertyName.equals("foreignKey")) {
                allcols.add(0, this.getResourceConverter().getString("schemaPropertyCellEditor.foreignKeys", "<< Foreign keys >>"));
                DefaultComboBoxModel<String> cAllcols = new DefaultComboBoxModel<String>(allcols);
                this.listEditor.setModel(cFks);
                this.selOptions = cFks;
                this.allOptions = cAllcols;
                this.listEditor.addActionListener(this.al);
            } else {
                DefaultComboBoxModel<String> cAllcols = new DefaultComboBoxModel<String>(allcols);
                this.listEditor.setModel(cAllcols);
            }
            this.listEditor.setSelectedItem((String)value);
            this.listEditorValue = (String)value;
            this.activeEditor = this.listEditor;
        } else if (targetClassz == MondrianGuiDef.Hierarchy.class && propertyName.equals("primaryKey")) {
            List<Object> allcols;
            MondrianGuiDef.Hierarchy hProps = (MondrianGuiDef.Hierarchy)((Object)tableModel.getValue());
            String pkTable = hProps.primaryKeyTable;
            String schemaName = null;
            String pk = "";
            MondrianGuiDef.RelationOrJoin relation = hProps.relation;
            if (relation instanceof MondrianGuiDef.Table) {
                pkTable = ((MondrianGuiDef.Table)relation).name;
                schemaName = ((MondrianGuiDef.Table)relation).schema;
                pk = this.jdbcMetaData.getTablePK(schemaName, pkTable);
            } else if (relation instanceof MondrianGuiDef.Join) {
                String[] schemaAndTable = SchemaExplorer.getTableNameForAlias(hProps.relation, pkTable);
                schemaName = schemaAndTable[0];
                pkTable = schemaAndTable[1];
            }
            if (relation instanceof MondrianGuiDef.Table || relation instanceof MondrianGuiDef.Join) {
                allcols = this.jdbcMetaData.getAllColumns(schemaName, pkTable);
                pk = this.jdbcMetaData.getTablePK(schemaName, pkTable);
            } else {
                allcols = Collections.emptyList();
            }
            DefaultComboBoxModel cAllcols = new DefaultComboBoxModel(new Vector(allcols));
            this.listEditor.setEditable(true);
            this.listEditor.setToolTipText(null);
            this.listEditor.removeActionListener(this.al);
            this.listEditor.setModel(cAllcols);
            if (value == null || ((String)value).equals("")) {
                this.listEditor.setSelectedItem(pk);
            } else {
                this.listEditor.setSelectedItem((String)value);
                this.listEditorValue = (String)value;
            }
            this.activeEditor = this.listEditor;
        } else if (targetClassz == MondrianGuiDef.Level.class && propertyName.equals("column") || targetClassz == MondrianGuiDef.Level.class && propertyName.equals("nameColumn") || targetClassz == MondrianGuiDef.Level.class && propertyName.equals("parentColumn") || targetClassz == MondrianGuiDef.Level.class && propertyName.equals("ordinalColumn") || targetClassz == MondrianGuiDef.Level.class && propertyName.equals("captionColumn") || targetClassz == MondrianGuiDef.Closure.class && propertyName.equals("parentColumn") || targetClassz == MondrianGuiDef.Closure.class && propertyName.equals("childColumn") || targetClassz == MondrianGuiDef.Property.class && propertyName.equals("column")) {
            MondrianGuiDef.Level lProps = targetClassz == MondrianGuiDef.Level.class ? (MondrianGuiDef.Level)((Object)tableModel.getValue()) : (MondrianGuiDef.Level)((Object)this.getParentObject());
            String schemaName = null;
            String lTable = lProps.table;
            if (targetClassz == MondrianGuiDef.Level.class && parent != null && parent instanceof MondrianGuiDef.Hierarchy) {
                MondrianGuiDef.RelationOrJoin relation = ((MondrianGuiDef.Hierarchy)((Object)parent)).relation;
                if (relation instanceof MondrianGuiDef.Table) {
                    lTable = ((MondrianGuiDef.Table)relation).name;
                    schemaName = ((MondrianGuiDef.Table)relation).schema;
                } else if (relation instanceof MondrianGuiDef.Join) {
                    String[] schemaAndTable = SchemaExplorer.getTableNameForAlias(relation, lTable);
                    schemaName = schemaAndTable[0];
                    lTable = schemaAndTable[1];
                }
            }
            List<Object> allcols = lTable != null ? this.jdbcMetaData.getAllColumns(schemaName, lTable) : Collections.emptyList();
            DefaultComboBoxModel cAllcols = new DefaultComboBoxModel(new Vector(allcols));
            this.listEditor.setEditable(true);
            this.listEditor.setToolTipText(null);
            this.listEditor.removeActionListener(this.al);
            this.listEditor.setModel(cAllcols);
            this.listEditor.setSelectedItem((String)value);
            this.listEditorValue = (String)value;
            this.activeEditor = this.listEditor;
        } else if (targetClassz == MondrianGuiDef.Property.class && propertyName.equals("type")) {
            this.listEditor.setEditable(false);
            this.listEditor.setToolTipText(null);
            this.listEditor.removeActionListener(this.al);
            this.listEditor.setModel(new DefaultComboBoxModel<String>(MondrianGuiDef.Property._type_values));
            this.listEditor.setSelectedItem((String)value);
            this.activeEditor = this.listEditor;
        } else if (targetClassz == MondrianGuiDef.AggFactCount.class && propertyName.equals("column") || targetClassz == MondrianGuiDef.AggMeasureFactCount.class && propertyName.equals("column") || targetClassz == MondrianGuiDef.AggIgnoreColumn.class && propertyName.equals("column") || targetClassz == MondrianGuiDef.AggLevelProperty.class && propertyName.equals("column") || targetClassz == MondrianGuiDef.AggLevel.class && Arrays.asList("column", "ordinalColumn", "captionColumn", "nameColumn").contains(propertyName) || targetClassz == MondrianGuiDef.AggMeasure.class && propertyName.equals("column") || targetClassz == MondrianGuiDef.AggForeignKey.class && propertyName.equals("factColumn") || targetClassz == MondrianGuiDef.AggForeignKey.class && propertyName.equals("aggColumn")) {
            List<String> allcols = this.jdbcMetaData.getAllColumns(null, null);
            DefaultComboBoxModel<String> cAllcols = new DefaultComboBoxModel<String>(new Vector<String>(allcols));
            this.listEditor.setEditable(true);
            this.listEditor.setToolTipText(null);
            this.listEditor.removeActionListener(this.al);
            this.listEditor.setModel(cAllcols);
            this.listEditor.setSelectedItem((String)value);
            this.listEditorValue = (String)value;
            this.activeEditor = this.listEditor;
        } else if (targetClassz == MondrianGuiDef.Table.class && propertyName.equals("schema")) {
            List<String> allschemas = this.jdbcMetaData.getAllSchemas();
            DefaultComboBoxModel<String> cAllschemas = new DefaultComboBoxModel<String>(new Vector<String>(allschemas));
            this.listEditor.setEditable(true);
            this.listEditor.setToolTipText(null);
            this.listEditor.removeActionListener(this.al);
            this.listEditor.setModel(cAllschemas);
            this.listEditor.setSelectedItem((String)value);
            this.listEditorValue = (String)value;
            this.activeEditor = this.listEditor;
        } else if (currentRelation != null && nonTableRelation && (targetClassz == MondrianGuiDef.Hierarchy.class && propertyName.equals("primaryKeyTable") || targetClassz == MondrianGuiDef.Level.class && propertyName.equals("table"))) {
            this.listEditor.setEditable(false);
            this.listEditor.setToolTipText(null);
            this.listEditor.removeActionListener(this.al);
            this.activeEditor = this.listEditor;
        } else if (targetClassz == MondrianGuiDef.Table.class && propertyName.equals("name") || targetClassz == MondrianGuiDef.Hierarchy.class && propertyName.equals("primaryKeyTable") || targetClassz == MondrianGuiDef.Level.class && propertyName.equals("table")) {
            String schema = "";
            if (targetClassz == MondrianGuiDef.Table.class) {
                MondrianGuiDef.Table tProps = (MondrianGuiDef.Table)((Object)tableModel.getValue());
                schema = tProps.schema;
            }
            Vector<String> factTables = new Vector<String>(this.jdbcMetaData.getFactTables(schema));
            Vector<String> allTablesMinusFact = new Vector<String>(this.jdbcMetaData.getAllTables(schema, selectedFactTable));
            Vector<String> allTables = new Vector<String>(this.jdbcMetaData.getAllTables(schema));
            Vector<String> dimeTables = new Vector<String>(this.jdbcMetaData.getDimensionTables(schema, selectedFactTable));
            DefaultComboBoxModel<String> cFactTables = new DefaultComboBoxModel<String>(factTables);
            DefaultComboBoxModel<String> cAllTables = new DefaultComboBoxModel<String>(allTablesMinusFact.size() > 0 ? allTablesMinusFact : allTables);
            DefaultComboBoxModel<String> cDimeTables = new DefaultComboBoxModel<String>(dimeTables);
            if (targetClassz == MondrianGuiDef.Level.class || targetClassz == MondrianGuiDef.Hierarchy.class) {
                MondrianGuiDef.RelationOrJoin relation = null;
                relation = parent != null && parent instanceof MondrianGuiDef.Hierarchy ? ((MondrianGuiDef.Hierarchy)((Object)parent)).relation : ((MondrianGuiDef.Hierarchy)((Object)tableModel.target)).relation;
                if (relation instanceof MondrianGuiDef.Join) {
                    TreeSet<String> joinTables = new TreeSet<String>();
                    SchemaExplorer.getTableNamesForJoin(relation, joinTables);
                    cAllTables = new DefaultComboBoxModel<String>(new Vector<String>(joinTables));
                }
            }
            this.listEditor.setEditable(true);
            this.listEditor.setToolTipText(null);
            this.listEditor.removeActionListener(this.al);
            this.listEditor.setModel(cAllTables);
            this.allOptions = cAllTables;
            boolean toggleModel = false;
            if (parentClassz == MondrianGuiDef.Cube.class) {
                this.allOptions = cAllTables = new DefaultComboBoxModel<String>(allTables);
                if (factTables.size() > 0) {
                    cFactTables.insertElementAt(this.workbench.getResourceConverter().getString("schemaPropertyCellEditor.allTables", "<< All Tables >>"), 0);
                    cAllTables.insertElementAt(this.workbench.getResourceConverter().getString("schemaPropertyCellEditor.factTables", "<< Fact Tables >>"), 0);
                    this.listEditor.setModel(cFactTables);
                    this.selOptions = cFactTables;
                    toggleModel = true;
                }
            } else if (dimeTables.size() > 0) {
                cDimeTables.insertElementAt(this.workbench.getResourceConverter().getString("schemaPropertyCellEditor.allTables", "<< All Tables >>"), 0);
                cAllTables.insertElementAt(this.workbench.getResourceConverter().getString("schemaPropertyCellEditor.dimensionTables", "<< Dimension Tables >>"), 0);
                this.listEditor.setModel(cDimeTables);
                this.selOptions = cDimeTables;
                toggleModel = true;
            }
            if (toggleModel) {
                this.listEditor.addActionListener(this.al);
            }
            this.listEditor.setSelectedItem((String)value);
            this.listEditorValue = (String)value;
            this.activeEditor = this.listEditor;
            if (targetClassz == MondrianGuiDef.Level.class && propertyName.equals(SchemaExplorer.DEF_LEVEL[1]) && parent != null || targetClassz == MondrianGuiDef.Hierarchy.class && propertyName.equals(SchemaExplorer.DEF_HIERARCHY[7]) && parent != null) {
                MondrianGuiDef.RelationOrJoin relation = null;
                if (parent instanceof MondrianGuiDef.Hierarchy) {
                    relation = ((MondrianGuiDef.Hierarchy)((Object)parent)).relation;
                } else if (parent instanceof MondrianGuiDef.Dimension) {
                    relation = ((MondrianGuiDef.Hierarchy)((Object)tableModel.target)).relation;
                }
                if (relation instanceof MondrianGuiDef.Table) {
                    this.activeEditor = this.stringEditor;
                    this.stringEditor.setText((String)value);
                }
            }
        } else if (propertyName.equals("cdata")) {
            try {
                this.cdataTextArea.read(new StringReader((String)value), null);
            }
            catch (Exception schema) {
                // empty catch block
            }
            this.activeEditor = this.jScrollPaneCDATA;
        } else if (value instanceof String) {
            this.activeEditor = this.stringEditor;
            this.stringEditor.setText((String)value);
        } else if (value instanceof Boolean) {
            this.activeEditor = this.booleanEditor;
            this.booleanEditor.setSelected((Boolean)value);
        } else if (value instanceof Integer) {
            this.activeEditor = this.integerEditor;
            this.integerEditor.setText((String)value);
        } else if (value == null) {
            value = "";
            this.activeEditor = this.stringEditor;
            this.stringEditor.setText((String)value);
        } else if (value.getClass() == MondrianGuiDef.Join.class) {
            SchemaPropertyCellEditor spce = new SchemaPropertyCellEditor(this.workbench);
            this.tableEditor.setDefaultEditor(Object.class, spce);
            SchemaPropertyCellRenderer spcr = new SchemaPropertyCellRenderer(this.workbench);
            this.tableEditor.setDefaultRenderer(Object.class, spcr);
            PropertyTableModel ptm = new PropertyTableModel(this.workbench, value, SchemaExplorer.DEF_JOIN);
            this.tableEditor.setModel(ptm);
            this.activeEditor = this.tableEditor;
        } else {
            if (value.getClass() == MondrianGuiDef.NameExpression.class) {
                return null;
            }
            if (value.getClass() == MondrianGuiDef.RelationOrJoin.class) {
                SchemaPropertyCellEditor spce = new SchemaPropertyCellEditor(this.workbench);
                this.tableEditor.setDefaultEditor(Object.class, spce);
                SchemaPropertyCellRenderer spcr = new SchemaPropertyCellRenderer(this.workbench);
                this.tableEditor.setDefaultRenderer(Object.class, spcr);
                PropertyTableModel ptm = new PropertyTableModel(this.workbench, value, SchemaExplorer.DEF_RELATION);
                this.tableEditor.setModel(ptm);
                this.activeEditor = this.tableEditor;
                return null;
            }
            if (value.getClass() == MondrianGuiDef.OrdinalExpression.class) {
                SchemaPropertyCellEditor spce = new SchemaPropertyCellEditor(this.workbench);
                this.tableEditor.setDefaultEditor(Object.class, spce);
                SchemaPropertyCellRenderer spcr = new SchemaPropertyCellRenderer(this.workbench);
                this.tableEditor.setDefaultRenderer(Object.class, spcr);
                PropertyTableModel ptm = new PropertyTableModel(this.workbench, (Object)((MondrianGuiDef.OrdinalExpression)value).expressions[0], SchemaExplorer.DEF_SQL);
                ptm.setParentTarget(((PropertyTableModel)table.getModel()).target);
                this.tableEditor.setModel(ptm);
                this.activeEditor = this.tableEditor;
            } else if (value.getClass() == MondrianGuiDef.CaptionExpression.class) {
                SchemaPropertyCellEditor spce = new SchemaPropertyCellEditor(this.workbench);
                this.tableEditor.setDefaultEditor(Object.class, spce);
                SchemaPropertyCellRenderer spcr = new SchemaPropertyCellRenderer(this.workbench);
                this.tableEditor.setDefaultRenderer(Object.class, spcr);
                PropertyTableModel ptm = new PropertyTableModel(this.workbench, (Object)((MondrianGuiDef.CaptionExpression)value).expressions[0], SchemaExplorer.DEF_SQL);
                ptm.setParentTarget(((PropertyTableModel)table.getModel()).target);
                this.tableEditor.setModel(ptm);
                this.activeEditor = this.tableEditor;
            } else if (value.getClass() == MondrianGuiDef.Formula.class) {
                SchemaPropertyCellEditor spce = new SchemaPropertyCellEditor(this.workbench, this.jdbcMetaData);
                this.tableEditor.setDefaultEditor(Object.class, spce);
                SchemaPropertyCellRenderer spcr = new SchemaPropertyCellRenderer(this.workbench);
                this.tableEditor.setDefaultRenderer(Object.class, spcr);
                PropertyTableModel ptm = new PropertyTableModel(this.workbench, value, SchemaExplorer.DEF_FORMULA);
                this.tableEditor.setModel(ptm);
                this.tableEditor.getColumnModel().getColumn(0).setMaxWidth(100);
                this.tableEditor.getColumnModel().getColumn(0).setMinWidth(100);
                this.activeEditor = this.tableEditor;
            } else if (value.getClass() == MondrianGuiDef.CalculatedMemberProperty.class) {
                SchemaPropertyCellEditor spce = new SchemaPropertyCellEditor(this.workbench, this.jdbcMetaData);
                this.tableEditor.setDefaultEditor(Object.class, spce);
                SchemaPropertyCellRenderer spcr = new SchemaPropertyCellRenderer(this.workbench);
                this.tableEditor.setDefaultRenderer(Object.class, spcr);
                PropertyTableModel ptm = new PropertyTableModel(this.workbench, value, SchemaExplorer.DEF_CALCULATED_MEMBER_PROPERTY);
                this.tableEditor.setModel(ptm);
                this.tableEditor.getColumnModel().getColumn(0).setMaxWidth(100);
                this.tableEditor.getColumnModel().getColumn(0).setMinWidth(100);
                this.activeEditor = this.tableEditor;
            } else if (value.getClass() == MondrianGuiDef.Table.class) {
                SchemaPropertyCellEditor spce = new SchemaPropertyCellEditor(this.workbench, this.jdbcMetaData);
                for (int i = this.listeners.size() - 1; i >= 0; --i) {
                    spce.addCellEditorListener(this.listeners.get(i));
                }
                this.tableEditor.setDefaultEditor(Object.class, spce);
                SchemaPropertyCellRenderer spcr = new SchemaPropertyCellRenderer(this.workbench);
                this.tableEditor.setDefaultRenderer(Object.class, spcr);
                PropertyTableModel ptm = new PropertyTableModel(this.workbench, value, SchemaExplorer.DEF_TABLE);
                ptm.setFactTable(selectedFactTable);
                if (targetClassz == MondrianGuiDef.Cube.class) {
                    ptm.setParentTarget(((PropertyTableModel)table.getModel()).target);
                }
                this.tableEditor.setModel(ptm);
                this.tableEditor.getColumnModel().getColumn(0).setMaxWidth(100);
                this.tableEditor.getColumnModel().getColumn(0).setMinWidth(100);
                this.activeEditor = this.tableEditor;
            } else if (value.getClass() == MondrianGuiDef.AggFactCount.class) {
                SchemaPropertyCellEditor spce = new SchemaPropertyCellEditor(this.workbench, this.jdbcMetaData);
                for (int i = this.listeners.size() - 1; i >= 0; --i) {
                    spce.addCellEditorListener(this.listeners.get(i));
                }
                this.tableEditor.setDefaultEditor(Object.class, spce);
                SchemaPropertyCellRenderer spcr = new SchemaPropertyCellRenderer(this.workbench);
                this.tableEditor.setDefaultRenderer(Object.class, spcr);
                PropertyTableModel ptm = new PropertyTableModel(this.workbench, value, SchemaExplorer.DEF_AGG_FACT_COUNT);
                ptm.setFactTable(selectedFactTable);
                this.tableEditor.setModel(ptm);
                this.tableEditor.getColumnModel().getColumn(0).setMaxWidth(100);
                this.tableEditor.getColumnModel().getColumn(0).setMinWidth(100);
                this.activeEditor = this.tableEditor;
            } else if (value.getClass() == MondrianGuiDef.Closure.class) {
                SchemaPropertyCellEditor spce = new SchemaPropertyCellEditor(this.workbench, this.jdbcMetaData);
                for (int i = this.listeners.size() - 1; i >= 0; --i) {
                    spce.addCellEditorListener(this.listeners.get(i));
                }
                this.tableEditor.setDefaultEditor(Object.class, spce);
                SchemaPropertyCellRenderer spcr = new SchemaPropertyCellRenderer(this.workbench);
                this.tableEditor.setDefaultRenderer(Object.class, spcr);
                PropertyTableModel ptm = new PropertyTableModel(this.workbench, value, SchemaExplorer.DEF_CLOSURE);
                ptm.setFactTable(selectedFactTable);
                if (targetClassz == MondrianGuiDef.Level.class) {
                    ptm.setParentTarget(((PropertyTableModel)table.getModel()).target);
                }
                this.tableEditor.setModel(ptm);
                this.tableEditor.getColumnModel().getColumn(0).setMaxWidth(100);
                this.tableEditor.getColumnModel().getColumn(0).setMinWidth(100);
                spcr.setTableRendererHeight(this.tableEditor, null);
                this.activeEditor = this.tableEditor;
            } else if (value.getClass() == MondrianGuiDef.Property.class) {
                SchemaPropertyCellEditor spce = new SchemaPropertyCellEditor(this.workbench);
                this.tableEditor.setDefaultEditor(Object.class, spce);
                SchemaPropertyCellRenderer spcr = new SchemaPropertyCellRenderer(this.workbench);
                this.tableEditor.setDefaultRenderer(Object.class, spcr);
                PropertyTableModel ptm = new PropertyTableModel(this.workbench, value, SchemaExplorer.DEF_PROPERTY);
                this.tableEditor.setModel(ptm);
                this.activeEditor = this.tableEditor;
            } else {
                value = "";
                this.activeEditor = this.stringEditor;
                this.stringEditor.setText((String)value);
            }
        }
        this.activeEditor.setVisible(true);
        this.setOriginalValue();
        table.changeSelection(row, column, false, false);
        this.activeEditor.setBackground(new Color(224, 249, 255));
        this.activeEditor.requestFocusInWindow();
        return this.activeEditor;
    }

    private void setOriginalValue() {
        if (this.activeEditor == this.stringEditor) {
            this.originalValue = this.stringEditor.getText();
        } else if (this.activeEditor == this.booleanEditor) {
            this.originalValue = this.booleanEditor.isSelected();
        } else if (this.activeEditor == this.listEditor) {
            if (this.listEditor.isEditable()) {
                this.originalValue = this.listEditor.getEditor().getItem();
            } else {
                if (this.listEditor.getSelectedItem() == this.noSelect) {
                    this.originalValue = null;
                }
                this.originalValue = this.listEditor.getSelectedItem();
            }
        } else if (this.activeEditor == this.tableEditor) {
            this.originalValue = ((PropertyTableModel)this.tableEditor.getModel()).getValue();
        } else if (this.activeEditor == this.jScrollPaneCDATA) {
            StringWriter cdataTextAreaStr = new StringWriter();
            try {
                this.cdataTextArea.write(cdataTextAreaStr);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.originalValue = ((Object)cdataTextAreaStr).toString();
        }
    }

    @Override
    public void addCellEditorListener(CellEditorListener l) {
        this.listeners.add(l);
    }

    @Override
    public void cancelCellEditing() {
        if (this.activeEditor != null) {
            this.activeEditor.setVisible(false);
            this.fireEditingCancelled();
        }
    }

    @Override
    public Object getCellEditorValue() {
        if (this.activeEditor == this.stringEditor) {
            return this.stringEditor.getText();
        }
        if (this.activeEditor == this.booleanEditor) {
            return this.booleanEditor.isSelected();
        }
        if (this.activeEditor == this.listEditor) {
            if (this.listEditor.isEditable()) {
                return this.listEditor.getEditor().getItem();
            }
            if (this.listEditor.getSelectedItem() == this.noSelect) {
                return null;
            }
            return this.listEditor.getSelectedItem();
        }
        if (this.activeEditor == this.tableEditor) {
            return ((PropertyTableModel)this.tableEditor.getModel()).getValue();
        }
        if (this.activeEditor == this.jScrollPaneCDATA) {
            StringWriter cdataTextAreaStr = new StringWriter();
            try {
                this.cdataTextArea.write(cdataTextAreaStr);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return ((Object)cdataTextAreaStr).toString();
        }
        return null;
    }

    @Override
    public boolean isCellEditable(EventObject anEvent) {
        return true;
    }

    @Override
    public void removeCellEditorListener(CellEditorListener l) {
        this.listeners.remove(l);
    }

    @Override
    public boolean shouldSelectCell(EventObject anEvent) {
        return true;
    }

    @Override
    public boolean stopCellEditing() {
        if (this.activeEditor != null) {
            if (this.activeEditor == this.tableEditor && this.tableEditor.isEditing()) {
                ArrayList<JTable> nestedTableEditors = new ArrayList<JTable>();
                JTable nestedTableEditor = this.tableEditor;
                while (nestedTableEditor != null) {
                    nestedTableEditors.add(nestedTableEditor);
                    SchemaPropertyCellEditor sce = (SchemaPropertyCellEditor)nestedTableEditor.getCellEditor();
                    if (sce != null && sce.activeEditor == sce.tableEditor && sce.tableEditor.isEditing()) {
                        nestedTableEditor = sce.tableEditor;
                        continue;
                    }
                    nestedTableEditor = null;
                }
                for (int i = nestedTableEditors.size() - 1; i >= 0; --i) {
                    ((JTable)nestedTableEditors.get(i)).editingStopped(null);
                }
            }
            this.activeEditor.setVisible(false);
            this.fireEditingStopped();
        }
        return true;
    }

    protected void fireEditingStopped() {
        ChangeEvent ce = new ChangeEvent(this);
        for (int i = this.listeners.size() - 1; i >= 0; --i) {
            this.listeners.get(i).editingStopped(ce);
        }
    }

    protected void fireEditingCancelled() {
        ChangeEvent ce = new ChangeEvent(this);
        for (int i = this.listeners.size() - 1; i >= 0; --i) {
            this.listeners.get(i).editingCanceled(ce);
        }
    }

    private List<String> getUdfs() {
        ArrayList<String> udfs = new ArrayList<String>();
        MondrianGuiDef.Schema s = this.getSchema();
        if (s != null) {
            MondrianGuiDef.UserDefinedFunction[] u = s.userDefinedFunctions;
            for (int i = 0; i < u.length; ++i) {
                if (u[i].className == null || udfs.contains(u[i].className)) continue;
                udfs.add(u[i].className);
            }
        }
        return udfs;
    }

    private List<String> getFormatStrings() {
        ArrayList<String> fs = new ArrayList<String>();
        MondrianGuiDef.Schema s = this.getSchema();
        if (s != null) {
            MondrianGuiDef.Cube[] c = s.cubes;
            for (int i = 0; i < c.length; ++i) {
                MondrianGuiDef.Measure[] m = c[i].measures;
                for (int j = 0; j < m.length; ++j) {
                    if (m[j].formatString == null || fs.contains(m[j].formatString)) continue;
                    fs.add(m[j].formatString);
                }
            }
        }
        return fs;
    }

    private MondrianGuiDef.Schema getSchema() {
        SchemaExplorer se = this.getSchemaExplorer();
        return se == null ? null : se.getSchema();
    }

    private Object getParentObject() {
        SchemaExplorer se = this.getSchemaExplorer();
        if (se != null) {
            Object po = se.getParentObject();
            return po;
        }
        return null;
    }

    private SchemaExplorer getSchemaExplorer() {
        for (int i = this.listeners.size() - 1; i >= 0; --i) {
            CellEditorListener cel = this.listeners.get(i);
            if (!(cel instanceof SchemaExplorer)) continue;
            return (SchemaExplorer)cel;
        }
        return null;
    }

    private List<String> getSource() {
        ArrayList<String> source = new ArrayList<String>();
        MondrianGuiDef.Schema s = this.getSchema();
        if (s != null) {
            MondrianGuiDef.Dimension[] u = s.dimensions;
            for (int i = 0; i < u.length; ++i) {
                source.add(u[i].name);
            }
        }
        return source;
    }

    private List<String> getCubes() {
        ArrayList<String> source = new ArrayList<String>();
        MondrianGuiDef.Schema s = this.getSchema();
        if (s != null) {
            MondrianGuiDef.Cube[] u = s.cubes;
            for (int i = 0; i < u.length; ++i) {
                source.add(u[i].name);
            }
        }
        return source;
    }

    private void generatePrimaryKeyTables(Object relation, List<String> v) {
        if (relation == null) {
            return;
        }
        if (relation instanceof MondrianGuiDef.Table) {
            String sname = ((MondrianGuiDef.Table)((Object)relation)).schema;
            v.add((sname == null || sname.equals("") ? "" : sname + "->") + ((MondrianGuiDef.Table)((Object)relation)).name);
            return;
        }
        MondrianGuiDef.Join currentJoin = (MondrianGuiDef.Join)((Object)relation);
        this.generatePrimaryKeyTables((Object)currentJoin.left, v);
        this.generatePrimaryKeyTables((Object)currentJoin.right, v);
    }

    private List<String> getDimensions() {
        ArrayList<String> dims = new ArrayList<String>();
        Object po = this.getParentObject();
        if (po != null) {
            MondrianGuiDef.Schema s;
            MondrianGuiDef.CubeGrant parent = (MondrianGuiDef.CubeGrant)po;
            if (parent.cube != null && !parent.cube.equals("") && (s = this.getSchema()) != null) {
                for (int i = 0; i < s.cubes.length; ++i) {
                    if (!s.cubes[i].name.equals(parent.cube)) continue;
                    dims.add("Measures");
                    for (int j = 0; j < s.cubes[i].dimensions.length; ++j) {
                        dims.add(s.cubes[i].dimensions[j].name);
                    }
                    break;
                }
            }
        }
        return dims;
    }

    private List<String> getHierarchies() {
        ArrayList<String> hiers = new ArrayList<String>();
        Object po = this.getParentObject();
        if (po != null) {
            MondrianGuiDef.Schema s;
            MondrianGuiDef.CubeGrant parent = (MondrianGuiDef.CubeGrant)po;
            if (parent.cube != null && !parent.cube.equals("") && (s = this.getSchema()) != null) {
                for (int i = 0; i < s.cubes.length; ++i) {
                    if (!s.cubes[i].name.equals(parent.cube)) continue;
                    for (int j = 0; j < s.cubes[i].dimensions.length; ++j) {
                        MondrianGuiDef.Dimension sharedDim = SchemaPropertyCellEditor.lookupDimension(s, s.cubes[i].dimensions[j]);
                        NodeDef[] children = sharedDim.getChildren();
                        for (int k = 0; k < children.length; ++k) {
                            if (!(children[k] instanceof MondrianGuiDef.Hierarchy)) continue;
                            String hname = ((MondrianGuiDef.Hierarchy)children[k]).name;
                            if (hname != null) {
                                if (MondrianProperties.instance().SsasCompatibleNaming.get()) {
                                    hiers.add(Util.quoteMdxIdentifier((String)s.cubes[i].dimensions[j].name) + "." + Util.quoteMdxIdentifier((String)hname));
                                    continue;
                                }
                                hiers.add(Util.quoteMdxIdentifier((String)(s.cubes[i].dimensions[j].name + "." + hname)));
                                continue;
                            }
                            hiers.add(Util.quoteMdxIdentifier((String)s.cubes[i].dimensions[j].name));
                        }
                    }
                    break;
                }
            }
        }
        return hiers;
    }

    private List<String> getLevels(String hierarchy) {
        Object po;
        String data;
        if (hierarchy == null || hierarchy.equals("")) {
            return this.hlevels;
        }
        List segments = Util.parseIdentifier((String)hierarchy);
        if (segments == null || segments.size() == 0) {
            return this.hlevels;
        }
        if (!MondrianProperties.instance().SsasCompatibleNaming.get() && (data = ((Id.NameSegment)segments.get(0)).getName()).indexOf(".") >= 0) {
            Id.Segment segment = (Id.Segment)segments.get(0);
            segments.clear();
            segments.add(new Id.NameSegment(data.substring(0, data.indexOf(".")), segment.getQuoting()));
            segments.add(new Id.NameSegment(data.substring(data.indexOf(".") + 1), segment.getQuoting()));
        }
        if ((po = this.getParentObject()) == null) {
            return this.hlevels;
        }
        MondrianGuiDef.CubeGrant parent = (MondrianGuiDef.CubeGrant)po;
        if (parent.cube == null || parent.cube.equals("")) {
            return this.hlevels;
        }
        if (this.cacheCube.equals(parent.cube) && this.cacheHierarchy.equals(hierarchy)) {
            return this.hlevels;
        }
        this.hlevels = new ArrayList<String>();
        this.cacheCube = parent.cube;
        this.cacheHierarchy = hierarchy;
        MondrianGuiDef.Schema s = this.getSchema();
        if (s == null) {
            return this.hlevels;
        }
        for (int i = 0; i < s.cubes.length; ++i) {
            MondrianGuiDef.Cube cube = s.cubes[i];
            if (!cube.name.equals(parent.cube)) continue;
            for (int j = 0; j < cube.dimensions.length; ++j) {
                int k;
                MondrianGuiDef.CubeDimension dimension = cube.dimensions[j];
                if (!((Id.Segment)segments.get(0)).matches(dimension.name)) continue;
                MondrianGuiDef.Dimension d = SchemaPropertyCellEditor.lookupDimension(s, dimension);
                NodeDef[] children = d.getChildren();
                MondrianGuiDef.Hierarchy hierarchyObj = null;
                for (k = 0; k < children.length; ++k) {
                    if (!(children[k] instanceof MondrianGuiDef.Hierarchy) || (segments.size() != 1 || ((MondrianGuiDef.Hierarchy)children[k]).name != null) && (segments.size() == 0 || !((Id.Segment)segments.get(1)).matches(((MondrianGuiDef.Hierarchy)children[k]).name))) continue;
                    hierarchyObj = (MondrianGuiDef.Hierarchy)children[k];
                    break;
                }
                if (hierarchyObj == null) continue;
                for (k = 0; k < hierarchyObj.levels.length; ++k) {
                    this.hlevels.add(hierarchy + "." + Util.quoteMdxIdentifier((String)hierarchyObj.levels[k].name));
                }
            }
            break;
        }
        return this.hlevels;
    }

    private static MondrianGuiDef.Dimension lookupDimension(MondrianGuiDef.Schema schema, MondrianGuiDef.CubeDimension cubeDimension) {
        if (cubeDimension instanceof MondrianGuiDef.Dimension) {
            return (MondrianGuiDef.Dimension)cubeDimension;
        }
        MondrianGuiDef.DimensionUsage dimensionUsage = (MondrianGuiDef.DimensionUsage)cubeDimension;
        for (int m = 0; m < schema.dimensions.length; ++m) {
            MondrianGuiDef.Dimension dimension = schema.dimensions[m];
            if (!dimension.name.equals(dimensionUsage.source)) continue;
            return dimension;
        }
        return null;
    }

    private I18n getResourceConverter() {
        return this.workbench.getResourceConverter();
    }

    public void setMetaData(JdbcMetaData jdbcMetaData) {
        this.jdbcMetaData = jdbcMetaData;
    }
}

