/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.metaverse.api;

import java.util.Map;
import java.util.UUID;
import org.pentaho.dictionary.DictionaryConst;
import org.pentaho.dictionary.MetaverseLink;
import org.pentaho.dictionary.MetaverseTransientNode;
import org.pentaho.metaverse.api.IDocument;
import org.pentaho.metaverse.api.ILogicalIdGenerator;
import org.pentaho.metaverse.api.IMetaverseLink;
import org.pentaho.metaverse.api.IMetaverseNode;
import org.pentaho.metaverse.api.IMetaverseObjectFactory;
import org.pentaho.metaverse.api.INamespace;
import org.pentaho.metaverse.api.MetaverseDocument;

public class MetaverseObjectFactory
implements IMetaverseObjectFactory {
    @Override
    public IDocument createDocumentObject() {
        return new MetaverseDocument();
    }

    @Override
    public IMetaverseLink createLinkObject() {
        return new MetaverseLink();
    }

    @Override
    public IMetaverseNode createNodeObject(String id) {
        MetaverseTransientNode node = new MetaverseTransientNode();
        node.setStringID(id);
        node.setLogicalIdGenerator(DictionaryConst.LOGICAL_ID_GENERATOR_DEFAULT);
        node.setProperty("virtual", true);
        return node;
    }

    @Override
    public IMetaverseNode createNodeObject(String id, String name, String type) {
        IMetaverseNode node = this.createNodeObject(id);
        node.setName(name);
        node.setType(type);
        return node;
    }

    @Override
    public IMetaverseNode createNodeObject(INamespace namespace, String name, String type) {
        IMetaverseNode node = this.createNodeObject(UUID.randomUUID().toString(), name, type);
        node.setProperty("namespace", namespace.getNamespaceId());
        return node;
    }

    @Override
    public IMetaverseNode createNodeObject(INamespace namespace, ILogicalIdGenerator idGenerator, Map<String, Object> properties) {
        MetaverseTransientNode node = new MetaverseTransientNode();
        node.setProperties(properties);
        node.setProperty("namespace", namespace.getNamespaceId());
        node.setLogicalIdGenerator(idGenerator);
        node.setProperty("virtual", true);
        String id = node.getLogicalId();
        node.setStringID(id);
        return node;
    }
}

