/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.http;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class HttpConfig {
    private static Policy policy;

    public static void setPolicy(Policy policy) {
        HttpConfig.policy = policy;
    }

    public static boolean isSecure() {
        return policy == Policy.HTTPS_ONLY;
    }

    public static String getSchemePrefix() {
        return HttpConfig.isSecure() ? "https://" : "http://";
    }

    public static String getScheme(Policy policy) {
        return policy == Policy.HTTPS_ONLY ? "https://" : "http://";
    }

    static {
        Configuration conf = new Configuration();
        boolean sslEnabled = conf.getBoolean("hadoop.ssl.enabled", false);
        policy = sslEnabled ? Policy.HTTPS_ONLY : Policy.HTTP_ONLY;
    }

    public static enum Policy {
        HTTP_ONLY,
        HTTPS_ONLY,
        HTTP_AND_HTTPS;

        private static final Policy[] VALUES;

        public static Policy fromString(String value) {
            for (Policy p : VALUES) {
                if (!p.name().equalsIgnoreCase(value)) continue;
                return p;
            }
            return null;
        }

        public boolean isHttpEnabled() {
            return this == HTTP_ONLY || this == HTTP_AND_HTTPS;
        }

        public boolean isHttpsEnabled() {
            return this == HTTPS_ONLY || this == HTTP_AND_HTTPS;
        }

        static {
            VALUES = Policy.values();
        }
    }
}

