/*
 * Decompiled with CFR 0.152.
 */
package com.pentaho.big.data.bundles.impl.shim.hdfs;

import com.pentaho.big.data.bundles.impl.shim.common.ShimBridgingServiceTracker;
import com.pentaho.big.data.bundles.impl.shim.hdfs.HadoopFileSystemFactoryImpl;
import java.util.Properties;
import org.osgi.framework.BundleContext;
import org.pentaho.bigdata.api.hdfs.HadoopFileSystemFactory;
import org.pentaho.di.core.hadoop.HadoopConfigurationBootstrap;
import org.pentaho.di.core.hadoop.HadoopConfigurationListener;
import org.pentaho.hadoop.shim.ConfigurationException;
import org.pentaho.hadoop.shim.HadoopConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HadoopFileSystemFactoryLoader
implements HadoopConfigurationListener {
    public static final String HADOOP_FILESYSTEM_FACTORY_IMPL_CANONICAL_NAME = HadoopFileSystemFactoryImpl.class.getCanonicalName();
    private static final Logger LOGGER = LoggerFactory.getLogger(HadoopFileSystemFactoryLoader.class);
    private final BundleContext bundleContext;
    private final ShimBridgingServiceTracker shimBridgingServiceTracker;

    public HadoopFileSystemFactoryLoader(BundleContext bundleContext, ShimBridgingServiceTracker shimBridgingServiceTracker) throws ConfigurationException {
        this(bundleContext, shimBridgingServiceTracker, HadoopConfigurationBootstrap.getInstance());
    }

    public HadoopFileSystemFactoryLoader(BundleContext bundleContext, ShimBridgingServiceTracker shimBridgingServiceTracker, HadoopConfigurationBootstrap hadoopConfigurationBootstrap) throws ConfigurationException {
        this.bundleContext = bundleContext;
        this.shimBridgingServiceTracker = shimBridgingServiceTracker;
        hadoopConfigurationBootstrap.registerHadoopConfigurationListener((HadoopConfigurationListener)this);
    }

    public void onConfigurationOpen(HadoopConfiguration hadoopConfiguration, boolean defaultConfiguration) {
        try {
            String scheme = "hdfs";
            Properties configProperties = hadoopConfiguration.getConfigProperties();
            if (configProperties != null) {
                scheme = configProperties.getProperty("scheme", "hdfs");
            }
            this.shimBridgingServiceTracker.registerWithClassloader((Object)hadoopConfiguration, HadoopFileSystemFactory.class, HADOOP_FILESYSTEM_FACTORY_IMPL_CANONICAL_NAME, this.bundleContext, hadoopConfiguration.getHadoopShim().getClass().getClassLoader(), new Class[]{Boolean.TYPE, HadoopConfiguration.class, String.class}, new Object[]{defaultConfiguration, hadoopConfiguration, scheme});
        }
        catch (Exception e) {
            LOGGER.error("Unable to register " + hadoopConfiguration.getIdentifier() + " shim", (Throwable)e);
        }
    }

    public void onConfigurationClose(HadoopConfiguration hadoopConfiguration) {
        this.shimBridgingServiceTracker.unregister((Object)hadoopConfiguration);
    }

    public void onClassLoaderAvailable(ClassLoader classLoader) {
    }
}

