/*
 * Decompiled with CFR 0.152.
 */
package com.pentaho.big.data.bundles.impl.shim.hdfs;

import java.net.URI;
import org.apache.hadoop.fs.Path;
import org.pentaho.bigdata.api.hdfs.HadoopFileSystemPath;

public class HadoopFileSystemPathImpl
implements HadoopFileSystemPath {
    private final Path path;

    public HadoopFileSystemPathImpl(Path path) {
        this.path = path;
    }

    public static HadoopFileSystemPathImpl toHadoopFileSystemPathImpl(HadoopFileSystemPath hadoopFileSystemPath) {
        if (hadoopFileSystemPath instanceof HadoopFileSystemPathImpl) {
            return (HadoopFileSystemPathImpl)hadoopFileSystemPath;
        }
        if (hadoopFileSystemPath == null) {
            return null;
        }
        return new HadoopFileSystemPathImpl(new Path(hadoopFileSystemPath.toString()));
    }

    public String getPath() {
        return this.path.toUri().getPath();
    }

    public String getName() {
        return this.path.getName();
    }

    public String toString() {
        return this.path.toString();
    }

    public URI toUri() {
        return this.path.toUri();
    }

    public HadoopFileSystemPath resolve(HadoopFileSystemPath child) {
        return new HadoopFileSystemPathImpl(new Path(this.path, HadoopFileSystemPathImpl.toHadoopFileSystemPathImpl(child).getRawPath()));
    }

    public HadoopFileSystemPath resolve(String child) {
        return new HadoopFileSystemPathImpl(new Path(this.path, child));
    }

    public HadoopFileSystemPath getParent() {
        return new HadoopFileSystemPathImpl(this.path.getParent());
    }

    public Path getRawPath() {
        return this.path;
    }
}

