/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.ra;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.jms.JMSException;
import javax.jms.ServerSession;
import javax.jms.ServerSessionPool;
import javax.jms.Session;
import javax.resource.spi.UnavailableException;
import javax.resource.spi.endpoint.MessageEndpoint;
import javax.transaction.xa.XAResource;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.ActiveMQQueueSession;
import org.apache.activemq.ActiveMQSession;
import org.apache.activemq.ActiveMQTopicSession;
import org.apache.activemq.command.MessageDispatch;
import org.apache.activemq.ra.ActiveMQEndpointWorker;
import org.apache.activemq.ra.LocalAndXATransaction;
import org.apache.activemq.ra.MessageActivationSpec;
import org.apache.activemq.ra.MessageEndpointProxy;
import org.apache.activemq.ra.ServerSessionImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerSessionPoolImpl
implements ServerSessionPool {
    private static final Logger LOG = LoggerFactory.getLogger(ServerSessionPoolImpl.class);
    private final ActiveMQEndpointWorker activeMQAsfEndpointWorker;
    private final int maxSessions;
    private final List<ServerSessionImpl> idleSessions = new ArrayList<ServerSessionImpl>();
    private final List<ServerSessionImpl> activeSessions = new ArrayList<ServerSessionImpl>();
    private final Lock sessionLock = new ReentrantLock();
    private final AtomicBoolean closing = new AtomicBoolean(false);

    public ServerSessionPoolImpl(ActiveMQEndpointWorker activeMQAsfEndpointWorker, int maxSessions) {
        this.activeMQAsfEndpointWorker = activeMQAsfEndpointWorker;
        this.maxSessions = maxSessions;
    }

    private ServerSessionImpl createServerSessionImpl() throws JMSException {
        MessageActivationSpec activationSpec = this.activeMQAsfEndpointWorker.endpointActivationKey.getActivationSpec();
        int acknowledge2 = this.activeMQAsfEndpointWorker.transacted ? 0 : activationSpec.getAcknowledgeModeForSession();
        ActiveMQConnection connection = this.activeMQAsfEndpointWorker.getConnection();
        if (connection == null) {
            return null;
        }
        ActiveMQSession session = (ActiveMQSession)connection.createSession(this.activeMQAsfEndpointWorker.transacted, acknowledge2);
        try {
            int batchSize = 0;
            if (activationSpec.getEnableBatchBooleanValue()) {
                batchSize = activationSpec.getMaxMessagesPerBatchIntValue();
            }
            if (activationSpec.isUseRAManagedTransactionEnabled()) {
                MessageEndpoint endpoint = this.createEndpoint(null);
                return new ServerSessionImpl(this, session, this.activeMQAsfEndpointWorker.workManager, endpoint, true, batchSize);
            }
            MessageEndpoint endpoint = this.createEndpoint(new LocalAndXATransaction(session.getTransactionContext()));
            return new ServerSessionImpl(this, session, this.activeMQAsfEndpointWorker.workManager, endpoint, false, batchSize);
        }
        catch (UnavailableException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Could not create an endpoint.", (Throwable)e);
            }
            session.close();
            return null;
        }
    }

    private MessageEndpoint createEndpoint(LocalAndXATransaction txResourceProxy) throws UnavailableException {
        MessageEndpoint endpoint = this.activeMQAsfEndpointWorker.endpointFactory.createEndpoint((XAResource)txResourceProxy);
        MessageEndpointProxy endpointProxy = new MessageEndpointProxy(endpoint);
        return endpointProxy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServerSession getServerSession() throws JMSException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("ServerSession requested.");
        }
        if (this.closing.get()) {
            throw new JMSException("Session Pool Shutting Down.");
        }
        ServerSessionImpl ss = null;
        this.sessionLock.lock();
        try {
            ss = this.getExistingServerSession(false);
        }
        finally {
            this.sessionLock.unlock();
        }
        if (ss != null) {
            return ss;
        }
        ss = this.createServerSessionImpl();
        this.sessionLock.lock();
        try {
            if (ss == null) {
                if (this.activeSessions.isEmpty() && this.idleSessions.isEmpty()) {
                    throw new JMSException("Endpoint factory did not allow creation of any endpoints.");
                }
                ss = this.getExistingServerSession(true);
            } else {
                this.activeSessions.add(ss);
            }
        }
        finally {
            this.sessionLock.unlock();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Created a new session: " + ss);
        }
        return ss;
    }

    private ServerSessionImpl getExistingServerSession(boolean force2) {
        ServerSessionImpl ss = null;
        if (this.idleSessions.size() > 0) {
            ss = this.idleSessions.remove(this.idleSessions.size() - 1);
        }
        if (ss != null) {
            this.activeSessions.add(ss);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Using idle session: " + ss);
            }
        } else if (force2 || this.activeSessions.size() >= this.maxSessions) {
            ss = this.getExistingActiveServerSession();
        }
        return ss;
    }

    private ServerSessionImpl getExistingActiveServerSession() {
        ServerSessionImpl ss = null;
        if (!this.activeSessions.isEmpty()) {
            if (this.activeSessions.size() > 1) {
                ss = this.activeSessions.remove(0);
                this.activeSessions.add(ss);
            } else {
                ss = this.activeSessions.get(0);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Reusing an active session: " + ss);
        }
        return ss;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void returnToPool(ServerSessionImpl ss) {
        this.sessionLock.lock();
        this.activeSessions.remove(ss);
        try {
            if (ss.isStale()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Discarding stale ServerSession to be returned to pool: " + ss);
                }
                ss.close();
            } else {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("ServerSession returned to pool: " + ss);
                }
                this.idleSessions.add(ss);
            }
        }
        finally {
            this.sessionLock.unlock();
        }
        AtomicBoolean atomicBoolean = this.closing;
        synchronized (atomicBoolean) {
            this.closing.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFromPool(ServerSessionImpl ss) {
        this.sessionLock.lock();
        try {
            this.activeSessions.remove(ss);
        }
        finally {
            this.sessionLock.unlock();
        }
        try {
            ActiveMQSession session = (ActiveMQSession)ss.getSession();
            List<MessageDispatch> l = session.getUnconsumedMessages();
            if (!l.isEmpty()) {
                ActiveMQConnection connection = this.activeMQAsfEndpointWorker.getConnection();
                if (connection != null) {
                    for (MessageDispatch md : l) {
                        if (connection.hasDispatcher(md.getConsumerId())) {
                            this.dispatchToSession(md);
                            LOG.trace("on remove of {} redispatch of {}", (Object)session, (Object)md);
                            continue;
                        }
                        LOG.trace("on remove not redispatching {}, dispatcher no longer present on {}", (Object)md, (Object)session.getConnection());
                    }
                } else {
                    LOG.trace("on remove of {} not redispatching while disconnected", (Object)session);
                }
            }
        }
        catch (Throwable t) {
            LOG.error("Error redispatching unconsumed messages from stale server session {}", (Object)ss, (Object)t);
        }
        ss.close();
        AtomicBoolean atomicBoolean = this.closing;
        synchronized (atomicBoolean) {
            this.closing.notify();
        }
    }

    private void dispatchToSession(MessageDispatch messageDispatch) throws JMSException {
        ServerSession serverSession = this.getServerSession();
        Session s = serverSession.getSession();
        ActiveMQSession session = null;
        if (s instanceof ActiveMQSession) {
            session = (ActiveMQSession)s;
        } else if (s instanceof ActiveMQQueueSession) {
            session = (ActiveMQSession)s;
        } else if (s instanceof ActiveMQTopicSession) {
            session = (ActiveMQSession)s;
        } else {
            this.activeMQAsfEndpointWorker.getConnection().onAsyncException(new JMSException("Session pool provided an invalid session type: " + s.getClass()));
        }
        session.dispatch(messageDispatch);
        serverSession.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        this.closing.set(true);
        int activeCount = this.closeSessions();
        while (activeCount > 0) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Active Sessions = " + activeCount);
            }
            try {
                AtomicBoolean atomicBoolean = this.closing;
                synchronized (atomicBoolean) {
                    this.closing.wait(250L);
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return;
            }
            activeCount = this.closeSessions();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int closeSessions() {
        this.sessionLock.lock();
        try {
            for (ServerSessionImpl ss : this.activeSessions) {
                try {
                    ActiveMQSession session = (ActiveMQSession)ss.getSession();
                    if (session.isClosed()) continue;
                    session.close();
                }
                catch (JMSException ignored) {
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug("Failed to close active running server session {}, reason:{}", new Object[]{ss, ignored.toString(), ignored});
                }
            }
            for (ServerSessionImpl ss : this.idleSessions) {
                ss.close();
            }
            this.idleSessions.clear();
            int n = this.activeSessions.size();
            return n;
        }
        finally {
            this.sessionLock.unlock();
        }
    }

    public boolean isClosing() {
        return this.closing.get();
    }

    public void setClosing(boolean closing) {
        this.closing.set(closing);
    }
}

