/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.jdbc.translators;

import com.sap.dbtech.jdbc.exceptions.ValueOverflow;
import com.sap.dbtech.jdbc.packet.DataPart;
import com.sap.dbtech.jdbc.translators.DBTechTranslator;
import com.sap.dbtech.jdbc.translators.SQLParamController;
import com.sap.dbtech.util.StringUtil;
import com.sap.dbtech.util.StructuredMem;
import com.sap.dbtech.vsp00.DataType;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;

abstract class CharDataTranslator
extends DBTechTranslator {
    protected static final byte[] HighTime_C = new byte[]{48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 49, 49, 49, 49, 49, 49, 49, 49, 49, 49, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 51, 51};
    protected static final byte[] LowTime_C = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49};

    protected CharDataTranslator(int n, int n2, int n3, int n4, int n5, int n6) {
        super(n, n2, n3, n4, n5, n6);
    }

    public boolean isCaseSensitive() {
        return true;
    }

    protected void putSpecific(DataPart dataPart, Object object) throws SQLException {
        byte[] byArray = StringUtil.bytes_iso8859_1(object.toString());
        if (byArray.length > this.physicalLength - 1) {
            throw new ValueOverflow(DataType.stringValuesC[this.dataType], -1);
        }
        dataPart.putInt1(32, this.bufpos - 1);
        dataPart.putStringBytes(byArray, this.bufpos, this.physicalLength - 1);
    }

    public Date getDate(SQLParamController sQLParamController, StructuredMem structuredMem, Calendar calendar) throws SQLException {
        String string = this.getString(sQLParamController, structuredMem);
        if (string == null) {
            return null;
        }
        try {
            Date date = Date.valueOf(string);
            if (calendar == null) {
                return date;
            }
            calendar.setTime(date);
            return DBTechTranslator.CalendarUtil.getDateFromCalendar(calendar);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            try {
                Timestamp timestamp = Timestamp.valueOf(string);
                if (calendar == null) {
                    return new Date(timestamp.getTime());
                }
                calendar.setTime(timestamp);
                return DBTechTranslator.CalendarUtil.getDateFromCalendar(calendar);
            }
            catch (IllegalArgumentException illegalArgumentException2) {
                throw this.newParseException(string, "Date");
            }
        }
    }

    public Time getTime(SQLParamController sQLParamController, StructuredMem structuredMem, Calendar calendar) throws SQLException {
        String string = this.getString(sQLParamController, structuredMem);
        if (string == null) {
            return null;
        }
        try {
            Time time = Time.valueOf(string);
            if (calendar == null) {
                return time;
            }
            calendar.setTime(time);
            return DBTechTranslator.CalendarUtil.getTimeFromCalendar(calendar);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            try {
                Timestamp timestamp = Timestamp.valueOf(string);
                if (calendar == null) {
                    return new Time(timestamp.getTime());
                }
                calendar.setTime(timestamp);
                return DBTechTranslator.CalendarUtil.getTimeFromCalendar(calendar);
            }
            catch (IllegalArgumentException illegalArgumentException2) {
                throw this.newParseException(string, "Time");
            }
        }
    }

    public Timestamp getTimestamp(SQLParamController sQLParamController, StructuredMem structuredMem, Calendar calendar) throws SQLException {
        String string = this.getString(sQLParamController, structuredMem);
        if (string == null) {
            return null;
        }
        try {
            Timestamp timestamp = Timestamp.valueOf(string);
            if (calendar == null) {
                return timestamp;
            }
            calendar.setTime(timestamp);
            return DBTechTranslator.CalendarUtil.getTimestampFromCalendar(calendar, timestamp.getNanos());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            try {
                Date date = Date.valueOf(string);
                if (calendar == null) {
                    return new Timestamp(date.getTime());
                }
                calendar.setTime(date);
                return DBTechTranslator.CalendarUtil.getTimestampFromCalendar(calendar, 0);
            }
            catch (IllegalArgumentException illegalArgumentException2) {
                throw this.newParseException(string, "Timestamp");
            }
        }
    }
}

