/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v23.message;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v23.group.MFN_M06_MF_CLIN_STUDY;
import ca.uhn.hl7v2.model.v23.segment.MFI;
import ca.uhn.hl7v2.model.v23.segment.MSH;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.log.HapiLogFactory;

public class MFN_M06
extends AbstractMessage {
    public MFN_M06(ModelClassFactory factory) {
        super(factory);
        this.init(factory);
    }

    public MFN_M06() {
        super((ModelClassFactory)new DefaultModelClassFactory());
        this.init((ModelClassFactory)new DefaultModelClassFactory());
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MSH.class, true, false);
            this.add(MFI.class, true, false);
            this.add(MFN_M06_MF_CLIN_STUDY.class, true, true);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error creating MFN_M06 - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.3";
    }

    public MSH getMSH() {
        MSH ret = null;
        try {
            ret = (MSH)this.get("MSH");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public MFI getMFI() {
        MFI ret = null;
        try {
            ret = (MFI)this.get("MFI");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public MFN_M06_MF_CLIN_STUDY getMF_CLIN_STUDY() {
        MFN_M06_MF_CLIN_STUDY ret = null;
        try {
            ret = (MFN_M06_MF_CLIN_STUDY)this.get("MF_CLIN_STUDY");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public MFN_M06_MF_CLIN_STUDY getMF_CLIN_STUDY(int rep) {
        MFN_M06_MF_CLIN_STUDY ret = null;
        try {
            ret = (MFN_M06_MF_CLIN_STUDY)this.get("MF_CLIN_STUDY", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getMF_CLIN_STUDYReps() {
        int reps = -1;
        try {
            reps = this.getAll("MF_CLIN_STUDY").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertMF_CLIN_STUDY(MFN_M06_MF_CLIN_STUDY structure, int rep) throws HL7Exception {
        super.insertRepetition("MF_CLIN_STUDY", (Structure)structure, rep);
    }

    public MFN_M06_MF_CLIN_STUDY insertMF_CLIN_STUDY(int rep) throws HL7Exception {
        return (MFN_M06_MF_CLIN_STUDY)super.insertRepetition("MF_CLIN_STUDY", rep);
    }

    public MFN_M06_MF_CLIN_STUDY removeMF_CLIN_STUDY(int rep) throws HL7Exception {
        return (MFN_M06_MF_CLIN_STUDY)super.removeRepetition("MF_CLIN_STUDY", rep);
    }
}

