/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.daemon.impl.comparator;

import org.apache.hadoop.hive.llap.daemon.impl.TaskRunnerCallable;
import org.apache.hadoop.hive.llap.daemon.impl.comparator.LlapQueueComparatorBase;
import org.apache.hadoop.hive.llap.daemon.rpc.LlapDaemonProtocolProtos;

public class FirstInFirstOutComparator
extends LlapQueueComparatorBase {
    @Override
    public int compareInternal(TaskRunnerCallable o1, TaskRunnerCallable o2) {
        int knownPending2;
        LlapDaemonProtocolProtos.FragmentRuntimeInfo fri1 = o1.getFragmentRuntimeInfo();
        LlapDaemonProtocolProtos.FragmentRuntimeInfo fri2 = o2.getFragmentRuntimeInfo();
        if (fri1.getDagStartTime() < fri2.getDagStartTime()) {
            return -1;
        }
        if (fri1.getDagStartTime() > fri2.getDagStartTime()) {
            return 1;
        }
        if (o1.getQueryId().equals(o2.getQueryId())) {
            return Integer.compare(fri1.getWithinDagPriority(), fri2.getWithinDagPriority());
        }
        if (fri1.getFirstAttemptStartTime() < fri2.getFirstAttemptStartTime()) {
            return -1;
        }
        if (fri1.getFirstAttemptStartTime() > fri2.getFirstAttemptStartTime()) {
            return 1;
        }
        int knownPending1 = fri1.getNumSelfAndUpstreamTasks() - fri1.getNumSelfAndUpstreamCompletedTasks();
        if (knownPending1 < (knownPending2 = fri2.getNumSelfAndUpstreamTasks() - fri2.getNumSelfAndUpstreamCompletedTasks())) {
            return -1;
        }
        if (knownPending1 > knownPending2) {
            return 1;
        }
        return 0;
    }
}

