/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.gis.shapefiles;

import java.awt.geom.Point2D;
import org.pentaho.gis.shapefiles.Converter;
import org.pentaho.gis.shapefiles.Shape;
import org.pentaho.gis.shapefiles.ShapeInterface;

public class ShapePoint
extends Shape
implements ShapeInterface {
    public double x;
    public double y;

    public ShapePoint(byte[] content) {
        super(1);
        this.x = Converter.getDoubleLittle(content, 4);
        this.y = Converter.getDoubleLittle(content, 12);
    }

    public ShapePoint(double x, double y) {
        super(1);
        this.x = x;
        this.y = y;
    }

    public boolean equals(ShapePoint p) {
        return this.getDistance(p) < 1.0E-4;
    }

    public double getDistance(ShapePoint p) {
        return (p.x - this.x) * (p.x - this.x) + (p.y - this.y) * (p.y - this.y);
    }

    public String toString() {
        return "(" + this.x + "," + this.y + ")";
    }

    public Point2D.Double getPoint2D() {
        return new Point2D.Double(this.x, this.y);
    }
}

