/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.dataservice.serialization;

import com.google.common.annotations.VisibleForTesting;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.dataservice.Context;
import org.pentaho.di.trans.dataservice.DataServiceMeta;
import org.pentaho.di.trans.dataservice.serialization.DataServiceAlreadyExistsException;
import org.pentaho.di.trans.dataservice.serialization.EmbeddedMetaStoreFactory;
import org.pentaho.di.trans.dataservice.serialization.ServiceTrans;
import org.pentaho.metastore.api.IMetaStore;
import org.pentaho.metastore.api.exceptions.MetaStoreException;
import org.pentaho.metastore.persist.MetaStoreFactory;

public class DataServiceReferenceSynchronizer {
    private final Context context;

    public DataServiceReferenceSynchronizer(Context context) {
        this.context = context;
    }

    @VisibleForTesting
    public DataServiceReferenceSynchronizer() {
        this.context = null;
    }

    public void sync(TransMeta transMeta, Function<? super Exception, ?> exceptionHandler) {
        this.sync(transMeta, exceptionHandler, false);
    }

    public void sync(TransMeta transMeta, Function<? super Exception, ?> exceptionHandler, boolean overwrite) {
        Map<String, ServiceTrans> allPublished;
        Map<String, DataServiceMeta> servicesInTrans;
        MetaStoreFactory<ServiceTrans> serviceTransMetaStoreFactory = this.getMetastoreFactory(transMeta.getMetaStore(), ServiceTrans.class);
        try {
            servicesInTrans = this.getDataServicesInTransMeta(transMeta);
            allPublished = this.getAllPublishedServiceTrans(transMeta, serviceTransMetaStoreFactory);
        }
        catch (MetaStoreException e) {
            exceptionHandler.apply((Exception)((Object)e));
            return;
        }
        Map<String, ServiceTrans> publishedInTrans = this.getPublishedServicesFromTransMeta(transMeta, allPublished);
        List<String> toDelete = publishedInTrans.keySet().stream().filter(name -> !servicesInTrans.keySet().contains(name)).collect(Collectors.toList());
        List<String> nameConflicts = servicesInTrans.keySet().stream().filter(name -> allPublished.keySet().contains(name) && !publishedInTrans.keySet().contains(name)).collect(Collectors.toList());
        List<String> toSave = servicesInTrans.keySet().stream().filter(name -> overwrite || !nameConflicts.contains(name)).collect(Collectors.toList());
        toSave.forEach(name -> {
            try {
                serviceTransMetaStoreFactory.saveElement((Object)ServiceTrans.create((DataServiceMeta)servicesInTrans.get(name)));
            }
            catch (Exception e) {
                exceptionHandler.apply(e);
            }
        });
        toDelete.forEach(name -> {
            try {
                serviceTransMetaStoreFactory.deleteElement(name);
            }
            catch (MetaStoreException e) {
                exceptionHandler.apply((Exception)((Object)e));
            }
        });
        nameConflicts.forEach(name -> exceptionHandler.apply((Exception)((Object)new DataServiceAlreadyExistsException((DataServiceMeta)servicesInTrans.get(name)))));
    }

    private Map<String, ServiceTrans> getPublishedServicesFromTransMeta(TransMeta transMeta, Map<String, ServiceTrans> publishedServices) {
        return publishedServices.entrySet().stream().filter(entry -> ServiceTrans.references(transMeta).stream().anyMatch(reference -> ((ServiceTrans)entry.getValue()).getReferences().contains(reference))).collect(Collectors.toMap(e -> (String)e.getKey(), e -> (ServiceTrans)e.getValue()));
    }

    private Map<String, ServiceTrans> getAllPublishedServiceTrans(TransMeta transMeta, MetaStoreFactory<ServiceTrans> serviceTransMetaStoreFactory) throws MetaStoreException {
        return serviceTransMetaStoreFactory.getElements().stream().filter(serviceTrans -> serviceTrans.getReferences().stream().anyMatch(reference -> reference.exists(transMeta.getRepository()))).collect(Collectors.toMap(ServiceTrans::getName, Function.identity()));
    }

    private Map<String, DataServiceMeta> getDataServicesInTransMeta(TransMeta transMeta) throws MetaStoreException {
        return this.getEmbeddedMetaStoreFactory(transMeta).getElements().stream().collect(Collectors.toMap(DataServiceMeta::getName, Function.identity()));
    }

    @VisibleForTesting
    protected <T> MetaStoreFactory<T> getMetastoreFactory(IMetaStore metaStore, Class<T> clazz) {
        return new MetaStoreFactory(clazz, metaStore, "pentaho");
    }

    @VisibleForTesting
    protected MetaStoreFactory<DataServiceMeta> getEmbeddedMetaStoreFactory(TransMeta meta) throws MetaStoreException {
        assert (this.context != null);
        return new EmbeddedMetaStoreFactory(meta, this.context.getPushDownFactories(), null);
    }
}

