/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.dataservice.ui.menu;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Tree;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.extension.ExtensionPoint;
import org.pentaho.di.core.extension.ExtensionPointInterface;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.dataservice.DataServiceContext;
import org.pentaho.di.trans.dataservice.DataServiceMeta;
import org.pentaho.di.trans.dataservice.ui.DataServiceDelegate;
import org.pentaho.di.trans.dataservice.ui.UIFactory;
import org.pentaho.di.ui.core.ConstUI;
import org.pentaho.di.ui.spoon.TreeSelection;

@ExtensionPoint(id="DataServicePopupMenuExtension", description="Creates popup menus for data services", extensionPointId="SpoonPopupMenuExtension")
public class DataServicePopupMenuExtension
implements ExtensionPointInterface {
    private static final Class<?> PKG = DataServicePopupMenuExtension.class;
    private static final Log logger = LogFactory.getLog(DataServicePopupMenuExtension.class);
    private DataServiceDelegate delegate;
    private UIFactory uiFactory;
    public DataServiceMeta selectedDataService;

    public DataServicePopupMenuExtension(DataServiceContext context) {
        this.delegate = context.getDataServiceDelegate();
        this.uiFactory = context.getUIFactory();
    }

    public void callExtensionPoint(LogChannelInterface log, Object extension) throws KettleException {
        Menu popupMenu = null;
        Tree selectionTree = (Tree)extension;
        TreeSelection[] objects = this.delegate.getSpoon().getTreeObjects(selectionTree);
        TreeSelection object = objects[0];
        Object selection = object.getSelection();
        if (selection == DataServiceMeta.class) {
            popupMenu = this.uiFactory.getMenu(selectionTree);
            this.createRootPopupMenu(popupMenu);
        } else if (selection instanceof DataServiceMeta) {
            this.selectedDataService = (DataServiceMeta)selection;
            popupMenu = this.uiFactory.getMenu(selectionTree);
            this.createItemPopupMenu(popupMenu);
        }
        if (popupMenu != null) {
            ConstUI.displayMenu((Menu)popupMenu, (Control)selectionTree);
        } else {
            selectionTree.setMenu(null);
        }
    }

    private void createNewMenuItem(Menu parent) {
        MenuItem newMenu = this.createPopupMenu(parent, BaseMessages.getString(PKG, (String)"DataServicePopupMenu.New.Label", (String[])new String[0]), new DataServiceNewCommand());
        newMenu.setEnabled(!this.delegate.getSpoon().getActiveTransformation().getSteps().isEmpty());
    }

    private void createRootPopupMenu(Menu parent) {
        this.createNewMenuItem(parent);
        this.uiFactory.getMenuItem(parent, 2);
        this.createPopupMenu(parent, BaseMessages.getString(PKG, (String)"DataServicePopupMenu.DriverDetails.Label", (String[])new String[0]), new DriverDetailsCommand());
    }

    private void createItemPopupMenu(Menu parent) {
        this.createNewMenuItem(parent);
        this.createPopupMenu(parent, BaseMessages.getString(PKG, (String)"DataServicePopupMenu.Edit.Label", (String[])new String[0]), new DataServiceEditCommand());
        this.createPopupMenu(parent, BaseMessages.getString(PKG, (String)"DataServicePopupMenu.Delete.Label", (String[])new String[0]), new DataServiceDeleteCommand());
        this.uiFactory.getMenuItem(parent, 2);
        this.createPopupMenu(parent, BaseMessages.getString(PKG, (String)"DataServicePopupMenu.Test.Label", (String[])new String[0]), new DataServiceTestCommand());
        this.uiFactory.getMenuItem(parent, 2);
        this.createPopupMenu(parent, BaseMessages.getString(PKG, (String)"DataServicePopupMenu.DriverDetails.Label", (String[])new String[0]), new DriverDetailsCommand());
    }

    private MenuItem createPopupMenu(Menu parent, String label, final DataServiceCommand dataServiceCommand) {
        MenuItem menuItem = this.uiFactory.getMenuItem(parent, 0);
        menuItem.setText(label);
        menuItem.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                dataServiceCommand.execute();
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }
        });
        return menuItem;
    }

    class DriverDetailsCommand
    implements DataServiceCommand {
        DriverDetailsCommand() {
        }

        @Override
        public void execute() {
            DataServicePopupMenuExtension.this.delegate.showDriverDetailsDialog();
        }
    }

    class DataServiceTestCommand
    implements DataServiceCommand {
        DataServiceTestCommand() {
        }

        @Override
        public void execute() {
            DataServicePopupMenuExtension.this.delegate.showTestDataServiceDialog(DataServicePopupMenuExtension.this.selectedDataService);
        }
    }

    class DataServiceDeleteCommand
    implements DataServiceCommand {
        DataServiceDeleteCommand() {
        }

        @Override
        public void execute() {
            DataServicePopupMenuExtension.this.delegate.removeDataService(DataServicePopupMenuExtension.this.selectedDataService, true);
        }
    }

    class DataServiceEditCommand
    implements DataServiceCommand {
        DataServiceEditCommand() {
        }

        @Override
        public void execute() {
            DataServicePopupMenuExtension.this.delegate.editDataService(DataServicePopupMenuExtension.this.selectedDataService);
        }
    }

    class DataServiceNewCommand
    implements DataServiceCommand {
        DataServiceNewCommand() {
        }

        @Override
        public void execute() {
            DataServicePopupMenuExtension.this.delegate.createNewDataService(null);
        }
    }

    static interface DataServiceCommand {
        public void execute();
    }
}

