/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.packages.command;

import java.util.SortedMap;
import org.apache.karaf.packages.core.PackageRequirement;
import org.apache.karaf.packages.core.PackageService;
import org.apache.karaf.shell.commands.Command;
import org.apache.karaf.shell.commands.Option;
import org.apache.karaf.shell.console.OsgiCommandSupport;
import org.apache.karaf.shell.table.Col;
import org.apache.karaf.shell.table.ShellTable;
import org.osgi.framework.Bundle;

@Command(scope="package", name="imports", description="Lists imported packages and the bundles that import them")
public class Imports
extends OsgiCommandSupport {
    @Option(name="-p", description="Only show package instead of full filter", required=false, multiValued=false)
    boolean onlyPackage;
    @Option(name="--no-format", description="Disable table rendered output", required=false, multiValued=false)
    boolean noFormat;
    private PackageService packageService;

    public Imports(PackageService packageService) {
        this.packageService = packageService;
    }

    protected Object doExecute() throws Exception {
        SortedMap imports = this.packageService.getImports();
        ShellTable table = new ShellTable();
        table.column(new Col(this.onlyPackage ? "Package name" : "Filter"));
        table.column(new Col("Optional"));
        table.column(new Col("ID"));
        table.column(new Col("Bundle Name"));
        table.column(new Col("Resolveable"));
        for (String filter : imports.keySet()) {
            PackageRequirement req = (PackageRequirement)imports.get(filter);
            Bundle bundle = req.getBundle();
            String firstCol = this.onlyPackage ? req.getPackageName() : req.getFilter();
            table.addRow().addContent(new Object[]{firstCol, req.isOptional() ? "optional" : "", bundle.getBundleId(), bundle.getSymbolicName(), req.isResolveable()});
        }
        table.print(System.out, !this.noFormat);
        return null;
    }
}

