/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.jdbc.translators;

import com.sap.dbtech.jdbc.packet.DataPart;
import com.sap.dbtech.jdbc.translators.DBTechTranslator;
import com.sap.dbtech.jdbc.translators.DateTranslator;
import com.sap.dbtech.jdbc.translators.SQLParamController;
import com.sap.dbtech.util.StructuredMem;
import com.sap.dbtech.util.UnicodeUtil;
import java.sql.Date;
import java.sql.SQLException;
import java.util.Calendar;

public class UnicodeDateTranslator
extends DateTranslator {
    public UnicodeDateTranslator(int n, int n2, int n3, int n4, int n5, int n6) {
        super(n, n2, n3, n4, n5, n6);
    }

    public String getString(SQLParamController sQLParamController, StructuredMem structuredMem) throws SQLException {
        String string = null;
        if (!this.isNull(sQLParamController, structuredMem)) {
            string = structuredMem.getString(this.bufpos, this.physicalLength - 1);
        }
        return string;
    }

    public Date getDate(SQLParamController sQLParamController, StructuredMem structuredMem, Calendar calendar) throws SQLException {
        Date date = null;
        if (!this.isNull(sQLParamController, structuredMem)) {
            byte[] byArray = structuredMem.getBytes(this.bufpos, this.physicalLength - 1);
            int n = (byArray[1] - 48) * 1000;
            n += (byArray[3] - 48) * 100;
            n += (byArray[5] - 48) * 10;
            n += byArray[7] - 48;
            int n2 = (byArray[11] - 48) * 10;
            n2 += byArray[13] - 48;
            int n3 = (byArray[17] - 48) * 10;
            n3 += byArray[19] - 48;
            if (calendar == null) {
                date = new Date(n - 1900, n2 - 1, n3);
            } else {
                calendar.clear();
                calendar.set(n, n2 - 1, n3, 0, 0, 0);
                date = DBTechTranslator.CalendarUtil.getDateFromCalendar(calendar);
            }
        }
        return date;
    }

    protected void putSpecific(DataPart dataPart, Object object) {
        dataPart.putInt1(1, this.bufpos - 1);
        dataPart.putUnicodeBytes((byte[])object, this.bufpos, this.physicalLength - 1);
    }

    public Object transDateForInput(Date date, Calendar calendar) throws SQLException {
        if (date == null) {
            return null;
        }
        byte[] byArray = (byte[])super.transDateForInput(date, calendar);
        byte[] byArray2 = UnicodeUtil.bytes2BigUnicode(byArray);
        this.checkFieldLimits(byArray2.length);
        return byArray2;
    }
}

