/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.util.cache;

import com.sap.dbtech.util.cache.DListElement;
import java.util.Dictionary;
import java.util.Hashtable;

public class LruCache {
    private Dictionary lookup;
    private Association lruTop;
    private Association lruBottom;
    private int currentSize;
    private int maxSize;
    static Object[] templateForClear = new Object[0];

    public LruCache(int n) {
        this.maxSize = n;
        this.clear();
    }

    public void clear() {
        this.currentSize = 0;
        this.lookup = new Hashtable(this.maxSize);
        this.lruTop = null;
        this.lruBottom = null;
    }

    public Object get(Object object) {
        Object object2 = null;
        Association association = (Association)this.lookup.get(object);
        if (association != null) {
            object2 = association.getObject();
            this.moveToTop(association);
        }
        return object2;
    }

    public void put(Object object, Object object2) {
        Association association = new Association(object, object2);
        this.lookup.put(object, association);
        if (this.lruTop != null) {
            this.lruTop.prepend(association);
        }
        this.lruTop = association;
        if (this.lruBottom == null) {
            this.lruBottom = association;
        }
        ++this.currentSize;
        if (this.currentSize > this.maxSize) {
            this.removeLast();
        }
    }

    private void moveToTop(Association association) {
        if (association == this.lruTop) {
            return;
        }
        if (association == this.lruBottom) {
            this.lruBottom = (Association)association.previous();
        }
        association.remove();
        this.lruTop.prepend(association);
        this.lruTop = association;
    }

    private void removeLast() {
        Association association = this.lruBottom;
        this.lruBottom = (Association)association.previous();
        this.lookup.remove(association.getKey());
        this.removeHook(association);
        --this.currentSize;
    }

    protected void removeHook(Object object) {
    }

    public Object[] clearAll() {
        Object[] objectArray = ((Hashtable)this.lookup).values().toArray(templateForClear);
        this.clear();
        return objectArray;
    }

    private static class Association
    extends DListElement {
        Object key;

        Association(Object object, Object object2) {
            super(object2);
            this.key = object;
        }

        final Object getKey() {
            return this.key;
        }
    }
}

