/*
 * Decompiled with CFR 0.152.
 */
package com.infobright.etl.model;

import com.infobright.etl.model.ValueConverter;
import com.infobright.etl.model.ValueConverterException;
import com.infobright.etl.model.datatype.AbstractColumnType;
import com.infobright.logging.EtlLogger;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BrighthouseRecord {
    protected final List<AbstractColumnType> columns;
    private final Charset charset;

    public static List<AbstractColumnType> readColumnTypes(ResultSetMetaData md, Charset charset, EtlLogger logger, boolean checkValues) throws SQLException {
        ArrayList<AbstractColumnType> columns = new ArrayList<AbstractColumnType>();
        for (int i = 1; i <= md.getColumnCount(); ++i) {
            AbstractColumnType colType = AbstractColumnType.getInstance(md.getColumnName(i), md.getColumnType(i), md.getColumnTypeName(i), md.getPrecision(i), md.getScale(i), charset, logger);
            colType.setCheckValues(checkValues);
            columns.add(colType);
        }
        return columns;
    }

    protected BrighthouseRecord(List<AbstractColumnType> columns, Charset charset) {
        this.columns = columns;
        this.charset = charset;
    }

    public abstract int size();

    public abstract void writeTo(OutputStream var1) throws IOException;

    public abstract void setData(int var1, Object var2, ValueConverter var3) throws ValueConverterException;

    protected Charset getCharset() {
        return this.charset;
    }
}

