/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.designtime.swing.colorchooser;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import javax.swing.colorchooser.ColorChooserComponentFactory;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.pentaho.reporting.libraries.designtime.swing.colorchooser.AbstractColorChooserPanel;
import org.pentaho.reporting.libraries.designtime.swing.colorchooser.ColorSchema;
import org.pentaho.reporting.libraries.designtime.swing.colorchooser.CombinedColorChooser;
import org.pentaho.reporting.libraries.designtime.swing.colorchooser.ExtendedColorModel;
import org.pentaho.reporting.libraries.designtime.swing.colorchooser.SwatchColorChooser;

public class ColorChooserPane
extends JComponent {
    private JComponent previewPane;
    private JTabbedPane multiSelectorPane;
    private ExtendedColorModel colorModel = new ExtendedColorModel();
    private SwatchColorChooser swatchColorChooser;

    public ColorChooserPane() {
        this.colorModel.addChangeListener(new PreviewColorUpdater());
        this.previewPane = ColorChooserComponentFactory.getPreviewPanel();
        this.multiSelectorPane = new JTabbedPane();
        this.swatchColorChooser = new SwatchColorChooser();
        this.addColorChooserPanel(new CombinedColorChooser());
        this.addColorChooserPanel(this.swatchColorChooser);
        this.setLayout(new BorderLayout());
        this.add((Component)this.previewPane, "South");
        this.add((Component)this.multiSelectorPane, "Center");
    }

    public JComponent getPreviewPane() {
        return this.previewPane;
    }

    public void addSwatches(ColorSchema colorSchema) {
        this.swatchColorChooser.addSwatches(colorSchema);
    }

    public void clearSwatches() {
        this.swatchColorChooser.clearSwatches();
    }

    public void removeSwatches(ColorSchema colorSchema) {
        this.swatchColorChooser.removeSwatches(colorSchema);
    }

    public SwatchColorChooser getSwatchColorChooser() {
        return this.swatchColorChooser;
    }

    public ExtendedColorModel getModel() {
        return this.colorModel;
    }

    public void addColorChooserPanel(AbstractColorChooserPanel panel) {
        this.multiSelectorPane.addTab(panel.getDisplayName(), panel.getSmallDisplayIcon(), panel);
        this.multiSelectorPane.setMnemonicAt(this.multiSelectorPane.getTabCount() - 1, panel.getMnemonic());
        this.multiSelectorPane.setDisplayedMnemonicIndexAt(this.multiSelectorPane.getTabCount() - 1, panel.getDisplayedMnemonicIndex());
        panel.installChooserPanel(this.colorModel);
    }

    public void removeColorChooserPanel(AbstractColorChooserPanel panel) {
        panel.uninstallChooserPanel();
        this.multiSelectorPane.remove(panel);
    }

    public AbstractColorChooserPanel getColorChooserPanel(int index) {
        return (AbstractColorChooserPanel)this.multiSelectorPane.getComponentAt(index);
    }

    public void removeAllColorChooserPanels() {
        int count = this.getColorChooserPanelCount();
        for (int i = 0; i < count; ++i) {
            this.getColorChooserPanel(i).uninstallChooserPanel();
        }
        this.multiSelectorPane.removeAll();
    }

    public int getColorChooserPanelCount() {
        return this.multiSelectorPane.getTabCount();
    }

    public void setColor(Color value) {
        this.colorModel.setSelectedColor(value);
    }

    private class PreviewColorUpdater
    implements ChangeListener {
        private PreviewColorUpdater() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            ColorChooserPane.this.previewPane.setForeground(ColorChooserPane.this.colorModel.getSelectedColor());
        }
    }
}

