/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.designtime.swing.colorchooser;

import java.awt.Color;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;

public class ExtendedColorModel {
    private EventListenerList eventListenerList = new EventListenerList();
    private int hue;
    private int saturation;
    private int value;
    private int red;
    private int green;
    private int blue;
    private boolean traceEvents;

    public void setTraceEvents(boolean traceEvents) {
        this.traceEvents = traceEvents;
    }

    public int getHue() {
        return this.hue;
    }

    public int getSaturation() {
        return this.saturation;
    }

    public int getValue() {
        return this.value;
    }

    public int getRed() {
        return this.red;
    }

    public int getGreen() {
        return this.green;
    }

    public int getBlue() {
        return this.blue;
    }

    public void fireChangeEvent() {
        ChangeListener[] listeners = (ChangeListener[])this.eventListenerList.getListeners(ChangeListener.class);
        if (listeners.length == 0) {
            return;
        }
        ChangeEvent event = new ChangeEvent(this);
        for (int i = 0; i < listeners.length; ++i) {
            ChangeListener listener = listeners[i];
            listener.stateChanged(event);
        }
        if (this.traceEvents) {
            new Exception().printStackTrace();
        }
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.eventListenerList.add(ChangeListener.class, changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.eventListenerList.remove(ChangeListener.class, changeListener);
    }

    public Color getSelectedColor() {
        return new Color(this.red, this.green, this.blue);
    }

    public void setSelectedColor(Color color) {
        if (color == null) {
            return;
        }
        if (this.red == color.getRed() && this.green == color.getGreen() && this.blue == color.getBlue()) {
            return;
        }
        this.red = color.getRed();
        this.green = color.getGreen();
        this.blue = color.getBlue();
        float[] hsb = Color.RGBtoHSB(this.red, this.green, this.blue, null);
        this.hue = (int)(hsb[0] * 360.0f);
        this.saturation = (int)(hsb[1] * 100.0f);
        this.value = (int)(hsb[2] * 100.0f);
        this.fireChangeEvent();
    }

    public void setHSB(int hue, int saturation, int value) {
        if (this.hue == hue && this.saturation == saturation && this.value == value) {
            return;
        }
        this.hue = hue;
        this.saturation = saturation;
        this.value = value;
        Color color = Color.getHSBColor((float)hue / 360.0f, (float)saturation / 100.0f, (float)value / 100.0f);
        this.red = color.getRed();
        this.green = color.getGreen();
        this.blue = color.getBlue();
        this.fireChangeEvent();
    }

    public void setRGB(int red, int green, int blue) {
        if (this.red == red && this.green == green && this.blue == blue) {
            return;
        }
        this.red = red;
        this.green = green;
        this.blue = blue;
        float[] hsb = Color.RGBtoHSB(red, green, blue, null);
        this.hue = (int)(hsb[0] * 360.0f);
        this.saturation = (int)(hsb[1] * 100.0f);
        this.value = (int)(hsb[2] * 100.0f);
        this.fireChangeEvent();
    }

    public void copyInto(ExtendedColorModel colorModel) {
        if (this.red == colorModel.red && this.green == colorModel.green && this.blue == colorModel.blue && this.hue == colorModel.hue && this.saturation == colorModel.saturation && this.value == colorModel.value) {
            return;
        }
        this.red = colorModel.red;
        this.green = colorModel.green;
        this.blue = colorModel.blue;
        this.hue = colorModel.hue;
        this.saturation = colorModel.saturation;
        this.value = colorModel.value;
        this.fireChangeEvent();
    }
}

