/*
 * Decompiled with CFR 0.152.
 */
package org.olap4j.driver.xmla;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Pattern;
import org.olap4j.OlapConnection;
import org.olap4j.OlapDatabaseMetaData;
import org.olap4j.OlapException;
import org.olap4j.OlapStatement;
import org.olap4j.PreparedOlapStatement;
import org.olap4j.Scenario;
import org.olap4j.driver.xmla.DeferredNamedListImpl;
import org.olap4j.driver.xmla.Factory;
import org.olap4j.driver.xmla.XmlaHelper;
import org.olap4j.driver.xmla.XmlaOlap4jCatalog;
import org.olap4j.driver.xmla.XmlaOlap4jCube;
import org.olap4j.driver.xmla.XmlaOlap4jDatabase;
import org.olap4j.driver.xmla.XmlaOlap4jDatabaseMetaData;
import org.olap4j.driver.xmla.XmlaOlap4jDimension;
import org.olap4j.driver.xmla.XmlaOlap4jDriver;
import org.olap4j.driver.xmla.XmlaOlap4jHierarchy;
import org.olap4j.driver.xmla.XmlaOlap4jLevel;
import org.olap4j.driver.xmla.XmlaOlap4jMeasure;
import org.olap4j.driver.xmla.XmlaOlap4jMember;
import org.olap4j.driver.xmla.XmlaOlap4jNamedSet;
import org.olap4j.driver.xmla.XmlaOlap4jProperty;
import org.olap4j.driver.xmla.XmlaOlap4jSchema;
import org.olap4j.driver.xmla.XmlaOlap4jServerInfos;
import org.olap4j.driver.xmla.XmlaOlap4jUtil;
import org.olap4j.driver.xmla.proxy.XmlaOlap4jCachedProxy;
import org.olap4j.driver.xmla.proxy.XmlaOlap4jProxy;
import org.olap4j.driver.xmla.proxy.XmlaOlap4jProxyException;
import org.olap4j.impl.ConnectStringParser;
import org.olap4j.impl.LcidLocale;
import org.olap4j.impl.Named;
import org.olap4j.impl.Olap4jUtil;
import org.olap4j.impl.UnmodifiableArrayList;
import org.olap4j.mdx.ParseTreeWriter;
import org.olap4j.mdx.SelectNode;
import org.olap4j.mdx.parser.MdxParser;
import org.olap4j.mdx.parser.MdxParserFactory;
import org.olap4j.mdx.parser.MdxValidator;
import org.olap4j.mdx.parser.impl.DefaultMdxParserImpl;
import org.olap4j.metadata.Catalog;
import org.olap4j.metadata.Database;
import org.olap4j.metadata.Datatype;
import org.olap4j.metadata.Dimension;
import org.olap4j.metadata.Hierarchy;
import org.olap4j.metadata.Level;
import org.olap4j.metadata.Measure;
import org.olap4j.metadata.Member;
import org.olap4j.metadata.NamedList;
import org.olap4j.metadata.Property;
import org.olap4j.metadata.Schema;
import org.olap4j.metadata.XmlaConstants;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class XmlaOlap4jConnection
implements OlapConnection {
    final XmlaHelper helper = new XmlaHelper();
    private XmlaOlap4jDatabase olap4jDatabase;
    private XmlaOlap4jCatalog olap4jCatalog;
    private XmlaOlap4jSchema olap4jSchema;
    final XmlaOlap4jDatabaseMetaData olap4jDatabaseMetaData;
    private static final String CONNECT_STRING_PREFIX = "jdbc:xmla:";
    final XmlaOlap4jDriver driver;
    final Factory factory;
    final XmlaOlap4jProxy proxy;
    private boolean closed = false;
    final XmlaOlap4jServerInfos serverInfos;
    private Locale locale;
    private String catalogName;
    private String schemaName;
    private String roleName;
    private String databaseName;
    private final Map<String, String> databaseProperties;
    private boolean autoCommit;
    private boolean readOnly;
    private final NamedList<XmlaOlap4jDatabase> olapDatabases;
    private final URL serverUrlObject;
    private HashSet<String> olap4jDatabaseProperties = null;
    private static final boolean DEBUG = false;
    final AtomicBoolean propPopulation = new AtomicBoolean(false);
    private static final Pattern LOWERCASE_PATTERN = Pattern.compile(".*[a-z].*");

    XmlaOlap4jConnection(Factory factory, XmlaOlap4jDriver driver, XmlaOlap4jProxy proxy, String url, Properties info) throws SQLException {
        if (!XmlaOlap4jConnection.acceptsURL(url)) {
            throw new AssertionError((Object)"does not start with 'jdbc:xmla:'");
        }
        this.factory = factory;
        this.driver = driver;
        this.proxy = proxy;
        final Map<String, String> map = XmlaOlap4jConnection.parseConnectString(url, info);
        this.databaseProperties = new HashMap<String, String>();
        for (String infoKey : map.keySet()) {
            this.databaseProperties.put(infoKey, map.get(infoKey));
        }
        this.databaseName = map.get(XmlaOlap4jDriver.Property.DATABASE.name());
        this.catalogName = map.get(XmlaOlap4jDriver.Property.CATALOG.name());
        this.schemaName = map.get(XmlaOlap4jDriver.Property.SCHEMA.name());
        this.roleName = map.get(XmlaOlap4jDriver.Property.ROLE.name());
        String serverUrl = map.get(XmlaOlap4jDriver.Property.SERVER.name());
        if (serverUrl == null) {
            throw this.getHelper().createException("Connection property '" + XmlaOlap4jDriver.Property.SERVER.name() + "' must be specified");
        }
        try {
            this.serverUrlObject = new URL(serverUrl);
        }
        catch (MalformedURLException e) {
            throw this.getHelper().createException(e);
        }
        this.initSoapCache(map);
        this.serverInfos = new XmlaOlap4jServerInfos(){
            private String sessionId = null;

            public String getUsername() {
                return (String)map.get(XmlaOlap4jDriver.Property.USER.name());
            }

            public String getPassword() {
                return (String)map.get(XmlaOlap4jDriver.Property.PASSWORD.name());
            }

            public URL getUrl() {
                return XmlaOlap4jConnection.this.serverUrlObject;
            }

            public String getSessionId() {
                return this.sessionId;
            }

            public void setSessionId(String sessionId) {
                this.sessionId = sessionId;
            }
        };
        this.olap4jDatabaseMetaData = factory.newDatabaseMetaData(this);
        this.olapDatabases = new DeferredNamedListImpl<XmlaOlap4jDatabase>(MetadataRequest.DISCOVER_DATASOURCES, new Context(this, this.olap4jDatabaseMetaData, null, null, null, null, null, null), new DatabaseHandler(), null);
    }

    private XmlaHelper getHelper() {
        return this.helper;
    }

    private void initSoapCache(Map<String, String> map) throws OlapException {
        if (map.containsKey(XmlaOlap4jDriver.Property.CACHE.name())) {
            HashMap<String, String> props = new HashMap<String, String>();
            for (Map.Entry<String, String> entry : map.entrySet()) {
                if (!entry.getKey().startsWith(XmlaOlap4jDriver.Property.CACHE.name() + ".")) continue;
                props.put(entry.getKey().substring(XmlaOlap4jDriver.Property.CACHE.name().length() + 1), entry.getValue());
            }
            ((XmlaOlap4jCachedProxy)this.proxy).setCache(map, props);
        }
    }

    static Map<String, String> parseConnectString(String url, Properties info) {
        String x = url.substring(CONNECT_STRING_PREFIX.length());
        Map map = ConnectStringParser.parseConnectString((String)x);
        for (Map.Entry<String, String> entry : XmlaOlap4jConnection.toMap(info).entrySet()) {
            map.put(entry.getKey(), entry.getValue());
        }
        return map;
    }

    static boolean acceptsURL(String url) {
        return url.startsWith(CONNECT_STRING_PREFIX);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String makeConnectionPropertyList() throws OlapException {
        AtomicBoolean atomicBoolean = this.propPopulation;
        synchronized (atomicBoolean) {
            if (this.propPopulation.get()) {
                return "";
            }
            if (this.olap4jDatabaseProperties == null) {
                this.propPopulation.set(true);
                this.olap4jDatabaseProperties = new HashSet();
                ResultSet rs = this.olap4jDatabaseMetaData.getDatabaseProperties(null, null);
                try {
                    while (rs.next()) {
                        String property = rs.getString(XmlaConstants.Literal.PROPERTY_NAME.name());
                        if (property == null) continue;
                        property = property.toUpperCase();
                        this.olap4jDatabaseProperties.add(property);
                    }
                }
                catch (SQLException e) {
                    throw new OlapException((Throwable)e);
                }
                finally {
                    this.propPopulation.set(false);
                    try {
                        rs.close();
                    }
                    catch (SQLException e) {
                        throw new OlapException();
                    }
                }
            }
        }
        StringBuilder buf = new StringBuilder();
        for (String prop : this.databaseProperties.keySet()) {
            if (prop.startsWith(XmlaOlap4jDriver.Property.CACHE.name())) continue;
            try {
                XmlaOlap4jDriver.Property.valueOf(prop);
            }
            catch (IllegalArgumentException e) {
                if (!this.olap4jDatabaseProperties.contains(prop)) continue;
                buf.append("        <");
                XmlaOlap4jConnection.xmlEncode(buf, prop);
                buf.append(">");
                XmlaOlap4jConnection.xmlEncode(buf, this.databaseProperties.get(prop));
                buf.append("</");
                XmlaOlap4jConnection.xmlEncode(buf, prop);
                buf.append(">\n");
            }
        }
        return buf.toString();
    }

    public OlapStatement createStatement() {
        return this.factory.newStatement(this);
    }

    public PreparedStatement prepareStatement(String sql) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public CallableStatement prepareCall(String sql) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public String nativeSQL(String sql) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.autoCommit = autoCommit;
    }

    public boolean getAutoCommit() throws SQLException {
        return this.autoCommit;
    }

    public void commit() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void rollback() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void close() throws SQLException {
        this.closed = true;
    }

    public boolean isClosed() throws SQLException {
        return this.closed;
    }

    public OlapDatabaseMetaData getMetaData() {
        return this.olap4jDatabaseMetaData;
    }

    public void setReadOnly(boolean readOnly) throws SQLException {
        this.readOnly = readOnly;
    }

    public boolean isReadOnly() throws SQLException {
        return this.readOnly;
    }

    public void setDatabase(String databaseName) throws OlapException {
        if (databaseName == null) {
            throw new OlapException("Database name cannot be null.");
        }
        this.olap4jDatabase = (XmlaOlap4jDatabase)this.getOlapDatabases().get(databaseName);
        if (this.olap4jDatabase == null) {
            throw new OlapException("No database named " + databaseName + " could be found.");
        }
        this.databaseName = databaseName;
        this.olap4jCatalog = null;
        this.olap4jSchema = null;
    }

    public String getDatabase() throws OlapException {
        return this.getOlapDatabase().getName();
    }

    public Database getOlapDatabase() throws OlapException {
        if (this.olap4jDatabase == null) {
            if (this.databaseName == null) {
                NamedList<Database> databases = this.getOlapDatabases();
                if (databases.size() == 0) {
                    throw new OlapException("No database found.");
                }
                this.olap4jDatabase = (XmlaOlap4jDatabase)databases.get(0);
                this.databaseName = this.olap4jDatabase.getName();
                this.olap4jCatalog = null;
                this.olap4jSchema = null;
            } else {
                this.olap4jDatabase = (XmlaOlap4jDatabase)this.getOlapDatabases().get(this.databaseName);
                this.olap4jCatalog = null;
                this.olap4jSchema = null;
                if (this.olap4jDatabase == null) {
                    throw new OlapException("No database named " + this.databaseName + " could be found.");
                }
            }
        }
        return this.olap4jDatabase;
    }

    public NamedList<Database> getOlapDatabases() throws OlapException {
        return Olap4jUtil.cast(this.olapDatabases);
    }

    public void setCatalog(String catalogName) throws OlapException {
        if (catalogName == null) {
            throw new OlapException("Catalog name cannot be null.");
        }
        this.olap4jCatalog = (XmlaOlap4jCatalog)this.getOlapCatalogs().get(catalogName);
        if (this.olap4jCatalog == null) {
            throw new OlapException("No catalog named " + catalogName + " could be found.");
        }
        this.catalogName = catalogName;
        this.olap4jSchema = null;
    }

    public String getCatalog() throws OlapException {
        return this.getOlapCatalog().getName();
    }

    public Catalog getOlapCatalog() throws OlapException {
        if (this.olap4jCatalog == null) {
            Database database = this.getOlapDatabase();
            if (this.catalogName == null) {
                if (database.getCatalogs().size() == 0) {
                    throw new OlapException("No catalogs could be found.");
                }
                this.olap4jCatalog = (XmlaOlap4jCatalog)database.getCatalogs().get(0);
                this.catalogName = this.olap4jCatalog.getName();
                this.olap4jSchema = null;
            } else {
                this.olap4jCatalog = (XmlaOlap4jCatalog)database.getCatalogs().get(this.catalogName);
                if (this.olap4jCatalog == null) {
                    throw new OlapException("No catalog named " + this.catalogName + " could be found.");
                }
                this.olap4jSchema = null;
            }
        }
        return this.olap4jCatalog;
    }

    public NamedList<Catalog> getOlapCatalogs() throws OlapException {
        return this.getOlapDatabase().getCatalogs();
    }

    public String getSchema() throws OlapException {
        return this.getOlapSchema().getName();
    }

    public void setSchema(String schemaName) throws OlapException {
        if (schemaName == null) {
            throw new OlapException("Schema name cannot be null.");
        }
        Catalog catalog = this.getOlapCatalog();
        this.olap4jSchema = (XmlaOlap4jSchema)catalog.getSchemas().get(schemaName);
        if (this.olap4jSchema == null) {
            throw new OlapException("No schema named " + schemaName + " could be found in catalog " + catalog.getName());
        }
        this.schemaName = schemaName;
    }

    public synchronized Schema getOlapSchema() throws OlapException {
        if (this.olap4jSchema == null) {
            Catalog catalog = this.getOlapCatalog();
            if (this.schemaName == null) {
                if (catalog.getSchemas().size() == 0) {
                    throw new OlapException("No schemas could be found.");
                }
                this.olap4jSchema = (XmlaOlap4jSchema)catalog.getSchemas().get(0);
            } else {
                this.olap4jSchema = (XmlaOlap4jSchema)catalog.getSchemas().get(this.schemaName);
                if (this.olap4jSchema == null) {
                    throw new OlapException("No schema named " + this.schemaName + " could be found.");
                }
            }
        }
        return this.olap4jSchema;
    }

    public NamedList<Schema> getOlapSchemas() throws OlapException {
        return this.getOlapCatalog().getSchemas();
    }

    public void setTransactionIsolation(int level) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public int getTransactionIsolation() throws SQLException {
        return 0;
    }

    public SQLWarning getWarnings() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void clearWarnings() throws SQLException {
    }

    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public Map<String, Class<?>> getTypeMap() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void setHoldability(int holdability) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public int getHoldability() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public Savepoint setSavepoint() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public Savepoint setSavepoint(String name) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void rollback(Savepoint savepoint) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface.isInstance(this)) {
            return iface.cast(this);
        }
        throw this.getHelper().createException("does not implement '" + iface + "'");
    }

    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isInstance(this);
    }

    public PreparedOlapStatement prepareOlapStatement(String mdx) throws OlapException {
        return this.factory.newPreparedStatement(mdx, this);
    }

    public MdxParserFactory getParserFactory() {
        return new MdxParserFactory(){

            public MdxParser createMdxParser(OlapConnection connection) {
                return new DefaultMdxParserImpl();
            }

            public MdxValidator createMdxValidator(OlapConnection connection) {
                return new XmlaOlap4jMdxValidator(connection);
            }
        };
    }

    public static Map<String, String> toMap(final Properties properties) {
        return new AbstractMap<String, String>(){

            @Override
            public Set<Map.Entry<String, String>> entrySet() {
                return Olap4jUtil.cast(properties.entrySet());
            }
        };
    }

    String getURL() {
        throw Olap4jUtil.needToImplement((Object)this);
    }

    public void setLocale(Locale locale) {
        if (locale == null) {
            throw new IllegalArgumentException("locale must not be null");
        }
        Locale previousLocale = this.locale;
        this.locale = locale;
        if (!Olap4jUtil.equal((Object)previousLocale, (Object)locale)) {
            this.clearCache();
        }
    }

    private void clearCache() {
        ((DeferredNamedListImpl)this.olapDatabases).reset();
        this.olap4jCatalog = null;
        this.olap4jDatabase = null;
        this.olap4jSchema = null;
    }

    public Locale getLocale() {
        if (this.locale == null) {
            return Locale.getDefault();
        }
        return this.locale;
    }

    public void setRoleName(String roleName) throws OlapException {
        this.roleName = roleName;
    }

    public String getRoleName() {
        return this.roleName;
    }

    public List<String> getAvailableRoleNames() throws OlapException {
        LinkedHashSet<String> roleNames = new LinkedHashSet<String>();
        for (Catalog catalog : this.getOlapCatalogs()) {
            List<String> catalogRoles = ((XmlaOlap4jCatalog)catalog).getAvailableRoles();
            roleNames.addAll(catalogRoles);
        }
        return new ArrayList<String>(roleNames);
    }

    public Scenario createScenario() {
        throw new UnsupportedOperationException();
    }

    public void setScenario(Scenario scenario) {
        throw new UnsupportedOperationException();
    }

    public Scenario getScenario() {
        throw new UnsupportedOperationException();
    }

    <T extends Named> void populateList(List<T> list, Context context, MetadataRequest metadataRequest, Handler<T> handler, Object[] restrictions) throws OlapException {
        String request = this.generateRequest(context, metadataRequest, restrictions);
        Element root = this.executeMetadataRequest(request);
        for (Element o : XmlaOlap4jUtil.childElements(root)) {
            if (!o.getLocalName().equals("row")) continue;
            handler.handle(o, context, list);
        }
        handler.sortList(list);
    }

    Element executeMetadataRequest(String request) throws OlapException {
        Element session;
        Document doc;
        byte[] bytes;
        try {
            bytes = this.proxy.get(this.serverInfos, request);
        }
        catch (XmlaOlap4jProxyException e) {
            throw this.getHelper().createException("This connection encountered an exception while executing a query.", e);
        }
        try {
            doc = XmlaOlap4jUtil.parse(bytes);
        }
        catch (IOException e) {
            throw this.getHelper().createException("error discovering metadata", e);
        }
        catch (SAXException e) {
            throw this.getHelper().createException("error discovering metadata", e);
        }
        Element envelope = doc.getDocumentElement();
        assert (envelope.getLocalName().equals("Envelope"));
        assert (envelope.getNamespaceURI().equals("http://schemas.xmlsoap.org/soap/envelope/"));
        Element header = XmlaOlap4jUtil.findChild(envelope, "http://schemas.xmlsoap.org/soap/envelope/", "Header");
        Element body = XmlaOlap4jUtil.findChild(envelope, "http://schemas.xmlsoap.org/soap/envelope/", "Body");
        Element fault = XmlaOlap4jUtil.findChild(body, "http://schemas.xmlsoap.org/soap/envelope/", "Fault");
        if (fault != null) {
            throw this.getHelper().createException("XMLA provider gave exception: " + XmlaOlap4jUtil.prettyPrint(fault) + "\n" + "Request was:\n" + request);
        }
        if (header != null && (session = XmlaOlap4jUtil.findChild(header, "urn:schemas-microsoft-com:xml-analysis", "Session")) != null) {
            String sessionId = session.getAttribute("SessionId");
            if ("".equals(sessionId)) {
                sessionId = null;
            }
            this.serverInfos.setSessionId(sessionId);
        }
        Element discoverResponse = XmlaOlap4jUtil.findChild(body, "urn:schemas-microsoft-com:xml-analysis", "DiscoverResponse");
        Element returnElement = XmlaOlap4jUtil.findChild(discoverResponse, "urn:schemas-microsoft-com:xml-analysis", "return");
        return XmlaOlap4jUtil.findChild(returnElement, "urn:schemas-microsoft-com:xml-analysis:rowset", "root");
    }

    public String generateRequest(Context context, MetadataRequest metadataRequest, Object[] restrictions) throws OlapException {
        Locale locale1;
        NamedList<Catalog> catalogs;
        String content = "Data";
        String encoding = this.proxy.getEncodingCharsetName();
        StringBuilder buf = new StringBuilder("<?xml version=\"1.0\" encoding=\"" + encoding + "\"?>\n" + "<SOAP-ENV:Envelope\n" + "    xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\"\n" + "    SOAP-ENV:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\">\n" + "  <SOAP-ENV:Body>\n" + "    <Discover xmlns=\"urn:schemas-microsoft-com:xml-analysis\"\n" + "        SOAP-ENV:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\">\n" + "    <RequestType>");
        buf.append(metadataRequest.name());
        buf.append("</RequestType>\n    <Restrictions>\n      <RestrictionList>\n");
        String restrictedCatalogName = null;
        if (restrictions.length > 0) {
            if (restrictions.length % 2 != 0) {
                throw new IllegalArgumentException();
            }
            for (int i = 0; i < restrictions.length; i += 2) {
                String restriction = (String)restrictions[i];
                Object o = restrictions[i + 1];
                if (o instanceof String) {
                    buf.append("<").append(restriction).append(">");
                    String value = (String)o;
                    XmlaOlap4jConnection.xmlEncode(buf, value);
                    buf.append("</").append(restriction).append(">");
                    if (!restriction.equals("CATALOG_NAME")) continue;
                    restrictedCatalogName = value;
                    continue;
                }
                List valueList = (List)o;
                for (String value : valueList) {
                    buf.append("<").append(restriction).append(">");
                    XmlaOlap4jConnection.xmlEncode(buf, value);
                    buf.append("</").append(restriction).append(">");
                }
            }
        }
        buf.append("      </RestrictionList>\n    </Restrictions>\n    <Properties>\n      <PropertyList>\n");
        String conProperties = this.makeConnectionPropertyList();
        if (conProperties != null && !"".equals(conProperties)) {
            buf.append(conProperties);
        }
        if (this.roleName != null && !"".equals(this.roleName)) {
            buf.append("        <Roles>");
            XmlaOlap4jConnection.xmlEncode(buf, this.roleName);
            buf.append("</Roles>\n");
        }
        if (metadataRequest.requiresDatasourceName()) {
            String dataSourceInfo;
            switch (BackendFlavor.getFlavor(context.olap4jConnection)) {
                case ESSBASE: {
                    dataSourceInfo = context.olap4jConnection.getOlapDatabase().getDataSourceInfo();
                    break;
                }
                default: {
                    dataSourceInfo = context.olap4jConnection.getDatabase();
                }
            }
            buf.append("        <DataSourceInfo>");
            XmlaOlap4jConnection.xmlEncode(buf, dataSourceInfo);
            buf.append("</DataSourceInfo>\n");
        }
        String requestCatalogName = null;
        if (restrictedCatalogName != null && restrictedCatalogName.length() > 0) {
            requestCatalogName = restrictedCatalogName;
        }
        if (context.olap4jCatalog != null) {
            requestCatalogName = context.olap4jCatalog.getName();
        }
        if (requestCatalogName == null && metadataRequest.requiresCatalogName() && (catalogs = context.olap4jConnection.getOlapCatalogs()).size() > 0) {
            requestCatalogName = ((Catalog)catalogs.get(0)).getName();
        }
        if (requestCatalogName != null && metadataRequest.allowsCatalogName()) {
            if (this.getOlapCatalogs().get(requestCatalogName) == null) {
                throw new OlapException("No catalog named " + requestCatalogName + " exist on the server.");
            }
            buf.append("        <Catalog>");
            XmlaOlap4jConnection.xmlEncode(buf, requestCatalogName);
            buf.append("</Catalog>\n");
        }
        if (metadataRequest.allowsLocale() && (locale1 = context.olap4jConnection.getLocale()) != null) {
            short lcid = LcidLocale.localeToLcid((Locale)locale1);
            buf.append("<LocaleIdentifier>").append(lcid).append("</LocaleIdentifier>");
        }
        buf.append("        <Content>");
        XmlaOlap4jConnection.xmlEncode(buf, "Data");
        buf.append("</Content>\n      </PropertyList>\n    </Properties>\n  </Discover>\n</SOAP-ENV:Body>\n</SOAP-ENV:Envelope>");
        return buf.toString();
    }

    private static void xmlEncode(StringBuilder buf, String value) {
        int n = value.length();
        block7: for (int i = 0; i < n; ++i) {
            char c = value.charAt(i);
            switch (c) {
                case '&': {
                    buf.append("&amp;");
                    continue block7;
                }
                case '<': {
                    buf.append("&lt;");
                    continue block7;
                }
                case '>': {
                    buf.append("&gt;");
                    continue block7;
                }
                case '\"': {
                    buf.append("&quot;");
                    continue block7;
                }
                case '\'': {
                    buf.append("&apos;");
                    continue block7;
                }
                default: {
                    buf.append(c);
                }
            }
        }
    }

    private static class XmlaOlap4jMdxValidator
    implements MdxValidator {
        private final OlapConnection connection;

        XmlaOlap4jMdxValidator(OlapConnection connection) {
            this.connection = connection;
        }

        public SelectNode validateSelect(SelectNode selectNode) throws OlapException {
            StringWriter sw = new StringWriter();
            selectNode.unparse(new ParseTreeWriter((Writer)sw));
            String mdx = sw.toString();
            XmlaOlap4jConnection olap4jConnection = (XmlaOlap4jConnection)this.connection;
            return selectNode;
        }
    }

    static class MetadataColumn {
        final String name;
        final String xmlaName;

        MetadataColumn(String xmlaName, String name) {
            this.xmlaName = xmlaName;
            this.name = name;
        }

        MetadataColumn(String xmlaName) {
            this.xmlaName = xmlaName;
            String name = xmlaName;
            if (LOWERCASE_PATTERN.matcher(name).matches()) {
                name = Olap4jUtil.camelToUpper((String)name);
            }
            if (name.equals("VALUE")) {
                name = "PROPERTY_VALUE";
            }
            this.name = name;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum MetadataRequest {
        DISCOVER_DATASOURCES(new MetadataColumn("DataSourceName"), new MetadataColumn("DataSourceDescription"), new MetadataColumn("URL"), new MetadataColumn("DataSourceInfo"), new MetadataColumn("ProviderName"), new MetadataColumn("ProviderType"), new MetadataColumn("AuthenticationMode")),
        DISCOVER_SCHEMA_ROWSETS(new MetadataColumn("SchemaName"), new MetadataColumn("SchemaGuid"), new MetadataColumn("Restrictions"), new MetadataColumn("Description")),
        DISCOVER_ENUMERATORS(new MetadataColumn("EnumName"), new MetadataColumn("EnumDescription"), new MetadataColumn("EnumType"), new MetadataColumn("ElementName"), new MetadataColumn("ElementDescription"), new MetadataColumn("ElementValue")),
        DISCOVER_PROPERTIES(new MetadataColumn("PropertyName"), new MetadataColumn("PropertyDescription"), new MetadataColumn("PropertyType"), new MetadataColumn("PropertyAccessType"), new MetadataColumn("IsRequired"), new MetadataColumn("Value")),
        DISCOVER_KEYWORDS(new MetadataColumn("Keyword")),
        DISCOVER_LITERALS(new MetadataColumn("LiteralName"), new MetadataColumn("LiteralValue"), new MetadataColumn("LiteralInvalidChars"), new MetadataColumn("LiteralInvalidStartingChars"), new MetadataColumn("LiteralMaxLength")),
        DBSCHEMA_CATALOGS(new MetadataColumn("CATALOG_NAME"), new MetadataColumn("DESCRIPTION"), new MetadataColumn("ROLES"), new MetadataColumn("DATE_MODIFIED")),
        DBSCHEMA_COLUMNS(new MetadataColumn("TABLE_CATALOG"), new MetadataColumn("TABLE_SCHEMA"), new MetadataColumn("TABLE_NAME"), new MetadataColumn("COLUMN_NAME"), new MetadataColumn("ORDINAL_POSITION"), new MetadataColumn("COLUMN_HAS_DEFAULT"), new MetadataColumn("COLUMN_FLAGS"), new MetadataColumn("IS_NULLABLE"), new MetadataColumn("DATA_TYPE"), new MetadataColumn("CHARACTER_MAXIMUM_LENGTH"), new MetadataColumn("CHARACTER_OCTET_LENGTH"), new MetadataColumn("NUMERIC_PRECISION"), new MetadataColumn("NUMERIC_SCALE")),
        DBSCHEMA_PROVIDER_TYPES(new MetadataColumn("TYPE_NAME"), new MetadataColumn("DATA_TYPE"), new MetadataColumn("COLUMN_SIZE"), new MetadataColumn("LITERAL_PREFIX"), new MetadataColumn("LITERAL_SUFFIX"), new MetadataColumn("IS_NULLABLE"), new MetadataColumn("CASE_SENSITIVE"), new MetadataColumn("SEARCHABLE"), new MetadataColumn("UNSIGNED_ATTRIBUTE"), new MetadataColumn("FIXED_PREC_SCALE"), new MetadataColumn("AUTO_UNIQUE_VALUE"), new MetadataColumn("IS_LONG"), new MetadataColumn("BEST_MATCH")),
        DBSCHEMA_TABLES(new MetadataColumn("TABLE_CATALOG"), new MetadataColumn("TABLE_SCHEMA"), new MetadataColumn("TABLE_NAME"), new MetadataColumn("TABLE_TYPE"), new MetadataColumn("TABLE_GUID"), new MetadataColumn("DESCRIPTION"), new MetadataColumn("TABLE_PROPID"), new MetadataColumn("DATE_CREATED"), new MetadataColumn("DATE_MODIFIED")),
        DBSCHEMA_TABLES_INFO(new MetadataColumn("TABLE_CATALOG"), new MetadataColumn("TABLE_SCHEMA"), new MetadataColumn("TABLE_NAME"), new MetadataColumn("TABLE_TYPE"), new MetadataColumn("TABLE_GUID"), new MetadataColumn("BOOKMARKS"), new MetadataColumn("BOOKMARK_TYPE"), new MetadataColumn("BOOKMARK_DATATYPE"), new MetadataColumn("BOOKMARK_MAXIMUM_LENGTH"), new MetadataColumn("BOOKMARK_INFORMATION"), new MetadataColumn("TABLE_VERSION"), new MetadataColumn("CARDINALITY"), new MetadataColumn("DESCRIPTION"), new MetadataColumn("TABLE_PROPID")),
        DBSCHEMA_SCHEMATA(new MetadataColumn("CATALOG_NAME"), new MetadataColumn("SCHEMA_NAME"), new MetadataColumn("SCHEMA_OWNER")),
        MDSCHEMA_ACTIONS(new MetadataColumn("CATALOG_NAME"), new MetadataColumn("SCHEMA_NAME"), new MetadataColumn("CUBE_NAME"), new MetadataColumn("ACTION_NAME"), new MetadataColumn("COORDINATE"), new MetadataColumn("COORDINATE_TYPE")),
        MDSCHEMA_CUBES(new MetadataColumn("CATALOG_NAME"), new MetadataColumn("SCHEMA_NAME"), new MetadataColumn("CUBE_NAME"), new MetadataColumn("CUBE_TYPE"), new MetadataColumn("CUBE_GUID"), new MetadataColumn("CREATED_ON"), new MetadataColumn("LAST_SCHEMA_UPDATE"), new MetadataColumn("SCHEMA_UPDATED_BY"), new MetadataColumn("LAST_DATA_UPDATE"), new MetadataColumn("DATA_UPDATED_BY"), new MetadataColumn("IS_DRILLTHROUGH_ENABLED"), new MetadataColumn("IS_WRITE_ENABLED"), new MetadataColumn("IS_LINKABLE"), new MetadataColumn("IS_SQL_ENABLED"), new MetadataColumn("DESCRIPTION"), new MetadataColumn("CUBE_CAPTION"), new MetadataColumn("BASE_CUBE_NAME")),
        MDSCHEMA_DIMENSIONS(new MetadataColumn("CATALOG_NAME"), new MetadataColumn("SCHEMA_NAME"), new MetadataColumn("CUBE_NAME"), new MetadataColumn("DIMENSION_NAME"), new MetadataColumn("DIMENSION_UNIQUE_NAME"), new MetadataColumn("DIMENSION_GUID"), new MetadataColumn("DIMENSION_CAPTION"), new MetadataColumn("DIMENSION_ORDINAL"), new MetadataColumn("DIMENSION_TYPE"), new MetadataColumn("DIMENSION_CARDINALITY"), new MetadataColumn("DEFAULT_HIERARCHY"), new MetadataColumn("DESCRIPTION"), new MetadataColumn("IS_VIRTUAL"), new MetadataColumn("IS_READWRITE"), new MetadataColumn("DIMENSION_UNIQUE_SETTINGS"), new MetadataColumn("DIMENSION_MASTER_UNIQUE_NAME"), new MetadataColumn("DIMENSION_IS_VISIBLE")),
        MDSCHEMA_FUNCTIONS(new MetadataColumn("FUNCTION_NAME"), new MetadataColumn("DESCRIPTION"), new MetadataColumn("PARAMETER_LIST"), new MetadataColumn("RETURN_TYPE"), new MetadataColumn("ORIGIN"), new MetadataColumn("INTERFACE_NAME"), new MetadataColumn("LIBRARY_NAME"), new MetadataColumn("CAPTION")),
        MDSCHEMA_HIERARCHIES(new MetadataColumn("CATALOG_NAME"), new MetadataColumn("SCHEMA_NAME"), new MetadataColumn("CUBE_NAME"), new MetadataColumn("DIMENSION_UNIQUE_NAME"), new MetadataColumn("HIERARCHY_NAME"), new MetadataColumn("HIERARCHY_UNIQUE_NAME"), new MetadataColumn("HIERARCHY_GUID"), new MetadataColumn("HIERARCHY_CAPTION"), new MetadataColumn("DIMENSION_TYPE"), new MetadataColumn("HIERARCHY_CARDINALITY"), new MetadataColumn("DEFAULT_MEMBER"), new MetadataColumn("ALL_MEMBER"), new MetadataColumn("DESCRIPTION"), new MetadataColumn("STRUCTURE"), new MetadataColumn("IS_VIRTUAL"), new MetadataColumn("IS_READWRITE"), new MetadataColumn("DIMENSION_UNIQUE_SETTINGS"), new MetadataColumn("DIMENSION_IS_VISIBLE"), new MetadataColumn("HIERARCHY_IS_VISIBLE"), new MetadataColumn("HIERARCHY_ORDINAL"), new MetadataColumn("DIMENSION_IS_SHARED"), new MetadataColumn("PARENT_CHILD")),
        MDSCHEMA_LEVELS(new MetadataColumn("CATALOG_NAME"), new MetadataColumn("SCHEMA_NAME"), new MetadataColumn("CUBE_NAME"), new MetadataColumn("DIMENSION_UNIQUE_NAME"), new MetadataColumn("HIERARCHY_UNIQUE_NAME"), new MetadataColumn("LEVEL_NAME"), new MetadataColumn("LEVEL_UNIQUE_NAME"), new MetadataColumn("LEVEL_GUID"), new MetadataColumn("LEVEL_CAPTION"), new MetadataColumn("LEVEL_NUMBER"), new MetadataColumn("LEVEL_CARDINALITY"), new MetadataColumn("LEVEL_TYPE"), new MetadataColumn("CUSTOM_ROLLUP_SETTINGS"), new MetadataColumn("LEVEL_UNIQUE_SETTINGS"), new MetadataColumn("LEVEL_IS_VISIBLE"), new MetadataColumn("DESCRIPTION")),
        MDSCHEMA_MEASURES(new MetadataColumn("CATALOG_NAME"), new MetadataColumn("SCHEMA_NAME"), new MetadataColumn("CUBE_NAME"), new MetadataColumn("MEASURE_NAME"), new MetadataColumn("MEASURE_UNIQUE_NAME"), new MetadataColumn("MEASURE_CAPTION"), new MetadataColumn("MEASURE_GUID"), new MetadataColumn("MEASURE_AGGREGATOR"), new MetadataColumn("DATA_TYPE"), new MetadataColumn("MEASURE_IS_VISIBLE"), new MetadataColumn("LEVELS_LIST"), new MetadataColumn("DESCRIPTION")),
        MDSCHEMA_MEMBERS(new MetadataColumn("CATALOG_NAME"), new MetadataColumn("SCHEMA_NAME"), new MetadataColumn("CUBE_NAME"), new MetadataColumn("DIMENSION_UNIQUE_NAME"), new MetadataColumn("HIERARCHY_UNIQUE_NAME"), new MetadataColumn("LEVEL_UNIQUE_NAME"), new MetadataColumn("LEVEL_NUMBER"), new MetadataColumn("MEMBER_ORDINAL"), new MetadataColumn("MEMBER_NAME"), new MetadataColumn("MEMBER_UNIQUE_NAME"), new MetadataColumn("MEMBER_TYPE"), new MetadataColumn("MEMBER_GUID"), new MetadataColumn("MEMBER_CAPTION"), new MetadataColumn("CHILDREN_CARDINALITY"), new MetadataColumn("PARENT_LEVEL"), new MetadataColumn("PARENT_UNIQUE_NAME"), new MetadataColumn("PARENT_COUNT"), new MetadataColumn("TREE_OP"), new MetadataColumn("DEPTH")),
        MDSCHEMA_PROPERTIES(new MetadataColumn("CATALOG_NAME"), new MetadataColumn("SCHEMA_NAME"), new MetadataColumn("CUBE_NAME"), new MetadataColumn("DIMENSION_UNIQUE_NAME"), new MetadataColumn("HIERARCHY_UNIQUE_NAME"), new MetadataColumn("LEVEL_UNIQUE_NAME"), new MetadataColumn("MEMBER_UNIQUE_NAME"), new MetadataColumn("PROPERTY_NAME"), new MetadataColumn("PROPERTY_CAPTION"), new MetadataColumn("PROPERTY_TYPE"), new MetadataColumn("DATA_TYPE"), new MetadataColumn("PROPERTY_CONTENT_TYPE"), new MetadataColumn("DESCRIPTION")),
        MDSCHEMA_SETS(new MetadataColumn("CATALOG_NAME"), new MetadataColumn("SCHEMA_NAME"), new MetadataColumn("CUBE_NAME"), new MetadataColumn("SET_NAME"), new MetadataColumn("SCOPE"));

        final List<MetadataColumn> columns;
        final Map<String, MetadataColumn> columnsByName;

        private MetadataRequest(MetadataColumn ... columns) {
            if (this.name().equals("DBSCHEMA_CATALOGS")) {
                columns = new MetadataColumn[]{new MetadataColumn("CATALOG_NAME", "TABLE_CAT")};
            } else if (this.name().equals("DBSCHEMA_SCHEMATA")) {
                columns = new MetadataColumn[]{new MetadataColumn("SCHEMA_NAME", "TABLE_SCHEM"), new MetadataColumn("CATALOG_NAME", "TABLE_CAT")};
            }
            this.columns = UnmodifiableArrayList.asCopyOf((Object[])columns);
            HashMap<String, MetadataColumn> map = new HashMap<String, MetadataColumn>();
            for (MetadataColumn column : columns) {
                map.put(column.name, column);
            }
            this.columnsByName = Collections.unmodifiableMap(map);
        }

        public boolean requiresDatasourceName() {
            return this != DISCOVER_DATASOURCES && this != DISCOVER_PROPERTIES;
        }

        public boolean requiresCatalogName() {
            return this == MDSCHEMA_FUNCTIONS;
        }

        public boolean allowsCatalogName() {
            return true;
        }

        public MetadataColumn getColumn(String name) {
            return this.columnsByName.get(name);
        }

        public boolean allowsLocale() {
            return this.name().startsWith("MDSCHEMA");
        }
    }

    static class Context {
        final XmlaOlap4jConnection olap4jConnection;
        final XmlaOlap4jDatabaseMetaData olap4jDatabaseMetaData;
        final XmlaOlap4jCatalog olap4jCatalog;
        final XmlaOlap4jSchema olap4jSchema;
        final XmlaOlap4jCube olap4jCube;
        final XmlaOlap4jDimension olap4jDimension;
        final XmlaOlap4jHierarchy olap4jHierarchy;
        final XmlaOlap4jLevel olap4jLevel;

        Context(XmlaOlap4jConnection olap4jConnection, XmlaOlap4jDatabaseMetaData olap4jDatabaseMetaData, XmlaOlap4jCatalog olap4jCatalog, XmlaOlap4jSchema olap4jSchema, XmlaOlap4jCube olap4jCube, XmlaOlap4jDimension olap4jDimension, XmlaOlap4jHierarchy olap4jHierarchy, XmlaOlap4jLevel olap4jLevel) {
            this.olap4jConnection = olap4jConnection;
            this.olap4jDatabaseMetaData = olap4jDatabaseMetaData;
            this.olap4jCatalog = olap4jCatalog;
            this.olap4jSchema = olap4jSchema;
            this.olap4jCube = olap4jCube;
            this.olap4jDimension = olap4jDimension;
            this.olap4jHierarchy = olap4jHierarchy;
            this.olap4jLevel = olap4jLevel;
            assert (!(olap4jDatabaseMetaData == null && olap4jCatalog != null || olap4jCatalog == null && olap4jSchema != null || olap4jSchema == null && olap4jCube != null || olap4jCube == null && olap4jDimension != null || olap4jDimension == null && olap4jHierarchy != null || olap4jHierarchy == null && olap4jLevel != null));
        }

        Context(XmlaOlap4jCube olap4jCube, XmlaOlap4jDimension olap4jDimension, XmlaOlap4jHierarchy olap4jHierarchy, XmlaOlap4jLevel olap4jLevel) {
            this(olap4jCube.olap4jSchema.olap4jCatalog.olap4jDatabaseMetaData.olap4jConnection, olap4jCube.olap4jSchema.olap4jCatalog.olap4jDatabaseMetaData, olap4jCube.olap4jSchema.olap4jCatalog, olap4jCube.olap4jSchema, olap4jCube, olap4jDimension, olap4jHierarchy, olap4jLevel);
        }

        Context(XmlaOlap4jLevel olap4jLevel) {
            this(olap4jLevel.olap4jHierarchy.olap4jDimension.olap4jCube, olap4jLevel.olap4jHierarchy.olap4jDimension, olap4jLevel.olap4jHierarchy, olap4jLevel);
        }

        XmlaOlap4jHierarchy getHierarchy(Element row) {
            if (this.olap4jHierarchy != null) {
                return this.olap4jHierarchy;
            }
            String hierarchyUniqueName = XmlaOlap4jUtil.stringElement(row, "HIERARCHY_UNIQUE_NAME");
            XmlaOlap4jHierarchy hierarchy = this.getCube((Element)row).hierarchiesByUname.get(hierarchyUniqueName);
            if (hierarchy == null) {
                String dimensionUniqueName = XmlaOlap4jUtil.stringElement(row, "DIMENSION_UNIQUE_NAME");
                String dimensionName = (String)Olap4jUtil.parseUniqueName((String)dimensionUniqueName).get(0);
                XmlaOlap4jDimension dimension = (XmlaOlap4jDimension)this.getCube((Element)row).dimensions.get(dimensionName);
                dimension.getHierarchies().size();
                hierarchy = this.getCube((Element)row).hierarchiesByUname.get(hierarchyUniqueName);
            }
            return hierarchy;
        }

        XmlaOlap4jCube getCube(Element row) {
            if (this.olap4jCube != null) {
                return this.olap4jCube;
            }
            throw new UnsupportedOperationException();
        }

        XmlaOlap4jDimension getDimension(Element row) {
            if (this.olap4jDimension != null) {
                return this.olap4jDimension;
            }
            String dimensionUniqueName = XmlaOlap4jUtil.stringElement(row, "DIMENSION_UNIQUE_NAME");
            XmlaOlap4jDimension dimension = this.getCube((Element)row).dimensionsByUname.get(dimensionUniqueName);
            if (dimension == null) {
                String dimensionName = XmlaOlap4jUtil.stringElement(row, "DIMENSION_NAME");
                return (XmlaOlap4jDimension)this.getCube((Element)row).dimensions.get(dimensionName);
            }
            return dimension;
        }

        public XmlaOlap4jLevel getLevel(Element row) {
            if (this.olap4jLevel != null) {
                return this.olap4jLevel;
            }
            String levelUniqueName = XmlaOlap4jUtil.stringElement(row, "LEVEL_UNIQUE_NAME");
            XmlaOlap4jLevel level = this.getCube((Element)row).levelsByUname.get(levelUniqueName);
            if (level == null) {
                String dimensionUniqueName = XmlaOlap4jUtil.stringElement(row, "DIMENSION_UNIQUE_NAME");
                String dimensionName = (String)Olap4jUtil.parseUniqueName((String)dimensionUniqueName).get(0);
                XmlaOlap4jDimension dimension = (XmlaOlap4jDimension)this.getCube((Element)row).dimensions.get(dimensionName);
                for (Hierarchy hierarchyInit : dimension.getHierarchies()) {
                    hierarchyInit.getLevels().size();
                }
                level = this.getCube((Element)row).levelsByUname.get(levelUniqueName);
            }
            return level;
        }

        public XmlaOlap4jCatalog getCatalog(Element row) throws OlapException {
            if (this.olap4jCatalog != null) {
                return this.olap4jCatalog;
            }
            String catalogName = XmlaOlap4jUtil.stringElement(row, "CATALOG_NAME");
            return (XmlaOlap4jCatalog)this.olap4jConnection.getOlapCatalogs().get(catalogName);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static abstract class HandlerImpl<T extends Named>
    implements Handler<T> {
        HandlerImpl() {
        }

        @Override
        public void sortList(List<T> list) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static interface Handler<T extends Named> {
        public void handle(Element var1, Context var2, List<T> var3) throws OlapException;

        public void sortList(List<T> var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class PropertyHandler
    extends HandlerImpl<XmlaOlap4jProperty> {
        PropertyHandler() {
        }

        @Override
        public void handle(Element row, Context context, List<XmlaOlap4jProperty> list) throws OlapException {
            String description = XmlaOlap4jUtil.stringElement(row, "DESCRIPTION");
            String uniqueName = XmlaOlap4jUtil.stringElement(row, "DESCRIPTION");
            String caption = XmlaOlap4jUtil.stringElement(row, "PROPERTY_CAPTION");
            String name = XmlaOlap4jUtil.stringElement(row, "PROPERTY_NAME");
            Datatype ordinalDatatype = (Datatype)Datatype.getDictionary().forName(XmlaOlap4jUtil.stringElement(row, "DATA_TYPE"));
            Datatype datatype = ordinalDatatype == null ? (Datatype)Datatype.getDictionary().forOrdinal(XmlaOlap4jUtil.integerElement(row, "DATA_TYPE").intValue()) : ordinalDatatype;
            Integer contentTypeOrdinal = XmlaOlap4jUtil.integerElement(row, "PROPERTY_CONTENT_TYPE");
            Property.ContentType contentType = contentTypeOrdinal == null ? null : (Property.ContentType)Property.ContentType.getDictionary().forOrdinal(contentTypeOrdinal.intValue());
            int propertyType = XmlaOlap4jUtil.integerElement(row, "PROPERTY_TYPE");
            Set type = Property.TypeFlag.getDictionary().forMask(propertyType);
            list.add(new XmlaOlap4jProperty(uniqueName, name, caption, description, datatype, type, contentType));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class CatalogSchemaHandler
    extends HandlerImpl<XmlaOlap4jSchema> {
        private String catalogName;

        public CatalogSchemaHandler(String catalogName) {
            if (catalogName == null) {
                throw new RuntimeException("The CatalogSchemaHandler handler requires a catalog name.");
            }
            this.catalogName = catalogName;
        }

        @Override
        public void handle(Element row, Context context, List<XmlaOlap4jSchema> list) throws OlapException {
            String schemaName2;
            String schemaName = XmlaOlap4jUtil.stringElement(row, "SCHEMA_NAME");
            String catalogName = XmlaOlap4jUtil.stringElement(row, "CATALOG_NAME");
            String string = schemaName2 = schemaName == null ? "" : schemaName;
            if (this.catalogName.equals(catalogName) && ((NamedList)list).get(schemaName2) == null) {
                list.add(new XmlaOlap4jSchema(context.getCatalog(row), schemaName2));
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class SchemaHandler
    extends HandlerImpl<XmlaOlap4jSchema> {
        SchemaHandler() {
        }

        @Override
        public void handle(Element row, Context context, List<XmlaOlap4jSchema> list) throws OlapException {
            String schemaName = XmlaOlap4jUtil.stringElement(row, "SCHEMA_NAME");
            list.add(new XmlaOlap4jSchema(context.getCatalog(row), schemaName == null ? "" : schemaName));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class NamedSetHandler
    extends HandlerImpl<XmlaOlap4jNamedSet> {
        NamedSetHandler() {
        }

        @Override
        public void handle(Element row, Context context, List<XmlaOlap4jNamedSet> list) {
            String setName = XmlaOlap4jUtil.stringElement(row, "SET_NAME");
            list.add(new XmlaOlap4jNamedSet(context.getCube(row), setName));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class MemberHandler
    extends HandlerImpl<XmlaOlap4jMember> {
        private static final Set<String> EXCLUDED_PROPERTY_NAMES = new HashSet<String>(Arrays.asList(Property.StandardMemberProperty.CATALOG_NAME.name(), Property.StandardMemberProperty.CUBE_NAME.name(), Property.StandardMemberProperty.DIMENSION_UNIQUE_NAME.name(), Property.StandardMemberProperty.HIERARCHY_UNIQUE_NAME.name(), Property.StandardMemberProperty.LEVEL_UNIQUE_NAME.name(), Property.StandardMemberProperty.PARENT_LEVEL.name(), Property.StandardMemberProperty.PARENT_COUNT.name(), Property.StandardMemberProperty.MEMBER_KEY.name(), Property.StandardMemberProperty.IS_PLACEHOLDERMEMBER.name(), Property.StandardMemberProperty.IS_DATAMEMBER.name(), Property.StandardMemberProperty.LEVEL_NUMBER.name(), Property.StandardMemberProperty.MEMBER_ORDINAL.name(), Property.StandardMemberProperty.MEMBER_UNIQUE_NAME.name(), Property.StandardMemberProperty.MEMBER_NAME.name(), Property.StandardMemberProperty.PARENT_UNIQUE_NAME.name(), Property.StandardMemberProperty.MEMBER_TYPE.name(), Property.StandardMemberProperty.MEMBER_CAPTION.name(), Property.StandardMemberProperty.CHILDREN_CARDINALITY.name(), Property.StandardMemberProperty.DEPTH.name()));
        private static final Member.Type[] MEMBER_TYPE_VALUES = Member.Type.values();

        MemberHandler() {
        }

        @Override
        public void handle(Element row, Context context, List<XmlaOlap4jMember> list) {
            int memberOrdinal = XmlaOlap4jUtil.integerElement(row, Property.StandardMemberProperty.MEMBER_ORDINAL.name());
            String memberUniqueName = XmlaOlap4jUtil.stringElement(row, Property.StandardMemberProperty.MEMBER_UNIQUE_NAME.name());
            String memberName = XmlaOlap4jUtil.stringElement(row, Property.StandardMemberProperty.MEMBER_NAME.name());
            String parentUniqueName = XmlaOlap4jUtil.stringElement(row, Property.StandardMemberProperty.PARENT_UNIQUE_NAME.name());
            Member.Type memberType = MEMBER_TYPE_VALUES[XmlaOlap4jUtil.integerElement(row, Property.StandardMemberProperty.MEMBER_TYPE.name())];
            String memberCaption = XmlaOlap4jUtil.stringElement(row, Property.StandardMemberProperty.MEMBER_CAPTION.name());
            int childrenCardinality = XmlaOlap4jUtil.integerElement(row, Property.StandardMemberProperty.CHILDREN_CARDINALITY.name());
            XmlaOlap4jLevel level = context.getLevel(row);
            HashMap<Property, Object> map = new HashMap<Property, Object>();
            this.addUserDefinedDimensionProperties(row, level, map);
            Integer depth = XmlaOlap4jUtil.integerElement(row, Property.StandardMemberProperty.DEPTH.name());
            if (depth != null && depth.intValue() != level.getDepth()) {
                map.put((Property)Property.StandardMemberProperty.DEPTH, depth);
            }
            XmlaOlap4jMember member = new XmlaOlap4jMember(level, memberUniqueName, memberName, memberCaption, "", parentUniqueName, memberType, childrenCardinality, memberOrdinal, map);
            list.add(member);
        }

        private void addUserDefinedDimensionProperties(Element row, XmlaOlap4jLevel level, Map<Property, Object> map) {
            NodeList nodes = row.getChildNodes();
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node node = nodes.item(i);
                if (EXCLUDED_PROPERTY_NAMES.contains(node.getLocalName())) continue;
                for (Property property : level.getProperties()) {
                    if (!(property instanceof XmlaOlap4jProperty) || !property.getName().equalsIgnoreCase(node.getLocalName())) continue;
                    map.put(property, node.getTextContent());
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class MeasureHandler
    extends HandlerImpl<XmlaOlap4jMeasure> {
        MeasureHandler() {
        }

        @Override
        public void handle(Element row, Context context, List<XmlaOlap4jMeasure> list) throws OlapException {
            String measureName = XmlaOlap4jUtil.stringElement(row, "MEASURE_NAME");
            String measureUniqueName = XmlaOlap4jUtil.stringElement(row, "MEASURE_UNIQUE_NAME");
            String measureCaption = XmlaOlap4jUtil.stringElement(row, "MEASURE_CAPTION");
            String description = XmlaOlap4jUtil.stringElement(row, "DESCRIPTION");
            String formatString = XmlaOlap4jUtil.stringElement(row, "DEFAULT_FORMAT_STRING");
            Measure.Aggregator measureAggregator = (Measure.Aggregator)Measure.Aggregator.getDictionary().forOrdinal(XmlaOlap4jUtil.integerElement(row, "MEASURE_AGGREGATOR").intValue());
            Datatype ordinalDatatype = (Datatype)Datatype.getDictionary().forName(XmlaOlap4jUtil.stringElement(row, "DATA_TYPE"));
            Datatype datatype = ordinalDatatype == null ? (Datatype)Datatype.getDictionary().forOrdinal(XmlaOlap4jUtil.integerElement(row, "DATA_TYPE").intValue()) : ordinalDatatype;
            boolean measureIsVisible = XmlaOlap4jUtil.booleanElement(row, "MEASURE_IS_VISIBLE");
            XmlaOlap4jMember member = context.getCube(row).getMetadataReader().lookupMemberByUniqueName(measureUniqueName);
            if (member == null) {
                throw new OlapException("The server failed to resolve a member with the same unique name as a measure named " + measureUniqueName);
            }
            list.add(new XmlaOlap4jMeasure((XmlaOlap4jLevel)member.getLevel(), measureUniqueName, measureName, measureCaption, description, formatString, null, measureAggregator, datatype, measureIsVisible, member.getOrdinal()));
        }

        @Override
        public void sortList(List<XmlaOlap4jMeasure> list) {
            Collections.sort(list, new Comparator<XmlaOlap4jMeasure>(){

                @Override
                public int compare(XmlaOlap4jMeasure o1, XmlaOlap4jMeasure o2) {
                    return o1.getOrdinal() - o2.getOrdinal();
                }
            });
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class LevelHandler
    extends HandlerImpl<XmlaOlap4jLevel> {
        public static final int MDLEVEL_TYPE_CALCULATED = 2;
        private final XmlaOlap4jCube cubeForCallback;

        public LevelHandler(XmlaOlap4jCube cubeForCallback) {
            this.cubeForCallback = cubeForCallback;
        }

        @Override
        public void handle(Element row, Context context, List<XmlaOlap4jLevel> list) {
            String levelUniqueName = XmlaOlap4jUtil.stringElement(row, "LEVEL_UNIQUE_NAME");
            String levelName = XmlaOlap4jUtil.stringElement(row, "LEVEL_NAME") == null ? (levelUniqueName != null ? levelUniqueName.replaceAll("^\\[", "").replaceAll("\\]$", "") : null) : XmlaOlap4jUtil.stringElement(row, "LEVEL_NAME");
            String levelCaption = XmlaOlap4jUtil.stringElement(row, "LEVEL_CAPTION");
            String description = XmlaOlap4jUtil.stringElement(row, "DESCRIPTION");
            int levelNumber = XmlaOlap4jUtil.integerElement(row, "LEVEL_NUMBER");
            Integer levelTypeCode = XmlaOlap4jUtil.integerElement(row, "LEVEL_TYPE");
            Level.Type levelType = (Level.Type)Level.Type.getDictionary().forOrdinal(levelTypeCode.intValue());
            boolean calculated = (levelTypeCode & 2) != 0;
            int levelCardinality = XmlaOlap4jUtil.integerElement(row, "LEVEL_CARDINALITY");
            XmlaOlap4jLevel level = new XmlaOlap4jLevel(context.getHierarchy(row), levelUniqueName, levelName, levelCaption, description, levelNumber, levelType, calculated, levelCardinality);
            list.add(level);
            this.cubeForCallback.levelsByUname.put(level.getUniqueName(), level);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class HierarchyHandler
    extends HandlerImpl<XmlaOlap4jHierarchy> {
        private final XmlaOlap4jCube cubeForCallback;

        public HierarchyHandler(XmlaOlap4jCube cubeForCallback) {
            this.cubeForCallback = cubeForCallback;
        }

        @Override
        public void handle(Element row, Context context, List<XmlaOlap4jHierarchy> list) throws OlapException {
            String hierarchyUniqueName = XmlaOlap4jUtil.stringElement(row, "HIERARCHY_UNIQUE_NAME");
            String hierarchyName = XmlaOlap4jUtil.stringElement(row, "HIERARCHY_NAME") == null ? (hierarchyUniqueName != null ? hierarchyUniqueName.replaceAll("^\\[", "").replaceAll("\\]$", "") : null) : XmlaOlap4jUtil.stringElement(row, "HIERARCHY_NAME");
            String hierarchyCaption = XmlaOlap4jUtil.stringElement(row, "HIERARCHY_CAPTION");
            String description = XmlaOlap4jUtil.stringElement(row, "DESCRIPTION");
            String allMember = XmlaOlap4jUtil.stringElement(row, "ALL_MEMBER");
            String defaultMemberUniqueName = XmlaOlap4jUtil.stringElement(row, "DEFAULT_MEMBER");
            XmlaOlap4jHierarchy hierarchy = new XmlaOlap4jHierarchy(context.getDimension(row), hierarchyUniqueName, hierarchyName, hierarchyCaption, description, allMember != null, defaultMemberUniqueName);
            list.add(hierarchy);
            this.cubeForCallback.hierarchiesByUname.put(hierarchy.getUniqueName(), hierarchy);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class DimensionHandler
    extends HandlerImpl<XmlaOlap4jDimension> {
        private final XmlaOlap4jCube cubeForCallback;

        public DimensionHandler(XmlaOlap4jCube cube) {
            this.cubeForCallback = cube;
        }

        @Override
        public void handle(Element row, Context context, List<XmlaOlap4jDimension> list) {
            String dimensionName = XmlaOlap4jUtil.stringElement(row, "DIMENSION_NAME");
            String dimensionUniqueName = XmlaOlap4jUtil.stringElement(row, "DIMENSION_UNIQUE_NAME");
            String dimensionCaption = XmlaOlap4jUtil.stringElement(row, "DIMENSION_CAPTION");
            String description = XmlaOlap4jUtil.stringElement(row, "DESCRIPTION");
            int dimensionType = XmlaOlap4jUtil.integerElement(row, "DIMENSION_TYPE");
            Dimension.Type type = (Dimension.Type)Dimension.Type.getDictionary().forOrdinal(dimensionType);
            String defaultHierarchyUniqueName = XmlaOlap4jUtil.stringElement(row, "DEFAULT_HIERARCHY");
            Integer dimensionOrdinal = XmlaOlap4jUtil.integerElement(row, "DIMENSION_ORDINAL");
            XmlaOlap4jDimension dimension = new XmlaOlap4jDimension(context.olap4jCube, dimensionUniqueName, dimensionName, dimensionCaption, description, type, defaultHierarchyUniqueName, dimensionOrdinal == null ? 0 : dimensionOrdinal);
            list.add(dimension);
            if (dimensionOrdinal != null) {
                Collections.sort(list, new Comparator<XmlaOlap4jDimension>(){

                    @Override
                    public int compare(XmlaOlap4jDimension d1, XmlaOlap4jDimension d2) {
                        if (d1.getOrdinal() == d2.getOrdinal()) {
                            return 0;
                        }
                        if (d1.getOrdinal() > d2.getOrdinal()) {
                            return 1;
                        }
                        return -1;
                    }
                });
            }
            this.cubeForCallback.dimensionsByUname.put(dimension.getUniqueName(), dimension);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class CubeHandler
    extends HandlerImpl<XmlaOlap4jCube> {
        CubeHandler() {
        }

        @Override
        public void handle(Element row, Context context, List<XmlaOlap4jCube> list) throws OlapException {
            String cubeName = XmlaOlap4jUtil.stringElement(row, "CUBE_NAME");
            String caption = XmlaOlap4jUtil.stringElement(row, "CUBE_CAPTION");
            if (caption == null) {
                caption = cubeName;
            }
            String description = XmlaOlap4jUtil.stringElement(row, "DESCRIPTION");
            list.add(new XmlaOlap4jCube(context.olap4jSchema, cubeName, caption, description));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class CatalogHandler
    extends HandlerImpl<XmlaOlap4jCatalog> {
        private final XmlaOlap4jDatabase database;

        public CatalogHandler(XmlaOlap4jDatabase database) {
            this.database = database;
        }

        @Override
        public void handle(Element row, Context context, List<XmlaOlap4jCatalog> list) {
            String catalogName = XmlaOlap4jUtil.stringElement(row, "CATALOG_NAME");
            String roles = XmlaOlap4jUtil.stringElement(row, "ROLES");
            ArrayList<String> roleList = new ArrayList<String>();
            if (roles != null && !"".equals(roles)) {
                for (String role : roles.split(",")) {
                    roleList.add(role);
                }
            }
            list.add(new XmlaOlap4jCatalog(context.olap4jDatabaseMetaData, this.database, catalogName, roleList));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class DatabaseHandler
    extends HandlerImpl<XmlaOlap4jDatabase> {
        DatabaseHandler() {
        }

        @Override
        public void handle(Element row, Context context, List<XmlaOlap4jDatabase> list) {
            String dsName = XmlaOlap4jUtil.stringElement(row, "DataSourceName");
            String dsDesc = XmlaOlap4jUtil.stringElement(row, "DataSourceDescription");
            String url = XmlaOlap4jUtil.stringElement(row, "URL");
            String dsInfo = XmlaOlap4jUtil.stringElement(row, "DataSourceInfo");
            String providerName = XmlaOlap4jUtil.stringElement(row, "ProviderName");
            StringTokenizer st = new StringTokenizer(XmlaOlap4jUtil.stringElement(row, "ProviderType"), ",");
            ArrayList<Database.ProviderType> pTypeList = new ArrayList<Database.ProviderType>();
            while (st.hasMoreTokens()) {
                pTypeList.add(Database.ProviderType.valueOf((String)st.nextToken()));
            }
            st = new StringTokenizer(XmlaOlap4jUtil.stringElement(row, "AuthenticationMode"), ",");
            ArrayList<Database.AuthenticationMode> aModeList = new ArrayList<Database.AuthenticationMode>();
            while (st.hasMoreTokens()) {
                aModeList.add(Database.AuthenticationMode.valueOf((String)st.nextToken()));
            }
            list.add(new XmlaOlap4jDatabase(context.olap4jConnection, dsName, dsDesc, providerName, url, dsInfo, pTypeList, aModeList));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum BackendFlavor {
        MONDRIAN("Mondrian"),
        SSAS("Microsoft"),
        PALO("Palo"),
        SAP("SAP"),
        ESSBASE("Essbase"),
        UNKNOWN("");

        private final String token;

        private BackendFlavor(String token) {
            this.token = token;
        }

        static BackendFlavor getFlavor(XmlaOlap4jConnection conn) throws OlapException {
            String dataSourceInfo = conn.getOlapDatabase().getDataSourceInfo();
            for (BackendFlavor flavor : BackendFlavor.values()) {
                if (!dataSourceInfo.contains(flavor.token)) continue;
                return flavor;
            }
            throw new AssertionError((Object)"Can't determine the backend vendor.");
        }
    }
}

