/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.resgen;

import java.io.File;
import java.io.IOException;
import org.eigenbase.resgen.FileTask;
import org.eigenbase.resgen.PropertiesFileTask;
import org.eigenbase.resgen.ResourceDef;
import org.eigenbase.resgen.ResourceGenTask;
import org.eigenbase.resgen.XmlFileTask;
import org.eigenbase.xom.DOMWrapper;

public class ResourceGen {
    public static void main(String[] args) throws IOException {
        ResourceGenTask rootArgs = ResourceGen.parse(args);
        new ResourceGen().run(rootArgs);
    }

    static ResourceGenTask parse(String[] args) {
        ResourceGenTask rootArgs = new ResourceGenTask();
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (arg.equals("-mode") && i + 1 < args.length) {
                rootArgs.setMode(args[++i]);
                continue;
            }
            if (arg.equals("-srcdir") && i + 1 < args.length) {
                rootArgs.setSrcdir(new File(args[++i]));
                continue;
            }
            if (arg.equals("-destdir") && i + 1 < args.length) {
                rootArgs.setDestdir(new File(args[++i]));
                continue;
            }
            if (arg.equals("-resdir") && i + 1 < args.length) {
                rootArgs.setResdir(new File(args[++i]));
                continue;
            }
            if (arg.equals("-locales") && i + 1 < args.length) {
                rootArgs.setLocales(args[++i]);
                continue;
            }
            if (arg.equals("-style") && i + 1 < args.length) {
                rootArgs.setStyle(args[++i]);
                continue;
            }
            if (arg.equals("-force")) {
                rootArgs.setForce(true);
                continue;
            }
            if (arg.equals("-commentstyle")) {
                rootArgs.setCommentStyle(args[++i]);
                continue;
            }
            ResourceGenTask.Include resourceArgs = new ResourceGenTask.Include();
            rootArgs.addInclude(resourceArgs);
            resourceArgs.setName(arg);
        }
        if (rootArgs.getIncludes().length == 0) {
            throw new Error("No input file specified.");
        }
        if (rootArgs.getDestdir() == null) {
            rootArgs.setDestdir(rootArgs.getSrcdir());
        }
        return rootArgs;
    }

    void run(ResourceGenTask rootArgs) throws IOException {
        rootArgs.validate();
        ResourceGenTask.Include[] includes = rootArgs.getIncludes();
        for (int i = 0; i < includes.length; ++i) {
            includes[i].process(this);
        }
    }

    void comment(String message) {
        System.out.println(message);
    }

    static String getResourceInitcap(ResourceDef.Resource resource) {
        String name = resource.name;
        if (name.equals(name.toUpperCase())) {
            return "_" + name;
        }
        return name.substring(0, 1).toUpperCase() + name.substring(1);
    }

    static String getComment(ResourceDef.Resource resource) {
        DOMWrapper[] children = resource.getDef().getChildren();
        for (int i = 0; i < children.length; ++i) {
            DOMWrapper child = children[i];
            if (child.getType() != 3) continue;
            return child.getText();
        }
        return null;
    }

    FileTask createXmlTask(ResourceGenTask.Include include, String fileName, String className, String baseClassName, boolean outputJava, String cppClassName, String cppBaseClassName, boolean outputCpp) {
        return new XmlFileTask(include, fileName, className, baseClassName, outputJava, cppClassName, cppBaseClassName, outputCpp);
    }

    FileTask createPropertiesTask(ResourceGenTask.Include include, String fileName) {
        return new PropertiesFileTask(include, fileName);
    }
}

