/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.tools.configeditor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreePath;
import org.pentaho.reporting.libraries.base.boot.AbstractBoot;
import org.pentaho.reporting.libraries.base.config.HierarchicalConfiguration;
import org.pentaho.reporting.tools.configeditor.editor.ConfigEditorPanel;
import org.pentaho.reporting.tools.configeditor.model.ConfigDescriptionEntry;
import org.pentaho.reporting.tools.configeditor.model.ConfigTreeModel;
import org.pentaho.reporting.tools.configeditor.model.ConfigTreeModuleNode;
import org.pentaho.reporting.tools.configeditor.util.ConfigTreeRenderer;

public class ConfigEditorPane
extends JPanel {
    private ConfigEditorPanel detailEditorPane;
    private ConfigTreeModel treeModel;
    private JTree tree;
    private HierarchicalConfiguration configuration;
    private AbstractBoot packageManager;

    public ConfigEditorPane(AbstractBoot packageManager, boolean includeGlobals) {
        this.packageManager = packageManager;
        this.detailEditorPane = new ConfigEditorPanel();
        this.setLayout(new BorderLayout());
        JSplitPane splitPane = new JSplitPane(1, this.createEntryTree(includeGlobals), this.detailEditorPane);
        splitPane.setDividerLocation(250);
        this.add((Component)splitPane, "Center");
    }

    private JComponent createEntryTree(boolean includeGlobals) {
        this.treeModel = new ConfigTreeModel(this.packageManager, includeGlobals);
        DefaultTreeSelectionModel selectionModel = new DefaultTreeSelectionModel();
        selectionModel.setSelectionMode(1);
        this.tree = new JTree(this.treeModel);
        this.tree.setSelectionModel(selectionModel);
        this.tree.setCellRenderer(new ConfigTreeRenderer());
        this.tree.setRootVisible(false);
        this.tree.setShowsRootHandles(true);
        this.tree.addTreeSelectionListener(new ModuleTreeSelectionHandler());
        return new JScrollPane(this.tree, 20, 31);
    }

    public void updateConfiguration(HierarchicalConfiguration configuration) {
        this.configuration = configuration;
        this.treeModel.updateConfiguration();
        for (int i = 0; i < this.tree.getRowCount(); ++i) {
            this.tree.expandRow(i);
        }
        this.tree.setSelectionRow(1);
    }

    public void reset() {
        if (this.configuration == null) {
            return;
        }
        Enumeration defaults = this.configuration.getConfigProperties();
        while (defaults.hasMoreElements()) {
            String key = (String)defaults.nextElement();
            this.configuration.setConfigProperty(key, null);
        }
    }

    public String getDescriptionForKey(String key) {
        ConfigDescriptionEntry entry = this.treeModel.getEntryForKey(key);
        if (entry != null) {
            return entry.getDescription();
        }
        return null;
    }

    public void load(boolean append) throws IOException {
        this.treeModel.load(append);
    }

    public void loadModel(InputStream in, boolean append) throws IOException {
        this.treeModel.load(in, append);
    }

    protected ConfigEditorPanel getDetailEditorPane() {
        return this.detailEditorPane;
    }

    public void commit() {
        this.detailEditorPane.store();
    }

    private class ModuleTreeSelectionHandler
    implements TreeSelectionListener {
        protected ModuleTreeSelectionHandler() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            if (ConfigEditorPane.this.configuration == null) {
                throw new IllegalStateException("Need a configuration");
            }
            TreePath path = e.getPath();
            Object lastPathElement = path.getLastPathComponent();
            if (lastPathElement instanceof ConfigTreeModuleNode) {
                ConfigTreeModuleNode node = (ConfigTreeModuleNode)lastPathElement;
                ConfigEditorPanel detailEditorPane = ConfigEditorPane.this.getDetailEditorPane();
                detailEditorPane.store();
                detailEditorPane.editModule(node.getModule(), ConfigEditorPane.this.configuration, node.getAssignedKeys());
            }
        }
    }
}

