/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.tools.configeditor.editor;

import java.util.HashMap;
import java.util.Iterator;
import org.pentaho.reporting.libraries.base.boot.Module;
import org.pentaho.reporting.libraries.base.config.HierarchicalConfiguration;
import org.pentaho.reporting.tools.configeditor.Messages;
import org.pentaho.reporting.tools.configeditor.editor.DefaultModuleEditor;
import org.pentaho.reporting.tools.configeditor.editor.ModuleEditor;
import org.pentaho.reporting.tools.configeditor.model.ConfigDescriptionEntry;

public final class EditorFactory {
    private static EditorFactory factory;
    private final HashMap<ModuleEditor, Integer> priorities;
    private final Messages messages = Messages.getInstance();

    private EditorFactory() {
        this.priorities = new HashMap();
        this.registerModuleEditor(new DefaultModuleEditor(), -1);
    }

    public static synchronized EditorFactory getInstance() {
        if (factory == null) {
            factory = new EditorFactory();
        }
        return factory;
    }

    public void registerModuleEditor(ModuleEditor editor, int priority) {
        if (editor == null) {
            throw new NullPointerException(this.messages.getString("EditorFactory.ERROR_0001_EDITOR_IS_NULL"));
        }
        this.priorities.put(editor, new Integer(priority));
    }

    public ModuleEditor getModule(Module module, HierarchicalConfiguration config, ConfigDescriptionEntry[] keyNames) {
        if (module == null) {
            throw new NullPointerException(this.messages.getString("EditorFactory.ERROR_0002_MODULE_IS_NULL"));
        }
        if (config == null) {
            throw new NullPointerException(this.messages.getString("EditorFactory.ERROR_0003_CONFIG_IS_NULL"));
        }
        if (keyNames == null) {
            throw new NullPointerException(this.messages.getString("EditorFactory.ERROR_0004_KEYNAMES_IS_NULL"));
        }
        Iterator<ModuleEditor> keys = this.priorities.keySet().iterator();
        ModuleEditor currentEditor = null;
        int currentEditorPriority = Integer.MIN_VALUE;
        while (keys.hasNext()) {
            Integer prio;
            ModuleEditor ed = keys.next();
            if (!ed.canHandle(module) || (prio = this.priorities.get(ed)) <= currentEditorPriority) continue;
            currentEditorPriority = prio;
            currentEditor = ed;
        }
        if (currentEditor != null) {
            return currentEditor.createInstance(module, config, keyNames);
        }
        return null;
    }
}

