/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.tools.configeditor.model;

import java.util.ArrayList;
import org.pentaho.reporting.libraries.base.boot.Module;
import org.pentaho.reporting.tools.configeditor.model.AbstractConfigTreeNode;
import org.pentaho.reporting.tools.configeditor.model.ConfigDescriptionEntry;
import org.pentaho.reporting.tools.configeditor.model.ModuleNodeFactory;

public class ConfigTreeModuleNode
extends AbstractConfigTreeNode {
    private final String configurationPrefix;
    private final Module module;
    private final ArrayList<ConfigDescriptionEntry> assignedKeys = new ArrayList();

    public ConfigTreeModuleNode(Module module) {
        super(module.getName());
        this.module = module;
        this.configurationPrefix = ModuleNodeFactory.getPackage(this.module.getClass());
    }

    public Module getModule() {
        return this.module;
    }

    public String getConfigurationPrefix() {
        return this.configurationPrefix;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("ConfigTreeModule={");
        buffer.append(this.getConfigurationPrefix());
        buffer.append('}');
        return buffer.toString();
    }

    @Override
    public boolean isLeaf() {
        return true;
    }

    @Override
    public boolean getAllowsChildren() {
        return false;
    }

    public void addAssignedKey(ConfigDescriptionEntry key) {
        if (key == null) {
            throw new NullPointerException();
        }
        if (!this.assignedKeys.contains(key)) {
            this.assignedKeys.add(key);
        }
    }

    public void removeAssignedKey(ConfigDescriptionEntry key) {
        if (key == null) {
            throw new NullPointerException();
        }
        this.assignedKeys.remove(key);
    }

    public ConfigDescriptionEntry[] getAssignedKeys() {
        return this.assignedKeys.toArray(new ConfigDescriptionEntry[this.assignedKeys.size()]);
    }
}

