/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.tools.configeditor.model;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.libraries.base.boot.AbstractBoot;
import org.pentaho.reporting.libraries.base.boot.Module;
import org.pentaho.reporting.libraries.base.config.metadata.ConfigurationDomain;
import org.pentaho.reporting.libraries.base.config.metadata.ConfigurationMetaData;
import org.pentaho.reporting.libraries.base.config.metadata.ConfigurationMetaDataEntry;
import org.pentaho.reporting.libraries.base.config.metadata.ConfigurationMetaDataParser;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.tools.configeditor.Messages;
import org.pentaho.reporting.tools.configeditor.model.ClassConfigDescriptionEntry;
import org.pentaho.reporting.tools.configeditor.model.ConfigDescriptionEntry;
import org.pentaho.reporting.tools.configeditor.model.ConfigDescriptionModel;
import org.pentaho.reporting.tools.configeditor.model.ConfigTreeModuleNode;
import org.pentaho.reporting.tools.configeditor.model.EnumConfigDescriptionEntry;
import org.pentaho.reporting.tools.configeditor.model.TextConfigDescriptionEntry;
import org.xml.sax.SAXException;

public class ModuleNodeFactory {
    private static final Log logger = LogFactory.getLog(ModuleNodeFactory.class);
    private final Messages messages;
    private final Module[] activeModules;
    private final ArrayList<ConfigTreeModuleNode> globalNodes;
    private final ArrayList<ConfigTreeModuleNode> localNodes;
    private final HashMap<String, ConfigDescriptionEntry> configEntryLookup;
    private AbstractBoot packageManager;

    public ModuleNodeFactory(AbstractBoot packageManager) {
        this.packageManager = packageManager;
        this.messages = Messages.getInstance();
        this.activeModules = packageManager.getPackageManager().getAllModules();
        Arrays.sort(this.activeModules, new ModuleSorter());
        this.globalNodes = new ArrayList();
        this.localNodes = new ArrayList();
        this.configEntryLookup = new HashMap();
    }

    public void load(boolean append) throws IOException {
        String configurationDomain = this.packageManager.getConfigurationDomain();
        ConfigurationDomain domain = ConfigurationMetaData.getInstance().createDomain(configurationDomain);
        ConfigurationMetaDataParser parser = new ConfigurationMetaDataParser();
        parser.parseConfiguration(this.packageManager);
        if (!append) {
            this.configEntryLookup.clear();
        }
        ConfigurationMetaDataEntry[] entries = domain.getAll();
        for (int i = 0; i < entries.length; ++i) {
            ConfigDescriptionEntry value;
            String[] tags;
            ConfigurationMetaDataEntry entry = entries[i];
            if (entry.getClassName() != null) {
                ClassConfigDescriptionEntry value2 = new ClassConfigDescriptionEntry(entry.getKey());
                try {
                    value2.setBaseClass(Class.forName(entry.getClassName(), false, ObjectUtilities.getClassLoader(this.packageManager.getClass())));
                    value2.setHidden(entry.isHidden());
                    value2.setGlobal(entry.isGlobal());
                    value2.setDescription(entry.getDescription());
                    this.configEntryLookup.put(entry.getKey(), value2);
                    continue;
                }
                catch (Exception e) {
                    logger.info((Object)("Failed to load defined class '" + entry.getClassName() + "' , fall back to plain-text entry for key " + entry.getKey()));
                }
            }
            if ((tags = entry.getTags()).length > 0) {
                value = new EnumConfigDescriptionEntry(entry.getKey());
                ((EnumConfigDescriptionEntry)value).setOptions(tags);
                value.setHidden(entry.isHidden());
                value.setGlobal(entry.isGlobal());
                value.setDescription(entry.getDescription());
                this.configEntryLookup.put(entry.getKey(), value);
                continue;
            }
            value = new TextConfigDescriptionEntry(entry.getKey());
            value.setHidden(entry.isHidden());
            value.setGlobal(entry.isGlobal());
            value.setDescription(entry.getDescription());
            this.configEntryLookup.put(entry.getKey(), value);
        }
    }

    public void load(InputStream in, boolean append) throws IOException {
        if (!append) {
            this.configEntryLookup.clear();
        }
        ConfigDescriptionModel model = new ConfigDescriptionModel();
        try {
            model.load(in);
        }
        catch (SAXException saxException) {
            String error = this.messages.getString("ModuleNodeFactory.ERROR_0001_PARSE_FAILURE", saxException.getMessage());
            logger.error((Object)error, (Throwable)saxException);
            throw new IOException(error);
        }
        catch (ParserConfigurationException pE) {
            String error = this.messages.getString("ModuleNodeFactory.ERROR_0002_PARSER_CONFIG_ERROR", pE.getMessage());
            logger.error((Object)error, (Throwable)pE);
            throw new IOException(error);
        }
        ConfigDescriptionEntry[] entries = model.toArray();
        for (int i = 0; i < entries.length; ++i) {
            this.configEntryLookup.put(entries[i].getKeyName(), entries[i]);
        }
    }

    public void init() {
        this.globalNodes.clear();
        this.localNodes.clear();
        for (String key : this.configEntryLookup.keySet()) {
            this.processKey(key);
        }
    }

    private void processKey(String key) {
        ConfigTreeModuleNode node;
        ConfigDescriptionEntry cde = this.configEntryLookup.get(key);
        if (cde == null) {
            try {
                if (System.getProperties().containsKey(key)) {
                    logger.debug((Object)("Ignored key from the system properties: " + key));
                    return;
                }
                logger.debug((Object)("Undefined key added on the fly: " + key));
                cde = new TextConfigDescriptionEntry(key);
            }
            catch (SecurityException se) {
                logger.debug((Object)("Unsafe key-definition due to security restrictions: " + key), (Throwable)se);
                cde = new TextConfigDescriptionEntry(key);
            }
        }
        if (cde.isHidden()) {
            return;
        }
        Module mod = this.lookupModule(key);
        if (mod == null) {
            return;
        }
        if (!cde.isGlobal()) {
            node = this.lookupNode(mod, this.localNodes);
            if (node == null) {
                node = new ConfigTreeModuleNode(mod);
                this.localNodes.add(node);
            }
            node.addAssignedKey(cde);
        }
        if ((node = this.lookupNode(mod, this.globalNodes)) == null) {
            node = new ConfigTreeModuleNode(mod);
            this.globalNodes.add(node);
        }
        node.addAssignedKey(cde);
    }

    private ConfigTreeModuleNode lookupNode(Module key, ArrayList nodeList) {
        if (key == null) {
            return null;
        }
        for (int i = 0; i < nodeList.size(); ++i) {
            ConfigTreeModuleNode node = (ConfigTreeModuleNode)nodeList.get(i);
            if (key != node.getModule()) continue;
            return node;
        }
        return null;
    }

    public static String getPackage(Class c) {
        String className = c.getName();
        int idx = className.lastIndexOf(46);
        if (idx <= 0) {
            return "";
        }
        return className.substring(0, idx);
    }

    private Module lookupModule(String key) {
        Module retval = null;
        int confidence = -1;
        for (int i = 0; i < this.activeModules.length; ++i) {
            String modPackage = ModuleNodeFactory.getPackage(this.activeModules[i].getClass());
            if (!key.startsWith(modPackage) || confidence >= modPackage.length()) continue;
            confidence = modPackage.length();
            retval = this.activeModules[i];
        }
        return retval;
    }

    public ConfigTreeModuleNode[] getGlobalNodes() {
        ConfigTreeModuleNode[] retval = this.globalNodes.toArray(new ConfigTreeModuleNode[this.globalNodes.size()]);
        Arrays.sort(retval, new ConfigTreeModuleNodeComparator());
        return retval;
    }

    public ConfigTreeModuleNode[] getLocalNodes() {
        ConfigTreeModuleNode[] retval = this.localNodes.toArray(new ConfigTreeModuleNode[this.localNodes.size()]);
        Arrays.sort(retval, new ConfigTreeModuleNodeComparator());
        return retval;
    }

    public ConfigDescriptionEntry getEntryForKey(String key) {
        return this.configEntryLookup.get(key);
    }

    private static class ModuleSorter
    implements Comparator<Module>,
    Serializable {
        protected ModuleSorter() {
        }

        @Override
        public int compare(Module o1, Module o2) {
            String name2;
            String name1;
            if (o1.getClass().getPackage() == null || o2.getClass().getPackage() == null) {
                name1 = ModuleNodeFactory.getPackage(o1.getClass());
                name2 = ModuleNodeFactory.getPackage(o2.getClass());
            } else {
                name1 = o1.getClass().getPackage().getName();
                name2 = o2.getClass().getPackage().getName();
            }
            return name1.compareTo(name2);
        }
    }

    private static class ConfigTreeModuleNodeComparator
    implements Comparator<ConfigTreeModuleNode> {
        private ConfigTreeModuleNodeComparator() {
        }

        @Override
        public int compare(ConfigTreeModuleNode n1, ConfigTreeModuleNode n2) {
            return n1.getName().compareTo(n2.getName());
        }
    }
}

