/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.amazon.s3;

import org.pentaho.amazon.s3.S3FileOutputMeta;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.textfileoutput.TextFileOutput;

public class S3FileOutput
extends TextFileOutput {
    public static final String ACCESS_KEY_SYSTEM_PROPERTY = "aws.accessKeyId";
    public static final String SECRET_KEY_SYSTEM_PROPERTY = "aws.secretKey";

    public S3FileOutput(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        S3FileOutputMeta s3Meta = (S3FileOutputMeta)smi;
        String accessKeySystemProperty = System.getProperty(ACCESS_KEY_SYSTEM_PROPERTY);
        String secretKeySystemProperty = System.getProperty(SECRET_KEY_SYSTEM_PROPERTY);
        if (!this.isEmpty(s3Meta.getAccessKey()) && this.isEmpty(accessKeySystemProperty)) {
            System.setProperty(ACCESS_KEY_SYSTEM_PROPERTY, s3Meta.getAccessKey());
        }
        if (!this.isEmpty(s3Meta.getSecretKey()) && this.isEmpty(secretKeySystemProperty)) {
            System.setProperty(SECRET_KEY_SYSTEM_PROPERTY, s3Meta.getSecretKey());
        }
        return super.init(smi, sdi);
    }

    public void markStop() {
        super.markStop();
        String accessKeySystemProperty = System.getProperty(ACCESS_KEY_SYSTEM_PROPERTY);
        String secretKeySystemProperty = System.getProperty(SECRET_KEY_SYSTEM_PROPERTY);
        if (!this.isEmpty(accessKeySystemProperty)) {
            System.setProperty(ACCESS_KEY_SYSTEM_PROPERTY, "");
        }
        if (!this.isEmpty(secretKeySystemProperty)) {
            System.setProperty(SECRET_KEY_SYSTEM_PROPERTY, "");
        }
    }

    private boolean isEmpty(String value) {
        return value == null || value.length() <= 0;
    }
}

