/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.hadoop;

import java.util.function.Supplier;
import org.pentaho.di.core.annotations.LifecyclePlugin;
import org.pentaho.di.core.gui.GUIOption;
import org.pentaho.di.core.hadoop.HadoopClusterFolderProvider;
import org.pentaho.di.core.lifecycle.LifeEventHandler;
import org.pentaho.di.core.lifecycle.LifecycleException;
import org.pentaho.di.core.lifecycle.LifecycleListener;
import org.pentaho.di.core.util.ExecutorUtil;
import org.pentaho.di.ui.core.namedcluster.NamedClusterUIHelper;
import org.pentaho.di.ui.spoon.Spoon;
import org.pentaho.di.ui.spoon.tree.TreeFolderProvider;

@LifecyclePlugin(id="HadoopSpoonPlugin", name="Hadoop Spoon Plugin")
public class HadoopSpoonPlugin
implements LifecycleListener,
GUIOption<Object> {
    public static final String PLUGIN_ID = "HadoopSpoonPlugin";
    private static Class<?> PKG = HadoopSpoonPlugin.class;
    private Supplier<Spoon> spoonSupplier = Spoon::getInstance;
    public static final String HDFS_SCHEME = "hdfs";
    public static final String HDFS_SCHEME_DISPLAY_NAME = "HDFS";
    public static final String MAPRFS_SCHEME = "maprfs";
    public static final String MAPRFS_SCHEME_DISPLAY_NAME = "MapRFS";

    public void onStart(LifeEventHandler arg0) throws LifecycleException {
        ExecutorUtil.getExecutor().submit(new Runnable(){

            @Override
            public void run() {
                NamedClusterUIHelper.getNamedClusterUIFactory();
            }
        });
        Spoon spoon = this.spoonSupplier.get();
        if (spoon != null) {
            spoon.getTreeManager().addTreeProvider(Spoon.STRING_TRANSFORMATIONS, (TreeFolderProvider)new HadoopClusterFolderProvider());
            spoon.getTreeManager().addTreeProvider(Spoon.STRING_JOBS, (TreeFolderProvider)new HadoopClusterFolderProvider());
        }
    }

    public void onExit(LifeEventHandler arg0) throws LifecycleException {
    }

    public String getLabelText() {
        return null;
    }

    public Object getLastValue() {
        return null;
    }

    public GUIOption.DisplayType getType() {
        return null;
    }

    public void setValue(Object value) {
    }
}

