/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.hadoop;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.InvalidPropertiesFormatException;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.configuration.reloading.FileChangedReloadingStrategy;
import org.apache.commons.configuration.reloading.ReloadingStrategy;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;

public class PropertiesConfigurationProperties
extends Properties {
    private final PropertiesConfiguration propertiesConfiguration;

    public PropertiesConfigurationProperties(FileObject fileObject) throws ConfigurationException, FileSystemException {
        this(PropertiesConfigurationProperties.initPropertiesConfiguration(fileObject));
    }

    public PropertiesConfigurationProperties(PropertiesConfiguration propertiesConfiguration) {
        this.propertiesConfiguration = propertiesConfiguration;
    }

    private static PropertiesConfiguration initPropertiesConfiguration(FileObject fileObject) throws FileSystemException, ConfigurationException {
        PropertiesConfiguration propertiesConfiguration = new PropertiesConfiguration(fileObject.getURL());
        propertiesConfiguration.setAutoSave(true);
        FileChangedReloadingStrategy fileChangedReloadingStrategy = new FileChangedReloadingStrategy();
        fileChangedReloadingStrategy.setRefreshDelay(1000L);
        propertiesConfiguration.setReloadingStrategy((ReloadingStrategy)fileChangedReloadingStrategy);
        return propertiesConfiguration;
    }

    @Override
    public synchronized String getProperty(String key) {
        return this.getProperty(key, null);
    }

    @Override
    public synchronized String getProperty(String key, String defaultValue) {
        return this.propertiesConfiguration.getString(key, defaultValue);
    }

    @Override
    public synchronized Object get(Object key) {
        if (key == null || key instanceof String) {
            return this.propertiesConfiguration.getProperty((String)key);
        }
        return null;
    }

    @Override
    public synchronized Object setProperty(String key, String value) {
        return this.put(key, value);
    }

    @Override
    public synchronized Object put(Object key, Object value) {
        if (key instanceof String) {
            Object previous = this.get(key);
            this.propertiesConfiguration.setProperty((String)key, value);
            return previous;
        }
        throw new IllegalArgumentException("Can only store properties with String keys");
    }

    private Set<String> getPropertyNames() {
        HashSet<String> result = new HashSet<String>();
        Iterator keys = this.propertiesConfiguration.getKeys();
        while (keys.hasNext()) {
            result.add((String)keys.next());
        }
        return result;
    }

    @Override
    public synchronized Set<String> stringPropertyNames() {
        return Collections.unmodifiableSet(this.getPropertyNames());
    }

    @Override
    public synchronized Set<Object> keySet() {
        return Collections.unmodifiableSet(this.getPropertyNames());
    }

    private Map<String, Object> toMap() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Iterator keys = this.propertiesConfiguration.getKeys();
        while (keys.hasNext()) {
            String next = (String)keys.next();
            result.put(next, this.propertiesConfiguration.getProperty(next));
        }
        return result;
    }

    @Override
    public synchronized Set<Map.Entry<Object, Object>> entrySet() {
        Map<String, Object> map = this.toMap();
        return Collections.unmodifiableSet(map.entrySet());
    }

    @Override
    public synchronized int size() {
        return this.getPropertyNames().size();
    }

    @Override
    public synchronized boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public synchronized Enumeration<Object> keys() {
        return new Vector<String>(this.getPropertyNames()).elements();
    }

    @Override
    public synchronized Enumeration<Object> elements() {
        return new Vector<Object>(this.toMap().values()).elements();
    }

    @Override
    public synchronized boolean contains(Object value) {
        return this.containsValue(value);
    }

    @Override
    public synchronized boolean containsValue(Object value) {
        return this.values().contains(value);
    }

    @Override
    public synchronized Enumeration<?> propertyNames() {
        return new Vector<String>(this.getPropertyNames()).elements();
    }

    @Override
    public synchronized Collection<Object> values() {
        return this.toMap().values();
    }

    @Override
    public synchronized boolean containsKey(Object key) {
        if (key == null || key instanceof String) {
            return this.propertiesConfiguration.containsKey((String)key);
        }
        return false;
    }

    @Override
    public synchronized Object remove(Object key) {
        if (key == null || key instanceof String) {
            Object result = this.propertiesConfiguration.getProperty((String)key);
            this.propertiesConfiguration.clearProperty((String)key);
            return result;
        }
        return null;
    }

    @Override
    public synchronized void putAll(Map<?, ?> t) {
        for (Map.Entry<?, ?> entry : t.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public synchronized void clear() {
        this.propertiesConfiguration.clear();
    }

    @Override
    public synchronized void load(Reader reader) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public synchronized void load(InputStream inStream) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void save(OutputStream out, String comments) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void store(Writer writer, String comments) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void store(OutputStream out, String comments) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public synchronized void loadFromXML(InputStream in) throws IOException, InvalidPropertiesFormatException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void storeToXML(OutputStream os, String comment) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void storeToXML(OutputStream os, String comment, String encoding) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void list(PrintStream out) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void list(PrintWriter out) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void rehash() {
        throw new UnsupportedOperationException();
    }

    @Override
    public synchronized Object clone() {
        throw new UnsupportedOperationException();
    }
}

