/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.ui.xul.swt.tags;

import java.awt.Component;
import java.io.File;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.pentaho.ui.xul.XulComponent;
import org.pentaho.ui.xul.XulDomContainer;
import org.pentaho.ui.xul.components.XulFileDialog;
import org.pentaho.ui.xul.containers.XulRoot;
import org.pentaho.ui.xul.dom.Element;
import org.pentaho.ui.xul.swt.SwtElement;

public class SwtFileDialog
extends SwtElement
implements XulFileDialog {
    FileDialog fc;
    private XulFileDialog.SEL_TYPE selectionType = XulFileDialog.SEL_TYPE.SINGLE;
    private XulFileDialog.VIEW_TYPE viewType = XulFileDialog.VIEW_TYPE.FILES_DIRECTORIES;
    private String[] selectedFiles;
    private Component parentObject = null;
    private XulComponent parent;
    private XulDomContainer domContainer;
    private String selectedFile;
    private File fileHint;

    public SwtFileDialog(Element self, XulComponent parent, XulDomContainer domContainer, String tagName) {
        super("filedialog");
        this.parent = domContainer.getDocumentRoot().getRootElement();
        domContainer.getDocumentRoot().getRootElement().addChild((Element)this);
        this.domContainer = domContainer;
    }

    public File getFile() {
        return new File(this.fc.getFilterPath() + File.separator + this.fc.getFileName());
    }

    public File[] getFiles() {
        String[] selected = this.fc.getFileNames();
        File[] retVal = new File[selected.length];
        int i = 0;
        for (String s : selected) {
            retVal[i++] = new File(this.fc.getFilterPath() + s);
        }
        return retVal;
    }

    public XulFileDialog.SEL_TYPE getSelectionMode() {
        return this.selectionType;
    }

    public XulFileDialog.VIEW_TYPE getViewType() {
        return this.viewType;
    }

    public void setSelectionMode(XulFileDialog.SEL_TYPE type) {
        this.selectionType = type;
    }

    public void setViewType(XulFileDialog.VIEW_TYPE type) {
        this.viewType = type;
    }

    public XulFileDialog.RETURN_CODE showOpenDialog() {
        return this.showOpen();
    }

    public XulFileDialog.RETURN_CODE showOpenDialog(Object f) {
        if (f != null) {
            this.fileHint = (File)f;
        }
        return this.showOpen();
    }

    public XulFileDialog.RETURN_CODE showSaveDialog() {
        return this.showSave();
    }

    public XulFileDialog.RETURN_CODE showSaveDialog(Object f) {
        if (f != null) {
            this.fileHint = (File)f;
        }
        return this.showSave();
    }

    private XulFileDialog.RETURN_CODE showOpen() {
        String retVal;
        this.fc = new FileDialog((Shell)((XulRoot)this.domContainer.getDocumentRoot().getRootElement()).getRootObject(), 4096);
        if (this.fileHint != null) {
            this.fc.setFileName(this.fileHint.getAbsolutePath());
        }
        if ((retVal = this.fc.open()) != null) {
            if (this.selectionType == XulFileDialog.SEL_TYPE.SINGLE) {
                this.selectedFile = this.fc.getFileName();
            } else {
                this.selectedFiles = this.fc.getFileNames();
            }
            return XulFileDialog.RETURN_CODE.OK;
        }
        return XulFileDialog.RETURN_CODE.CANCEL;
    }

    private XulFileDialog.RETURN_CODE showSave() {
        String retVal;
        this.fc = new FileDialog((Shell)this.domContainer.getDocumentRoot().getRootElement().getManagedObject(), 8192);
        if (this.fileHint != null) {
            this.fc.setFileName(this.fileHint.getAbsolutePath());
        }
        if ((retVal = this.fc.open()) != null) {
            if (this.selectionType == XulFileDialog.SEL_TYPE.SINGLE) {
                this.selectedFile = this.fc.getFileName();
            } else {
                this.selectedFiles = this.fc.getFileNames();
            }
            return XulFileDialog.RETURN_CODE.OK;
        }
        return XulFileDialog.RETURN_CODE.CANCEL;
    }

    public void setModalParent(Object parent) {
    }
}

