/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.ui.xul.swt.tags.treeutil;

import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.pentaho.ui.xul.swt.tags.treeutil.XulColumnSorter;
import org.pentaho.ui.xul.swt.tags.treeutil.XulSortProperties;
import org.pentaho.ui.xul.swt.tags.treeutil.XulTableColumnLabelProvider;

public class TableColumnSorter
extends XulColumnSorter {
    private TableViewer viewer;

    public TableColumnSorter(Viewer viewer, XulSortProperties properties) {
        super(viewer, properties);
    }

    @Override
    public void initializeViewer(Viewer viewer) throws Exception {
        if (!(viewer instanceof TableViewer)) {
            throw new Exception();
        }
        this.viewer = (TableViewer)viewer;
        this.viewer.setComparator((ViewerComparator)this);
        if (this.properties.isSortable()) {
            for (TableColumn tableColumn : this.viewer.getTable().getColumns()) {
                tableColumn.addSelectionListener(this.selectionHandler);
            }
        }
    }

    @Override
    public Item[] getViewerColumns() {
        return this.viewer.getTable().getColumns();
    }

    @Override
    public void setViewerColumns() {
        Table table = this.viewer.getTable();
        switch (this.direction) {
            case ASCENDING: {
                table.setSortColumn((TableColumn)this.column);
                table.setSortDirection(128);
                this.compareIndex = 1;
                break;
            }
            case DESCENDING: {
                table.setSortColumn((TableColumn)this.column);
                table.setSortDirection(1024);
                this.compareIndex = -1;
                break;
            }
            default: {
                table.setSortColumn(null);
                table.setSortDirection(0);
                this.compareIndex = 0;
            }
        }
        this.viewer.setComparator(null);
        this.viewer.setComparator((ViewerComparator)this);
    }

    @Override
    protected int doCompare(Viewer v, Object e1, Object e2) {
        String t1 = "";
        String t2 = "";
        if (this.viewer.getLabelProvider() instanceof XulTableColumnLabelProvider) {
            XulTableColumnLabelProvider columnLabelProvider = (XulTableColumnLabelProvider)this.viewer.getLabelProvider();
            t1 = columnLabelProvider.getColumnText(e1, this.columnIndex);
            t2 = columnLabelProvider.getColumnText(e2, this.columnIndex);
        } else {
            ILabelProvider labelProvider = (ILabelProvider)this.viewer.getLabelProvider(this.columnIndex);
            t1 = labelProvider.getText(e1);
            t2 = labelProvider.getText(e2);
        }
        if (t1 == null) {
            t1 = "";
        }
        if (t2 == null) {
            t2 = "";
        }
        return t1.compareToIgnoreCase(t2);
    }
}

