/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.ui.xul.swt.tags.treeutil;

import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.pentaho.ui.xul.swt.tags.treeutil.XulColumnSorter;
import org.pentaho.ui.xul.swt.tags.treeutil.XulSortProperties;

public class TreeColumnSorter
extends XulColumnSorter {
    private TreeViewer viewer;

    public TreeColumnSorter(TreeViewer viewer, XulSortProperties properties) {
        super((Viewer)viewer, properties);
    }

    @Override
    public void initializeViewer(Viewer viewer) throws Exception {
        if (!(viewer instanceof TreeViewer)) {
            throw new Exception();
        }
        this.viewer = (TreeViewer)viewer;
        this.viewer.setComparator((ViewerComparator)this);
        if (this.properties.isSortable()) {
            for (TreeColumn tableColumn : this.viewer.getTree().getColumns()) {
                tableColumn.addSelectionListener(this.selectionHandler);
            }
        }
    }

    @Override
    public void setViewerColumns() {
        Tree tree = this.viewer.getTree();
        switch (this.direction) {
            case ASCENDING: {
                tree.setSortColumn((TreeColumn)this.column);
                tree.setSortDirection(128);
                this.compareIndex = 1;
                break;
            }
            case DESCENDING: {
                tree.setSortColumn((TreeColumn)this.column);
                tree.setSortDirection(1024);
                this.compareIndex = -1;
                break;
            }
            default: {
                tree.setSortColumn(null);
                tree.setSortDirection(0);
                this.compareIndex = 0;
            }
        }
        this.viewer.setComparator(null);
        this.viewer.setComparator((ViewerComparator)this);
    }

    @Override
    protected int doCompare(Viewer v, Object e1, Object e2) {
        ILabelProvider labelProvider = (ILabelProvider)this.viewer.getLabelProvider(this.columnIndex);
        String t1 = labelProvider.getText(e1);
        String t2 = labelProvider.getText(e2);
        if (t1 == null) {
            t1 = "";
        }
        if (t2 == null) {
            t2 = "";
        }
        return t1.compareToIgnoreCase(t2);
    }

    @Override
    public Item[] getViewerColumns() {
        return this.viewer.getTree().getColumns();
    }
}

