/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.jaas.modules;

import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.Permission;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import javax.security.auth.Subject;
import javax.security.auth.SubjectDomainCombiner;
import org.apache.karaf.jaas.boot.principal.UserPrincipal;

public class JaasHelper {
    public static String getUserName(Subject subject) {
        if (subject != null && subject.getPrincipals().iterator().hasNext()) {
            return subject.getPrincipals(UserPrincipal.class).iterator().next().getName();
        }
        return null;
    }

    public static <T> T doAs(final Subject subject, PrivilegedAction<T> action) {
        if (action == null) {
            throw new NullPointerException();
        }
        final AccessControlContext currentAcc = AccessController.getContext();
        AccessControlContext newAcc = AccessController.doPrivileged(new PrivilegedAction<AccessControlContext>(){

            @Override
            public AccessControlContext run() {
                if (subject == null) {
                    return new AccessControlContext(currentAcc, null);
                }
                return new AccessControlContext(currentAcc, new OsgiSubjectDomainCombiner(subject));
            }
        });
        return AccessController.doPrivileged(action, newAcc);
    }

    public static <T> T doAs(final Subject subject, PrivilegedExceptionAction<T> action) throws PrivilegedActionException {
        if (action == null) {
            throw new NullPointerException();
        }
        final AccessControlContext currentAcc = AccessController.getContext();
        AccessControlContext newAcc = AccessController.doPrivileged(new PrivilegedAction<AccessControlContext>(){

            @Override
            public AccessControlContext run() {
                if (subject == null) {
                    return new AccessControlContext(currentAcc, null);
                }
                return new AccessControlContext(currentAcc, new OsgiSubjectDomainCombiner(subject));
            }
        });
        return AccessController.doPrivileged(action, newAcc);
    }

    public static class DelegatingProtectionDomain
    extends ProtectionDomain {
        private final ProtectionDomain delegate;

        DelegatingProtectionDomain(ProtectionDomain delegate, Principal[] principals) {
            super(delegate.getCodeSource(), delegate.getPermissions(), delegate.getClassLoader(), principals);
            this.delegate = delegate;
        }

        @Override
        public boolean implies(Permission permission) {
            return this.delegate.implies(permission);
        }
    }

    public static class OsgiSubjectDomainCombiner
    extends SubjectDomainCombiner {
        private final Subject subject;

        public OsgiSubjectDomainCombiner(Subject subject) {
            super(subject);
            this.subject = subject;
        }

        @Override
        public ProtectionDomain[] combine(ProtectionDomain[] currentDomains, ProtectionDomain[] assignedDomains) {
            int i;
            int cLen = currentDomains == null ? 0 : currentDomains.length;
            int aLen = assignedDomains == null ? 0 : assignedDomains.length;
            ProtectionDomain[] newDomains = new ProtectionDomain[cLen + aLen];
            Principal[] principals = this.subject.getPrincipals().toArray(new Principal[0]);
            for (i = 0; i < cLen; ++i) {
                newDomains[i] = new DelegatingProtectionDomain(currentDomains[i], principals);
            }
            for (i = 0; i < aLen; ++i) {
                newDomains[cLen + i] = assignedDomains[i];
            }
            newDomains = this.optimize(newDomains);
            return newDomains;
        }

        private ProtectionDomain[] optimize(ProtectionDomain[] domains) {
            if (domains == null || domains.length == 0) {
                return null;
            }
            ProtectionDomain[] optimized = new ProtectionDomain[domains.length];
            int num = 0;
            for (int i = 0; i < domains.length; ++i) {
                ProtectionDomain pd = domains[i];
                if (pd == null) continue;
                boolean found = false;
                for (int j = 0; j < num && !found; ++j) {
                    found = optimized[j] == pd;
                }
                if (found) continue;
                optimized[num++] = pd;
            }
            if (num > 0 && num < domains.length) {
                ProtectionDomain[] downSize = new ProtectionDomain[num];
                System.arraycopy(optimized, 0, downSize, 0, downSize.length);
                optimized = downSize;
            }
            return num == 0 || optimized.length == 0 ? null : optimized;
        }
    }
}

