/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.hadoop.shim.common.format.orc;

import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.orc.Writer;
import org.pentaho.hadoop.shim.api.format.IOrcMetaData;
import org.pentaho.hadoop.shim.api.format.IOrcOutputField;

public class OrcMetaDataWriter
implements IOrcMetaData.Writer {
    private static final Logger logger = Logger.getLogger(OrcMetaDataWriter.class);
    private Writer writer;

    public OrcMetaDataWriter(Writer writer) {
        this.writer = writer;
    }

    public void write(List<? extends IOrcOutputField> fields) {
        fields.forEach(field -> {
            try {
                this.setMetaData((IOrcOutputField)field);
            }
            catch (UnsupportedEncodingException e) {
                logger.error((Object)("Field " + field.getPentahoFieldName() + ": cannot set Orc Metadata"));
            }
        });
    }

    private void setMetaData(IOrcOutputField field) throws UnsupportedEncodingException {
        this.addMetaData(field, IOrcMetaData.propertyType.TYPE, this.toByteBuffer(field.getPentahoFieldName()));
        this.addMetaData(field, IOrcMetaData.propertyType.NULLABLE, this.toByteBuffer(field.getAllowNull()));
        if (field.getDefaultValue() != null) {
            this.addMetaData(field, IOrcMetaData.propertyType.DEFAULT, this.toByteBuffer(field.getDefaultValue()));
        }
    }

    private void addMetaData(IOrcOutputField field, IOrcMetaData.propertyType propertyType2, ByteBuffer valueBuffer) {
        this.writer.addUserMetadata(IOrcMetaData.determinePropertyName((String)field.getPentahoFieldName(), (String)propertyType2.toString()), valueBuffer);
    }

    private ByteBuffer toByteBuffer(int i) throws UnsupportedEncodingException {
        return this.toByteBuffer(String.valueOf(i));
    }

    private ByteBuffer toByteBuffer(String s) throws UnsupportedEncodingException {
        return ByteBuffer.wrap(s.getBytes("UTF-8"));
    }

    private ByteBuffer toByteBuffer(boolean b) throws UnsupportedEncodingException {
        return ByteBuffer.wrap(String.valueOf(b).getBytes("UTF-8"));
    }
}

