/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.engine.configuration.impl;

import java.util.Collections;
import java.util.List;
import org.pentaho.di.engine.configuration.api.RunConfiguration;
import org.pentaho.di.engine.configuration.api.RunConfigurationFactory;
import org.pentaho.metastore.api.IMetaStore;
import org.pentaho.metastore.api.exceptions.MetaStoreException;
import org.pentaho.metastore.persist.MetaStoreFactory;
import org.pentaho.osgi.metastore.locator.api.MetastoreLocator;

public abstract class MetaStoreRunConfigurationFactory
implements RunConfigurationFactory {
    protected MetastoreLocator metastoreLocator;

    public MetaStoreRunConfigurationFactory(MetastoreLocator metastoreLocator) {
        this.metastoreLocator = metastoreLocator;
    }

    private <T extends RunConfiguration> MetaStoreFactory<T> getMetastoreFactory(Class<T> clazz, IMetaStore metaStore) {
        return new MetaStoreFactory(clazz, metaStore, "pentaho");
    }

    protected <T extends RunConfiguration> MetaStoreFactory<T> getMetastoreFactory(Class<T> clazz) throws MetaStoreException {
        return this.getMetastoreFactory(clazz, this.metastoreLocator.getMetastore());
    }

    protected abstract <T extends RunConfiguration> MetaStoreFactory<T> getMetaStoreFactory() throws MetaStoreException;

    public boolean delete(String name) {
        try {
            this.getMetaStoreFactory().deleteElement(name);
        }
        catch (MetaStoreException me) {
            return false;
        }
        return true;
    }

    public void deleteAll() {
        try {
            List elementNames = this.getMetaStoreFactory().getElementNames();
            for (String name : elementNames) {
                this.getMetaStoreFactory().deleteElement(name);
            }
        }
        catch (MetaStoreException metaStoreException) {
            // empty catch block
        }
    }

    public List<RunConfiguration> load() {
        try {
            return this.getMetaStoreFactory().getElements();
        }
        catch (MetaStoreException me) {
            return Collections.emptyList();
        }
    }

    public RunConfiguration load(String name) {
        try {
            return (RunConfiguration)this.getMetaStoreFactory().loadElement(name);
        }
        catch (MetaStoreException me) {
            return null;
        }
    }

    public boolean save(RunConfiguration runConfiguration) {
        try {
            this.getMetaStoreFactory().saveElement((Object)runConfiguration);
        }
        catch (MetaStoreException me) {
            return false;
        }
        return true;
    }

    public List<String> getNames() {
        try {
            return this.getMetaStoreFactory().getElementNames();
        }
        catch (MetaStoreException me) {
            return Collections.emptyList();
        }
    }

    public void setMetastoreLocator(MetastoreLocator metastoreLocator) {
        this.metastoreLocator = metastoreLocator;
    }
}

