/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.metaverse.impl;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.io.FileUtils;
import org.pentaho.di.core.Const;
import org.pentaho.metaverse.api.IGraphWriter;
import org.pentaho.metaverse.api.ILineageWriter;
import org.pentaho.metaverse.api.IMetaverseBuilder;
import org.pentaho.metaverse.api.model.IExecutionProfile;
import org.pentaho.metaverse.api.model.LineageHolder;
import org.pentaho.metaverse.graph.GraphMLWriter;
import org.pentaho.metaverse.graph.GraphSONWriter;
import org.pentaho.metaverse.impl.model.ExecutionProfileUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class FileSystemLineageWriter
implements ILineageWriter {
    public static final String DEFAULT_OUTPUT_FOLDER = ".";
    private static final Logger log = LoggerFactory.getLogger(FileSystemLineageWriter.class);
    private IGraphWriter graphWriter = new GraphMLWriter();
    private String outputFolder = ".";
    private String outputStrategy = "none";
    protected static SimpleDateFormat dateFolderFormat = new SimpleDateFormat("YYYYMMdd");

    public void outputExecutionProfile(LineageHolder holder) throws IOException {
        IExecutionProfile profile;
        if (holder != null && (profile = holder.getExecutionProfile()) != null) {
            try (OutputStream fos = this.getProfileOutputStream(holder);){
                if (fos != null) {
                    ExecutionProfileUtil.outputExecutionProfile(fos, profile);
                } else {
                    log.debug("No profile output stream associated with this LineageWriter");
                }
            }
        }
    }

    public void outputLineageGraph(LineageHolder holder) throws IOException {
        IMetaverseBuilder builder;
        if (holder != null && (builder = holder.getMetaverseBuilder()) != null) {
            try (OutputStream fos = this.getGraphOutputStream(holder);){
                if (fos != null) {
                    this.graphWriter.outputGraph(builder.getGraph(), fos);
                } else {
                    log.debug("No graph output stream associated with this LineageWriter");
                }
            }
        }
    }

    public IGraphWriter getGraphWriter() {
        return this.graphWriter;
    }

    public void setGraphWriter(IGraphWriter graphWriter) {
        this.graphWriter = graphWriter;
    }

    public String getOutputFolder() {
        return this.outputFolder;
    }

    public void setOutputFolder(String outputFolder) {
        this.outputFolder = outputFolder;
    }

    protected OutputStream createOutputStream(LineageHolder holder, String extension) {
        if (holder != null) {
            try {
                IExecutionProfile profile = holder.getExecutionProfile();
                String timestampString = Long.toString(profile.getExecutionData().getStartTime().getTime());
                File destFolder = this.getOutputDirectoryAsFile(holder);
                String name = Const.NVL((String)profile.getName(), (String)"unknown");
                File file = new File(destFolder, timestampString + "_" + name + extension);
                try {
                    return new FileOutputStream(file);
                }
                catch (FileNotFoundException e) {
                    log.error("Couldn't find file: " + file.getAbsolutePath(), (Throwable)e);
                    return null;
                }
            }
            catch (Exception e) {
                log.error("Couldn't get output stream", (Throwable)e);
                return null;
            }
        }
        return null;
    }

    protected File getOutputDirectoryAsFile(LineageHolder holder) {
        File rootFolder = this.getDateFolder(this.outputFolder, holder);
        boolean rootFolderExists = rootFolder.exists();
        if (!rootFolderExists) {
            rootFolderExists = rootFolder.mkdirs();
        }
        if (rootFolderExists) {
            IExecutionProfile profile = holder.getExecutionProfile();
            String id = holder.getId() == null ? "unknown_artifact" : holder.getId();
            try {
                File folder;
                if (this.isWindows()) {
                    id = this.replaceColonInPath(id);
                }
                if (!(folder = new File(rootFolder, id)).exists()) {
                    boolean result = folder.mkdirs();
                    if (!result) {
                        log.error("Couldn't create folder: " + folder.getAbsolutePath());
                    }
                } else if (folder.isFile()) {
                    throw new IllegalStateException("Output folder must be a folder, not a file. [" + folder.getAbsolutePath() + "]");
                }
                return folder;
            }
            catch (Exception e) {
                log.error("Couldn't create output file", (Throwable)e);
                return null;
            }
        }
        return null;
    }

    protected String replaceColonInPath(String id) {
        String newPath = id;
        if (id.matches("([A-Za-z]:.*)")) {
            newPath = id.replaceFirst(":", "");
        }
        return newPath;
    }

    protected boolean isWindows() {
        return this.getOsName().contains("win");
    }

    protected String getOsName() {
        return System.getProperty("os.name").toLowerCase();
    }

    protected File getDateFolder(String parentDir, LineageHolder holder) {
        String dir;
        String string = dir = parentDir == null ? "" : parentDir + File.separator;
        if (holder != null && holder.getExecutionProfile() != null) {
            IExecutionProfile profile = holder.getExecutionProfile();
            dir = dir + dateFolderFormat.format(profile.getExecutionData().getStartTime());
        } else {
            dir = dir + dateFolderFormat.format(new Date());
        }
        return new File(dir);
    }

    protected OutputStream getProfileOutputStream(LineageHolder holder) {
        return this.createOutputStream(holder, ".execution.js");
    }

    protected OutputStream getGraphOutputStream(LineageHolder holder) {
        String ext = this.graphWriter instanceof GraphMLWriter ? ".graphml" : (this.graphWriter instanceof GraphSONWriter ? ".graphson" : ".txt");
        return this.createOutputStream(holder, ext);
    }

    public String getOutputStrategy() {
        return this.outputStrategy;
    }

    public void setOutputStrategy(String strategy) {
        this.outputStrategy = strategy;
    }

    public void cleanOutput(LineageHolder holder) {
        String folderName = "unknown";
        try {
            File folder = this.getOutputDirectoryAsFile(holder);
            if (folder.exists()) {
                FileUtils.deleteDirectory((File)folder);
            }
            folderName = folder.getAbsolutePath();
        }
        catch (IOException ioe) {
            log.error("Couldn't delete directory: " + folderName, (Throwable)ioe);
        }
    }
}

