/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.metaverse.impl.model.kettle.json;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.MapUtils;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.core.plugins.StepPluginType;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.StringObjectId;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.metaverse.analyzer.kettle.step.GenericStepMetaAnalyzer;
import org.pentaho.metaverse.api.MetaverseAnalyzerException;
import org.pentaho.metaverse.api.analyzer.kettle.ComponentDerivationRecord;
import org.pentaho.metaverse.api.analyzer.kettle.step.IFieldLineageMetadataProvider;
import org.pentaho.metaverse.api.analyzer.kettle.step.IStepAnalyzer;
import org.pentaho.metaverse.api.analyzer.kettle.step.IStepAnalyzerProvider;
import org.pentaho.metaverse.api.analyzer.kettle.step.IStepExternalResourceConsumer;
import org.pentaho.metaverse.api.analyzer.kettle.step.IStepExternalResourceConsumerProvider;
import org.pentaho.metaverse.api.analyzer.kettle.step.StepAnalyzer;
import org.pentaho.metaverse.api.model.IExternalResourceInfo;
import org.pentaho.metaverse.api.model.kettle.FieldInfo;
import org.pentaho.metaverse.api.model.kettle.IFieldMapping;
import org.pentaho.metaverse.impl.model.kettle.LineageRepository;
import org.pentaho.metaverse.impl.model.kettle.json.GenericStepOrJobEntryJsonSerializer;
import org.pentaho.metaverse.messages.Messages;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractStepMetaJsonSerializer<T extends BaseStepMeta>
extends GenericStepOrJobEntryJsonSerializer<T> {
    public static final String JSON_PROPERTY_TRANSFORMS = "transforms";
    public static final String JSON_PROPERTY_INPUT_FIELDS = "inputFields";
    public static final String JSON_PROPERTY_OUTPUT_FIELDS = "outputFields";
    public static final String JSON_PROPERTY_MAPPINGS = "fieldMappings";
    private IStepAnalyzerProvider stepAnalyzerProvider;
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractStepMetaJsonSerializer.class);

    protected AbstractStepMetaJsonSerializer(Class<T> aClass) {
        super(aClass);
    }

    protected AbstractStepMetaJsonSerializer(Class<T> aClass, LineageRepository repo) {
        super(aClass);
        this.setLineageRepository(repo);
    }

    public IStepAnalyzerProvider getStepAnalyzerProvider() {
        return this.stepAnalyzerProvider;
    }

    public void setStepAnalyzerProvider(IStepAnalyzerProvider stepAnalyzerProvider) {
        this.stepAnalyzerProvider = stepAnalyzerProvider;
    }

    @Override
    protected void writeBasicInfo(T meta, JsonGenerator json) throws IOException {
        StepMeta parentStepMeta = meta.getParentStepMeta();
        if (parentStepMeta != null) {
            json.writeStringField("@class", meta.getClass().getName());
            json.writeStringField("name", parentStepMeta.getName());
            json.writeStringField("type", this.getStepType(parentStepMeta));
        }
    }

    @Override
    protected void writeCustom(T meta, JsonGenerator json, SerializerProvider serializerProvider) throws IOException {
        StepMeta parentStepMeta = meta.getParentStepMeta();
        if (parentStepMeta != null) {
            this.writeCustomProperties(meta, json, serializerProvider);
            this.writeInputFields(meta, json);
            this.writeOutputFields(parentStepMeta, json);
            this.writeFieldTransforms(meta, json, serializerProvider);
            this.writeFieldMappings(meta, json, serializerProvider);
        }
    }

    protected void writeFieldMappings(T meta, JsonGenerator json, SerializerProvider serializerProvider) throws IOException {
        json.writeArrayFieldStart(JSON_PROPERTY_MAPPINGS);
        IFieldLineageMetadataProvider mapper = this.getFieldLineageMetadataProvider(meta);
        try {
            Set fieldMappings = mapper.getFieldMappings(meta);
            if (fieldMappings != null) {
                for (IFieldMapping fieldMapping : fieldMappings) {
                    json.writeObject((Object)fieldMapping);
                }
            }
        }
        catch (MetaverseAnalyzerException e) {
            LOGGER.warn(Messages.getString("WARNING.Serialization.Step.WriteFieldMappings", meta.getParentStepMeta().getName()), (Throwable)e);
        }
        json.writeEndArray();
    }

    @Override
    protected void writeRepoAttributes(T meta, JsonGenerator json) throws IOException {
        StepMeta parentStepMeta = meta.getParentStepMeta();
        if (parentStepMeta != null) {
            String id = meta.getObjectId() == null ? parentStepMeta.getName() : meta.getObjectId().toString();
            StringObjectId stepId = new StringObjectId(id);
            LineageRepository repo = this.getLineageRepository();
            if (repo != null) {
                Map<String, Object> attrs = repo.getStepAttributesCache((ObjectId)stepId);
                json.writeObjectField("attributes", attrs);
                List<Map<String, Object>> fields = repo.getStepFieldsCache((ObjectId)stepId);
                json.writeObjectField("fields", fields);
            }
        }
    }

    protected void writeFieldTransforms(T meta, JsonGenerator json, SerializerProvider serializerProvider) throws IOException, JsonGenerationException {
        json.writeArrayFieldStart(JSON_PROPERTY_TRANSFORMS);
        IFieldLineageMetadataProvider mapper = this.getFieldLineageMetadataProvider(meta);
        try {
            Set changes = mapper.getChangeRecords(meta);
            if (changes != null) {
                for (ComponentDerivationRecord change : changes) {
                    if (!change.hasDelta()) continue;
                    json.writeObject((Object)change);
                }
            }
        }
        catch (MetaverseAnalyzerException e) {
            LOGGER.warn(Messages.getString("WARNING.Serialization.Step.WriteFieldTransforms", meta.getParentStepMeta().getName()), (Throwable)e);
        }
        json.writeEndArray();
    }

    protected abstract void writeCustomProperties(T var1, JsonGenerator var2, SerializerProvider var3) throws IOException;

    @Override
    protected void writeExternalResources(T meta, JsonGenerator json, SerializerProvider serializerProvider) throws IOException, JsonGenerationException {
        HashSet metaClassSet = new HashSet(1);
        metaClassSet.add(meta.getClass());
        IStepExternalResourceConsumerProvider stepExternalResourceConsumerProvider = this.getStepExternalResourceConsumerProvider();
        List resourceConsumers = null;
        if (stepExternalResourceConsumerProvider != null) {
            resourceConsumers = stepExternalResourceConsumerProvider.getExternalResourceConsumers(metaClassSet);
        }
        json.writeArrayFieldStart("externalResources");
        if (resourceConsumers != null) {
            for (IStepExternalResourceConsumer resourceConsumer : resourceConsumers) {
                Collection infos = resourceConsumer.getResourcesFromMeta(meta);
                for (IExternalResourceInfo info : infos) {
                    json.writeObject((Object)info);
                }
            }
        }
        json.writeEndArray();
    }

    protected void writeInputFields(T meta, JsonGenerator json) throws IOException {
        IFieldLineageMetadataProvider fieldLineageProvider = this.getFieldLineageMetadataProvider(meta);
        Map fieldMap = fieldLineageProvider.getInputFields(meta);
        ArrayList<RowMetaInterface> fieldMetaList = new ArrayList<RowMetaInterface>();
        if (!MapUtils.isEmpty((Map)fieldMap)) {
            for (RowMetaInterface rowMetaInterface : fieldMap.values()) {
                fieldMetaList.add(rowMetaInterface);
            }
        }
        this.writeFields(json, fieldMetaList, JSON_PROPERTY_INPUT_FIELDS);
    }

    protected void writeOutputFields(StepMeta parentStepMeta, JsonGenerator json) throws IOException {
        TransMeta parentTransMeta = parentStepMeta.getParentTransMeta();
        if (parentTransMeta != null) {
            try {
                RowMetaInterface stepFields = parentTransMeta.getStepFields(parentStepMeta);
                this.writeFields(json, stepFields, JSON_PROPERTY_OUTPUT_FIELDS);
            }
            catch (KettleStepException e) {
                LOGGER.warn(Messages.getString("WARNING.Serialization.Step.OutputFields", parentStepMeta.getName()), (Throwable)e);
            }
        }
    }

    protected void writeFields(JsonGenerator json, List<RowMetaInterface> fieldMetaList, String arrayObjectName) throws IOException {
        json.writeArrayFieldStart(arrayObjectName);
        for (RowMetaInterface fields : fieldMetaList) {
            List valueMetaInterfaces = fields.getValueMetaList();
            for (ValueMetaInterface valueMetaInterface : valueMetaInterfaces) {
                FieldInfo fieldInfo = new FieldInfo(valueMetaInterface);
                json.writeObject((Object)fieldInfo);
            }
        }
        json.writeEndArray();
    }

    protected void writeFields(JsonGenerator json, RowMetaInterface fields, String arrayObjectName) throws IOException {
        ArrayList<RowMetaInterface> fieldMetaList = new ArrayList<RowMetaInterface>(1);
        fieldMetaList.add(fields);
        this.writeFields(json, fieldMetaList, arrayObjectName);
    }

    protected String getStepType(StepMeta parentStepMeta) {
        String stepType = null;
        try {
            stepType = PluginRegistry.getInstance().findPluginWithId(StepPluginType.class, parentStepMeta.getStepID()).getName();
        }
        catch (Throwable t) {
            stepType = parentStepMeta.getStepID();
        }
        return stepType;
    }

    protected IFieldLineageMetadataProvider getFieldLineageMetadataProvider(T meta) {
        IStepAnalyzerProvider provider = this.getStepAnalyzerProvider();
        if (provider == null) {
            provider = (IStepAnalyzerProvider)PentahoSystem.get(IStepAnalyzerProvider.class);
        }
        if (provider != null) {
            HashSet types = new HashSet();
            types.add(meta.getClass());
            List analyzers = provider.getAnalyzers(types);
            if (analyzers != null) {
                for (IStepAnalyzer analyzer : analyzers) {
                    if (analyzer instanceof StepAnalyzer) {
                        StepAnalyzer bsa = (StepAnalyzer)analyzer;
                        try {
                            bsa.validateState(null, meta);
                            bsa.loadInputAndOutputStreamFields(meta);
                        }
                        catch (MetaverseAnalyzerException metaverseAnalyzerException) {
                            // empty catch block
                        }
                    }
                    if (!(analyzer instanceof IFieldLineageMetadataProvider)) continue;
                    return (IFieldLineageMetadataProvider)analyzer;
                }
            }
        }
        return new GenericStepMetaAnalyzer();
    }
}

