/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.metaverse.impl.model.kettle.json;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JavaType;
import java.io.IOException;
import java.util.List;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.job.Job;
import org.pentaho.di.job.JobHopMeta;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.entry.JobEntryBase;
import org.pentaho.di.job.entry.JobEntryCopy;
import org.pentaho.di.job.entry.JobEntryInterface;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.repository.StringObjectId;
import org.pentaho.metaverse.api.model.kettle.HopInfo;
import org.pentaho.metaverse.impl.model.kettle.LineageRepository;
import org.pentaho.metaverse.impl.model.kettle.json.AbstractMetaJsonSerializer;
import org.pentaho.metaverse.messages.Messages;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobMetaJsonSerializer
extends AbstractMetaJsonSerializer<JobMeta> {
    private static final Logger LOGGER = LoggerFactory.getLogger(JobMetaJsonSerializer.class);

    public JobMetaJsonSerializer(Class<JobMeta> aClass) {
        super(aClass);
    }

    public JobMetaJsonSerializer(JavaType javaType) {
        super(javaType);
    }

    public JobMetaJsonSerializer(Class<?> aClass, boolean b) {
        super(aClass, b);
    }

    @Override
    protected void serializeHops(JobMeta meta, JsonGenerator json) throws IOException {
        json.writeArrayFieldStart("hops");
        int numberOfHops = meta.nrJobHops();
        for (int i = 0; i < numberOfHops; ++i) {
            JobHopMeta hopMeta = meta.getJobHop(i);
            HopInfo hopInfo = new HopInfo(hopMeta);
            json.writeObject((Object)hopInfo);
        }
        json.writeEndArray();
    }

    @Override
    protected void serializeSteps(JobMeta meta, JsonGenerator json) throws IOException {
        json.writeArrayFieldStart("steps");
        int numberOfEntries = meta.nrJobEntries();
        for (int i = 0; i < numberOfEntries; ++i) {
            JobEntryCopy jobEntry = meta.getJobEntry(i);
            LineageRepository repo = this.getLineageRepository();
            StringObjectId jobId = meta.getObjectId() == null ? new StringObjectId(meta.getName()) : meta.getObjectId();
            StringObjectId entryId = jobEntry.getObjectId() == null ? new StringObjectId(jobEntry.getName()) : jobEntry.getObjectId();
            JobEntryInterface jobEntryInterface = jobEntry.getEntry();
            JobEntryBase jobEntryBase = this.getJobEntryBase(jobEntryInterface);
            Job job = new Job(null, meta);
            jobEntryBase.setParentJob(job);
            jobEntryInterface.setObjectId((ObjectId)entryId);
            try {
                jobEntryInterface.saveRep((Repository)repo, null, (ObjectId)jobId);
            }
            catch (KettleException e) {
                LOGGER.warn(Messages.getString("INFO.Serialization.Trans.Step", jobEntry.getName()), (Throwable)e);
            }
            json.writeObject((Object)jobEntryBase);
        }
        json.writeEndArray();
    }

    protected JobEntryBase getJobEntryBase(JobEntryInterface jobEntryInterface) {
        JobEntryBase jobEntryBase = new JobEntryBase(jobEntryInterface.getName(), jobEntryInterface.getDescription());
        if (jobEntryInterface instanceof JobEntryBase) {
            jobEntryBase = (JobEntryBase)jobEntryInterface;
        }
        return jobEntryBase;
    }

    @Override
    protected List<String> getUsedVariables(JobMeta meta) {
        return meta.getUsedVariables();
    }
}

