/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.metaverse.locator;

import java.io.File;
import java.net.URI;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.pentaho.metaverse.api.IDocumentListener;
import org.pentaho.metaverse.api.MetaverseLocatorException;
import org.pentaho.metaverse.locator.BaseLocator;
import org.pentaho.metaverse.locator.FileSystemLocatorRunner;
import org.pentaho.metaverse.messages.Messages;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSystemLocator
extends BaseLocator<File> {
    public static final String LOCATOR_TYPE = "FileSystem";
    private static final long serialVersionUID = 3308953622126327699L;
    private static final Logger LOG = LoggerFactory.getLogger(FileSystemLocator.class);
    private String rootFolder;

    public FileSystemLocator() {
        this.setLocatorType(LOCATOR_TYPE);
    }

    public FileSystemLocator(List<IDocumentListener> documentListeners) {
        super(documentListeners);
        this.setLocatorType(LOCATOR_TYPE);
    }

    @Override
    protected Object getContents(File file) throws Exception {
        String content = "";
        try {
            content = FileUtils.readFileToString((File)file);
        }
        catch (Throwable e) {
            LOG.error(Messages.getString("ERROR.IndexingDocument", file.getPath()), e);
        }
        return content;
    }

    public String getRootFolder() {
        return this.rootFolder;
    }

    public void setRootFolder(String rootFolder) {
        this.rootFolder = rootFolder;
    }

    public void startScan() throws MetaverseLocatorException {
        File root = new File(this.rootFolder);
        if (!root.exists()) {
            LOG.error(Messages.getString("ERROR.FileSystemLocator.RootFolder.DoesNotExist", root.getAbsolutePath()));
            throw new MetaverseLocatorException(Messages.getString("ERROR.FileSystemLocator.RootFolder.DoesNotExist", root.getAbsolutePath()));
        }
        if (!root.isDirectory()) {
            LOG.error(Messages.getString("ERROR.FileSystemLocator.RootFolder.NotAFolder", root.getAbsolutePath()));
            throw new MetaverseLocatorException(Messages.getString("ERROR.FileSystemLocator.RootFolder.NotAFolder", root.getAbsolutePath()));
        }
        FileSystemLocatorRunner lr = new FileSystemLocatorRunner();
        lr.setRoot(root);
        this.startScan(lr);
    }

    public URI getRootUri() {
        File root = new File(this.getRootFolder());
        if (root.exists()) {
            URI rootUri = root.toURI();
            return rootUri;
        }
        return null;
    }
}

