/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.metaverse.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.vfs2.FileDepthSelector;
import org.apache.commons.vfs2.FileSelectInfo;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileType;
import org.pentaho.metaverse.messages.Messages;

public class VfsDateRangeFilter
extends FileDepthSelector {
    protected SimpleDateFormat format;
    private Date startingDate;
    private Date endingDate;

    public VfsDateRangeFilter(SimpleDateFormat format) {
        super(1, 256);
        this.format = format;
    }

    public VfsDateRangeFilter(SimpleDateFormat format, Date startingDate) {
        this(format);
        this.startingDate = startingDate;
    }

    public VfsDateRangeFilter(SimpleDateFormat format, String startingDate) {
        this(format);
        this.setStartingDate(startingDate);
    }

    public VfsDateRangeFilter(SimpleDateFormat format, Date startingDate, Date endingDate) {
        this(format, startingDate);
        this.endingDate = endingDate;
    }

    public VfsDateRangeFilter(SimpleDateFormat format, String startingDate, String endingDate) {
        this(format, startingDate);
        this.setEndingDate(endingDate);
    }

    public Date getEndingDate() {
        return this.endingDate;
    }

    public void setEndingDate(Date endingDate) {
        this.endingDate = endingDate;
    }

    public void setEndingDate(String endingDate) {
        this.endingDate = this.parseDateString(endingDate);
    }

    public Date getStartingDate() {
        return this.startingDate;
    }

    public void setStartingDate(Date startingDate) {
        this.startingDate = startingDate;
    }

    public void setStartingDate(String startingDate) {
        this.startingDate = this.parseDateString(startingDate);
    }

    protected Date parseDateString(String dateString) throws IllegalArgumentException {
        if (dateString == null) {
            return null;
        }
        try {
            return this.format.parse(dateString);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException(Messages.getString("ERROR.CouldNotParseDateFromString", dateString), e);
        }
    }

    public boolean includeFile(FileSelectInfo fileInfo) {
        boolean result = super.includeFile(fileInfo);
        try {
            if (fileInfo.getFile().getType() == FileType.FOLDER) {
                Date folderDate = this.format.parse(fileInfo.getFile().getName().getBaseName());
                int startCompare = 0;
                int endCompare = 0;
                if (this.startingDate != null) {
                    startCompare = folderDate.compareTo(this.startingDate);
                }
                if (this.endingDate != null) {
                    endCompare = folderDate.compareTo(this.endingDate);
                }
                return startCompare >= 0 && endCompare <= 0 && result;
            }
            return false;
        }
        catch (ParseException | FileSystemException e) {
            return false;
        }
    }
}

