/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.oozie.AppType;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.executor.jpa.BundleJobGetForUserJPAExecutor;
import org.apache.oozie.executor.jpa.CoordinatorJobGetForUserJPAExecutor;
import org.apache.oozie.executor.jpa.JPAExecutorException;
import org.apache.oozie.executor.jpa.WorkflowJobGetForUserJPAExecutor;
import org.apache.oozie.service.ConfigurationService;
import org.apache.oozie.service.JPAService;
import org.apache.oozie.service.Service;
import org.apache.oozie.service.ServiceException;
import org.apache.oozie.service.Services;
import org.apache.oozie.util.XLog;

public class JMSTopicService
implements Service {
    public static final String CONF_PREFIX = "oozie.service.JMSTopicService.";
    public static final String TOPIC_NAME = "oozie.service.JMSTopicService.topic.name";
    public static final String TOPIC_PREFIX = "oozie.service.JMSTopicService.topic.prefix";
    private static XLog LOG;
    private Configuration conf;
    private final Map<String, String> topicMap = new HashMap<String, String>();
    private static final List<String> JOB_TYPE_CONSTANTS;
    private static final List<String> ALLOWED_TOPIC_NAMES;
    private JPAService jpaService = Services.get().get(JPAService.class);
    private String defaultTopicName = TopicType.access$000(TopicType.USER);
    private String topicPrefix;

    @Override
    public void init(Services services) throws ServiceException {
        LOG = XLog.getLog(this.getClass());
        this.conf = services.getConf();
        this.parseTopicConfiguration();
        this.topicPrefix = this.conf.get(TOPIC_PREFIX, "");
    }

    private void parseTopicConfiguration() throws ServiceException {
        String topicName = ConfigurationService.get(this.conf, TOPIC_NAME);
        if (topicName == null) {
            throw new ServiceException(ErrorCode.E0100, this.getClass().getName(), "JMS topic cannot be null ");
        }
        LOG.info("Topic Name is [{0}]", topicName);
        String[] topic = topicName.trim().split(",");
        for (int i = 0; i < topic.length; ++i) {
            String[] split = topic[i].trim().split("=");
            if (split.length == 2) {
                split[0] = split[0].trim();
                split[1] = split[1].trim();
                if (split[0].equals("default")) {
                    if (!ALLOWED_TOPIC_NAMES.contains(split[1])) {
                        throw new ServiceException(ErrorCode.E0100, this.getClass().getName(), "Topic name " + split[1] + " not allowed in default; allowed" + "topics are " + ALLOWED_TOPIC_NAMES);
                    }
                    this.defaultTopicName = split[1];
                    continue;
                }
                if (!JOB_TYPE_CONSTANTS.contains(split[0])) {
                    throw new ServiceException(ErrorCode.E0100, this.getClass().getName(), "Incorrect job type for defining JMS topic: " + split[0] + " ;" + "allowed job types are " + JOB_TYPE_CONSTANTS);
                }
                if (!ALLOWED_TOPIC_NAMES.contains(split[1]) && split[1].contains("$")) {
                    throw new ServiceException(ErrorCode.E0100, this.getClass().getName(), "JMS topic value " + split[1] + " " + "for a job type is incorrect " + "Correct values are " + ALLOWED_TOPIC_NAMES);
                }
                this.topicMap.put(split[0], split[1]);
                continue;
            }
            throw new ServiceException(ErrorCode.E0100, this.getClass().getName(), "Property " + topic[i] + "has incorrect syntax; It should be specified as key value pair");
        }
    }

    public String getTopic(String jobId) throws JPAExecutorException {
        String topicName = null;
        if (jobId.contains("-W@")) {
            jobId = jobId.substring(0, jobId.indexOf(64));
            topicName = this.getTopicForWorkflow(jobId);
        } else if (jobId.endsWith("-W")) {
            topicName = this.getTopicForWorkflow(jobId);
        } else if (jobId.contains("-C@")) {
            jobId = jobId.substring(0, jobId.indexOf(64));
            topicName = this.getTopicForCoordinator(jobId);
        } else if (jobId.endsWith("C")) {
            topicName = this.getTopicForCoordinator(jobId);
        } else if (jobId.contains("-B_")) {
            jobId = jobId.substring(0, jobId.indexOf(95));
            topicName = this.getTopicForBundle(jobId);
        } else if (jobId.endsWith("B")) {
            topicName = this.getTopicForBundle(jobId);
        }
        return this.topicPrefix + topicName;
    }

    public String getTopic(AppType appType, String user, String jobId, String parentJobId) {
        String topicName = null;
        String id = jobId;
        if (appType == AppType.COORDINATOR_JOB || appType == AppType.COORDINATOR_ACTION) {
            topicName = this.topicMap.get(JobType.COORDINATOR.value);
            if (appType == AppType.COORDINATOR_ACTION) {
                id = parentJobId;
            }
        } else if (appType == AppType.WORKFLOW_JOB || appType == AppType.WORKFLOW_ACTION) {
            topicName = this.topicMap.get(JobType.WORKFLOW.value);
            if (appType == AppType.WORKFLOW_ACTION) {
                id = parentJobId;
            }
        } else if (appType == AppType.BUNDLE_JOB || appType == AppType.BUNDLE_ACTION) {
            topicName = this.topicMap.get(JobType.BUNDLE.value);
            if (appType == AppType.BUNDLE_ACTION) {
                id = parentJobId;
            }
        }
        if (topicName == null) {
            if (this.defaultTopicName.equals(TopicType.USER.value)) {
                topicName = user;
            } else if (this.defaultTopicName.equals(TopicType.JOBID.value)) {
                topicName = id;
            }
        }
        return this.topicPrefix + topicName;
    }

    private String getTopicForWorkflow(String jobId) throws JPAExecutorException {
        String topicName = this.topicMap.get(JobType.WORKFLOW.value);
        if (topicName == null) {
            topicName = this.defaultTopicName;
        }
        if (topicName.equals(TopicType.USER.value)) {
            topicName = this.jpaService.execute(new WorkflowJobGetForUserJPAExecutor(jobId));
        } else if (topicName.equals(TopicType.JOBID.value)) {
            topicName = jobId;
        }
        return topicName;
    }

    private String getTopicForCoordinator(String jobId) throws JPAExecutorException {
        String topicName = this.topicMap.get(JobType.COORDINATOR.value);
        if (topicName == null) {
            topicName = this.defaultTopicName;
        }
        if (topicName.equals(TopicType.USER.value)) {
            topicName = this.jpaService.execute(new CoordinatorJobGetForUserJPAExecutor(jobId));
        } else if (topicName.equals(TopicType.JOBID.value)) {
            topicName = jobId;
        }
        return topicName;
    }

    private String getTopicForBundle(String jobId) throws JPAExecutorException {
        String topicName = this.topicMap.get(JobType.BUNDLE.value);
        if (topicName == null) {
            topicName = this.defaultTopicName;
        }
        if (topicName.equals(TopicType.USER.value)) {
            topicName = this.jpaService.execute(new BundleJobGetForUserJPAExecutor(jobId));
        } else if (topicName.equals(TopicType.JOBID.value)) {
            topicName = jobId;
        }
        return topicName;
    }

    public Properties getTopicPatternProperties() {
        Properties props = new Properties();
        String wfTopic = this.topicMap.get(JobType.WORKFLOW.value);
        wfTopic = wfTopic != null ? wfTopic : this.defaultTopicName;
        props.put(AppType.WORKFLOW_JOB, wfTopic);
        props.put(AppType.WORKFLOW_ACTION, wfTopic);
        String coordTopic = this.topicMap.get(JobType.COORDINATOR.value);
        coordTopic = coordTopic != null ? coordTopic : this.defaultTopicName;
        props.put(AppType.COORDINATOR_JOB, coordTopic);
        props.put(AppType.COORDINATOR_ACTION, coordTopic);
        String bundleTopic = this.topicMap.get(JobType.BUNDLE.value);
        bundleTopic = bundleTopic != null ? bundleTopic : this.defaultTopicName;
        props.put(AppType.BUNDLE_JOB, bundleTopic);
        props.put(AppType.BUNDLE_ACTION, bundleTopic);
        return props;
    }

    public String getTopicPrefix() {
        return this.topicPrefix;
    }

    @Override
    public void destroy() {
        this.topicMap.clear();
    }

    @Override
    public Class<? extends Service> getInterface() {
        return JMSTopicService.class;
    }

    static {
        JOB_TYPE_CONSTANTS = new ArrayList<String>();
        ALLOWED_TOPIC_NAMES = new ArrayList<String>();
        ALLOWED_TOPIC_NAMES.add(TopicType.USER.value);
        ALLOWED_TOPIC_NAMES.add(TopicType.JOBID.value);
        JOB_TYPE_CONSTANTS.add(JobType.WORKFLOW.value);
        JOB_TYPE_CONSTANTS.add(JobType.COORDINATOR.value);
        JOB_TYPE_CONSTANTS.add(JobType.BUNDLE.value);
    }

    public static enum TopicType {
        USER("${username}"),
        JOBID("${jobId}");

        private String value;

        private TopicType(String value) {
            this.value = value;
        }

        String getValue() {
            return this.value;
        }
    }

    public static enum JobType {
        WORKFLOW("WORKFLOW"),
        COORDINATOR("COORDINATOR"),
        BUNDLE("BUNDLE");

        private String value;

        private JobType(String value) {
            this.value = value;
        }

        String getValue() {
            return this.value;
        }
    }
}

