/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.util;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.hadoop.conf.Configuration;
import org.apache.oozie.action.hadoop.PasswordMasker;
import org.apache.oozie.service.ConfigurationService;
import org.apache.oozie.service.Services;
import org.apache.oozie.util.XLog;

public class Instrumentation {
    private ScheduledExecutorService scheduler;
    private Lock counterLock = new ReentrantLock();
    private Lock timerLock = new ReentrantLock();
    private Lock variableLock = new ReentrantLock();
    private Lock samplerLock = new ReentrantLock();
    private Map<String, Map<String, Map<String, Object>>> all = new LinkedHashMap<String, Map<String, Map<String, Object>>>();
    private Map<String, Map<String, Element<Long>>> counters = new ConcurrentHashMap<String, Map<String, Element<Long>>>();
    private Map<String, Map<String, Element<Timer>>> timers = new ConcurrentHashMap<String, Map<String, Element<Timer>>>();
    private Map<String, Map<String, Element<Variable>>> variables = new ConcurrentHashMap<String, Map<String, Element<Variable>>>();
    private Map<String, Map<String, Element<Double>>> samplers = new ConcurrentHashMap<String, Map<String, Element<Double>>>();

    public Instrumentation() {
        this.all.put("variables", this.variables);
        this.all.put("samplers", this.samplers);
        this.all.put("counters", this.counters);
        this.all.put("timers", this.timers);
    }

    public void setScheduler(ScheduledExecutorService scheduler) {
        this.scheduler = scheduler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCron(String group, String name, Cron cron) {
        Timer timer;
        Map<String, Element<Timer>> map = this.timers.get(group);
        if (map == null) {
            try {
                this.timerLock.lock();
                map = this.timers.get(group);
                if (map == null) {
                    map = new HashMap<String, Element<Timer>>();
                    this.timers.put(group, map);
                }
            }
            finally {
                this.timerLock.unlock();
            }
        }
        if ((timer = (Timer)map.get(name)) == null) {
            try {
                this.timerLock.lock();
                timer = (Timer)map.get(name);
                if (timer == null) {
                    timer = new Timer();
                    map.put(name, timer);
                }
            }
            finally {
                this.timerLock.unlock();
            }
        }
        timer.addCron(cron);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incr(String group, String name, long count) {
        Counter counter;
        Map<String, Element<Long>> map = this.counters.get(group);
        if (map == null) {
            try {
                this.counterLock.lock();
                map = this.counters.get(group);
                if (map == null) {
                    map = new HashMap<String, Element<Long>>();
                    this.counters.put(group, map);
                }
            }
            finally {
                this.counterLock.unlock();
            }
        }
        if ((counter = (Counter)map.get(name)) == null) {
            try {
                this.counterLock.lock();
                counter = (Counter)map.get(name);
                if (counter == null) {
                    counter = new Counter();
                    map.put(name, counter);
                }
            }
            finally {
                this.counterLock.unlock();
            }
        }
        counter.addAndGet(count);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addVariable(String group, String name, Variable variable) {
        Map<String, Element<Variable>> map = this.variables.get(group);
        if (map == null) {
            try {
                this.variableLock.lock();
                map = this.variables.get(group);
                if (map == null) {
                    map = new HashMap<String, Element<Variable>>();
                    this.variables.put(group, map);
                }
            }
            finally {
                this.variableLock.unlock();
            }
        }
        if (map.containsKey(name)) {
            throw new RuntimeException(XLog.format("Variable group=[{0}] name=[{1}] already defined", group, name));
        }
        map.put(name, variable);
    }

    public Map<String, String> getJavaSystemProperties() {
        ImmutableMap unmasked = Maps.fromProperties((Properties)System.getProperties());
        return new PasswordMasker().mask((Map)unmasked);
    }

    public Map<String, String> getOSEnv() {
        Map<String, String> unmasked = System.getenv();
        return new PasswordMasker().mask(unmasked);
    }

    public Map<String, String> getConfiguration() {
        final Configuration maskedConf = Services.get().get(ConfigurationService.class).getMaskedConfiguration();
        return new Map<String, String>(){

            @Override
            public int size() {
                return maskedConf.size();
            }

            @Override
            public boolean isEmpty() {
                return maskedConf.size() == 0;
            }

            @Override
            public boolean containsKey(Object o) {
                return maskedConf.get((String)o) != null;
            }

            @Override
            public boolean containsValue(Object o) {
                throw new UnsupportedOperationException();
            }

            @Override
            public String get(Object o) {
                return maskedConf.get((String)o);
            }

            @Override
            public String put(String s, String s1) {
                throw new UnsupportedOperationException();
            }

            @Override
            public String remove(Object o) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void putAll(Map<? extends String, ? extends String> map) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void clear() {
                throw new UnsupportedOperationException();
            }

            @Override
            public Set<String> keySet() {
                LinkedHashSet<String> set = new LinkedHashSet<String>();
                for (Map.Entry entry : maskedConf) {
                    set.add((String)entry.getKey());
                }
                return set;
            }

            @Override
            public Collection<String> values() {
                LinkedHashSet<String> set = new LinkedHashSet<String>();
                for (Map.Entry entry : maskedConf) {
                    set.add((String)entry.getValue());
                }
                return set;
            }

            @Override
            public Set<Map.Entry<String, String>> entrySet() {
                LinkedHashSet<Map.Entry<String, String>> set = new LinkedHashSet<Map.Entry<String, String>>();
                for (Map.Entry entry : maskedConf) {
                    set.add(entry);
                }
                return set;
            }
        };
    }

    public Map<String, Map<String, Element<Long>>> getCounters() {
        return this.counters;
    }

    public Map<String, Map<String, Element<Timer>>> getTimers() {
        return this.timers;
    }

    public Map<String, Map<String, Element<Variable>>> getVariables() {
        return this.variables;
    }

    public Map<String, Map<String, Map<String, Object>>> getAll() {
        return this.all;
    }

    public String toString() {
        String E = System.getProperty("line.separator");
        StringBuilder sb = new StringBuilder(4096);
        for (String element : this.all.keySet()) {
            sb.append(element).append(':').append(E);
            ArrayList<String> groups = new ArrayList<String>(this.all.get(element).keySet());
            Collections.sort(groups);
            for (String group : groups) {
                sb.append("  ").append(group).append(':').append(E);
                ArrayList<String> names = new ArrayList<String>(this.all.get(element).get(group).keySet());
                Collections.sort(names);
                for (String name : names) {
                    sb.append("    ").append(name).append(": ").append(((Element)this.all.get(element).get(group).get(name)).getValue()).append(E);
                }
            }
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSampler(String group, String name, int period, int interval, Variable<Long> variable) {
        if (this.scheduler == null) {
            throw new IllegalStateException("scheduler not set, cannot sample");
        }
        try {
            this.samplerLock.lock();
            Map<String, Element<Double>> map = this.samplers.get(group);
            if (map == null && (map = this.samplers.get(group)) == null) {
                map = new HashMap<String, Element<Double>>();
                this.samplers.put(group, map);
            }
            if (map.containsKey(name)) {
                throw new RuntimeException(XLog.format("Sampler group=[{0}] name=[{1}] already defined", group, name));
            }
            Sampler sampler = new Sampler(period, interval, variable);
            map.put(name, sampler);
            this.scheduler.scheduleAtFixedRate(sampler, 0L, sampler.getSamplingInterval(), TimeUnit.SECONDS);
        }
        finally {
            this.samplerLock.unlock();
        }
    }

    public Map<String, Map<String, Element<Double>>> getSamplers() {
        return this.samplers;
    }

    public void stop() {
    }

    private static class Sampler
    implements Element<Double>,
    Runnable {
        private Lock lock = new ReentrantLock();
        private int samplingInterval;
        private Variable<Long> variable;
        private long[] values;
        private int current;
        private long valuesSum;
        private double rate;

        public Sampler(int samplingPeriod, int samplingInterval, Variable<Long> variable) {
            this.samplingInterval = samplingInterval;
            this.variable = variable;
            this.values = new long[samplingPeriod / samplingInterval];
            this.valuesSum = 0L;
            this.current = -1;
        }

        public int getSamplingInterval() {
            return this.samplingInterval;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                this.lock.lock();
                long newValue = (Long)this.variable.getValue();
                if (this.current == -1) {
                    this.valuesSum = newValue;
                    this.current = 0;
                    this.values[this.current] = newValue;
                } else {
                    this.current = (this.current + 1) % this.values.length;
                    this.valuesSum = this.valuesSum - this.values[this.current] + newValue;
                    this.values[this.current] = newValue;
                }
                this.rate = (double)this.valuesSum / (double)this.values.length;
            }
            finally {
                this.lock.unlock();
            }
        }

        @Override
        public Double getValue() {
            return this.rate;
        }
    }

    public static interface Variable<T>
    extends Element<T> {
    }

    public static class Timer
    implements Element<Timer> {
        Lock lock = new ReentrantLock();
        private long ownTime;
        private long totalTime;
        private long ticks;
        private long ownSquareTime;
        private long totalSquareTime;
        private long ownMinTime;
        private long ownMaxTime;
        private long totalMinTime;
        private long totalMaxTime;

        Timer() {
        }

        public String toString() {
            return XLog.format("ticks[{0}] totalAvg[{1}] ownAvg[{2}]", this.ticks, this.getTotalAvg(), this.getOwnAvg());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Timer getValue() {
            try {
                this.lock.lock();
                Timer timer = new Timer();
                timer.ownTime = this.ownTime;
                timer.totalTime = this.totalTime;
                timer.ticks = this.ticks;
                timer.ownSquareTime = this.ownSquareTime;
                timer.totalSquareTime = this.totalSquareTime;
                timer.ownMinTime = this.ownMinTime;
                timer.ownMaxTime = this.ownMaxTime;
                timer.totalMinTime = this.totalMinTime;
                timer.totalMaxTime = this.totalMaxTime;
                Timer timer2 = timer;
                return timer2;
            }
            finally {
                this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void addCron(Cron cron) {
            try {
                this.lock.lock();
                long own = cron.getOwn();
                long total = cron.getTotal();
                this.ownTime += own;
                this.totalTime += total;
                ++this.ticks;
                this.ownSquareTime += own * own;
                this.totalSquareTime += total * total;
                if (this.ticks == 1L) {
                    this.ownMinTime = own;
                    this.ownMaxTime = own;
                    this.totalMinTime = total;
                    this.totalMaxTime = total;
                } else {
                    this.ownMinTime = Math.min(this.ownMinTime, own);
                    this.ownMaxTime = Math.max(this.ownMaxTime, own);
                    this.totalMinTime = Math.min(this.totalMinTime, total);
                    this.totalMaxTime = Math.max(this.totalMaxTime, total);
                }
            }
            finally {
                this.lock.unlock();
            }
        }

        public long getOwn() {
            return this.ownTime;
        }

        public long getTotal() {
            return this.totalTime;
        }

        public long getTicks() {
            return this.ticks;
        }

        public long getOwnSquareSum() {
            return this.ownSquareTime;
        }

        public long getTotalSquareSum() {
            return this.totalSquareTime;
        }

        public long getOwnMin() {
            return this.ownMinTime;
        }

        public long getOwnMax() {
            return this.ownMaxTime;
        }

        public long getTotalMin() {
            return this.totalMinTime;
        }

        public long getTotalMax() {
            return this.totalMaxTime;
        }

        public long getOwnAvg() {
            return this.ticks != 0L ? this.ownTime / this.ticks : 0L;
        }

        public long getTotalAvg() {
            return this.ticks != 0L ? this.totalTime / this.ticks : 0L;
        }

        public double getTotalStdDev() {
            return this.evalStdDev(this.ticks, this.totalTime, this.totalSquareTime);
        }

        public double getOwnStdDev() {
            return this.evalStdDev(this.ticks, this.ownTime, this.ownSquareTime);
        }

        private double evalStdDev(long n, long sn, long ssn) {
            return n < 2L ? -1.0 : Math.sqrt((n * ssn - sn * sn) / (n * (n - 1L)));
        }
    }

    private static class Counter
    extends AtomicLong
    implements Element<Long> {
        private Counter() {
        }

        @Override
        public Long getValue() {
            return this.get();
        }

        @Override
        public String toString() {
            return Long.toString(this.get());
        }
    }

    public static interface Element<T> {
        public T getValue();
    }

    public static class Cron {
        private long start;
        private long end;
        private long lapStart;
        private long own;
        private long total;
        private boolean running = false;

        public void start() {
            if (!this.running) {
                if (this.lapStart == 0L) {
                    this.lapStart = System.currentTimeMillis();
                    if (this.start == 0L) {
                        this.end = this.start = this.lapStart;
                    }
                }
                this.running = true;
            }
        }

        public void stop() {
            if (this.running) {
                this.end = System.currentTimeMillis();
                if (this.start == 0L) {
                    this.start = this.end;
                }
                this.total = this.end - this.start;
                if (this.lapStart > 0L) {
                    this.own += this.end - this.lapStart;
                    this.lapStart = 0L;
                }
                this.running = false;
            }
        }

        public long getStart() {
            if (this.running) {
                throw new IllegalStateException("Timer running");
            }
            return this.start;
        }

        public long getEnd() {
            if (this.running) {
                throw new IllegalStateException("Timer running");
            }
            return this.end;
        }

        public long getTotal() {
            if (this.running) {
                throw new IllegalStateException("Timer running");
            }
            return this.total;
        }

        public long getOwn() {
            if (this.running) {
                throw new IllegalStateException("Timer running");
            }
            return this.own;
        }
    }
}

