/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.hadoop.shim.common.format.parquet;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.pentaho.hadoop.shim.api.format.IParquetInputField;
import org.pentaho.hadoop.shim.common.format.parquet.ParquetInputField;

public class ParquetInputFieldList
implements Iterable<IParquetInputField> {
    private List<IParquetInputField> fields;

    public ParquetInputFieldList(List<IParquetInputField> fields) {
        this.fields = fields;
    }

    public List<IParquetInputField> getFields() {
        return this.fields;
    }

    public String marshall() {
        StringBuilder o = new StringBuilder(2048);
        for (IParquetInputField f : this.fields) {
            o.append(IParquetInputField.marshall((IParquetInputField)f)).append('\n');
        }
        return o.toString();
    }

    public static ParquetInputFieldList unmarshall(String str) {
        String[] lines;
        ArrayList<IParquetInputField> inputFields = new ArrayList<IParquetInputField>();
        if (str.isEmpty()) {
            return new ParquetInputFieldList(inputFields);
        }
        for (String line : lines = str.split("\n")) {
            inputFields.add(ParquetInputField.unmarshallField(line));
        }
        return new ParquetInputFieldList(inputFields);
    }

    public boolean isEmpty() {
        return this.fields.isEmpty();
    }

    public int getFieldsCount() {
        return this.fields.size();
    }

    @Override
    public Iterator<IParquetInputField> iterator() {
        return this.fields.iterator();
    }

    public String toString() {
        return this.marshall();
    }
}

